<?php
/**
 * Theme styles , include style bsed on demo name.
 * include google font url.
 *
 * @package Dima Framework
 * @subpackage Functions
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'dima_global_styles' ) ) :
	/**
	 * Include main styles.
	 */
	function dima_global_styles() {
		$dima_css_style_dir = '/framework/asset/site/css/styles/';
		$demo               = 'noor_main';
		$ext                = '';
		$rtl                = is_rtl() ? '-rtl' : '';
		$lightbox           = dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_disable_lightbox' ) );
		$dropkick           = dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_disable_dropkick' ) );

		// Register styles.
		wp_enqueue_style( DIMA_THEME_FOLDER . '-style', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/style' . $ext . $rtl . '.min.css', array(), DIMA_VERSION );

		if ( $lightbox ) {
			wp_register_style( 'fancybox-css', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/fancybox.min.css', array(), DIMA_VERSION, 'all' );
			wp_enqueue_style( 'fancybox-css' );
		}

		if ( $dropkick ) {
			wp_register_style( 'dropkick-css', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/dropkick' . $rtl . '.min.css', array(), DIMA_VERSION, 'all' );
			wp_enqueue_style( 'dropkick-css' );
		}

		wp_register_style( 'mediaelement-css', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/mediaelementplayer.min.css', array(), DIMA_VERSION, 'all' );
		if ( DIMA_CF_IS_ACTIVE ) {
			$style_includes = get_option( '_caldera_forms_styleincludes' );
			if ( ! $style_includes['alert'] ) {
				wp_register_style( 'calderaforms-style', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/calderaforms' . $ext . $rtl . '.min.css', null, DIMA_VERSION, 'all' );
				wp_enqueue_style( 'calderaforms-style' );
			}
		}

		if ( DIMA_WC_IS_ACTIVE ) {
			wp_register_style( 'dima-woocommerce-style', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/woocommerce-style' . $ext . $rtl . '.min.css', null, DIMA_VERSION, 'all' );
			if ( dima_is_wc_page() ) {
				wp_enqueue_style( 'dima-woocommerce-style' );
			}
		}

		if ( DIMA_YITH_WISHLIST_IS_ACTIVE ) {
			wp_enqueue_style( 'dima-wishlist', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/wishlist' . $rtl . '.min.css', null, DIMA_VERSION, 'all' );
		}

		wp_enqueue_style( 'dima-quick-view', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/quick-view' . $rtl . '.min.css', null, DIMA_VERSION, 'all' );

		if ( DIMA_BBPRESS_IS_ACTIVE ) {
			wp_enqueue_style( 'dima-bbpress', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/bbpress-style' . $ext . '.min.css', null, DIMA_VERSION, 'all' );
		}
		if ( DIMA_GRAVITY_FORMS_IS_ACTIVE ) {
			wp_enqueue_style( 'dima-gravity-forms', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/gf-style' . $ext . '.min.css', null, DIMA_VERSION, 'all' );
		}
		if ( DIMA_CONTACT_FORM_7_IS_ACTIVE ) {
			add_filter( 'wpcf7_load_css', '__return_false' );
		}
		if ( DIMA_KB_IS_ACTIVE ) {
			wp_enqueue_style( 'dima-gravity-forms', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/kb-style' . $rtl . '.min.css', null, DIMA_VERSION, 'all' );
		}
		if ( DIMA_CRYP_WIDGET_IS_ACTIVE || DIMA_ULTIMATE_CRYPTO_IS_ACTIVE ) {
			wp_enqueue_style( 'dima-cryptocurrency-widget', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/cryptocurrency' . $rtl . '.min.css', null, DIMA_VERSION, 'all' );
		}

		if ( DIMA_EDD_IS_ACTIVE ) {
			wp_enqueue_style( 'dima-edd', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/edd' . $rtl . '.min.css', null, DIMA_VERSION, 'all' );
		}

		if ( DIMA_THE_EVENTS_CALENDAR_ACTIVE ) {
			wp_enqueue_style( 'dima-theeventscalendar-style', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/dima-events-calenda' . $ext . $rtl . '.min.css', null, DIMA_VERSION, 'all' );
		}
		wp_register_style( 'video-css', 'https://vjs.zencdn.net/7.3.0/video-js.min.css', array(), DIMA_VERSION, false );

		wp_register_style( 'dima-element-category-grid', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/element-category-grid.min.css', null, DIMA_VERSION, 'all' );

		if ( DIMA_GUTENBERG_IS_ACTIVE ) {
			wp_enqueue_style( 'dima-blocks-style', DIMA_TEMPLATE_URL . $dima_css_style_dir . $demo . '/blocks' . $ext . $rtl . '.min.css', null, DIMA_VERSION, 'all' );
		}
	}
endif;
add_action( 'wp_enqueue_scripts', 'dima_global_styles' );

if ( ! function_exists( 'dima_include_fonts' ) ) :
	/**
	 * Add fonts.
	 */
	function dima_include_fontawesome() {
		$protocol           = is_ssl() ? 'https' : 'http';
		$dima_css_style_dir = '/framework/asset/site/css/styles/';
		$fa                 = dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_fontawesome_five' ) );
		// Font Awesome.
		$fa_svg = dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_fontawesome_five_svg' ) );
		$fa_upg = dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_fontawesome_five_upgrading' ) );

		if ( ! $fa_svg && $fa ) {
			// FA: v5.7.1.
			wp_enqueue_style( 'fontawesome', DIMA_TEMPLATE_URL . $dima_css_style_dir . '/all.min.css', null, DIMA_VERSION, 'all' );
			if ( $fa_upg ) {
				wp_enqueue_style( 'fontawesome-shims', DIMA_TEMPLATE_URL . $dima_css_style_dir . '/v4-shims.min.css', null, DIMA_VERSION, 'all' );
			}
		}
	}

endif;

add_action( 'wp_enqueue_scripts', 'dima_include_fontawesome' );

if ( ! function_exists( 'dima_admin_styles' ) ) :
	/**
	 * Include Admin style.
	 */
	function dima_admin_styles( $hook ) {
		$rtl  = '';
		$rtl .= is_rtl() ? '-rtl' : '';
		// include global admin style for pixeldima.
		wp_enqueue_style( 'pixeldima-global', DIMA_TEMPLATE_URL . '/framework/asset/admin/css/pixeldima' . $rtl . '.min.css', null, DIMA_VERSION, 'all' );
		wp_enqueue_style( 'pixeldima-global' );

		// include meta style.
		if ( $hook == 'post.php' || $hook == 'post-new.php' || $hook == 'edit-tags.php' ) {
			wp_enqueue_style( 'dima-meta', DIMA_TEMPLATE_URL . '/framework/asset/admin/css/meta' . $rtl . '.min.css', null, DIMA_VERSION, 'all' );
		}
		$screen = get_current_screen();
		if ( $screen->id == 'edit-category' ) {
			return wp_enqueue_style( 'cmb2-styles' );
		}
		wp_enqueue_style( 'dima-tippy', DIMA_TEMPLATE_URL . '/framework/asset/admin/css/tippy.min.css', null, DIMA_VERSION, 'all' );
	}
endif;

add_action( 'admin_enqueue_scripts', 'dima_admin_styles' );

if ( ! function_exists( 'dima_customizer_controls' ) ) :
	/**
	 * [Add Style to customizer controls 'customizer-controls.css']
	 */
	function dima_customizer_controls() {
		$rtl = is_rtl() ? '-rtl' : '';

		wp_enqueue_style( 'dima_customizer_styles', DIMA_TEMPLATE_URL . '/framework/asset/admin/css/customizer-controls' . $rtl . '.min.css', array(), DIMA_VERSION, 'all' );
	}
endif;

add_action( 'customize_controls_print_styles', 'dima_customizer_controls' );
