<?php
/**
 * Theme scripts , include js.
 *
 * @package Dima Framework
 * @subpackage Functions
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'wp_enqueue_scripts', 'dima_global_scripts', 10 );
add_action( 'wp_enqueue_scripts', 'dima_localize_script', 10 );
add_action( 'admin_enqueue_scripts', 'dima_admin_scripts_meta_box' );
add_action( 'admin_enqueue_scripts', 'dima_admin_scripts' );
add_action( 'customize_preview_init', 'dima_preview_customizer_scripts' );
add_action( 'customize_controls_print_footer_scripts', 'dima_customizer_control_scripts' );
add_action( 'customize_controls_enqueue_scripts', 'dima_localize_script' );

if ( ! function_exists( 'dima_localize_script' ) ) {
	/**
	 * Undocumented function
	 *
	 * @return void
	 */
	function dima_localize_script() {
		$lightbox = dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_disable_lightbox' ) );
		$dropkick = dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_disable_dropkick' ) );
		$js_vars  = array(
			'is_rtl'              => is_rtl(),
			'sticky_behavior'     => 'default',
			'dima_lightbox'       => $lightbox,
			'dima_dropkick'       => $dropkick,
			'dima_lang'           => Dima::get_dima_theme_option_name(),
			'is_gutenberg '       => DIMA_GUTENBERG_IS_ACTIVE,
			'DIMA_TEMPLATE_URL'   => DIMA_TEMPLATE_URL,
			'DIMA_TEMPLATE_PATH'  => DIMA_TEMPLATE_PATH,
			'ajaxurl'             => esc_url( admin_url( 'admin-ajax.php' ) ),
			'is_lazy_image'       => dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_lazy_image' ) ),
			'is_singular'         => is_singular(),
			'ad_blocker_detector' => dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_ad_blocker_detector' ) ),
			'animation_active'    => dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_animation_active' ) ),
		);

		wp_localize_script( 'jquery', 'pxdm_js', $js_vars );
		wp_localize_script( 'dima-customizer-control-js', 'pxdm_js', $js_vars );
	}
}

if ( ! function_exists( 'dima_global_scripts' ) ) :
	/**
	 * Undocumented function
	 *
	 * @return void
	 */
	function dima_global_scripts() {
		if ( ! is_admin() && ! in_array( $GLOBALS['pagenow'], array( 'wp-login.php', 'wp-register.php' ) ) ) {

			$dima_smoothscroll   = dima_helper::dima_get_option( 'dima_smoothscroll' );
			$lightbox            = dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_disable_lightbox' ) );
			$dropkick            = dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_disable_dropkick' ) );
			$dima_sticky_sidebar = dima_helper::dima_am_i_true( dima_helper::dima_get_inherit_option( '_dima_meta_sidebar_sticky', 'dima_sticky_sidebar' ) );

			if ( DIMA_USE_LAZY ) {
				wp_register_script( 'lazysizes', DIMA_TEMPLATE_URL . '/framework/asset/site/js/specific/lazysizes.min.js', array(), DIMA_VERSION, false );
				wp_enqueue_script( 'lazysizes' );
			}

			if ( dima_helper::dima_am_i_true( dima_helper::dima_get_inherit_option( '_dima_meta_loading', 'dima_loading' ) ) ) {
				wp_register_script( 'dima-load-js', DIMA_TEMPLATE_URL . '/framework/asset/site/js/specific/dima-load.js', array( 'jquery' ), DIMA_VERSION, false );
				wp_enqueue_script( 'dima-load-js' );
			}

			wp_register_script( 'scrollspy', DIMA_TEMPLATE_URL . '/framework/asset/site/js/specific/scrollspy.js', array( 'jquery' ), DIMA_VERSION, false );
			wp_enqueue_script( 'scrollspy' );

			wp_register_script( 'modernizr-js', DIMA_TEMPLATE_URL . '/framework/asset/site/js/core/modernizr-custom.js', array(), DIMA_VERSION, false );
			wp_enqueue_script( 'modernizr-js' );
			wp_register_script( 'dima_init_js', DIMA_TEMPLATE_URL . '/framework/asset/site/js/core/init.js', array( 'jquery' ), DIMA_VERSION, false );
			wp_enqueue_script( 'dima_init_js' );
			if ( $dima_smoothscroll == '1' ) {
				wp_register_script( 'smoothscroll', DIMA_TEMPLATE_URL . '/framework/asset/site/js/specific/smoothscroll.min.js', array( 'jquery' ), DIMA_VERSION, false );
				wp_enqueue_script( 'smoothscroll' );
			}
			wp_register_script( 'sticky-sidebar', DIMA_TEMPLATE_URL . '/framework/asset/site/js/specific/theia-sticky-sidebar.min.js', array( 'jquery' ), DIMA_VERSION, false );

			if ( $dima_sticky_sidebar ) {
				wp_enqueue_script( 'sticky-sidebar' );
			}

			global $is_IE;
			if ( $is_IE ) {
				preg_match( '/MSIE (.*?);/', $_SERVER['HTTP_USER_AGENT'], $matches );
				if ( count( $matches ) < 2 ) {
					preg_match( '/Trident\/\d{1,2}.\d{1,2}; rv:([0-9]*)/', $_SERVER['HTTP_USER_AGENT'], $matches );
				}
				$version = $matches[1];
				// IE 10
				if ( $version <= 11 ) {
					wp_enqueue_script( 'dima-ie-scripts', DIMA_TEMPLATE_URL . '/framework/asset/site/js/specific/ie.js', array( 'jquery' ), false, false );
				}

				wp_register_script( 'respond.src', DIMA_TEMPLATE_URL . '/framework/asset/site/js/specific/respond.src.js', array( 'jquery' ), DIMA_VERSION, false );
				wp_enqueue_script( 'respond.src' );
			}

			// ------------ All files on module.
			// ------------ Do not change the files order.
			wp_register_script( 'dima-js-vendor', DIMA_TEMPLATE_URL . '/framework/asset/site/js/vendors.min.js', array( 'jquery' ), DIMA_VERSION, false );
			wp_enqueue_script( 'dima-js-vendor' );

			wp_register_script( 'dima-js-typed', 'https://cdn.jsdelivr.net/npm/typed.js@2.0.9"', array( 'jquery' ), DIMA_VERSION, false );

			// depending on shortcodes.
			if ( $lightbox ) {
				wp_register_script( 'fancybox-js', DIMA_TEMPLATE_URL . '/framework/asset/site/js/specific/jquery.fancybox.min.js', array( 'jquery' ), DIMA_VERSION, false );
				wp_enqueue_script( 'fancybox-js' );
			}
			if ( $dropkick ) {
				wp_register_script( 'dropkick.js', DIMA_TEMPLATE_URL . '/framework/asset/site/js/specific/dropkick.js', array( 'jquery' ), DIMA_VERSION, false );
				wp_enqueue_script( 'dropkick.js' );
			}
			wp_register_script( 'video-js', DIMA_TEMPLATE_URL . '/framework/asset/site/js/specific/video.js', array( 'jquery' ), DIMA_VERSION, false );
			wp_register_script( 'bigvideo-js', DIMA_TEMPLATE_URL . '/framework/asset/site/js/specific/bigvideo.js', array( 'jquery' ), DIMA_VERSION, false );
			wp_register_script( 'okvideo-js', DIMA_TEMPLATE_URL . '/framework/asset/site/js/specific/okvideo.js', array( 'jquery' ), DIMA_VERSION, false );
			wp_register_script( 'skrollr-js', DIMA_TEMPLATE_URL . '/framework/asset/site/js/specific/skrollr.js', array( 'jquery' ), DIMA_VERSION, false );
			wp_register_script( 'slick.min', DIMA_TEMPLATE_URL . '/framework/asset/site/js/specific/slick.min.js', array( 'jquery' ), DIMA_VERSION, false );
			wp_register_script( 'headroom.min', DIMA_TEMPLATE_URL . '/framework/asset/site/js/specific/headroom.min.js', array( 'jquery' ), DIMA_VERSION, false );
			wp_register_script( 'isotope.pkgd', DIMA_TEMPLATE_URL . '/framework/asset/site/js/specific/isotope.pkgd.min.js', array( 'jquery' ), DIMA_VERSION, false );

			wp_register_script( 'jquery.particleground', DIMA_TEMPLATE_URL . '/framework/asset/site/js/specific/jquery.particleground.min.js', array( 'jquery' ), DIMA_VERSION, false );
			wp_register_script( 'dima-particles', DIMA_TEMPLATE_URL . '/framework/asset/site/js/specific/dima_canvas_bg_style_2.js', array( 'jquery' ), DIMA_VERSION, false );

			if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
				wp_enqueue_script( 'comment-reply' );
			}

			wp_register_script( 'dima-js-main', DIMA_TEMPLATE_URL . '/framework/asset/site/js/core/main.js', array( 'jquery' ), DIMA_VERSION, false );
			wp_enqueue_script( 'dima-js-main' );
			$fa     = dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_fontawesome_five' ) );
			$fa_svg = dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_fontawesome_five_svg' ) );
			$fa_upg = dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_fontawesome_five_upgrading' ) );

			if ( DIMA_WC_IS_ACTIVE ) {
				wp_register_script( 'dima-js-woocommerce', DIMA_TEMPLATE_URL . '/framework/asset/site/js/specific/dima-woo.js', array( 'jquery' ), DIMA_VERSION, false );
				if ( dima_is_wc_page() ) {
					if ( ! dima_woocommerce_version_check( '3.0.0' ) ) {
						wp_register_script( 'jquery.flexslider', DIMA_TEMPLATE_URL . '/framework/asset/site/js/specific/jquery.flexslider.js', array( 'jquery' ), DIMA_VERSION, false );
					}
					wp_enqueue_script( 'dima-js-woocommerce' );
				}
			}

			$burger_menu_style = dima_helper::dima_get_inherit_option( '_dima_meta_burger_style', 'dima_header_burger_menu_style' );
			wp_register_script( 'perfect-scrollbar', DIMA_TEMPLATE_URL . '/framework/asset/site/js/specific/perfect-scrollbar.js', array(), '1.4', false );
			if ( $burger_menu_style == 'end' || DIMA_WC_IS_ACTIVE ) {
				wp_enqueue_script( 'perfect-scrollbar' );
			}
			if ( $fa ) {
				if ( $fa_svg ) {
					wp_register_script( 'fontawesome-svg', 'https://use.fontawesome.com/releases/v5.7.1/js/all.js', array( 'jquery' ), DIMA_VERSION, false );
					wp_enqueue_script( 'fontawesome-svg' );
				}

				if ( $fa_upg ) {
					wp_register_script( 'v4-shims', 'https://use.fontawesome.com/releases/v5.7.1/js/v4-shims.js', array( 'jquery' ), DIMA_VERSION, false );
					wp_enqueue_script( 'v4-shims' );
				}
			}
			if ( ! class_exists( 'WP_Service_Worker_Caching_Routes' ) ) {
				do_action( 'dima_website_schemas' );
				do_action( 'dima_action_organization_schemas' );
			}
		}
	}

endif;

if ( ! function_exists( 'dima_admin_scripts' ) ) :
	/**
	 * Undocumented function
	 *
	 * @param [type] $hook
	 * @return void
	 */
	function dima_admin_scripts( $hook ) {
		global $wp_customize;
		if ( isset( $wp_customize ) ) {
			return;
		}
		wp_enqueue_script( DIMA_THEME_FOLDER . '-pixeldima-global-js', DIMA_TEMPLATE_URL . '/framework/asset/admin/js/pixeldima-global.js', array( 'jquery' ), DIMA_VERSION, true );
		wp_enqueue_script( 'pixeldima-popper', DIMA_TEMPLATE_URL . '/framework/asset/admin/js/popper.js', array( 'jquery' ), DIMA_VERSION, true );
		wp_enqueue_script( 'pixeldima-tippy', DIMA_TEMPLATE_URL . '/framework/asset/admin/js/tippy.standalone.js', array( 'jquery' ), DIMA_VERSION, true );
		wp_enqueue_script( 'dima-customizer-backup-js', DIMA_TEMPLATE_URL . '/framework/asset/admin/js/dima-customizer-backup.js', array( 'jquery' ), DIMA_VERSION, true );
		wp_localize_script( DIMA_THEME_FOLDER . '-pixeldima-global-js', 'dimaAdminL10nStrings', dima_get_admin_script_l10n_strings() );

	}

	function dima_get_admin_script_l10n_strings() {
		return array(
			/* translators: URL. */
			'customizer_reset_msg' => __( 'Are you sure you want to reset your Customizer settings? is not reversible unless you have previously made a backup of your settings.', 'noor' ),
			'cache_msg'            => __( 'Resets all Dynamic CSS, cleans-up the database and deletes the uploads/dima-styles folder.', 'noor' ),
			'yes'                  => __( 'Yes', 'noor' ),
			'no'                   => __( 'No', 'noor' ),
			'register_first'       => sprintf( __( 'This plugin can only be installed or updated, after you have successfully completed the theme registration on the <a href="%s" target="_blank">Theme License</a> tab.', 'noor' ), admin_url( 'admin.php?page=pixel-dima-license' ) ),
		);
	}
endif;

if ( ! function_exists( 'dima_admin_scripts_meta_box' ) ) :
	function dima_admin_scripts_meta_box( $hook ) {
		global $wp_customize;
		if ( isset( $wp_customize ) ) {
			return;
		}

		if ( $hook == 'post.php' || $hook == 'post-new.php' || $hook == 'edit-tags.php' ) {
			wp_enqueue_script(
				'dima-meta-js',
				DIMA_TEMPLATE_URL . '/framework/asset/admin/js/dima-meta-boxes.js',
				array(
					'jquery',
					'media-upload',
					'thickbox',
				),
				DIMA_VERSION,
				true
			);

			wp_enqueue_script( 'dima-cmb2-types', DIMA_TEMPLATE_URL . '/framework/asset/admin/js/cmb2-dima-types.js', array( 'jquery-ui-tabs' ), DIMA_VERSION, true );
			wp_enqueue_script( 'dima-cmb2-rgba', DIMA_TEMPLATE_URL . '/framework/asset/admin/js/jw-cmb2-rgba-picker.js', array( 'wp-color-picker' ), DIMA_VERSION, true );
		}

		if ( $hook == 'post.php' || $hook == 'post-new.php' ) {
			wp_enqueue_script( 'jquery-ui-datepicker' );
		}
	}

	function dima_enqueue_blocks() {
		wp_enqueue_script(
			'dima-meta-js-for-g',
			DIMA_TEMPLATE_URL . '/framework/asset/admin/js/dima-meta-boxes-gutenberg.js',
			array(
				'wp-blocks',
				'wp-element',
			),
			DIMA_VERSION,
			true
		);
	}

	add_action( 'enqueue_block_editor_assets', 'dima_enqueue_blocks' );

endif;


if ( ! function_exists( 'dima_customizer_control_scripts' ) ) :
	function dima_customizer_control_scripts() {
		wp_enqueue_script( 'dima-customizer-control-js', DIMA_TEMPLATE_URL . '/framework/asset/admin/js/dima-custom-controls.js', array( 'jquery' ), DIMA_VERSION, true );
		wp_enqueue_script( 'dima-customizer-conditional-js', DIMA_TEMPLATE_URL . '/framework/asset/admin/js/dima-customizer-conditional.js', array( 'jquery' ), DIMA_VERSION, true );
	}
endif;

if ( ! function_exists( 'dima_preview_customizer_scripts' ) ) :
	function dima_preview_customizer_scripts() {
		wp_enqueue_script(
			'dima-customizer-js',
			DIMA_TEMPLATE_URL . '/framework/asset/admin/js/dima-theme-customizer.js',
			array(
				'jquery',
				'customize-preview',
			),
			DIMA_VERSION,
			true
		);
	}
endif;
