<?php
/**
 * Handles remotely installing premium plugins.
 *
 * @author     PixelDima
 * @copyright  (c) Copyright by PixelDima
 * @link       http://pixeldima.com
 * @package    Dima
 * @subpackage Core
 * @since      5.0.0
 */

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

/**
 * Remote installer for premium plugins.
 * This only works with our custom server plugin.
 */
class Dima_Remote_Installer {

	/**
	 * The remote API URL.
	 *
	 * @access private
	 * @var string
	 */
	// private $api_url = 'http://ziro.local/aws-update/aws-update/';
	private $api_url = 'https://api.pixeldima.com/aws-update/';

	/**
	 * The constructor.
	 *
	 * @access public
	 */
	public function __construct() {
		$this->api_url = trailingslashit( $this->api_url );
	}


	/**
	 * Gets the download URL for a plugin.
	 *
	 * @access public
	 * @since 5.0.0
	 * @param string       $download The plugin to download.
	 * @param string|false $token    Force-use a token, or use default if false.
	 * @return string|false
	 */
	public function get_package( $download, $bucker = 'noor' ) {

		// Try to get a cached response.
		$download_src = get_transient( 'dima_remote_installer_package' . $download );

		// If we've got it cached, then return it.
		if ( false !== $download_src && ! empty( $download_src ) ) {
			 // return $download_src;
		}

		$registered = dima_is_theme_enabled();
		if ( $registered || strpos( $download, 'noor_assistant' ) !== false ) {
			$api_args = array(
				'dima_action' => 'get_download',
				'item_name'   => rawurlencode( $download ),
				'version'     => Dima::get_theme_version(),
				'b'           => $bucker,
			);

			$download_src = add_query_arg( $api_args, $this->api_url );
			$download_src = $this->dima_get_presigned_url( $download_src );
			set_transient( 'dima_remote_installer_package' . $download, $download_src, 60 * 60 * 24 );
			return $download_src;
		}
		// Something went wrong, return false.
		return false;
	}

	/**
	 * Undocumented function
	 *
	 * @param [type] $url
	 * @return void
	 */
	public function dima_get_presigned_url( $url ) {

		$response = wp_remote_get( $url );
		if ( is_wp_error( $response ) ) {
			return false;
		} else {
			$body = wp_remote_retrieve_body( $response );

			$json = json_decode( $body );
			return $json->result->url;
		}
		return false;
	}
}
