<?php
/**
 * Dima WooCommerce Quickview
 *
 * @package Noor WordPress Theme
 * @version 10.1
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * Quickview option.
 *
 * @since 9.0
 */
class dima_Woo_Quickview {

	function __construct() {

		add_action( 'wp_ajax_dima_woo_get_product', array( $this, 'dima_woo_get_product_info' ) );
		add_action( 'wp_ajax_nopriv_dima_woo_get_product', array( $this, 'dima_woo_get_product_info' ) );
		add_action( 'dima_woocommerce_before_add_to_cart', array( $this, 'dima_woo_add_quick_view_button' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		add_action( 'wp_footer', array( $this, 'dima_quick_view_markup' ) );

		$this->dima_add_template_actions();
	}

	function enqueue_scripts() {
		wp_register_script( 'dima_woo_quick_view_js', get_template_directory_uri() . '/framework/functions/extensions/quick-view/js/quick_view_actions.js', array( 'jquery' ), DIMA_VERSION, true );
		wp_enqueue_script( 'dima_woo_quick_view_js' );
		wp_enqueue_script( 'wc-add-to-cart-variation' );
		wp_enqueue_script( 'slick.min' );
		wp_enqueue_script( 'dima-quick-view' );
	}

	public function dima_woo_add_quick_view_button() {

		global $dima_options;
		global $post;

		$product_style = ( ! empty( $dima_options['product_style'] ) ) ? $dima_options['product_style'] : 'classic';
		$button_class  = ( $product_style === 'classic' ) ? 'button' : '';
		$button_icon   = dima_get_svg_icon( 'ic_remove_red_eye' );
		$get_product   = wc_get_product( $post->ID );

		if ( $get_product->is_type( 'grouped' ) || $get_product->is_type( 'external' ) ) {
			return;
		}

		echo '<a href="#quick-view" class="dima_quick_view no-ajaxy ' . $button_class . '" data-product-id="' . $post->ID . '"> ' . $button_icon . '</a>';

	}

	public function dima_quick_view_markup() {

		global $dima_options;
		$quick_view_sizing = 'cropped';

		echo '<div class="dima-quick-view-box-backdrop"></div>';

		echo '<div class="dima-quick-view-box dima-product single-product product-details" data-image-sizing="' . $quick_view_sizing . '">
				<div class="inner-wrap">
					<div class="close">
						<a href="#" class="no-ajaxy">
							<span class="close-wrap flex justify-center self-center">' . dima_get_svg_icon( 'ic_close' ) . '</span>
						</a>
					</div>

					<div class="product-loading"></div>

					<div class="preview_image"></div>

					<div class="inner-content">
						<div class="product">
							<div class="product type-product">
								<div class="woocommerce-product-gallery">
								</div>
								<div class="summary entry-summary product-shop scrollable">
									<div class="summary-content">
									</div>
								</div>
							</div>
						</div>
					</div>

				</div>
			</div>';

	}


	public function dima_add_template_actions() {
		add_action( 'dima_quick_view_summary_content', 'woocommerce_template_single_title' );
		add_action( 'dima_quick_view_summary_content', 'woocommerce_template_single_rating' );
		add_action( 'dima_quick_view_summary_content', 'woocommerce_template_single_price' );
		add_action( 'dima_quick_view_summary_content', 'woocommerce_template_single_excerpt' );
		add_action( 'dima_quick_view_summary_content', 'woocommerce_template_single_add_to_cart' );
		add_action( 'dima_quick_view_sale_content', 'woocommerce_show_product_sale_flash' );

	}


	public function dima_woo_get_product_info() {

		global $woocommerce;
		global $post;

		$product_id = intval( $_POST['product_id'] );

		if ( intval( $product_id ) ) {

			wp( 'p=' . $product_id . '&post_type=product' );

			ob_start();

			while ( have_posts() ) :
				the_post(); ?>

			 <script>
		  var wc_add_to_cart_variation_params = {};
			 </script>

			<div class="product">

					<div itemscope id="product-<?php the_ID(); ?>" <?php post_class( 'product' ); ?> >

						  <?php

							do_action( 'dima_quick_view_sale_content' );

							global $product;
							if ( has_post_thumbnail() ) {
								?>
						  <div class="images">
						  <div class="dima-product-slider generate-markup">

						   <div class="carousel-cell woocommerce-product-gallery__image">
								   <a href="#">
									   <?php echo get_the_post_thumbnail( $post->ID, 'large' ); ?>
								   </a>
						   </div>

								<?php
								$product_attach_ids = $product->get_gallery_image_ids();
								if ( $product_attach_ids ) {

									foreach ( $product_attach_ids as $product_attach_id ) {

										$img_link = wp_get_attachment_url( $product_attach_id );

										if ( ! $img_link ) {
											continue;
										}

										printf( '<div class="carousel-cell woocommerce-product-gallery__image"><a href="%s" title="%s"> %s </a></div>', wp_get_attachment_url( $product_attach_id ), esc_attr( get_post( $product_attach_id )->post_title ), wp_get_attachment_image( $product_attach_id, 'large' ) );

									}// foreach

								} //if attach ids

								echo '</div> <!--dima-product-slider--> </div>';

							} else {
								$html  = '<div class="woocommerce-product-gallery__image--placeholder">';
								$html .= sprintf( '<img src="%s" alt="%s" class="wp-post-image" />', esc_url( wc_placeholder_img_src() ), esc_html__( 'Awaiting product image', 'woocommerce' ) );
								$html .= '</div>';
							}
							?>

							 <div class="summary entry-summary product-shop scrollable">
									 <div class="summary-content">
									   <?php
										do_action( 'dima_quick_view_summary_content' );
										?>
									 </div>
							 </div>

					 </div>
			 </div>

			<?php endwhile;

			echo ob_get_clean();

			exit();

		}
	}

}


$dima_quick_view = new dima_Woo_Quickview();

?>
