jQuery(document).ready(function($) {
	$("body").on("click", ".products article.product a.dima_quick_view", function(
		e
	) {
		e.preventDefault();

		var $quickViewBox = $(".dima-quick-view-box");
		var $product_id = $(this).data("product-id");

		//exit if no ID passed
		if (typeof $product_id === "undefined") {
			return;
		}

		quickView($(this).parents("article.product"), "open");

		//empty old product info
		$quickViewBox.find(".inner-content").empty();

		//get product info
		$.ajax({
			type: "POST",
			url: pxdm_js.ajaxurl,
			data: {
				action: "dima_woo_get_product",
				product_id: $product_id
			},
			success: function(response) {
				$quickViewBox.find(".inner-content").html(response);

				//store variation starting attr
				$vari_startingImage =
					$quickViewBox.find(".dima-product-slider div.carousel-cell:first img")
						.length > 0
						? $quickViewBox
								.find(".dima-product-slider div.carousel-cell:first img")
								.attr("src")
						: "";

				//slide BG Cover
				if ($('.dima-quick-view-box[data-image-sizing="cropped"]').length > 0) {
					slickSlideCover();
				}

				//variations
				if (typeof wc_add_to_cart_variation_params !== "undefined") {
					$(".variations_form").each(function() {
						$(this).wc_variation_form();
					});
				}

				//quantity
				quantityButtons();

				$(".dima-quick-view-box").addClass("fully-open");

				$(".dima-quick-view-box-backdrop").addClass("visible");
				setTimeout(function() {
					$(".dima-quick-view-box")
						.addClass("animate-width")
						.velocity(
							{
								left: productQV_Left + "px",
								width: productQV_Width + "px"
							},
							550,
							//"cubic-bezier(.55,0,.1,1)",
							function() {
								let is_rtl = pxdm_js.is_rtl ? true : false;
								//init slick
								$carousel = $(
									".dima-quick-view-box .dima-product-slider"
								).slick({
									//contain: true,
									lazyLoad: false,
									imagesLoaded: true,
									dots: false,
									resize: true,
									accessibility: false,
									rtl: is_rtl
									//percentPosition: true,
									//prevNextButtons: false,
									//setGallerySize: true,
									//wrapAround: true,
								});

								//show quick view content
								$(".dima-quick-view-box .preview_image").hide();
								$(".dima-quick-view-box").addClass("add-content");
								$(".dima-quick-view-box").addClass("fixedPos");
							}
						);
				}, 350);
			} // success
		}); //ajax
	}); //quick view click

	$("body").on(
		"click",
		".dima-quick-view-box-backdrop, .dima-quick-view-box .close",
		function(e) {
			e.preventDefault();
			if ($(".dima-quick-view-box.fully-open").length > 0) {
				quickView($(".product.open-dima-quick-view"), "close");
			}
		}
	);

	var $startingImage, $carousel, productQV_Width, productQV_Left, newHeight;

	function quickView(el, state) {
		var viewportWidth = window.innerWidth;
		var viewportHeight = window.innerHeight;

		var topSelected = el.offset().top - $(window).scrollTop(),
			leftSelected = el.offset().left,
			widthSelected = el.find("img").width(),
			heightSelected = el.find("img").height();

		var aspectRatio =
			parseInt(el.find(".box-image img").height()) /
			parseInt(el.find(".box-image img").width());

		var endingWidth = 425;

		if (aspectRatio < 1.1) {
			endingWidth = 550;
		}
		if (aspectRatio > 1.5) {
			endingWidth = 350;
		}

		newHeight = Math.floor(aspectRatio * endingWidth);
		var endingTop = (viewportHeight - newHeight) / 2;
		var endingLeft = (viewportWidth - endingWidth) / 2;

		productQV_Width = endingWidth + 475;
		productQV_Left = (viewportWidth - productQV_Width) / 2;

		if (state == "open") {
			//copy image
			var productImg = el.find(".box-image img:first").clone();
			$(".dima-quick-view-box .preview_image")
				.show()
				.html(productImg);

			$(".dima-quick-view-box").addClass("box-shadow-trans");
			$(".dima-quick-view-box").css({
				position: "fixed",
				transform: "",
				opacity: "1",
				top: topSelected,
				left: leftSelected,
				width: widthSelected,
				height: heightSelected
			});

			//hide item and show the quick view
			setTimeout(function() {
				el.addClass("open-dima-quick-view");
				$(".dima-quick-view-box").addClass("visible");
				$(".dima-quick-view-box-backdrop").css({
					visibility: "visible",
					"z-index": "10000",
					"pointer-events": "all"
				});
			}, 75);

			//show loading
			setTimeout(function() {
				$(".dima-quick-view-box").addClass("loading-vis");
			}, 75);

			setTimeout(function() {
				//animate size
				$(".dima-quick-view-box").velocity(
					{
						top: endingTop + "px",
						left: endingLeft + "px",
						width: endingWidth - 1 + "px",
						height: newHeight + "px"
					},
					{
						duration: 350,
						easing: "easeInSine"
					}
				);
			}, 125); //125
		} else {
			/*# close #*/
			$(".dima-quick-view-box").removeClass("fully-open");
			$(".dima-quick-view-box-backdrop").removeClass("visible");

			$.Velocity.animate(
				$(".dima-quick-view-box"),
				{ scale: "0.8", opacity: "0" },
				{
					duration: 450,
					easing: "easeOutSine"
				}
			).then(function() {
				el.removeClass("open-dima-quick-view");
				var $img = $(
					".dima-product-slider .slick-track .carousel-cell:first-child > img"
				);
				$startingImage = $img.length > 0 ? $img.attr("src") : "";
				$(".dima-quick-view-box-backdrop").css({
					visibility: "hidden",
					"z-index": "-1",
					"pointer-events": "none"
				});
				$(".dima-quick-view-box")
					.removeClass("visible")
					.removeClass("add-content")
					.removeClass("loading-vis")
					.removeClass("animate-width")
					.removeClass("fixedPos");
			});
		}
	} //quickview function

	function resizePos() {
		$(".dima-quick-view-box.fixedPos").css({
			left: ($(window).width() - $(".dima-quick-view-box").width()) / 2,
			top: ($(window).height() - $(".dima-quick-view-box").height()) / 2
		});
	}

	$(window).on("resize", resizePos);

	function slickSlideCover() {
		$(".dima-quick-view-box div.images img").css({
			height: parseInt($(".dima-quick-view-box").height()) + 4 + "px"
		});

		//set imgs as BGs
		$(".dima-quick-view-box .carousel-cell").each(function() {
			var $storedImgSrc = $(this)
				.find("img")
				.css("visibility", "hidden")
				.attr("src");

			if (typeof newHeight != "undefined") {
				$(this)
					.find("img")
					.css({
						height: newHeight + 4
					});
			}

			$(this).css({
				"background-image": "url(" + $storedImgSrc + ")",
				"background-size": "cover",
				"background-position": "center"
			});
		});
	}

	//variation support
	var $vari_startingImage = "";

	$("body").on(
		"blur",
		'.dima-quick-view-box select[name*="attribute_"]',
		function() {
			var $that = $(this);
			var attr_data = $(".variations_form").data("product_variations");
			var $parent_quick_view = $(this).parents(".dima-quick-view-box");

			if ($that.val().length > 0) {
				//give woo time to update img
				setTimeout(function() {
					$(attr_data).each(function(i, el) {
						if (el.image && el.image.src) {
							if (
								el.image.src ==
								$parent_quick_view
									.find(".slick-track div.carousel-cell:first a > img")
									.attr("src")
							) {
								if (el.image.url) {
									$parent_quick_view
										.find(".slick-track div.carousel-cell:first")
										.css("background-image", "url(" + el.image.src + ")");
									$carousel.slick("select", 0, true, false);
								} // if found img url
							} // if the sources match
						} // if img source exists
					}); //loop through attrs
				}, 30);
			} else {
				//reset to original
				$parent_quick_view
					.find(".slick-track div.carousel-cell:first")
					.css("background-image", "url(" + $vari_startingImage + ")");
			}
		}
	); //blur variation

	$("body").on(
		"change",
		'.dima-quick-view-box select[name*="attribute_"]',
		function() {
			//keep classes from default hidden btn and full width btn the same
			if (
				$(
					".dima-quick-view-box .product .product > .single_add_to_cart_button_wrap .single_add_to_cart_button"
				).length > 0
			) {
				setTimeout(function() {
					var addToCartClasses = $(
						".dima-quick-view-box .summary-content .single_add_to_cart_button"
					).attr("class");
					$(
						".dima-quick-view-box .product .product > .single_add_to_cart_button_wrap .single_add_to_cart_button"
					).attr("class", addToCartClasses);
				}, 290);
			}
		}
	); //blur variation 2

	function select2Init() {
		$(".dima-quick-view-box select").each(function() {
			$(this).select2({
				minimumResultsForSearch: 7,
				width: "100%"
			});
		});
	}

	// Quantity buttons
	function quantityButtons() {
		if ($(".dima-quick-view-box .plus").length == 0) {
			$(
				".dima-quick-view-box div.quantity:not(.buttons_added), .dima-quick-view-box td.quantity:not(.buttons_added)"
			)
				.addClass("buttons_added")
				.append('<input type="button" value="+" class="plus" />')
				.prepend('<input type="button" value="-" class="minus" />');
		}

		//also move add to cart button
		setTimeout(function() {
			var addToCartBtnText = $(
				".dima-quick-view-box .summary-content .single_add_to_cart_button"
			).text();
			var addToCartBtnClasses =
				$(
					".dima-quick-view-box .summary-content .single_add_to_cart_button[class]"
				).length > 0
					? $(
							".dima-quick-view-box .summary-content .single_add_to_cart_button"
					  ).attr("class")
					: "";
			//bind click to original button
			$(
				".dima-quick-view-box .product .product .single_add_to_cart_button_wrap > .single_add_to_cart_button"
			)
				.attr("class", addToCartBtnClasses)
				.on("click", function(e) {
					e.preventDefault(e);
					$(
						".dima-quick-view-box .summary-content .single_add_to_cart_button"
					).trigger("click");
				});
		}, 150);
	}
});
