<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class DIMA_AMP_WC {

	private static $instance = null;

	public static function get_instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new DIMA_AMP_WC();
		}

		return self::$instance;
	}

	private function __clone() {
	}

	private function __construct() {
	}

	public function dima_amp_get_woo_item_content( $postid ) {
		global $product;
		$product = wc_get_product( $postid );

		$output = '';
		if ( empty( $product ) || ! $product->is_visible() ) {
			return '';
		}
		$post_thumbnail_id = get_post_thumbnail_id( $postid );
		$full_size_image   = wp_get_attachment_image_src( $post_thumbnail_id, 'shop_single' );
		$attributes        = array(
			'title'                   => get_post_field( 'post_title', $post_thumbnail_id ),
			'data-caption'            => get_post_field( 'post_excerpt', $post_thumbnail_id ),
			'data-src'                => $full_size_image[0],
			'data-large_image'        => $full_size_image[0],
			'data-large_image_width'  => $full_size_image[1],
			'data-large_image_height' => $full_size_image[2],
		);
		$attachment_ids    = $product->get_gallery_image_ids();

		if ( $attachment_ids ) {
			$output .= '<amp-carousel width="' . $full_size_image[1] . '" height="' . $full_size_image[2] . '" type="slides" >';
			$output .= get_the_post_thumbnail( $postid, 'shop_single', $attributes );
			foreach ( $attachment_ids as $attachment_id ) {
				$output .= wp_get_attachment_image( $attachment_id, 'shop_single', false, $attributes );
			}
			$output .= '</amp-carousel>';

		} elseif ( $product->get_image_id() ) {
			$output .= '<amp-carousel width="' . $full_size_image[1] . '" height="' . $full_size_image[2] . '" type="slides" >';
			$output .= get_the_post_thumbnail( $postid, 'shop_single', $attributes );
			$output .= wp_get_attachment_image( $postid, 'shop_single', false, $attributes );
			$output .= '</amp-carousel>';
		}

		// tilte.
		$output .= '<h1 class="amp-wp-title">' . wp_kses_data( get_the_title( $postid ) ) . '</h1>';
		$output .= '<span class="dima-divider line-start line-hr small-line"></span>';

		// rate.
		$rating = wc_get_rating_html( $product->get_average_rating() );
		if ( ! empty( $rating ) && wc_review_ratings_enabled() ) {
			$output .= '<div class="star-rating-container aggregate">' . $rating . '</div>';
		}
		$output .= '<div class="price">';
		$output .= $product->get_price_html();
		$output .= '</div>';

		return $output;

	}

}

if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
	DIMA_AMP_WC::get_instance();
	function DIMA_AMP_WC() {
		return DIMA_AMP_WC::get_instance();
	}
}
