<?php
/**
 * Setup : DIMA Plugins
 *
 * @package Dima Framework
 * @subpackage Admin Setup
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Show plugins tab
 *
 * @return void
 */
function dima_setup_plugins() {
	if ( ! function_exists( 'get_plugins' ) ) {
		require_once wp_normalize_path( ABSPATH . 'wp-admin/includes/plugin.php' );
	}
	$pixeldima_setup_path = DIMA_TEMPLATE_PATH . '/framework/functions/admin/pixeldima-setup';
	require_once $pixeldima_setup_path . '/framework-dima-nav-tab.php';
	$plugins           = TGM_Plugin_Activation::$instance->plugins;
	$installed_plugins = get_plugins();
	$wp_api_plugins    = get_site_transient( 'dima_wordpress_org_plugins' );
	if ( ! function_exists( 'plugins_api' ) ) {
		include_once ABSPATH . 'wp-admin/includes/plugin-install.php'; // For plugins_api.
	}

	if ( ! $wp_api_plugins ) {
		$wp_org_plugins = array(
			'woocommerce'               => 'woocommerce/woocommerce.php',
			'yith-woocommerce-wishlist' => 'yith-woocommerce-wishlist/init.php',
			'wordpress-seo'             => 'wordpress-seo/wp-seo.php',
			'bbpress'                   => 'bbpress/bbpress.php',
			'the-events-calendar'       => 'the-events-calendar/the-events-calendar.php',
			'contact-form-7'            => 'contact-form-7/wp-contact-form-7',
			'amp'                       => 'amp/amp.php',
			'under-construction-page'   => 'under-construction-page/under-construction.php',
			'dima-take-action'          => 'dima-take-action/dima-take-action.php',
			'wp-page-widget'            => 'wp-page-widget/wp-page-widgets.php',
			'easy-digital-downloads'    => 'easy-digital-downloads/easy-digital-downloads.php',
		);
		$wp_api_plugins = array();
		foreach ( $wp_org_plugins as $slug => $path ) { // phpcs:ignore WordPress.WP.GlobalVariablesOverride.OverrideProhibited
			$wp_api_plugins[ $slug ] = (array) plugins_api(
				'plugin_information',
				array(
					'slug' => $slug,
				)
			);
		}
		set_site_transient( 'dima_wordpress_org_plugins', $wp_api_plugins, 15 * MINUTE_IN_SECONDS );
	}
	?>
	<div class="about-wrap pixeldima-home">
		<?php
		dima_admin_notice_message(
			array(
				'notice_id'   => 'theme_not_authorized',
				'title'       => esc_html__( 'Plugins', 'noor' ),
				'message'     => sprintf( esc_html__( 'All the plugins are well tested to work with %s and we keep them up to date. The themes comes packed with the following premium and free plugins', 'noor' ), strtoupper( DIMA_THEME_NAME ) ),
				'dismissible' => false,
				'class'       => 'standar',
				'standard'    => false,
			)
		);
		?>
		<ul id="dima-install-plugins" class="pixeldima-extensions-list flex flex-wrap justify-between">
			<?php
			foreach ( $plugins as $plugin ) :

				if ( ! isset( $plugin['dima_author'] ) ) {
					$plugin['dima_author'] = '';
				}
				$class         = '';
				$plugin_status = '';
				$file_path     = $plugin['file_path'];
				$plugin_action = dima_plugin_link( $plugin );

				// We have a repo plugin.
				if ( ! $plugin['version'] ) {
					$plugin['version'] = TGM_Plugin_Activation::$instance->does_plugin_have_update( $plugin['slug'] );
				}

				if ( is_plugin_active( $file_path ) ) {
					$status         = 'active';
					$status_message = esc_html__( 'Active', 'noor' );
					$class          = 'active dima-button-green';
				} else {
					$status         = 'inactive';
					$status_message = esc_html__( 'Inactive', 'noor' );
					$class          = 'inactive dima-button-warning';
				}
				if ( ! dima_helper::dima_is_plugin_exists( $plugin['file_path'] ) ) {
					$install_type   = 'install';
					$status         = 'not-installed';
					$status_message = esc_html__( 'Not Installed', 'noor' );
					$class          = 'not-installed dima-button-warning';
				}

				if ( isset( $plugin_action['update'] ) && $plugin_action['update'] ) {
					$class .= ' update';
				}

				?>
				<li class="pixeldima-extension shadow-md flex flex-col <?php echo esc_attr( $status ); ?>"
					id="<?php echo esc_attr( $plugin['slug'] ); ?>">
					<div class="pixeldima-extension-content">
						<?php if ( isset( $plugin_action['update'] ) && $plugin_action['update'] ) : ?>
						<div class="update-message notice inline notice-warning notice-alt">
							<?php /* translators: Version number. */ ?>
							<p><?php printf( esc_html__( 'New Version Available: %s', 'noor' ), esc_html( $plugin['version'] ) ); ?></p>
						</div>
						<?php endif; ?>

						<img src="<?php echo esc_url( $plugin['dima_logo'] ); ?>" class="img">
						<div class="info">
							<h4 class="title"><?php echo esc_attr( $plugin['name'] ); ?>
							<?php

							if ( isset( $installed_plugins[ $plugin['file_path'] ] ) ) {
								?>
								<span class="plugin-author"><?php printf( __( 'v%1$s | <a href="%2$s" target="_blank">%3$s</a>', 'noor' ), esc_html( $installed_plugins[ $plugin['file_path'] ]['Version'] ), esc_url_raw( $installed_plugins[ $plugin['file_path'] ]['AuthorURI'] ), esc_html( $installed_plugins[ $plugin['file_path'] ]['Author'] ) ); // WPCS: XSS ok. ?></span>
								<?php
							} else {
								$version = ( isset( $plugin['version'] ) ) ? $plugin['version'] : false;
								$version = ( isset( $wp_api_plugins[ $plugin['slug'] ] ) && isset( $wp_api_plugins[ $plugin['slug'] ]['version'] ) ) ? $wp_api_plugins[ $plugin['slug'] ]['version'] : $version;
								if ( isset( $plugin['plugin_author_url'] ) ) {
									?>
								<span class="plugin-author"><?php printf( __( 'v%1$s || <a href="%2$s">%3$s</a>', 'noor' ), $version, $plugin['plugin_author_url'], $plugin['dima_author'] ); ?></span>
									<?php
								}
							}
							?>
							</h4>
							<?php if ( isset( $plugin['required'] ) && $plugin['required'] ) : ?>
							<div class="status required">
								<?php esc_html_e( 'Required', 'noor' ); ?>
							</div>
							<?php endif; ?>
							<?php if ( isset( $plugin['premium'] ) && $plugin['premium'] ) : ?>
							<div class="status premium">
								<?php esc_html_e( 'Premium', 'noor' ); ?>
							</div>
							<?php endif; ?>
							<span class="status <?php echo esc_attr( $status ); ?>"><?php echo esc_attr( $status_message ); ?></span>

						</div>
					</div>
					<div class="btn text-center">
							<div class="theme-actions">
								<?php foreach ( $plugin_action as $action ) : // phpcs:ignore WordPress.WP.GlobalVariablesOverride.OverrideProhibited ?>
									<?php
									// No need to re-sanitize it...
									echo $action; // WPCS: XSS ok.
									?>
								<?php endforeach; ?>
							</div>
					</div>

				</li>

			<?php endforeach; ?>

		</ul>

	</div>

	<?php
}

/**
 * Undocumented function
 *
 * @param [type] $item
 * @return void
 */
function dima_plugin_link( $item ) {
	if ( ! function_exists( 'get_plugins' ) ) {
		require_once wp_normalize_path( ABSPATH . 'wp-admin/includes/plugin.php' );
	}
	$installed_plugins = get_plugins();

	$item['sanitized_plugin'] = $item['name'];

	$actions = array();

	// We have a repo plugin.
	if ( ! $item['version'] ) {
		$item['version'] = TGM_Plugin_Activation::$instance->does_plugin_have_update( $item['slug'] );
	}

	$disable_class = '';
	$data_version  = '';
	if ( 'noor_assistant' !== $item['slug'] && $item['premium'] && ! dima_is_theme_enabled() ) {
		$disable_class = ' disabled noor-no-token';
	}
	// We need to display the 'Install' hover link.
	if ( ! isset( $installed_plugins[ $item['file_path'] ] ) ) {
		if ( ! $disable_class ) {
			$url = esc_url(
				wp_nonce_url(
					add_query_arg(
						array(
							'page'          => rawurlencode( TGM_Plugin_Activation::$instance->menu ),
							'plugin'        => rawurlencode( $item['slug'] ),
							'plugin_name'   => rawurlencode( $item['sanitized_plugin'] ),
							'tgmpa-install' => 'install-plugin',
							'return_url'    => 'pixeldima-setup-plugins',
						),
						TGM_Plugin_Activation::$instance->get_tgmpa_url()
					),
					'tgmpa-install',
					'tgmpa-nonce'
				)
			);
		} else {
			$url = '#';
		}

		$actions = array(
			/* translators: Plugin name. */
			'install' => '<a href="' . $url . '" class="button dima-primary-button w-full ' . $disable_class . '"' . $data_version . ' title="' . sprintf( esc_attr__( 'Install %s', 'noor' ), $item['sanitized_plugin'] ) . '">' . esc_attr__( 'Install', 'noor' ) . '</a>',
		);

	} elseif ( version_compare( $installed_plugins[ $item['file_path'] ]['Version'], $item['version'], '<' ) ) {
		// We need to display the 'Update' hover link.
		$url = wp_nonce_url(
			add_query_arg(
				array(
					'page'         => rawurlencode( TGM_Plugin_Activation::$instance->menu ),
					'plugin'       => rawurlencode( $item['slug'] ),
					'tgmpa-update' => 'update-plugin',
					'version'      => rawurlencode( $item['version'] ),
					'return_url'   => 'pixeldima-setup-plugins',
				),
				TGM_Plugin_Activation::$instance->get_tgmpa_url()
			),
			'tgmpa-update',
			'tgmpa-nonce'
		);

		$actions = array(
			/* translators: Plugin Name. */
			'update' => '<a href="' . $url . '" class="button dima-primary-button dima-button-warning w-full ' . $disable_class . '" title="' . sprintf( esc_attr__( 'Update %s', 'noor' ), $item['sanitized_plugin'] ) . '">' . esc_attr__( 'Update', 'noor' ) . '</a>',
		);
	} elseif ( is_plugin_inactive( $item['file_path'] ) ) {
		// We need to display the 'Activate' hover link.
		$url     = esc_url(
			add_query_arg(
				array(
					'plugin'              => rawurlencode( $item['slug'] ),
					'plugin_name'         => rawurlencode( $item['sanitized_plugin'] ),
					'dima-activate'       => 'activate-plugin',
					'dima-activate-nonce' => wp_create_nonce( 'dima-activate' ),
				),
				admin_url( 'admin.php?page=pixeldima-setup-plugins' )
			)
		);
		$actions = array(
			/* translators: Plugin Name. */
			'activate' => '<a href="' . $url . '" class="button dima-primary-button w-full"' . $data_version . ' title="' . sprintf( esc_attr__( 'Activate %s', 'noor' ), $item['sanitized_plugin'] ) . '">' . esc_attr__( 'Activate', 'noor' ) . '</a>',
		);
	} elseif ( is_plugin_active( $item['file_path'] ) ) {
		$url     = esc_url(
			add_query_arg(
				array(
					'plugin'                => rawurlencode( $item['slug'] ),
					'plugin_name'           => rawurlencode( $item['sanitized_plugin'] ),
					'dima-deactivate'       => 'deactivate-plugin',
					'dima-deactivate-nonce' => wp_create_nonce( 'dima-deactivate' ),
				),
				admin_url( 'admin.php?page=pixeldima-setup-plugins' )
			)
		);
		$actions = array(
			/* translators: Plugin name. */
			'deactivate' => '<a href="' . $url . '" class="button dima-primary-button w-full" title="' . sprintf( esc_attr__( 'Deactivate %s', 'noor' ), $item['sanitized_plugin'] ) . '">' . esc_attr__( 'Deactivate', 'noor' ) . '</a>',
		);
	} // End if().

	return $actions;
}


	/**
	 * Actions to run on initial theme activation.
	 *
	 * @since 3.8.0
	 * @access public
	 * @return void
	 */
function dima_plugin_admin_init() {

	if ( current_user_can( 'switch_themes' ) ) {

		if ( isset( $_GET['dima-deactivate'] ) && 'deactivate-plugin' === $_GET['dima-deactivate'] ) {
			check_admin_referer( 'dima-deactivate', 'dima-deactivate-nonce' );

			$plugins = TGM_Plugin_Activation::$instance->plugins;

			foreach ( $plugins as $plugin ) {
				if ( isset( $_GET['plugin'] ) && $plugin['slug'] == $_GET['plugin'] ) {
					deactivate_plugins( $plugin['file_path'] );
				}
			}
		}
		if ( isset( $_GET['dima-activate'] ) && 'activate-plugin' === $_GET['dima-activate'] ) {
			check_admin_referer( 'dima-activate', 'dima-activate-nonce' );

			$plugins = TGM_Plugin_Activation::$instance->plugins;

			foreach ( $plugins as $plugin ) {
				if ( isset( $_GET['plugin'] ) && $plugin['slug'] == $_GET['plugin'] ) {
					activate_plugin( $plugin['file_path'] );

					wp_safe_redirect( admin_url( 'admin.php?page=pixeldima-setup-plugins' ) );
					exit;
				}
			}
		}
	}
}
add_action( 'admin_init', 'dima_plugin_admin_init' );
