<?php
/**
 * Setup : Welcome Page
 *
 * @package Dima Framework
 * @subpackage Admin Setup
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Undocumented function
 *
 * @return void
 */
function dima_setup_page_home() {
	$pixeldima_setup_path = DIMA_TEMPLATE_PATH . '/framework/functions/admin/pixeldima-setup';
	require_once $pixeldima_setup_path . '/framework-dima-nav-tab.php';
	?>

	<div class="about-wrap pixeldima-home">

		<?php
		ob_start();
		?>
		<h2><?php printf( esc_html__( 'Need help? We\'re here %s', 'noor' ), '&#x1F60A' ); ?></h2>

		<div class="changelog">
			<div class="feature-section flex">

				<div class="flex-1 bg-white p-5 m-2 pt-8 pb-8 shadow-md text-center">
					<svg class="h-24 w-24 text-gray-700 stroke-current" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-youtube"><path d="M22.54 6.42a2.78 2.78 0 0 0-1.94-2C18.88 4 12 4 12 4s-6.88 0-8.6.46a2.78 2.78 0 0 0-1.94 2A29 29 0 0 0 1 11.75a29 29 0 0 0 .46 5.33A2.78 2.78 0 0 0 3.4 19c1.72.46 8.6.46 8.6.46s6.88 0 8.6-.46a2.78 2.78 0 0 0 1.94-2 29 29 0 0 0 .46-5.25 29 29 0 0 0-.46-5.33z"></path><polygon points="9.75 15.02 15.5 11.75 9.75 8.48 9.75 15.02"></polygon></svg>
					<h3>
						<?php echo esc_html__( 'How-to Videos', 'noor' ); ?>
					</h3>
					<p><?php esc_html_e( 'Our How-to videos is perfect for learning about Noor and what is possible.', 'noor' ); ?></p>
					<br>
					<a href="https://www.youtube.com/watch?v=H4oxTfsVx3E&list=PLnqcQSxXL3f2bEptqV0P2eteIxZi62Ynv" target="_blank" rel="noopener"
					   class="button button-primary"><?php esc_html_e( 'Open Videos', 'noor' ); ?></a>
				</div>

				<div class="flex-1 bg-white p-5 pt-8 pb-8 m-2 shadow-md text-center">
				<svg class="h-24 w-24 text-gray-700 stroke-current" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-book"><path d="M4 19.5A2.5 2.5 0 0 1 6.5 17H20"></path><path d="M6.5 2H20v20H6.5A2.5 2.5 0 0 1 4 19.5v-15A2.5 2.5 0 0 1 6.5 2z"></path></svg>
					<h3>
						<?php esc_html_e( 'Online Documentation', 'noor' ); ?>
					</h3>
					<p><?php esc_html_e( 'We recommend you to browse through the Knowledge Base which cover most of your questions.', 'noor' ); ?></p>
					<a href="http://docs.pixeldima.com/noor/" target="_blank" rel="noopener" class="button button-primary"><?php esc_html_e( 'Open Documentation', 'noor' ); ?></a>
				</div>

				<div class="flex-1 bg-white p-5 m-2 pt-8 pb-8 shadow-md text-center">
				<svg class="h-24 w-24 text-gray-700 stroke-current" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-help-circle"><circle cx="12" cy="12" r="10"></circle><path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3"></path><line x1="12" y1="17" x2="12" y2="17"></line></svg>
					<h3>
						<?php echo esc_html__( 'Premium Support', 'noor' ); ?>
					</h3>
					<p><?php esc_html_e( 'Need one-to-one assistance? Get in touch with our Support team.', 'noor' ); ?></p>
					<br>
					<?php if ( ! dima_is_theme_enabled() ) { ?>
					<a href="<?php echo admin_url() . 'admin.php?page=pixel-dima-license'; ?>" class="button button-primary">Activate Theme to get support</a>
					<?php } elseif ( dima_is_support_expired( basename( get_template_directory() ) ) ) { ?>
					<p><strong>Support has expired :(</strong></p>
					<a target="_blank" href="<?php echo esc_url_raw( DIMA_THEME_ENVATO_URL ); ?>" class="button button-warning" style="color:red;">+ Extend Support time</a>
						<?php
					} else {
						?>
					<a href="https://docs.pixeldima.com/support/" class="button button-primary" target="_blank">
						<?php _e( 'Send us a Support Ticket', 'noor' ); ?>
					</a>
					<br><br><small><a href="https://themeforest.net/page/item_support_policy" target="_blank"><?php _e( 'What does support include?', 'noor' ); ?></a></small>
					<?php } ?>
				</div>
			</div>

		</div>

		<hr/>

		<ul id="follow-pixeldima">
			<li class="follow-pixeldima-fb">
				<div id="fb-root"></div>
				<script>(function (d, s, id) {
						var js, fjs = d.getElementsByTagName(s)[0];
						if (d.getElementById(id)) return;
						js = d.createElement(s);
						js.id = id;
						js.src = "//connect.facebook.net/en_US/sdk.js#xfbml=1&version=v2.9&appId=280065775530401";
						fjs.parentNode.insertBefore(js, fjs);
					}(document, 'script', 'facebook-jssdk'));</script>
				<div class="fb-like" data-href="https://facebook.com/pixeldima" data-layout="button_count"
					 data-action="like" data-size="large" data-show-faces="false" data-share="false"></div>
			</li>

			<li class="follow-pixeldima-twitter">
				<a href="https://twitter.com/pixeldima" class="twitter-follow-button" data-size="large"
				   data-show-count="false">Follow @pixeldima</a>
				<?php
				wp_enqueue_script( 'twitter-widgets', '//platform.twitter.com/widgets.js' );
				?>
			</li>
		</ul>


		<?php
		$output = ob_get_contents();
		ob_end_clean();
		?>

		<?php echo apply_filters( 'dima_addons_home_content', $output ); ?>

	</div>

	<?php
}
