<?php

add_action( 'cmb2_admin_init', 'dima_register_taxonomy_post_metabox' );
/**
 * Hook in and add a metabox to add fields to taxonomy terms
 */
function dima_register_taxonomy_post_metabox() {
	$prefix = '_dima_';
	/**
	 * Metabox to add fields to categories and tags
	 */
	$cmb_term = new_cmb2_box(
		array(
			'id'           => $prefix . 'post_category_edit',
			'title'        => esc_html__( 'Category Metabox', 'noor' ),
			'object_types' => array( 'term' ),
			'taxonomies'   => array( 'category' ),
			'cmb_styles'   => false,
		)
	);
	$cmb_term->add_field(
		array(
			'name' => esc_html__( 'Category Thumbnail Image', 'noor' ),
			'id'   => $prefix . 'category_thumbnail_image',
			'type' => 'file',
		)
	);
	$cmb_term->add_field(
		array(
			'name' => esc_html__( 'Category Page Tile Image', 'noor' ),
			'id'   => $prefix . 'category_image',
			'type' => 'file',
		)
	);
	$cmb_term->add_field(
		array(
			'name' => esc_html__( 'Category Color', 'noor' ),
			'id'   => $prefix . 'term_text_field',
			'type' => 'rgba_colorpicker',
		)
	);
}

add_action( 'cmb2_admin_init', 'dima_register_taxonomy_shop_metabox' );
/**
 * Hook in and add a metabox to add fields to taxonomy terms
 */
function dima_register_taxonomy_shop_metabox() {
	$prefix = '_dima_';
	/**
	 * Metabox to add fields to categories and tags
	 */
	$cmb_term = new_cmb2_box(
		array(
			'id'           => $prefix . 'shop_category_edit',
			'title'        => esc_html__( 'Category Metabox', 'noor' ),
			'object_types' => array( 'term' ),
			'taxonomies'   => array( 'product_cat' ),
			'cmb_styles'   => false,
		)
	);
	$cmb_term->add_field(
		array(
			'name' => esc_html__( 'Category Page Tile Image', 'noor' ),
			'id'   => $prefix . 'product_category_image',
			'type' => 'file',
		)
	);
	$cmb_term->add_field(
		array(
			'name' => esc_html__( 'Category Color', 'noor' ),
			'id'   => $prefix . 'term_text_field',
			'type' => 'rgba_colorpicker',
		)
	);
}
