<?php
/**
 * Sets up theme defaults
 *
 * @package tmg
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 */

if ( ! class_exists( 'DIMA_TGM_Automatic_Update' ) ) :

	class DIMA_TGM_Automatic_Update {


		function __construct() {
			// Check for theme & plugin updates.
			add_filter( 'http_request_args', array( $this, 'update_check' ), 5, 2 );

			// Inject plugin updates into the response array.
			// add_filter( 'pre_set_site_transient_update_plugins', array( $this, 'update_plugins' ) );
			// add_filter( 'pre_set_transient_update_plugins', array( $this, 'update_plugins' ) );
			// Inject plugin information into the API calls.
			add_filter( 'plugins_api', array( $this, 'dima_override_view_details' ), 10, 3 );
		}

		/**
		 * Disables requests to the wp.org repository for Noor.
		 *
		 * @since 5.0.0
		 *
		 * @param array  $request An array of HTTP request arguments.
		 * @param string $url The request URL.
		 * @return array
		 */
		public function update_check( $request, $url ) {

			// Theme update request.
			if ( false !== strpos( $url, '//api.wordpress.org/themes/update-check/1.1/' ) ) {

				// Decode JSON so we can manipulate the array.
				$data = json_decode( $request['body']['themes'] );

				// Remove Noor.
				unset( $data->themes->Noor );

				// Encode back into JSON and update the response.
				$request['body']['themes'] = wp_json_encode( $data );
			}
			return $request;
		}

		// Block wordpress.org repo for plugins with dima_plugin_upgrade set.
		function dima_override_view_details( $response, $action, $args ) {
			if ( 'plugin_information' === $action && isset( $args->slug ) ) {
				foreach ( TGM_Plugin_Activation::$instance->plugins as $plugin ) {
					if ( isset( $args->slug ) && $args->slug === $plugin['slug'] && isset( $plugin['dima_plugin_upgrade'] ) && $plugin['dima_plugin_upgrade'] === true ) {
						$response           = new stdClass();
						$response->name     = $plugin['name'];
						$response->slug     = $plugin['slug'];
						$response->version  = $plugin['version'];
						$response->package  = $plugin['source'];
						$response->sections = array( 'description' => sprintf( esc_html__( 'This plugin is bundled with %s.', 'noor' ), DIMA_THEME_NAME ) );
						break;
					}
				}
			}
			return $response;
		}


		public function update_plugins( $transient ) {

			// Get the array of arguments.
			$installed_plugins = array();

			if ( class_exists( 'Dima' ) ) {
				$plugins_info = Dima::get_bundled_plugins();
				if ( ! function_exists( 'get_plugins' ) ) {
					require_once wp_normalize_path( ABSPATH . 'wp-admin/includes/plugin.php' );
				}
				$installed_plugins = get_plugins();
			}
			// Loop available plugins.
			if ( isset( $installed_plugins ) && ! empty( $installed_plugins ) ) {
				foreach ( TGM_Plugin_Activation::$instance->plugins as $tgm_plugin ) {
					if ( $tgm_plugin['has_package'] && isset( $installed_plugins[ $tgm_plugin['file_path'] ] ) ) {
						$plugin = $installed_plugins[ $tgm_plugin['file_path'] ];
						if ( $plugin['Name'] === $tgm_plugin['name'] && isset( $plugins_info[ $tgm_plugin['slug'] ] ) && version_compare( $plugin['Version'], $plugins_info[ $tgm_plugin['slug'] ]['latest_version'], '<' ) && class_exists( 'Dima' ) ) {
							$response                 = new stdClass();
							$response->url            = '';
							$response->slug           = $tgm_plugin['slug'];
							$response->upgrade_notice = '';
							$response->new_version    = $tgm_plugin['version'];
							$response->package        = $tgm_plugin['source'];
							$transient->response[ $tgm_plugin['dima_plugin'] ] = $response;
						}
					}
				}
			}

			return $transient;
		}

	}

	if ( class_exists( 'TGM_Plugin_Activation' ) ) {
		new DIMA_TGM_Automatic_Update();
	}

endif;
