<?php
/**
 * Registers the plugins to be included via the TMG Plugin Activation class.
 *
 * @package noor
 * @author  PixelDima (https://pixeldima.com/)
 * @license Themeforest http://themeforest.net/licenses/regular_extended
 */

if ( ! function_exists( 'dima_register_theme_plugins' ) ) :

	add_action( 'tgmpa_register', 'dima_register_theme_plugins' );

	/**
	 * Gets all recommended and required plugins for use in TGM plugin.
	 */
	function dima_get_required_and_recommened_plugins() {
		$is_plugins_page = ( isset( $_GET['page'] ) && ( 'pixeldima-setup-plugins' === $_GET['page'] || 'install-required-plugins' === $_GET['page'] ) ); // WPCS: CSRF ok.
		$plugins_info    = Dima::get_bundled_plugins();
		if ( is_array( $plugins_info ) ) {
			foreach ( $plugins_info as $plugin ) {
				if ( $plugin['has_package'] ) {
					$plugins_info[ $plugin['slug'] ]['source'] = ( $is_plugins_page ) ? Dima()->remote_install->get_package( $plugin['key'], 'noor' ) : 'bundled';
				} else {
					$plugins_info[ $plugin['slug'] ]['source'] = 'repo';
				}
			}
		}

		return $plugins_info;
	}

	/**
	 * To regester theme plugins using TMG.
	 */
	function dima_register_theme_plugins() {
		// Theme plugins.
		$plugins_des = array(
			'noor_assistant'            => array(
				'dima_logo' => DIMA_TEMPLATE_URL . '/framework/images/admin/dashboard/dima-shortcode.png',
			),
			'js_composer'               => array(
				'dima_logo' => DIMA_TEMPLATE_URL . '/framework/images/admin/dashboard/Visual-Composer-Logo.png',
			),
			'revslider'                 => array(
				'dima_logo' => DIMA_TEMPLATE_URL . '/framework/images/admin/dashboard/slider_revolution_responsive.png',
			),
			'amp'                       => array(
				'dima_logo' => DIMA_TEMPLATE_URL . '/framework/images/admin/dashboard/logo-amp.png',
			),
			'pwa'                       => array(
				'dima_logo' => DIMA_TEMPLATE_URL . '/framework/images/admin/dashboard/logo-pwa.svg',
			),
			'woocommerce'               => array(
				'dima_logo' => DIMA_TEMPLATE_URL . '/framework/images/admin/dashboard/woocommerce-Logo.png',
			),
			'yith-woocommerce-wishlist' => array(
				'dima_logo' => DIMA_TEMPLATE_URL . '/framework/images/admin/dashboard/yith-woocommerce-wishlist.jpg',
			),
			'contact-form-7'            => array(
				'dima_logo' => DIMA_TEMPLATE_URL . '/framework/images/admin/dashboard/contactform7-Logo.png',
			),
			'bbpress'                   => array(
				'dima_logo' => DIMA_TEMPLATE_URL . '/framework/images/admin/dashboard/bbpree-Logo.png',
			),
			'dima-take-action'          => array(
				'dima_logo' => DIMA_TEMPLATE_URL . '/framework/images/admin/dashboard/dima-take-action.jpg',
			),
			'under-construction-page'   => array(
				'dima_logo' => DIMA_TEMPLATE_URL . '/framework/images/admin/dashboard/under-construction-page.png',
			),
			'easy-digital-downloads'    => array(
				'dima_logo' => DIMA_TEMPLATE_URL . '/framework/images/admin/dashboard/easy-digital-downloads.svg',
			),
			'envato-market'             => array(
				'dima_logo' => DIMA_TEMPLATE_URL . '/framework/images/admin/dashboard/envato.png',
			),
		);
		// Get all required and recommended plugins.
		$plugins = dima_get_required_and_recommened_plugins();
		$plugins = array_replace_recursive( $plugins, $plugins_des );

		// TMG configuration.
		$config = array(
			'id'           => 'noor',
			'domain'       => 'noor',
			'default_path' => '',
			'parent_slug'  => 'noor',
			'menu'         => 'pixeldima-setup-plugins',
			'has_notices'  => true,
			'dismissable'  => true,
			'is_automatic' => true,
			'message'      => '',
			'strings'      => array(
				'page_title'                      => esc_html__( 'Install Required Plugins', 'noor' ),
				'menu_title'                      => esc_html__( 'Install Plugins', 'noor' ),
				'installing'                      => esc_html__( 'Installing Plugin: %s', 'noor' ),
				'oops'                            => esc_html__( 'Something went wrong with the plugin API.', 'noor' ),
				'notice_can_install_required'     => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'noor' ),
				'notice_can_install_recommended'  => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'noor' ),
				'notice_cannot_install'           => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'noor' ),
				'notice_can_activate_required'    => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'noor' ),
				'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'noor' ),
				'notice_cannot_activate'          => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'noor' ),
				'notice_ask_to_update'            => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'noor' ),
				'notice_cannot_update'            => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'noor' ),
				'install_link'                    => _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'noor' ),
				'activate_link'                   => _n_noop( 'Activate installed plugin', 'Activate installed plugins', 'noor' ),
				'return'                          => esc_html__( 'Return to Required Plugins Installer', 'noor' ),
				'plugin_activated'                => esc_html__( 'Plugin activated successfully.', 'noor' ),
				'complete'                        => esc_html__( 'All plugins installed and activated successfully. %s', 'noor' ),
				'nag_type'                        => 'error',
			),
		);
		tgmpa( $plugins, $config );
	}
endif;

if ( ! function_exists( 'dima_remove_tgm_install_menu_item' ) ) :
	/**
	 * Remove "Install Plugins" Submenu Item.
	 */
	function dima_remove_tgm_install_menu_item() {
		remove_submenu_page( 'themes.php', 'install-required-plugins' );
	}

	add_action( 'admin_menu', 'dima_remove_tgm_install_menu_item', 9999 );
endif;
