<?php
/**
 * Available filters for extending Merlin WP.
 *
 * @package   Merlin WP
 * @version   5.3.7
 * @link      https://pixeldima.com/
 * @author    PixelDima.
 */

/**
 * Add your widget area to unset the default widgets from.
 * If your theme's first widget area is "sidebar-1", you don't need this.
 *
 * @see https://stackoverflow.com/questions/11757461/how-to-populate-widgets-on-sidebar-on-theme-activation
 *
 * @param  array $widget_areas Arguments for the sidebars_widgets widget areas.
 * @return array of arguments to update the sidebars_widgets option.
 */
function dima_merlin_unset_default_widgets_args( $widget_areas ) {

	$widget_areas = array(
		'sidebar-main'           => array(),
		'shop-widget-area'       => array(),
		'product-widget-area'    => array(),
		'edd-single-widget-area' => array(),
		'sidebar-portfolio'      => array(),
		'forums-widget-area'     => array(),
		'burger-area'            => array(),
		'footer-1'               => array(),
		'footer-2'               => array(),
		'footer-3'               => array(),
		'footer-4'               => array(),
		'footer-second-1'        => array(),
		'footer-second-2'        => array(),
		'footer-second-3'        => array(),
		'footer-second-4'        => array(),
	);

	return $widget_areas;
}
add_filter( 'merlin_unset_default_widgets_args', 'dima_merlin_unset_default_widgets_args' );
/**
 * Custom content for the generated child theme's functions.php file.
 *
 * @param string $output Generated content.
 * @param string $slug Parent theme slug.
 */
function dima_generate_child_functions_php( $output, $slug ) {

	$slug_no_hyphens = strtolower( preg_replace( '#[^a-zA-Z]#', '', $slug ) );

	$output = "
		<?php
		/**
		 * Enqueues child theme stylesheet, loading first the parent theme stylesheet.
		 */
		function {$slug_no_hyphens}_child_enqueue_styles() {
			wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array( '{$slug_no_hyphens}-style' ) );\n
		}

		add_action(  'wp_enqueue_scripts', '{$slug_no_hyphens}_child_enqueue_styles' );\n

		if ( ! defined( 'EDD_SLUG' ) ) {
			define( 'EDD_SLUG', 'products' );\n
		}
	";

	// Let's remove the tabs so that it displays nicely.
	$output = trim( preg_replace( '/\t+/', '', $output ) );

	// Filterable return.
	return $output;
}
add_filter( 'merlin_generate_child_functions_php', 'dima_generate_child_functions_php', 10, 2 );

/**
 * Content template for the child theme functions.php file.
 *
 * @link https://gist.github.com/richtabor/7d88d279706fc3093911e958fd1fd791
 *
 * @param string $slug    Parent theme slug.
 * @param string $parent  Parent theme name.
 * @param string $author  Parent theme author.
 * @param string $version Parent theme version.
 */
function dima_generate_child_style_css( $output, $slug, $parent, $author, $version ) {
	$parent_no_hyphens = strtolower( preg_replace( '#[^a-zA-Z]#', '', $parent ) );

	$output = "
	/**
	* Theme Name: {$slug}
	* Description: This is a child theme of {$parent}, generated by Merlin WP.
	* Author: {$author}
	* Template: {$parent}
	* Description: This is a blank child theme for Noor theme.
	* Tags: responsive-layout, one-column, two-columns, three-columns, four-columns, left-sidebar, right-sidebar, custom-colors, flexible-header, full-width-template, post-formats, theme-options, featured-images,rtl-language-support,threaded-comments, translation-ready
	* Version: {$version}
	* Text Domain:  {$parent_no_hyphens}
	*/\n

	/* write custom css after this line */\n
";

	// Let's remove the tabs so that it displays nicely.
	$output = trim( preg_replace( '/\t+/', '', $output ) );
	// Filterable return.
	return $output;
}
add_filter( 'merlin_generate_child_style_css', 'dima_generate_child_style_css', 10, 5 );
/**
 * Define the demo import files (remote files).
 *
 * To define imports, you just have to add the following code structure,
 * with your own values to your theme (using the 'merlin_import_files' filter).
 */
function dima_merlin_import_files() {
	return array(
		array(
			'import_file_name'           => 'Noor Promo',
			'import_file_url'            => 'demos/noor_promo/content/all.xml',
			'import_widgets_file_url'    => 'demos/noor_promo/content/widgets.wie',
			'import_pages_file_url'      => 'demos/noor_promo/content/pages.xml',
			'import_media_file_url'      => 'demos/noor_promo/content/media.xml',
			'import_portfolio_file_url'  => 'demos/noor_promo/content/portfolio.xml',
			'import_customizer_file_url' => 'demos/noor_promo/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/noor-promo.png',
			'import_notice'              => esc_html__( 'Noor Promo page with all elements.', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/noor-promo/',
		),

		/* Homes */
		array(
			'import_file_name'           => 'Home Corporate',
			'import_file_url'            => 'demos/noor_classic/content/all.xml',
			'import_widgets_file_url'    => 'demos/noor_classic/content/widgets.wie',
			'import_pages_file_url'      => 'demos/noor_classic/content/pages.xml',
			'import_posts_file_url'      => 'demos/noor_classic/content/posts.xml',
			'import_media_file_url'      => 'demos/noor_classic/content/media.xml',
			'import_portfolio_file_url'  => 'demos/noor_classic/content/portfolio.xml',
			'import_customizer_file_url' => 'demos/noor_classic/content/noor-export.dat',
			'import_rev_slider_file_url' => 'demos/noor_classic/revsliders/corporate_1.zip',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/corporate.png',
			'import_notice'              => esc_html__( 'Noor Classic home page.', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/noor-classic/',
		),

		array(
			'import_file_name'           => 'Home Agency',
			'import_file_url'            => 'demos/noor_classic/content/all.xml',
			'import_widgets_file_url'    => 'demos/noor_classic/content/widgets.wie',
			'import_pages_file_url'      => 'demos/noor_classic/content/pages.xml',
			'import_posts_file_url'      => 'demos/noor_classic/content/posts.xml',
			'import_media_file_url'      => 'demos/noor_classic/content/media.xml',
			'import_portfolio_file_url'  => 'demos/noor_classic/content/portfolio.xml',
			'import_customizer_file_url' => 'demos/noor_classic/content/noor-export.dat',
			'import_rev_slider_file_url' => 'demos/noor_classic/revsliders/agency.zip',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/agency.png',
			'import_notice'              => esc_html__( 'Noor Classic home page.', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/noor-classic/home/agency/',
		),

		array(
			'import_file_name'           => 'Home Digital Agency',
			'import_file_url'            => 'demos/noor_classic/content/all.xml',
			'import_widgets_file_url'    => 'demos/noor_classic/content/widgets.wie',
			'import_pages_file_url'      => 'demos/noor_classic/content/pages.xml',
			'import_posts_file_url'      => 'demos/noor_classic/content/posts.xml',
			'import_media_file_url'      => 'demos/noor_classic/content/media.xml',
			'import_portfolio_file_url'  => 'demos/noor_classic/content/portfolio.xml',
			'import_customizer_file_url' => 'demos/noor_classic/content/noor-export.dat',
			'import_rev_slider_file_url' => 'demos/noor_classic/revsliders/digital.zip',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/digital-agency.png',
			'import_notice'              => esc_html__( 'Noor Classic home page.', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/noor-classic/home/digital-agency/',
		),

		array(
			'import_file_name'           => 'Home Company',
			'import_file_url'            => 'demos/noor_classic/content/all.xml',
			'import_widgets_file_url'    => 'demos/noor_classic/content/widgets.wie',
			'import_pages_file_url'      => 'demos/noor_classic/content/pages.xml',
			'import_posts_file_url'      => 'demos/noor_classic/content/posts.xml',
			'import_media_file_url'      => 'demos/noor_classic/content/media.xml',
			'import_portfolio_file_url'  => 'demos/noor_classic/content/portfolio.xml',
			'import_customizer_file_url' => 'demos/noor_classic/content/noor-export.dat',
			'import_rev_slider_file_url' => 'demos/noor_classic/revsliders/company.zip',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/company.png',
			'import_notice'              => esc_html__( 'Noor Classic home page.', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/noor-classic/home/company/',
		),

		array(
			'import_file_name'           => 'Home Classic Blog',
			'import_file_url'            => 'demos/noor_classic/content/all.xml',
			'import_widgets_file_url'    => 'demos/noor_classic/content/widgets.wie',
			'import_pages_file_url'      => 'demos/noor_classic/content/pages.xml',
			'import_posts_file_url'      => 'demos/noor_classic/content/posts.xml',
			'import_media_file_url'      => 'demos/noor_classic/content/media.xml',
			'import_customizer_file_url' => 'demos/noor_classic/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/blog1.png',
			'import_notice'              => esc_html__( 'Noor Classic home page.', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/noor-classic/home/classic-blog/',
		),

		array(
			'import_file_name'           => 'Home Minimal Blog',
			'import_file_url'            => 'demos/noor_classic/content/all.xml',
			'import_widgets_file_url'    => 'demos/noor_classic/content/widgets.wie',
			'import_pages_file_url'      => 'demos/noor_classic/content/pages.xml',
			'import_posts_file_url'      => 'demos/noor_classic/content/posts.xml',
			'import_media_file_url'      => 'demos/noor_classic/content/media.xml',
			'import_customizer_file_url' => 'demos/noor_classic/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/blog2.png',
			'import_notice'              => esc_html__( 'Noor Classic home page.', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/noor-classic/home/minimal-blog/',
		),

		array(
			'import_file_name'           => 'Home Modern Blog',
			'import_file_url'            => 'demos/noor_classic/content/all.xml',
			'import_widgets_file_url'    => 'demos/noor_classic/content/widgets.wie',
			'import_pages_file_url'      => 'demos/noor_classic/content/pages.xml',
			'import_posts_file_url'      => 'demos/noor_classic/content/posts.xml',
			'import_media_file_url'      => 'demos/noor_classic/content/media.xml',
			'import_customizer_file_url' => 'demos/noor_classic/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/blog3.png',
			'import_notice'              => esc_html__( 'Noor Classic home page.', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/noor-classic/home/modern-blog/',
		),

		array(
			'import_file_name'           => 'Home Modern Portfolio',
			'import_file_url'            => 'demos/noor_classic/content/all.xml',
			'import_widgets_file_url'    => 'demos/noor_classic/content/widgets.wie',
			'import_pages_file_url'      => 'demos/noor_classic/content/pages.xml',
			'import_posts_file_url'      => 'demos/noor_classic/content/posts.xml',
			'import_media_file_url'      => 'demos/noor_classic/content/media.xml',
			'import_portfolio_file_url'  => 'demos/noor_classic/content/portfolio.xml',
			'import_customizer_file_url' => 'demos/noor_classic/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/portfolio3.png',
			'import_notice'              => esc_html__( 'Noor Classic home page.', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/noor-classic/home/modern-portfolio/',
		),
		array(
			'import_file_name'           => 'Home Minimal Portfolio',
			'import_file_url'            => 'demos/noor_classic/content/all.xml',
			'import_widgets_file_url'    => 'demos/noor_classic/content/widgets.wie',
			'import_pages_file_url'      => 'demos/noor_classic/content/pages.xml',
			'import_posts_file_url'      => 'demos/noor_classic/content/posts.xml',
			'import_media_file_url'      => 'demos/noor_classic/content/media.xml',
			'import_portfolio_file_url'  => 'demos/noor_classic/content/portfolio.xml',
			'import_customizer_file_url' => 'demos/noor_classic/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/portfolio2.png',
			'import_notice'              => esc_html__( 'Noor Classic home page.', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/noor-classic/home/minimal-portfolio/',
		),
		array(
			'import_file_name'           => 'Home Creative Portfolio',
			'import_file_url'            => 'demos/noor_classic/content/all.xml',
			'import_widgets_file_url'    => 'demos/noor_classic/content/widgets.wie',
			'import_pages_file_url'      => 'demos/noor_classic/content/pages.xml',
			'import_posts_file_url'      => 'demos/noor_classic/content/posts.xml',
			'import_media_file_url'      => 'demos/noor_classic/content/media.xml',
			'import_portfolio_file_url'  => 'demos/noor_classic/content/portfolio.xml',
			'import_customizer_file_url' => 'demos/noor_classic/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/portfolio1.png',
			'import_notice'              => esc_html__( 'Noor Classic home page.', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/noor-classic/home/creative-portfolio/',
		),

		/* !Homes */
		array(
			'import_file_name'           => 'Business',
			'import_file_url'            => 'demos/business/content/all.xml',
			'import_widgets_file_url'    => 'demos/business/content/widgets.wie',
			'import_pages_file_url'      => 'demos/business/content/pages.xml',
			'import_posts_file_url'      => 'demos/business/content/posts.xml',
			'import_media_file_url'      => 'demos/business/content/media.xml',
			'import_customizer_file_url' => 'demos/business/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/business.png',
			'import_rev_slider_file_url' => 'demos/business/revsliders/business01.zip',
			'import_notice'              => __( ' <b>5</b> Pages Home, About Us, Contact Us, News, Services <hr> <b> 16</b> Post.', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/business/',
		),

		/* Shop */
		array(
			'import_file_name'           => 'Home Furniture Shop #1',
			'import_file_url'            => 'demos/noor_ecommerce_ultimate/content/all.xml',
			'import_widgets_file_url'    => 'demos/noor_ecommerce_ultimate/content/widgets.wie',
			'import_pages_file_url'      => 'demos/noor_ecommerce_ultimate/content/pages.xml',
			'import_posts_file_url'      => 'demos/noor_ecommerce_ultimate/content/posts.xml',
			'import_media_file_url'      => 'demos/noor_ecommerce_ultimate/content/media.xml',
			'import_products_file_url'   => 'demos/noor_ecommerce_ultimate/content/products.xml',
			'import_customizer_file_url' => 'demos/noor_ecommerce_ultimate/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/shop3.png',
			'import_rev_slider_file_url' => 'demos/noor_ecommerce_ultimate/revsliders/shop2.zip',
			'import_notice'              => __( ' - <b>13</b> Pages ( 4 home Pages ) <br> <b>- 6</b> Post.', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/noor-ecommerce-ultimate/',
		),

		array(
			'import_file_name'           => 'Home Furniture Shop #2',
			'import_file_url'            => 'demos/noor_ecommerce_ultimate/content/all.xml',
			'import_widgets_file_url'    => 'demos/noor_ecommerce_ultimate/content/widgets.wie',
			'import_pages_file_url'      => 'demos/noor_ecommerce_ultimate/content/pages.xml',
			'import_posts_file_url'      => 'demos/noor_ecommerce_ultimate/content/posts.xml',
			'import_media_file_url'      => 'demos/noor_ecommerce_ultimate/content/media.xml',
			'import_products_file_url'   => 'demos/noor_classic/content/products.xml',
			'import_customizer_file_url' => 'demos/noor_ecommerce_ultimate/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/shop4.png',
			'import_rev_slider_file_url' => 'demos/noor_ecommerce_ultimate/revsliders/shop4.zip',
			'import_notice'              => __( ' - <b>13</b> Pages ( 4 home Pages ) <br> <b>- 6</b> Post.', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/noor-ecommerce-ultimate/home/furniture-shop-2/',
		),

		array(
			'import_file_name'           => 'Home Clothing Shop #1',
			'import_file_url'            => 'demos/noor_ecommerce_ultimate/content/all.xml',
			'import_widgets_file_url'    => 'demos/noor_ecommerce_ultimate/content/widgets.wie',
			'import_pages_file_url'      => 'demos/noor_ecommerce_ultimate/content/pages.xml',
			'import_posts_file_url'      => 'demos/noor_ecommerce_ultimate/content/posts.xml',
			'import_media_file_url'      => 'demos/noor_ecommerce_ultimate/content/media.xml',
			'import_products_file_url'   => 'demos/noor_classic/content/products.xml',
			'import_customizer_file_url' => 'demos/noor_ecommerce_ultimate/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/shop1.png',
			'import_rev_slider_file_url' => 'demos/noor_ecommerce_ultimate/revsliders/shop1.zip',
			'import_notice'              => __( ' - <b>13</b> Pages ( 4 home Pages ) <br> <b>- 6</b> Post.', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/noor-ecommerce-ultimate/home/clothing-shop/',
		),

		array(
			'import_file_name'           => 'Home Clothing Shop #2',
			'import_file_url'            => 'demos/noor_ecommerce_ultimate/content/all.xml',
			'import_widgets_file_url'    => 'demos/noor_ecommerce_ultimate/content/widgets.wie',
			'import_pages_file_url'      => 'demos/noor_ecommerce_ultimate/content/pages.xml',
			'import_posts_file_url'      => 'demos/noor_ecommerce_ultimate/content/posts.xml',
			'import_media_file_url'      => 'demos/noor_ecommerce_ultimate/content/media.xml',
			'import_products_file_url'   => 'demos/noor_classic/content/products.xml',
			'import_customizer_file_url' => 'demos/noor_ecommerce_ultimate/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/shop2.png',
			'import_rev_slider_file_url' => 'demos/noor_ecommerce_ultimate/revsliders/shop3.zip',
			'import_notice'              => __( ' - <b>13</b> Pages ( 4 home Pages ) <br> <b>- 6</b> Post.', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/noor-ecommerce-ultimate/home/shop-clothing-2/',
		),

		array(
			'import_file_name'           => 'Home Single Product',
			'import_file_url'            => 'demos/noor_ecommerce_ultimate/content/all.xml',
			'import_widgets_file_url'    => 'demos/noor_ecommerce_ultimate/content/widgets.wie',
			'import_pages_file_url'      => 'demos/noor_ecommerce_ultimate/content/pages.xml',
			'import_posts_file_url'      => 'demos/noor_ecommerce_ultimate/content/posts.xml',
			'import_media_file_url'      => 'demos/noor_ecommerce_ultimate/content/media.xml',
			'import_products_file_url'   => 'demos/noor_ecommerce_ultimate/content/products.xml',
			'import_customizer_file_url' => 'demos/noor_ecommerce_ultimate/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/single-product.png',
			'import_notice'              => __( ' - <b>13</b> Pages ( 4 home Pages ) <br> <b>- 6</b> Post.', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/noor-ecommerce-ultimate/home/single-product/',
		),

		/* !Shop */
		array(
			'import_file_name'           => 'Bitcurrency',
			'import_file_url'            => 'demos/bitcurrency/content/all.xml',
			'import_widgets_file_url'    => 'demos/bitcurrency/content/widgets.wie',
			'import_pages_file_url'      => 'demos/bitcurrency/content/pages.xml',
			'import_posts_file_url'      => 'demos/bitcurrency/content/posts.xml',
			'import_media_file_url'      => 'demos/bitcurrency/content/media.xml',
			'import_customizer_file_url' => 'demos/bitcurrency/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/bitcurrency.png',
			'import_notice'              => __( ' - <b>4</b> Pages <br>[ Home, About Us, Contact Us, News ] <br> <b>- 3</b> Post.', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/bitcurrency',
		),

		array(
			'import_file_name'           => 'Conference',
			'import_file_url'            => 'demos/conference/content/all.xml',
			'import_widgets_file_url'    => 'demos/conference/content/widgets.wie',
			'import_pages_file_url'      => 'demos/conference/content/pages.xml',
			'import_posts_file_url'      => 'demos/conference/content/posts.xml',
			'import_media_file_url'      => 'demos/conference/content/media.xml',
			'import_customizer_file_url' => 'demos/conference/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/conference.png',
			'import_rev_slider_file_url' => 'demos/conference/revsliders/conference.zip',
			'import_notice'              => __( ' - One Page demo with 5 Section.', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/conference',
		),

		array(
			'import_file_name'           => 'Business And Finance',
			'import_file_url'            => 'demos/business_and_finance/content/all.xml',
			'import_widgets_file_url'    => 'demos/business_and_finance/content/widgets.wie',
			'import_pages_file_url'      => 'demos/business_and_finance/content/pages.xml',
			'import_posts_file_url'      => 'demos/business_and_finance/content/posts.xml',
			'import_media_file_url'      => 'demos/business_and_finance/content/media.xml',
			'import_customizer_file_url' => 'demos/business_and_finance/content/noor-export.dat',
			'import_preview_image_url'   => 'demos/business_and_finance/business-and-finance.png',
			'import_rev_slider_file_url' => 'demos/business_and_finance/revsliders/business02.zip',
			'import_notice'              => __( ' - <b>6</b> Pages <br>[ Home, About Us, Contact Us,Contact Us #2, News ] <br> <b>- 3</b> Post.', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/business-and-finance/',
		),

		array(
			'import_file_name'           => 'Business Modern',
			'import_file_url'            => 'demos/business_modern/content/all.xml',
			'import_widgets_file_url'    => 'demos/business_modern/content/widgets.wie',
			'import_pages_file_url'      => 'demos/business_modern/content/pages.xml',
			'import_posts_file_url'      => 'demos/business_modern/content/posts.xml',
			'import_media_file_url'      => 'demos/business_modern/content/media.xml',
			'import_portfolio_file_url'  => 'demos/business_modern/content/portfolio.xml',
			'import_customizer_file_url' => 'demos/business_modern/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/business-modern.png',
			'import_rev_slider_file_url' => 'demos/business_modern/revsliders/business03.zip',
			'import_notice'              => __( ' - <b>5</b> Pages <br>[ Home, About Us, Contact Us, News, Services ] <br> <b>- 6</b> Post <br> <b>- 4</b> Portfolio.', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/business-modern/',
		),

		array(
			'import_file_name'           => 'Construction',
			'import_file_url'            => 'demos/construction/content/all.xml',
			'import_widgets_file_url'    => 'demos/construction/content/widgets.wie',
			'import_pages_file_url'      => 'demos/construction/content/pages.xml',
			'import_posts_file_url'      => 'demos/construction/content/posts.xml',
			'import_media_file_url'      => 'demos/construction/content/media.xml',
			'import_portfolio_file_url'  => 'demos/construction/content/portfolio.xml',
			'import_customizer_file_url' => 'demos/construction/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/construction.png',
			'import_rev_slider_file_url' => 'demos/construction/revsliders/construction.zip',
			'import_notice'              => __( ' - <b>5</b> Pages <br>[ Home, About Us, Contact Us, News, Services ] <br> <b>- 30</b> Post <br> <b>- 5</b> Portfolio.', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/business-modern/',
		),

		array(
			'import_file_name'           => 'Creative Agency',
			'import_file_url'            => 'demos/creative_agency/content/all.xml',
			'import_widgets_file_url'    => 'demos/creative_agency/content/widgets.wie',
			'import_pages_file_url'      => 'demos/creative_agency/content/pages.xml',
			'import_posts_file_url'      => 'demos/creative_agency/content/posts.xml',
			'import_media_file_url'      => 'demos/creative_agency/content/media.xml',
			'import_customizer_file_url' => 'demos/creative_agency/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/creative-agency.png',
			'import_rev_slider_file_url' => 'demos/creative_agency/revsliders/agency_creative_demo.zip',
			'import_notice'              => __( ' - <b>5</b> Pages <br>[ Home, About Us, Contact Us, News, Services ] <br> <b>- 30</b> Post', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/business-modern/',
		),

		array(
			'import_file_name'           => 'Medical',
			'import_file_url'            => 'demos/medical/content/all.xml',
			'import_widgets_file_url'    => 'demos/medical/content/widgets.wie',
			'import_pages_file_url'      => 'demos/medical/content/pages.xml',
			'import_posts_file_url'      => 'demos/medical/content/posts.xml',
			'import_media_file_url'      => 'demos/medical/content/media.xml',
			'import_customizer_file_url' => 'demos/medical/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/medical.png',
			'import_rev_slider_file_url' => 'demos/medical/revsliders/dentist.zip',
			'import_notice'              => __( ' - <b>5</b> Pages <br>[ Home, About Us, Contact Us, News, Services ] <br> <b>- 4</b> Post', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/medical/',
		),

		array(
			'import_file_name'           => 'Help Center',
			'import_file_url'            => 'demos/help_center/content/all.xml',
			'import_widgets_file_url'    => 'demos/help_center/content/widgets.wie',
			'import_pages_file_url'      => 'demos/help_center/content/pages.xml',
			'import_posts_file_url'      => 'demos/help_center/content/posts.xml',
			'import_media_file_url'      => 'demos/help_center/content/media.xml',
			'import_customizer_file_url' => 'demos/help_center/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/help-center.png',
			'import_notice'              => __( ' - <b>5</b> Pages <br>[ Home, About Us, Contact Us, Knowledge Base, New Ticket ]', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/help-center/',
		),

		array(
			'import_file_name'           => 'SEO',
			'import_file_url'            => 'demos/seo/content/all.xml',
			'import_widgets_file_url'    => 'demos/seo/content/widgets.wie',
			'import_pages_file_url'      => 'demos/seo/content/pages.xml',
			'import_posts_file_url'      => 'demos/seo/content/posts.xml',
			'import_media_file_url'      => 'demos/seo/content/media.xml',
			'import_customizer_file_url' => 'demos/seo/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/seo.png',
			'import_rev_slider_file_url' => 'demos/seo/revsliders/seo.zip',
			'import_notice'              => __( ' - <b>5</b> Pages <br>[ Home, About Us, Contact Us, Services , Blog ] <br> <b>4</b> Posts', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/seo/',
		),

		array(
			'import_file_name'           => 'Cars',
			'import_file_url'            => 'demos/cars/content/all.xml',
			'import_widgets_file_url'    => 'demos/cars/content/widgets.wie',
			'import_pages_file_url'      => 'demos/cars/content/pages.xml',
			'import_posts_file_url'      => 'demos/cars/content/posts.xml',
			'import_media_file_url'      => 'demos/cars/content/media.xml',
			'import_customizer_file_url' => 'demos/cars/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/cars.png',
			'import_rev_slider_file_url' => 'demos/cars/revsliders/header.zip',
			'import_notice'              => __( ' - <b>5</b> Pages <br>[ Home, About Us, Contact Us, Services , Blog ] <br> <b>3</b> Posts', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/cars/',
		),

		array(
			'import_file_name'           => 'App',
			'import_file_url'            => 'demos/app/content/all.xml',
			'import_widgets_file_url'    => 'demos/app/content/widgets.wie',
			'import_pages_file_url'      => 'demos/app/content/pages.xml',
			'import_posts_file_url'      => 'demos/app/content/posts.xml',
			'import_media_file_url'      => 'demos/app/content/media.xml',
			'import_customizer_file_url' => 'demos/app/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/app.png',
			'import_notice'              => __( ' - One Page demo for Creative App Landing Page with 5 sections ', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/app/',
		),

		array(
			'import_file_name'           => 'Startup',
			'import_file_url'            => 'demos/startup/content/all.xml',
			'import_widgets_file_url'    => 'demos/startup/content/widgets.wie',
			'import_pages_file_url'      => 'demos/startup/content/pages.xml',
			'import_posts_file_url'      => 'demos/startup/content/posts.xml',
			'import_media_file_url'      => 'demos/startup/content/media.xml',
			'import_customizer_file_url' => 'demos/startup/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/startup.png',
			'import_notice'              => __( ' - One Page demo for Creative App Landing Page with 5 sections and 3 Post', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/startup/',
		),

		array(
			'import_file_name'           => 'Event',
			'import_file_url'            => 'demos/event/content/all.xml',
			'import_widgets_file_url'    => 'demos/event/content/widgets.wie',
			'import_pages_file_url'      => 'demos/event/content/pages.xml',
			'import_posts_file_url'      => 'demos/event/content/posts.xml',
			'import_media_file_url'      => 'demos/event/content/media.xml',
			'import_customizer_file_url' => 'demos/event/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/event.png',
			'import_rev_slider_file_url' => 'demos/event/revsliders/agency_creative_demo.zip',
			'import_notice'              => __( ' - <b>3</b> Pages [ About Us, Contact Us and Home ]', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/event/',
		),

		array(
			'import_file_name'           => 'Digital Products',
			'import_file_url'            => 'demos/digital_products/content/all.xml',
			'import_widgets_file_url'    => 'demos/digital_products/content/widgets.wie',
			'import_pages_file_url'      => 'demos/digital_products/content/pages.xml',
			'import_posts_file_url'      => 'demos/digital_products/content/posts.xml',
			'import_media_file_url'      => 'demos/digital_products/content/media.xml',
			'import_customizer_file_url' => 'demos/digital_products/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/digital-products.png',
			'import_notice'              => __( ' - <b>5</b> Pages [ Home, Contact Us, Blog, Services, Checkout ] <br> <b>2</b> - Posts', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/digital-products/',
		),

		array(
			'import_file_name'           => 'Consulting',
			'import_file_url'            => 'demos/consulting/content/all.xml',
			'import_widgets_file_url'    => 'demos/consulting/content/widgets.wie',
			'import_pages_file_url'      => 'demos/consulting/content/pages.xml',
			'import_posts_file_url'      => 'demos/consulting/content/posts.xml',
			'import_media_file_url'      => 'demos/consulting/content/media.xml',
			'import_customizer_file_url' => 'demos/consulting/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/consulting.png',
			'import_portfolio_file_url'  => 'demos/consulting/content/portfolio.xml',
			'import_rev_slider_file_url' => 'demos/consulting/revsliders/consulting.zip',
			'import_notice'              => __( ' - <b>5</b> Pages [ Home, Contact Us, Blog, Services, About Us ] <br> <b>6</b> - Posts  <br> <b>4</b> - Portfolio', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/digital-products/',
		),

		array(
			'import_file_name'           => 'Block',
			'import_file_url'            => 'demos/block/content/all.xml',
			'import_widgets_file_url'    => 'demos/block/content/widgets.wie',
			'import_pages_file_url'      => 'demos/block/content/pages.xml',
			'import_posts_file_url'      => 'demos/block/content/posts.xml',
			'import_media_file_url'      => 'demos/block/content/media.xml',
			'import_customizer_file_url' => 'demos/block/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/block.png',
			'import_notice'              => __( ' - <b>2</b> Pages [ Home, Blog ] <br> <b>6</b> - Posts', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/block/',
		),

		array(
			'import_file_name'           => 'Travel',
			'import_file_url'            => 'demos/travel/content/all.xml',
			'import_widgets_file_url'    => 'demos/travel/content/widgets.wie',
			'import_pages_file_url'      => 'demos/travel/content/pages.xml',
			'import_posts_file_url'      => 'demos/travel/content/posts.xml',
			'import_media_file_url'      => 'demos/travel/content/media.xml',
			'import_customizer_file_url' => 'demos/travel/content/noor-export.dat',
			'import_preview_image_url'   => DIMA_TEMPLATE_URL . '/framework/images/admin/demos/travel.png',
			'import_rev_slider_file_url' => 'demos/travel/revsliders/slide.zip',
			'import_notice'              => __( ' - <b>4</b> Pages [ Home, News, About, Contact, Services ] <br> <b>3</b> - Posts', 'noor' ),
			'preview_url'                => 'https://noor.pixeldima.com/travel/',
		),

	);
}
add_filter( 'merlin_import_files', 'dima_merlin_import_files' );

/**
 * Execute custom code after the whole import has finished
 *
 * @param [type] $selected_import_index
 * @return void
 */
function dima_merlin_after_import_setup( $selected_import_index ) {
	// Assign menus to their locations.
	// Grab the selected import file.
	$selected_import_file = $GLOBALS['wizard']->import_files[ $selected_import_index ];
	// You may access the currently selected import file like so.

		/**Update Options */
		dima_helper::dima_update_option( 'dima_space_after_body', '' );
		dima_helper::dima_update_option( 'dima_google_map_api_key', '' );

	if ( isset( $selected_import_file['import_file_name'] ) ) {
		$demo_name = strtolower( $selected_import_file['import_file_name'] );
		dima_assign_menu( $demo_name );
		switch ( $demo_name ) {
			case 'Home Corporate':
				$front_page_id = get_page_by_title( 'Home' );
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $front_page_id->ID );
				break;
			case 'Home Agency':
				$front_page_id = get_page_by_title( 'Agency' );
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $front_page_id->ID );
				break;
			case 'Home Digital Agency':
				$front_page_id = get_page_by_title( 'Digital Agency' );
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $front_page_id->ID );
				break;
			case 'Home Company':
				$front_page_id = get_page_by_title( 'Company' );
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $front_page_id->ID );
				break;
			case 'Home Classic Blog':
				$front_page_id = get_page_by_title( 'Classic Blog' );
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $front_page_id->ID );
				break;
			case 'Home Minimal Blog':
				$front_page_id = get_page_by_title( 'Minimal Blog' );
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $front_page_id->ID );
				break;
			case 'Home Modern Blog':
				$front_page_id = get_page_by_title( 'Modern Blog' );
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $front_page_id->ID );
				break;

			case 'Home Modern Portfolio':
				$front_page_id = get_page_by_title( 'Modern Portfolio' );
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $front_page_id->ID );
				break;
			case 'Home Minimal Portfolio':
				$front_page_id = get_page_by_title( 'Minimal Portfolio' );
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $front_page_id->ID );
				break;
			case 'Creative Portfolio':
				$front_page_id = get_page_by_title( 'Creative Portfolio' );
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $front_page_id->ID );
				break;
			case 'Home Furniture Shop #1':
				$front_page_id = get_page_by_title( 'Home' );
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $front_page_id->ID );
				break;
			case 'Home Furniture Shop #2':
				$front_page_id = get_page_by_title( 'Furniture Shop 2' );
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $front_page_id->ID );
				break;
			case 'Home Clothing Shop #1':
				$front_page_id = get_page_by_title( 'Clothing Shop' );
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $front_page_id->ID );
				break;
			case 'Home Clothing Shop #2':
				$front_page_id = get_page_by_title( 'Shop Clothing 2' );
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $front_page_id->ID );
				break;
			case 'Home Single Product':
				$front_page_id = get_page_by_title( 'Single Product' );
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $front_page_id->ID );
				break;

			default:
				// Assign front page and posts page (blog page).
				$front_page_id = get_page_by_title( 'Home' );
				$blog_page_id  = get_page_by_title( 'Blog' );
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $front_page_id->ID );
				update_option( 'page_for_posts', $blog_page_id->ID );
				break;
		}
	}

}
add_action( 'merlin_after_all_import', 'dima_merlin_after_import_setup' );

/**
 * Execute custom code after the whole Generate the child theme has finished.
 * Here we copy the languges file.
 *
 * @return void
 */
/*
function dima_after_generate_child() {

}
add_action( 'merlin_after_generate_child', 'dima_after_generate_child' );
*/
if ( ! function_exists( 'dima_assign_menu' ) ) {
	/**
	 * Undocumented function
	 *
	 * @param string $demo_name
	 * @return void
	 */
	function dima_assign_menu( $demo_name = 'agency' ) {

		$locations = get_theme_mod( 'nav_menu_locations' );
		$menus     = wp_get_nav_menus();
		if ( $menus ) {

			foreach ( $menus as $menu ) {
				switch ( $demo_name ) {
					case 'Home Creative Portfolio':
					case 'Home Minimal Portfolio':
					case 'Home Modern Portfolio':
					case 'Home Modern Blog':
					case 'Home Minimal Blog':
					case 'Home Classic Blog':
					case 'Home Company':
					case 'Home Digital Agency':
					case 'Home Agency':
					case 'Home Corporate':
						if ( $menu->name == 'primary' ) {
							$locations['primary'] = $menu->term_id;
							$locations['burger']  = $menu->term_id;
						}

						if ( $menu->name == 'icon-menu' ) {
							$locations['icon'] = $menu->term_id;
						}
						break;

					case 'App':
					case 'Home Single Product':
						// Assign One Page Menu.
						$ona_page_menu = get_page_by_title( 'Home Single Product' );
						if ( isset( $ona_page_menu ) && $ona_page_menu->ID && $menu->name == 'onepage' ) {
							update_post_meta( $ona_page_menu->ID, '_dima_meta_primary_navigation', $menu->term_id );
						}
						break;

					case 'Creative Agency':
						if ( $menu->name == 'Creative Agency' ) {
							$locations['burger'] = $menu->term_id;
						}
						break;

					case 'conference':
					case 'modern_restaurant':
					case 'construction':
						if ( strtolower( $menu->name ) == 'primary' ) {
							$locations['primary'] = $menu->term_id;
							$locations['burger']  = $menu->term_id;
						}
						break;

					default:
						if ( strtolower( $menu->name ) == 'primary' ) {
							$locations['primary'] = $menu->term_id;
						}
						break;
				}
			}
		}

		set_theme_mod( 'nav_menu_locations', $locations ); // set menus to locations.
	}
}


/**
 * Undocumented function
 *
 * @param [type] $license
 * @return void
 */
function dima_ajax_activate_license( $license ) {
	$success = false;

	// Strings passed in from the config file.
	$strings = $GLOBALS['wizard']->get_strings();

	// Remove "Child" from the current theme name, if it's installed.
	$theme = basename( get_template_directory() );

	// Text strings.
	$success_message = $strings['license-json-success%s'];

	if ( ! empty( $theme ) ) {
		$errors            = array();
		$slug              = sanitize_text_field( $theme ); // get the theme's slug.
		$purchase_code_key = esc_attr( strtolower( str_replace( array( ' ', '.' ), '_', $slug ) ) ) . '_wup_purchase_code';

		$purchase_code = false;

		if ( ! empty( $license ) ) {
			// get the submitted purchase code and sanitize it.
			$purchase_code = sanitize_text_field( $license );

			// do a prevalidation; no need to make the API call if the format is not right.
			if ( true !== wupdates_prevalidate_purchase_code_MqXZL( $purchase_code ) ) {
				$purchase_code = false;
			}
		}
		if ( ! empty( $purchase_code ) ) {

			// check if this purchase code represents a sale of the theme.
			$http_args = array(
				'body' => array(
					'slug'          => $slug, // the theme's slug.
					'url'           => home_url(), // the site's home URL.
					'purchase_code' => $purchase_code,
				),
			);

			// make sure that we use a protocol that this hosting is capable of.
			$url = $http_url = set_url_scheme( 'https://wupdates.com/wp-json/wup/v1/front/check_envato_purchase_code/MqXZL', 'http' );
			if ( $ssl = wp_http_supports( array( 'ssl' ) ) ) {
				$url = set_url_scheme( $url, 'https' );
			}
			// make the call to the purchase code check API.
			$raw_response = wp_remote_post( $url, $http_args );
			if ( $ssl && is_wp_error( $raw_response ) ) {
				$raw_response = wp_remote_post( $http_url, $http_args );
			}

			// Make sure the response came back okay .
			if ( is_wp_error( $raw_response ) || 200 !== wp_remote_retrieve_response_code( $raw_response ) ) {
					$message = esc_html__( 'We are sorry but we couldn\'t connect to the verification server. Please try again later.', 'noor' );
			} else {
				$response = json_decode( $raw_response['body'], true );
				if ( ! empty( $response ) ) {
					// we will only update the purchase code if it's valid.
					// this way we keep existing valid purchase codes.
					if ( isset( $response['purchase_code'] ) && $response['purchase_code'] === 'valid' ) {
						$message = sprintf( esc_html( $success_message ), $theme );
						$success = true;
						// all is good, update the purchase code option.
						update_option( strtolower( $slug ) . '_wup_purchase_code', $purchase_code );

						dima_add_more_info( $slug, $response );

						// delete the update_themes transient so we force a recheck.
						set_site_transient( 'update_themes', null );

						// Removes the default EDD hook for this option, which breaks the AJAX call.
						remove_all_actions( 'update_option_' . $slug . '_license_key', 10 );
						update_option( $slug . '_license_key_status', 'valid' );
						update_option( $slug . '_license_key', $license );
					} else {
						if ( isset( $response['reason'] ) && ! empty( $response['reason'] ) && 'out_of_support' == $response['reason'] ) {
							$message = esc_html__( 'Your purchase\'s support period has ended. Please extend it to receive automatic updates.', 'noor' );
						} else {
							$message = esc_html__( 'Could not find a sale with this purchase code. Please double check.', 'noor' );
							delete_option( strtolower( $slug ) . '_wup_purchase_code' );
							set_site_transient( 'update_themes', null );
						}
					}
				}
			}
		} else {
			// in case the user hasn't entered a valid purchase code.
			$message = esc_html__( 'Please enter a valid purchase code. Make sure to get all the characters.', 'noor' );
		}

		$GLOBALS['wizard']->logger->info( 'Message: ' . $message );
		if ( ! $success ) {
			// if we do have errors, save them in the database so we can display them to the user.
			update_option( strtolower( $slug ) . '_wup_errors', $errors );
		} else {
			// since there are no errors, delete the option.
			delete_option( strtolower( $slug ) . '_wup_errors' );
		}

		return compact( 'success', 'message' );
	}

}
add_filter( 'merlin_ajax_activate_license', 'dima_ajax_activate_license', 10, 1 );
