<?php
/**
 * Merlin WP configuration file.
 *
 * @package   Merlin WP
 * @version   5.3.7
 * @link      https://pixeldima.com/
 * @author    PixelDima.
 */

if ( ! class_exists( 'Merlin' ) ) {
	return;
}

/**
 * Set directory locations, text strings, and settings.
 */

$wizard = new Merlin(

	$config  = array(
		'directory'            => '/framework/functions/admin/includes/merlin', // Location / directory where Merlin WP is placed in your theme.
		'merlin_url'           => 'dima', // The wp-admin page slug where Merlin WP loads.
		'parent_slug'          => 'themes.php', // The wp-admin parent page slug for the admin menu item.
		'capability'           => 'manage_options', // The capability required for this menu to be displayed to the user.
		'child_action_btn_url' => 'https://developer.wordpress.org/themes/advanced-topics/child-themes', // URL for the 'child-action-link'.
		'dev_mode'             => false, // Enable development mode for testing.
		'license_step'         => true, // EDD license activation step.
		'license_required'     => false, // Require the license activation step.
		'license_help_url'     => 'https://help.market.envato.com/hc/en-us/articles/202822600-Where-Is-My-Purchase-Code-', // URL for the 'license-tooltip'.
		'edd_remote_api_url'   => '', // EDD_Theme_Updater_Admin remote_api_url.
		'edd_item_name'        => 'Noor', // EDD_Theme_Updater_Admin item_name.
		'edd_theme_slug'       => 'noor', // EDD_Theme_Updater_Admin item_slug.
	),
	$strings = array(
		'admin-menu'               => esc_html__( 'Theme Setup', 'noor' ),
		/* translators: 1: Title Tag 2: Theme Name 3: Closing Title Tag */
		'title%s%s%s%s'            => esc_html__( '%1$s%2$s Themes &lsaquo; Theme Setup: %3$s%4$s', 'noor' ),
		'return-to-dashboard'      => esc_html__( 'Return to the dashboard', 'noor' ),
		'ignore'                   => esc_html__( 'Disable this wizard', 'noor' ),
		'btn-skip'                 => esc_html__( 'Skip', 'noor' ),
		'btn-next'                 => esc_html__( 'Next', 'noor' ),
		'btn-start'                => esc_html__( 'Start', 'noor' ),
		'btn-no'                   => esc_html__( 'Cancel', 'noor' ),
		'btn-plugins-install'      => esc_html__( 'Install', 'noor' ),
		'btn-child-install'        => esc_html__( 'Install', 'noor' ),
		'btn-content-install'      => esc_html__( 'Install', 'noor' ),
		'btn-import'               => esc_html__( 'Import', 'noor' ),
		'btn-license-activate'     => esc_html__( 'Activate', 'noor' ),
		'btn-license-skip'         => esc_html__( 'Later', 'noor' ),

		/* translators: Theme Name */
		'license-header%s'         => esc_html__( 'Activate %s', 'noor' ),
		/* translators: Theme Name */
		'license-header-success%s' => esc_html__( '%s is Activated', 'noor' ),
		/* translators: Theme Name */
		'license%s'                => esc_html__( 'Enter your license key to enable remote updates and theme support.', 'noor' ),
		'license-label'            => esc_html__( 'License key', 'noor' ),
		'license-success%s'        => esc_html__( 'The theme is already registered, so you can go to the next step!', 'noor' ),
		'license-json-success%s'   => esc_html__( 'Your theme is activated! Remote updates is enabled.', 'noor' ),
		'license-tooltip'          => esc_html__( 'Need help?', 'noor' ),

		/* translators: Theme Name */
		'welcome-header%s'         => esc_html__( 'Welcome to %s', 'noor' ),
		'welcome-header-success%s' => esc_html__( 'Hi. Welcome back', 'noor' ),
		'welcome%s'                => esc_html__( 'This wizard will set up your theme, install plugins, and import content. It is optional & should take only a few minutes.', 'noor' ),
		'welcome-success%s'        => esc_html__( 'You may have already run this theme setup wizard. If you would like to proceed anyway, click on the "Start" button below.', 'noor' ),

		'child-header'             => esc_html__( 'Install Child Theme', 'noor' ),
		'child-header-success'     => esc_html__( 'You\'re good to go!', 'noor' ),
		'child'                    => esc_html__( 'Let\'s build & activate a child theme so you may easily make theme changes.', 'noor' ),
		'child-success%s'          => esc_html__( 'Your child theme has already been installed and is now activated, if it wasn\'t already.', 'noor' ),
		'child-action-link'        => esc_html__( 'Learn about child themes', 'noor' ),
		'child-json-success%s'     => esc_html__( 'Awesome. Your child theme has already been installed and is now activated.', 'noor' ),
		'child-json-already%s'     => esc_html__( 'Awesome. Your child theme has been created and is now activated.', 'noor' ),

		'plugins-header'           => esc_html__( 'Install Plugins', 'noor' ),
		'plugins-header-success'   => esc_html__( 'You\'re up to speed!', 'noor' ),
		'plugins'                  => esc_html__( 'Let\'s install some essential WordPress plugins to get your site up to speed.', 'noor' ),
		'plugins-success%s'        => esc_html__( 'The required WordPress plugins are all installed and up to date. Press "Next" to continue the setup wizard.', 'noor' ),
		'plugins-action-link'      => esc_html__( 'Advanced', 'noor' ),

		'import-header'            => esc_html__( 'Import Content', 'noor' ),
		'import'                   => esc_html__( 'Let\'s import content to your website, to help you get familiar with the theme.', 'noor' ),
		'registration-demos'       => sprintf( __( 'Demos Can Only Be Imported With A Valid Registration, after you have successfully completed the theme registration on the <a href="%s" target="_blank">Theme License</a> tab.', 'noor' ), admin_url( 'admin.php?page=pixel-dima-license' ) ),
		'import-action-link'       => esc_html__( 'Advanced', 'noor' ),

		'ready-header'             => esc_html__( 'All done. Have fun!', 'noor' ),

		/* translators: Theme Author */
		'ready%s'                  => esc_html__( 'Your theme has been all set up. Enjoy your new theme by %s.', 'noor' ),
		'ready-action-link'        => esc_html__( 'Extras', 'noor' ),
		'ready-big-button'         => esc_html__( 'View your website', 'noor' ),
		'ready-link-1'             => sprintf( '<a href="%1$s" target="_blank">%2$s</a>', 'https://docs.pixeldima.com/noor/', esc_html__( 'Noor Documentation', 'noor' ) ),
		'ready-link-2'             => sprintf( '<a href="%1$s" target="_blank">%2$s</a>', 'https://docs.pixeldima.com/support/', esc_html__( 'Get Theme Support', 'noor' ) ),
		'ready-link-3'             => sprintf( '<a href="%1$s">%2$s</a>', admin_url( 'customize.php' ), esc_html__( 'Start Customizing', 'noor' ) ),
	)
);
