<?php
/**
 * Function used by gutenberg.
 *
 * @package Dima Framework
 * @subpackage Functions
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 */

/**
 * Enqueue block editor style
 */
function dima_block_editor_styles() {
	$rtl = is_rtl() ? '-rtl' : '';
	wp_enqueue_style( 'dima-block-editor-styles', get_theme_file_uri( '/framework/asset/site/css/styles/noor_main/blocks-style-editor' . $rtl . '.css' ), false, DIMA_VERSION, 'all' );
	// wp_enqueue_style( 'dima-block-editor-common', get_theme_file_uri( '/framework/asset/site/css/styles/noor_main/block-common' . $rtl . '.css' ), false, DIMA_VERSION, 'all' );
	if ( is_rtl() ) {
		wp_enqueue_style( 'dima-admin-font-custom', 'https://fonts.googleapis.com/css?family=Droid+Arabic+Naskh%3A300%2C400%2C400italic%2C300italic%7CDroid+Arabic+Kufi%3A700%7CDroid+Arabic+Naskh%3A400%7CDroid+Arabic+Kufi%3A500%7CDroid+Arabic+Kufi%3A300%2C400%7CPoppins%3A300%2C400%7CPoppins%3A300%2C400%2C700%7CPoppins%3A700%7CPoppins%3A300%2C400%7CPoppins%3A300%2C400&subset=arabic', null, DIMA_VERSION, 'all' );
	} else {
		wp_enqueue_style( 'dima-admin-font-custom', 'https://fonts.googleapis.com/css?family=Poppins%3A300%2C400%7CPoppins%3A300%2C400%2C700%7CPoppins%3A700%7CPoppins%3A300%2C400%7CPoppins%3A300%2C400', null, DIMA_VERSION, 'all' );
	}
}
if ( DIMA_GUTENBERG_IS_ACTIVE ) {
	add_action( 'enqueue_block_editor_assets', 'dima_block_editor_styles' );
}

/*
------------------------------*/
// Color Palette
/*------------------------------*/
$color_palette = [
	[
		'name'  => __( 'Noor Main', 'noor' ),
		'slug'  => 'cl-dima-main',
		'color' => '#333333',
	],
	[
		'name'  => __( 'white', 'noor' ),
		'slug'  => 'cl-dima-white',
		'color' => '#FFFFFF',
	],
	[
		'name'  => __( 'paragraph', 'noor' ),
		'slug'  => 'cl-dima-paragraph',
		'color' => '#757575',
	],
	[
		'name'  => __( 'Error', 'noor' ),
		'slug'  => 'cl-dima-error',
		'color' => '#f44336',
	],
	[
		'name'  => __( 'Warning', 'noor' ),
		'slug'  => 'cl-dima-warning',
		'color' => '#ffc107',
	],
	[
		'name'  => __( 'Success', 'noor' ),
		'slug'  => 'cl-dima-success',
		'color' => '#4caf50',
	],
	[
		'name'  => __( 'Info', 'noor' ),
		'slug'  => 'cl-dima-info',
		'color' => '#2196f3',
	],
];
