<?php
/**
 * Sets up the options for Customizer.
 *
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 */

/**
 * Class and Function List:
 * Function list:
 * - dima_register_theme_customizer_options()
 * - dima_customizer_controls_list()
 * Classes list:
 */

/**
 * [Functions to register Options into customizer. using "customize_register" hook]
 *
 * @param  [WP_Customize_Manager] $wp_customize [WP_Customize_Manager instance]
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Added theme option on the customizer.
 * $wp_customize
 */
function dima_register_theme_customizer_options( $wp_customize ) {

	global $dima_customizer_data;

	$customizer_path = DIMA_TEMPLATE_PATH . '/framework/functions/admin/customizer';
	include_once $customizer_path . '/choices.php';
	/**
	 * Out - Sections
	 */
	$i                              = 0;
	$customizer_array['sections'][] = array(
		'dima_customizer_section_templates',
		esc_html__( 'Demos', 'noor' ),
		++$i,
		'',
	);

	$customizer_array['panel'][] = array(
		'dima_customizer_section_layout_and_design',
		esc_html__( 'Site Layout and design', 'noor' ),
		esc_html__( 'Site Layout and design', 'noor' ),
		++$i,
		'',
	);

	$customizer_array['panel'][] = array(
		'dima_customizer_panel_typography',
		esc_html__( 'Typography', 'noor' ),
		esc_html__( 'Typography', 'noor' ),
		++$i,
	);

	$customizer_array['panel'][] = array(
		'dima_customizer_panel_header',
		esc_html__( 'Header', 'noor' ),
		esc_html__( 'Header', 'noor' ),
		++$i,
	);

	$customizer_array['panel'][] = array(
		'dima_customizer_panel_footer',
		esc_html__( 'Footer', 'noor' ),
		esc_html__( 'Footer', 'noor' ),
		++$i,
	);

	$customizer_array['panel'][] = array(
		'dima_customizer_panel_advanced',
		esc_html__( 'Advanced Settings', 'noor' ),
		esc_html__( 'Advanced Settings', 'noor' ),
		200,
	);

	$customizer_array['panel'][] = array(
		'dima_customizer_panel_projects',
		esc_html__( 'Portfolio', 'noor' ),
		esc_html__( 'Portfolio', 'noor' ),
		++$i,
	);

	$customizer_array['panel'][] = array(
		'dima_customizer_panel_blog',
		esc_html__( 'Blog Settings', 'noor' ),
		esc_html__( 'Blog Settings', 'noor' ),
		120,
	);

	$customizer_array['panel'][] = array(
		'woocommerce',
		esc_html__( 'Shop ( WooCommerce )', 'noor' ),
		esc_html__( 'Shop ( WooCommerce )', 'noor' ),
		++$i,
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_layout',
		esc_html__( 'Layout Settings', 'noor' ),
		++$i,
		'dima_customizer_section_layout_and_design',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_layout_framed',
		esc_html__( 'Frame & Boxed Settings', 'noor' ),
		++$i,
		'dima_customizer_section_layout_and_design',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_layout_style',
		esc_html__( 'Site Style', 'noor' ),
		++$i,
		'dima_customizer_section_layout_and_design',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_layout_other',
		esc_html__( 'Other Settings', 'noor' ),
		++$i,
		'dima_customizer_section_layout_and_design',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_navbar_style',
		esc_html__( 'Header Style & Layouts', 'noor' ),
		++$i,
		'dima_customizer_panel_header',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_navbar_sticky',
		esc_html__( 'Sticky Header', 'noor' ),
		++$i,
		'dima_customizer_panel_header',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_navbar_menu',
		esc_html__( 'Menu', 'noor' ),
		++$i,
		'dima_customizer_panel_header',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_navbar_submenu',
		esc_html__( 'Sub-Menu', 'noor' ),
		++$i,
		'dima_customizer_panel_header',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_navbar_burger_style',
		esc_html__( 'Menu-burger & Search', 'noor' ),
		++$i,
		'dima_customizer_panel_header',
	);

	$customizer_array['sections'][] = array(
		'title_tagline',
		esc_html__( 'Logo & Site Identity', 'noor' ),
		++$i,
		'dima_customizer_panel_header',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_navbar_logo_rtl',
		esc_html__( 'Logo (RTL) ( Deprecated )', 'noor' ),
		++$i,
		'dima_customizer_panel_header',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_navbar_call_to_action',
		esc_html__( 'Call to Action Button', 'noor' ),
		++$i,
		'dima_customizer_panel_header',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_navbar_page_title',
		esc_html__( 'Page Title', 'noor' ),
		++$i,
		'dima_customizer_panel_header',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_typography_general',
		esc_html__( 'General Typography', 'noor' ),
		++$i,
		'dima_customizer_panel_typography',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_typography_body',
		esc_html__( 'Body', 'noor' ),
		++$i,
		'dima_customizer_panel_typography',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_typography_menu',
		esc_html__( 'Main Menu', 'noor' ),
		++$i,
		'dima_customizer_panel_typography',
	);
	$customizer_array['sections'][] = array(
		'dima_customizer_section_typography_sub_menu',
		esc_html__( 'Main Menu: Dropdowns', 'noor' ),
		++$i,
		'dima_customizer_panel_typography',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_typography_sidebar',
		esc_html__( 'Sidebar', 'noor' ),
		++$i,
		'dima_customizer_panel_typography',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_typography_heading_h1',
		esc_html__( 'Heading H1', 'noor' ),
		++$i,
		'dima_customizer_panel_typography',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_typography_heading_h2',
		esc_html__( 'Heading H2', 'noor' ),
		++$i,
		'dima_customizer_panel_typography',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_typography_heading_h3',
		esc_html__( 'Heading H3', 'noor' ),
		++$i,
		'dima_customizer_panel_typography',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_typography_heading_h4',
		esc_html__( 'Heading H4', 'noor' ),
		++$i,
		'dima_customizer_panel_typography',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_typography_heading_h5',
		esc_html__( 'Heading H5', 'noor' ),
		++$i,
		'dima_customizer_panel_typography',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_typography_heading_h6',
		esc_html__( 'Heading H6', 'noor' ),
		++$i,
		'dima_customizer_panel_typography',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_typography_logo',
		esc_html__( 'Logo', 'noor' ),
		++$i,
		'dima_customizer_panel_typography',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_typography_button',
		esc_html__( 'Button', 'noor' ),
		++$i,
		'dima_customizer_panel_typography',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_typography_footer',
		esc_html__( 'Footer', 'noor' ),
		++$i,
		'dima_customizer_panel_typography',
	);
	$customizer_array['sections'][] = array(
		'dima_customizer_section_typography_small_footer',
		esc_html__( 'Small Footer And Copyright', 'noor' ),
		++$i,
		'dima_customizer_panel_typography',
	);

	/* Blog Sections */
	$customizer_array['sections'][] = array(
		'dima_customizer_section_blog',
		esc_html__( 'Latest Posts Settings', 'noor' ),
		++$i,
		'dima_customizer_panel_blog',
	);
	$customizer_array['sections'][] = array(
		'dima_customizer_section_single_post',
		esc_html__( 'Single Post Settings', 'noor' ),
		++$i,
		'dima_customizer_panel_blog',
	);
	$customizer_array['sections'][] = array(
		'dima_customizer_section_related_posts',
		esc_html__( 'Related Posts', 'noor' ),
		++$i,
		'dima_customizer_panel_blog',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_search_archives',
		esc_html__( 'Search & Archives', 'noor' ),
		++$i,
		'',
	);

	$customizer_array['sections'][] = array( 'dima_customizer_section_bbp', esc_html__( 'bbPress', 'noor' ), ++$i, '' );

	$customizer_array['sections'][] = array( 'dima_customizer_section_bp', esc_html__( 'BuddyPress', 'noor' ), ++$i, '' );

	$customizer_array['sections'][] = array(
		'dima_customizer_section_footer',
		esc_html__( 'General Settings', 'noor' ),
		++$i,
		'dima_customizer_panel_footer',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_copyright',
		esc_html__( 'Small Footer And Copyright', 'noor' ),
		++$i,
		'dima_customizer_panel_footer',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_featured',
		esc_html__( 'Featured Area', 'noor' ),
		++$i,
		'dima_customizer_panel_footer',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_footer_widget',
		esc_html__( 'Widgets', 'noor' ),
		++$i,
		'dima_customizer_panel_footer',
	);

	if ( DIMA_WC_IS_ACTIVE ) {

		$customizer_array['sections'][] = array(
			'dima_customizer_section_wc_shop',
			esc_html__( 'Shop Page', 'noor' ),
			++$i,
			'woocommerce',
		);
		$customizer_array['sections'][] = array(
			'dima_customizer_section_wc_sp',
			esc_html__( 'Single Product', 'noor' ),
			++$i,
			'woocommerce',
		);
		$customizer_array['sections'][] = array(
			'dima_customizer_section_wc_menu',
			esc_html__( 'Menu', 'noor' ),
			++$i,
			'woocommerce',
		);

	}

	if ( DIMA_EDD_IS_ACTIVE ) {
		$customizer_array['sections'][] = array(
			'dima_customizer_section_edd',
			esc_html__( 'Easy Digital Download', 'noor' ),
			++$i,
			'',
		);
	}

	/* Portfolio */

	$customizer_array['sections'][] = array(
		'dima_customizer_base_portfolio_options',
		esc_html__( 'Base portfolio options', 'noor' ),
		++$i,
		'dima_customizer_panel_projects',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_single_portfolio_item',
		esc_html__( 'Single portfolio item options', 'noor' ),
		++$i,
		'dima_customizer_panel_projects',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_portfolio_page_options',
		esc_html__( 'Portfolio page options', 'noor' ),
		++$i,
		'dima_customizer_panel_projects',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_portfolio_hover_options',
		esc_html__( 'Portfolio hover options', 'noor' ),
		++$i,
		'dima_customizer_panel_projects',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_portfolio_archive_page_options',
		esc_html__( 'Portfolio archive page options', 'noor' ),
		++$i,
		'dima_customizer_panel_projects',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_related_projects',
		esc_html__( 'Related Projects', 'noor' ),
		++$i,
		'dima_customizer_panel_projects',
	);

	$customizer_array['sections'][] = array( 'dima_customizer_section_code', esc_html__( 'Code Fields', 'noor' ), 150, '' );

	$customizer_array['sections'][] = array( 'dima_customizer_section_amp', esc_html__( 'Noor AMP', 'noor' ), 150, 'amp_panel' );

	$customizer_array['sections'][] = array(
		'dima_customizer_section_advanced',
		esc_html__( 'Performance Options', 'noor' ),
		++$i,
		'dima_customizer_panel_advanced',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_section_social',
		esc_html__( 'Social', 'noor' ),
		++$i,
		'dima_customizer_panel_advanced',
	);

	$customizer_array['sections'][] = array(
		'dima_customizer_global',
		esc_html__( 'Social Graph & SEO', 'noor' ),
		++$i,
		'dima_customizer_panel_advanced',
	);
	$customizer_array['sections'][] = array(
		'dima_customizer_section_ad',
		esc_html__( 'Advertisement', 'noor' ),
		++$i,
		'dima_customizer_panel_advanced',
	);
	$customizer_array['sections'][] = array(
		'dima_customizer_section_loading',
		esc_html__( 'Loading Screen', 'noor' ),
		++$i,
		'dima_customizer_panel_advanced',
	);

	$customizer_array['sections'][] = array( 'dima_customizer_section_custom', esc_html__( 'Custom', 'noor' ), 150, '' );

	/**
	 * Options
	 */

	$customizer_array['settings'][] = array( 'dima_layout_site', 'postMessage', 'dima_return_false', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_layout_site',
		'radio-image',
		esc_html__( 'Site Layout', 'noor' ),
		'dima_customizer_section_layout_framed',
		$Choices_site_layouts,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_boxed_margin', 'postMessage', 'dima_validate_slider' );
	$customizer_array['controls'][] = array(
		'dima_boxed_margin',
		'slider',
		esc_html__( 'Top & Bottom Margin (px)', 'noor' ),
		$Choices_boxed_margin,
		'dima_customizer_section_layout_framed',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_boxed_body_background_color', 'refresh', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_boxed_body_background_color',
		'color-alpha',
		esc_html__( 'Boxed Background Color', 'noor' ),
		'dima_customizer_section_layout_framed',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_boxed_body_background_image', 'refresh', 'dima_validate_image' );
	$customizer_array['controls'][] = array(
		'dima_boxed_body_background_image',
		'image',
		esc_html__( 'Boxed Background Image', 'noor' ),
		'dima_customizer_section_layout_framed',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_boxed_body_background_image_repeat', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_boxed_body_background_image_repeat',
		'select',
		esc_html__( 'Boxed Background Repeat', 'noor' ),
		'dima_customizer_section_layout_framed',
		array(
			''          => esc_html__( 'background-repeat', 'noor' ),
			'no-repeat' => esc_html__( 'No Repeat', 'noor' ),
			'repeat'    => esc_html__( 'Repeat All', 'noor' ),
			'repeat-x'  => esc_html__( 'Repeat Horizontally', 'noor' ),
			'repeat-y'  => esc_html__( 'Repeat Vertically', 'noor' ),
			'inherit'   => esc_html__( 'Inherit', 'noor' ),
		),
		wp_kses(
			__( 'Define the background repeat. <a href=\'http://www.w3schools.com/cssref/pr_background-repeat.asp\' target=\'_blank\'>Check this for reference</a>', 'noor' ),
			array(
				'a' => array(
					'href'   => array(),
					'target' => array(),
				),
			)
		),
	);

	$customizer_array['settings'][] = array( 'dima_boxed_body_background_image_attachment', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_boxed_body_background_image_attachment',
		'select',
		esc_html__( 'Boxed Background Attachment', 'noor' ),
		'dima_customizer_section_layout_framed',
		array(
			''        => esc_html__( 'background-attachement', 'noor' ),
			'fixed'   => esc_html__( 'Fixed', 'noor' ),
			'scroll'  => esc_html__( 'Scroll', 'noor' ),
			'inherit' => esc_html__( 'Inherit', 'noor' ),
		),
		wp_kses(
			__( "Define the background attachment. <a href='http://www.w3schools.com/cssref/pr_background-attachment.asp' target='_blank'>Check this for reference</a>", 'noor' ),
			array(
				'a' => array(
					'href'   => array(),
					'target' => array(),
				),
			)
		),
	);

	$customizer_array['settings'][] = array( 'dima_boxed_body_background_image_position', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_boxed_body_background_image_position',
		'select',
		esc_html__( 'Boxed Background Position', 'noor' ),
		'dima_customizer_section_layout_framed',
		array(
			''              => esc_html__( 'background-position', 'noor' ),
			'left top'      => esc_html__( 'Left Top', 'noor' ),
			'left center'   => esc_html__( 'Left Center', 'noor' ),
			'left bottom'   => esc_html__( 'Left Bottom', 'noor' ),
			'center top'    => esc_html__( 'Center Top', 'noor' ),
			'center center' => esc_html__( 'Center Center', 'noor' ),
			'center bottom' => esc_html__( 'Center Bottom', 'noor' ),
			'right top'     => esc_html__( 'Right Top', 'noor' ),
			'right center'  => esc_html__( 'Right Center', 'noor' ),
			'right bottom'  => esc_html__( 'Right Bottom', 'noor' ),
		),
		wp_kses(
			__( "Define the background position. <a href='http://www.w3schools.com/cssref/pr_background-position.asp' target='_blank'>Check this for reference</a>", 'noor' ),
			array(
				'a' => array(
					'href'   => array(),
					'target' => array(),
				),
			)
		),
	);
	$customizer_array['settings'][] = array( 'dima_boxed_body_background_image_size', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_boxed_body_background_image_size',
		'text',
		esc_html__( 'Boxed Background Size', 'noor' ),
		'dima_customizer_section_layout_framed',
		wp_kses(
			__( "Define the background size (Default value is 'cover'). <a href='http://www.w3schools.com/cssref/css3_pr_background-size.asp' target='_blank'>Check this for reference</a>", 'noor' ),
			array(
				'a' => array(
					'href'   => array(),
					'target' => array(),
				),
			)
		),
	);

	/*! ---- Boxed & Frame ---- */

	$customizer_array['settings'][] = array( 'dima_layout_content', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_layout_content',
		'radio-image',
		esc_html__( 'Content Layout', 'noor' ),
		'dima_customizer_section_layout',
		$Choices_of_content_layouts,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_navbar_position', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_header_navbar_position',
		'radio-image',
		esc_html__( 'Header Layout', 'noor' ),
		'dima_customizer_section_navbar_style',
		$Choices_navbar_position,
		'',
		'svg',
	);

	$customizer_array['settings'][] = array( 'dima_header_navbar_text_align', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_header_navbar_text_align',
		'radio_button_set',
		esc_html__( 'Navbar Aligning', 'noor' ),
		'dima_customizer_section_navbar_style',
		$Choices_alignement,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_menu_full_width', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_header_menu_full_width',
		'radio_button_set',
		esc_html__( 'Menu Full-Width', 'noor' ),
		'dima_customizer_section_navbar_style',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_navbar_menu_dark', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_header_navbar_menu_dark',
		'radio_button_set',
		esc_html__( 'Menu Dark', 'noor' ),
		'dima_customizer_section_navbar_style',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_navbar_background_color', 'postMessage', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_navbar_background_color',
		'color-alpha',
		esc_html__( 'Header Background Color', 'noor' ),
		'dima_customizer_section_navbar_style',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_menu_border_color', 'refresh', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_menu_border_color',
		'color-alpha',
		esc_html__( 'Header Border Color', 'noor' ),
		'dima_customizer_section_navbar_style',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_navbar_animation', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_header_navbar_animation',
		'radio',
		esc_html__( 'Sticky Header', 'noor' ),
		'dima_customizer_section_navbar_sticky',
		$Choices_navbar_animation,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_navbar_offset_by_px', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_header_navbar_offset_by_px',
		'text',
		esc_html__( 'Offset By Pixels', 'noor' ),
		'dima_customizer_section_navbar_sticky',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_navbar_offset_by_id', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_header_navbar_offset_by_id',
		'text',
		esc_html__( 'Offset By Element Target', 'noor' ),
		'dima_customizer_section_navbar_sticky',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_navbar_sticky_mobile', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_header_navbar_sticky_mobile',
		'radio_button_set',
		esc_html__( 'Sticky Header On Mobile', 'noor' ),
		'dima_customizer_section_navbar_sticky',
		$Choices_on_off,
		esc_html__( 'Check ON to activate sticky menu on mobile', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_navbar_background_color_after', 'refresh', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_navbar_background_color_after',
		'color-alpha',
		esc_html__( 'Sticky Header Background Color', 'noor' ),
		'dima_customizer_section_navbar_sticky',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_navbar_text_color_after', 'refresh', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_navbar_text_color_after',
		'color-alpha',
		esc_html__( 'Sticky Header Menu Font Color', 'noor' ),
		'dima_customizer_section_navbar_sticky',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_burger_menu', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_header_burger_menu',
		'radio_button_set',
		esc_html__( 'Navbar Burger', 'noor' ),
		'dima_customizer_section_navbar_burger_style',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_navbar_burger_mobile', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_header_navbar_burger_mobile',
		'radio_button_set',
		esc_html__( 'Display Desktop-Burger In Mobile', 'noor' ),
		'dima_customizer_section_navbar_burger_style',
		$Choices_on_off,
		esc_html( 'Check “On” to display the contents of Burger Menu desktop version in Mobile.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_header_burger_menu_style', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_header_burger_menu_style',
		'radio_button_set',
		esc_html__( 'Burger Style', 'noor' ),
		'dima_customizer_section_navbar_burger_style',
		$Choices_burger,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_navbar_transparent', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_header_navbar_transparent',
		'radio_button_set',
		esc_html__( 'Navbar Transparent (deprecated)', 'noor' ),
		'dima_customizer_section_navbar_style',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_burger_menu_float', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_header_burger_menu_float',
		'radio_button_set',
		esc_html__( 'Burger Position', 'noor' ),
		'dima_customizer_section_navbar_burger_style',
		$Choices_left_right_float,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_burger_bg_img', 'refresh', 'dima_validate_image' );
	$customizer_array['controls'][] = array(
		'dima_header_burger_bg_img',
		'image',
		esc_html__( 'Burger background Image', 'noor' ),
		'dima_customizer_section_navbar_burger_style',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_page_title_display', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_page_title_display',
		'radio_button_set',
		esc_html__( 'Page Title Display', 'noor' ),
		'dima_customizer_section_navbar_page_title',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_page_title_padding', 'postMessage', 'dima_validate_slider' );
	$customizer_array['controls'][] = array(
		'dima_page_title_padding',
		'slider',
		esc_html__( 'Page Title Padding (px)', 'noor' ),
		array(
			'min'  => '20',
			'max'  => '300',
			'step' => '5',
		),
		'dima_customizer_section_navbar_page_title',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_breadcrumb_position', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_breadcrumb_position',
		'radio_button_set',
		esc_html__( 'Page Title Style', 'noor' ),
		'dima_customizer_section_navbar_page_title',
		$Choices_breadcrumb,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_searchform_on_page_title', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_header_searchform_on_page_title',
		'radio_button_set',
		esc_html__( 'Search form on page title', 'noor' ),
		'dima_customizer_section_navbar_page_title',
		$Choices_on_off,
		esc_html__( 'Note: It work with page title style center.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_header_navbar_page_title_dark', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_header_navbar_page_title_dark',
		'radio_button_set',
		esc_html__( 'Page Title Dark', 'noor' ),
		'dima_customizer_section_navbar_page_title',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_breadcrumb_display', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_breadcrumb_display',
		'radio_button_set',
		esc_html__( 'Breadcrumbs Display', 'noor' ),
		'dima_customizer_section_navbar_page_title',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_breadcrumb_show_post_type_archive', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_breadcrumb_show_post_type_archive',
		'radio_button_set',
		esc_html__( 'Post Type Archives on Breadcrumbs', 'noor' ),
		'dima_customizer_section_navbar_page_title',
		$Choices_on_off,
		esc_html__( 'Turn on to display post type archives in the breadcrumbs path', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_breadcrumb_background_image', 'refresh', 'dima_validate_image' );
	$customizer_array['controls'][] = array(
		'dima_breadcrumb_background_image',
		'image',
		esc_html__( 'Page Title Background Image', 'noor' ),
		'dima_customizer_section_navbar_page_title',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_breadcumbs_image_style', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_breadcumbs_image_style',
		'radio_button_set',
		esc_html__( 'Page Title Backgrounds Parallax Style.', 'noor' ),
		'dima_customizer_section_navbar_page_title',
		array(
			'none'     => esc_html__( 'None', 'noor' ),
			'parallax' => esc_html__( 'Parallax', 'noor' ),
			'fixed'    => esc_html__( 'Fixed', 'noor' ),
		),
		'',
	);

	$customizer_array['settings'][] = array( 'dima_page_title_bg_color', 'refresh', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_page_title_bg_color',
		'color-alpha',
		esc_html__( 'Page Title Background Color', 'noor' ),
		'dima_customizer_section_navbar_page_title',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_page_title_bg_is_cover', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_page_title_bg_is_cover',
		'radio_button_set',
		esc_html__( 'Page Title Background is Cover', 'noor' ),
		'dima_customizer_section_navbar_page_title',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_navbar_background_image', 'refresh', 'dima_validate_image' );
	$customizer_array['controls'][] = array(
		'dima_navbar_background_image',
		'image',
		esc_html__( 'Side Menu Background Image', 'noor' ),
		'dima_customizer_section_navbar_style',
		esc_html__( 'Work with Fixed Right & Fixed Left menu', 'noor' ),
	);

	/*Top Bar*/
	$customizer_array['settings'][] = array( 'dima_navbar_option_address_text_topbar', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_navbar_option_address_text_topbar',
		'textarea',
		esc_html__( 'Address', 'noor' ),
		'dima_customizer_section_navbar_style',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_navbar_option_email_text_topbar', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_navbar_option_email_text_topbar',
		'textarea',
		esc_html__( 'Email', 'noor' ),
		'dima_customizer_section_navbar_style',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_navbar_option_tel_text_topbar', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_navbar_option_tel_text_topbar',
		'textarea',
		esc_html__( 'Phone', 'noor' ),
		'dima_customizer_section_navbar_style',
		'',
	);

	// http://codex.wordpress.org/Formatting_Date_and_Time
	$customizer_array['settings'][] = array( 'dima_navbar_option_today_text_topbar', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_navbar_option_today_text_topbar',
		'text',
		esc_html__( 'Today\'s Date Format', 'noor' ),
		'dima_customizer_section_navbar_style',
		wp_kses( __( 'For more details see <a href="https://codex.wordpress.org/Formatting_Date_and_Time" target="_blank" rel="noopener">Formatting Date and Time</a>', 'noor' ), dima_helper::dima_get_allowed_html_tag() ),
	);

	$customizer_array['settings'][] = array( 'dima_header_navbar_wpml_lang_show', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_header_navbar_wpml_lang_show',
		'radio_button_set',
		esc_html__( 'WPML language switcher', 'noor' ),
		'dima_customizer_section_navbar_style',
		$Choices_on_off,
		esc_html__( 'Allows you to have the WPML language switcher in header. Note, WPML plugin must be installed (WPML plugin is not included to the theme pack. You can find the plugin here)', 'noor' ) . ': http://wpml.org/',
	);

	$customizer_array['settings'][] = array( 'dima_navbar_lang_shortcode', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_navbar_lang_shortcode',
		'textarea',
		esc_html__( 'Language selection shortcode', 'noor' ),
		'dima_customizer_section_navbar_style',
		esc_attr__( 'In this field you can paste the language shortcode provided by the translating plugin', 'noor' ),
	);

	/*End Top Bar*/

	$customizer_array['settings'][] = array( 'dima_menu_copyright_display', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_menu_copyright_display',
		'radio_button_set',
		esc_html__( 'Copyright Display', 'noor' ),
		'dima_customizer_section_navbar_style',
		$Choices_on_off,
		esc_html__( 'This option for vertical menu.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_header_search_enable', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_header_search_enable',
		'radio_button_set',
		esc_html__( 'Search', 'noor' ),
		'dima_customizer_section_navbar_burger_style',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_search_style', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_header_search_style',
		'radio_button_set',
		esc_html__( 'Search Style', 'noor' ),
		'dima_customizer_section_navbar_burger_style',
		array(
			''         => 'Default',
			'material' => 'Material',
		),
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_search_screen', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_header_search_screen',
		'radio_button_set',
		esc_html__( 'Search full screen', 'noor' ),
		'dima_customizer_section_navbar_burger_style',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_search_dark', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_header_search_dark',
		'radio_button_set',
		esc_html__( 'Search is dark', 'noor' ),
		'dima_customizer_section_navbar_burger_style',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_burger_bg_color', 'refresh', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_header_burger_bg_color',
		'color-alpha',
		esc_html__( 'Search/burger background Color', 'noor' ),
		'dima_customizer_section_navbar_burger_style',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_search_bg_img', 'refresh', 'dima_validate_image' );
	$customizer_array['controls'][] = array(
		'dima_header_search_bg_img',
		'image',
		esc_html__( 'Search background Image', 'noor' ),
		'dima_customizer_section_navbar_burger_style',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_logo_width', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_header_logo_width',
		'text',
		esc_html__( 'Logo Width (px)', 'noor' ),
		'title_tagline',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_logo', 'refresh', 'dima_validate_image' );
	$customizer_array['controls'][] = array(
		'dima_header_logo',
		'image',
		esc_html__( 'Upload Your Default Logo', 'noor' ),
		'title_tagline',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_sticky_logo', 'refresh', 'dima_validate_image' );
	$customizer_array['controls'][] = array(
		'dima_header_sticky_logo',
		'image',
		esc_html__( 'Upload your logo for sticky & transparent menu', 'noor' ),
		'title_tagline',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_logo_retina', 'refresh', 'dima_validate_image' );
	$customizer_array['controls'][] = array(
		'dima_header_logo_retina',
		'image',
		esc_html__( 'Upload Your Default Logo (Retina Version @2x)', 'noor' ),
		'title_tagline',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_sticky_logo_retina', 'refresh', 'dima_validate_image' );
	$customizer_array['controls'][] = array(
		'dima_header_sticky_logo_retina',
		'image',
		esc_html__( 'Upload your logo for sticky & transparent menu (Retina Version @2x)', 'noor' ),
		'title_tagline',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_mobile_logo', 'refresh', 'dima_validate_image' );
	$customizer_array['controls'][] = array(
		'dima_header_mobile_logo',
		'image',
		esc_html__( 'Upload Your Mobile Logo', 'noor' ),
		'title_tagline',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_mobile_logo_retina', 'refresh', 'dima_validate_image' );
	$customizer_array['controls'][] = array(
		'dima_header_mobile_logo_retina',
		'image',
		esc_html__( 'Upload Your Mobile Logo (Retina Version @2x)', 'noor' ),
		'title_tagline',
		'',
	);

	// RTL
	$customizer_array['settings'][] = array( 'dima_header_logo_width_rtl', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_header_logo_width_rtl',
		'text',
		esc_html__( 'Logo Width (px)', 'noor' ),
		'dima_customizer_section_navbar_logo_rtl',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_logo_rtl', 'refresh', 'dima_validate_image' );
	$customizer_array['controls'][] = array(
		'dima_header_logo_rtl',
		'image',
		esc_html__( 'Upload Your Default Logo', 'noor' ),
		'dima_customizer_section_navbar_logo_rtl',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_sticky_logo_rtl', 'refresh', 'dima_validate_image' );
	$customizer_array['controls'][] = array(
		'dima_header_sticky_logo_rtl',
		'image',
		esc_html__( 'Upload Your Sticky Logo', 'noor' ),
		'dima_customizer_section_navbar_logo_rtl',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_mobile_logo_rtl', 'refresh', 'dima_validate_image' );
	$customizer_array['controls'][] = array(
		'dima_header_mobile_logo_rtl',
		'image',
		esc_html__( 'Upload Your Mobile Logo', 'noor' ),
		'dima_customizer_section_navbar_logo_rtl',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_logo_retina_rtl', 'refresh', 'dima_validate_image' );
	$customizer_array['controls'][] = array(
		'dima_header_logo_retina_rtl',
		'image',
		esc_html__( 'Upload Your Default Logo (Retina Version @2x)', 'noor' ),
		'dima_customizer_section_navbar_logo_rtl',
		'',
	);
	$customizer_array['settings'][] = array( 'dima_header_sticky_logo_retina_rtl', 'refresh', 'dima_validate_image' );
	$customizer_array['controls'][] = array(
		'dima_header_sticky_logo_retina_rtl',
		'image',
		esc_html__( 'Upload Your Sticky Logo (Retina Version @2x)', 'noor' ),
		'dima_customizer_section_navbar_logo_rtl',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_mobile_logo_retina_rtl', 'refresh', 'dima_validate_image' );
	$customizer_array['controls'][] = array(
		'dima_header_mobile_logo_retina_rtl',
		'image',
		esc_html__( 'Upload Your Mobile Logo (Retina Version @2x)', 'noor' ),
		'dima_customizer_section_navbar_logo_rtl',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_navbar_primary_menu', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_header_navbar_primary_menu',
		'radio_button_set',
		esc_html__( 'Display Primary Menu', 'noor' ),
		'dima_customizer_section_navbar_menu',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_navbar_icon_menu', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_header_navbar_icon_menu',
		'radio_button_set',
		esc_html__( 'Display Icon Menu', 'noor' ),
		'dima_customizer_section_navbar_menu',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_navbar_shear_icon', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_header_navbar_shear_icon',
		'radio_button_set',
		esc_html__( 'Display social icons', 'noor' ),
		'dima_customizer_section_navbar_menu',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_navbar_button', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_header_navbar_button',
		'radio_button_set',
		esc_html__( 'Call to Action Button on The Menu', 'noor' ),
		'dima_customizer_section_navbar_call_to_action',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_navbar_button_url', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_header_navbar_button_url',
		'text',
		esc_html__( 'Button URL', 'noor' ),
		'dima_customizer_section_navbar_call_to_action',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_navbar_button_txt', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_header_navbar_button_txt',
		'text',
		esc_html__( 'Button Text', 'noor' ),
		'dima_customizer_section_navbar_call_to_action',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_navbar_button_class', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_header_navbar_button_class',
		'text',
		esc_html__( 'Button CSS Class', 'noor' ),
		'dima_customizer_section_navbar_call_to_action',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_navbar_button_bg_color', 'refresh', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_header_navbar_button_bg_color',
		'color-alpha',
		esc_html__( 'Button Background Color', 'noor' ),
		'dima_customizer_section_navbar_call_to_action',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_navbar_button_bg_color_hover', 'refresh', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_header_navbar_button_bg_color_hover',
		'color-alpha',
		esc_html__( 'Button Hover Background', 'noor' ),
		'dima_customizer_section_navbar_call_to_action',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_header_navbar_button_txt_color', 'refresh', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_header_navbar_button_txt_color',
		'color-alpha',
		esc_html__( 'Button Text Color', 'noor' ),
		'dima_customizer_section_navbar_call_to_action',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_navbar_underline_on_off', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_navbar_underline_on_off',
		'radio_button_set',
		esc_html__( 'Display Underline', 'noor' ),
		'dima_customizer_section_navbar_menu',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_navbar_underline_hover_color', 'refresh', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_navbar_underline_hover_color',
		'color-alpha',
		esc_html__( 'NavBar Underline Hover Color', 'noor' ),
		'dima_customizer_section_navbar_menu',
		'',
	);

	// Submenu
	$customizer_array['settings'][] = array( 'dima_header_navbar_sup_menu_dark', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_header_navbar_sup_menu_dark',
		'radio_button_set',
		esc_html__( 'Sub-Menu Dark', 'noor' ),
		'dima_customizer_section_navbar_submenu',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_submenu_bg_color', 'refresh', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_submenu_bg_color',
		'color-alpha',
		esc_html__( 'Sub-Menu Background Color', 'noor' ),
		'dima_customizer_section_navbar_submenu',
		'',
	);

	// End Submenu
	/*--!NavBar--*/

	/* < (8) content width > */
	$customizer_array['settings'][] = array( 'dima_content_width', 'postMessage', 'dima_validate_slider' );
	$customizer_array['controls'][] = array(
		'dima_content_width',
		'slider',
		esc_html__( 'Site Content Width (%)', 'noor' ),
		$Choices_sizing_content_width,
		'dima_customizer_section_layout',
		'',
	);

	/* < (9) box width > */
	$customizer_array['settings'][] = array( 'dima_content_max_width', 'postMessage', 'dima_validate_slider' );
	$customizer_array['controls'][] = array(
		'dima_content_max_width',
		'slider',
		esc_html__( 'Site Max Content Width (px)', 'noor' ),
		$Choices_max_sizing_content_width,
		'dima_customizer_section_layout',
		'',
	);

	/* < (9) box width > */
	$customizer_array['settings'][] = array( 'dima_sidebar_width', 'postMessage', 'dima_validate_slider' );
	$customizer_array['controls'][] = array(
		'dima_sidebar_width',
		'slider',
		esc_html__( 'Site Sidebar Width (px)', 'noor' ),
		array(
			'min'  => '240',
			'max'  => '350',
			'step' => '5',
		),
		'dima_customizer_section_layout',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_section_padding', 'postMessage', 'dima_validate_slider' );
	$customizer_array['controls'][] = array(
		'dima_section_padding',
		'slider',
		esc_html__( 'Section Padding (px)', 'noor' ),
		array(
			'min'  => '40',
			'max'  => '170',
			'step' => '5',
		),
		'dima_customizer_section_layout',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_sticky_sidebar', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_sticky_sidebar',
		'radio_button_set',
		esc_html__( 'Sticky Sidebar', 'noor' ),
		'dima_customizer_section_layout',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_frame_size', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_frame_size',
		'radio_button_set',
		esc_html__( 'Framed', 'noor' ),
		'dima_customizer_section_layout_framed',
		$Choices_frame_size,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_frame_color', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_frame_color',
		'color-alpha',
		esc_html__( 'Frame color', 'noor' ),
		'dima_customizer_section_layout_framed',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_smoothscroll', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_smoothscroll',
		'radio_button_set',
		esc_html__( 'Smooth Scroll', 'noor' ),
		'dima_customizer_section_layout_other',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_blog_link_icon', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_blog_link_icon',
		'text',
		esc_html__( 'Hover SVG Icon For Post', 'noor' ),
		'dima_customizer_section_layout_other',
		wp_kses(
			__( 'Enter SVG Icon name <a href=\'https://noor.pixeldima.com/noor-icons/\' target=\'_blank\'>(You can choose from the provided icons)</a>', 'noor' ),
			array(
				'a' => array(
					'href'   => array(),
					'target' => array(),
				),
			)
		),
	);

	$customizer_array['settings'][] = array( 'dima_shop_link_icon', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_shop_link_icon',
		'text',
		esc_html__( 'SVG Icon For Product Link', 'noor' ),
		'dima_customizer_section_layout_other',
		wp_kses(
			__( 'Enter SVG Icon name <a href=\'https://noor.pixeldima.com/noor-icons/\' target=\'_blank\'>(You can choose from the provided icons)</a>', 'noor' ),
			array(
				'a' => array(
					'href'   => array(),
					'target' => array(),
				),
			)
		),
	);
	$customizer_array['settings'][] = array( 'dima_add_to_link_icon', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_add_to_link_icon',
		'text',
		esc_html__( 'SVG Icon For Product Add to Cart', 'noor' ),
		'dima_customizer_section_layout_other',
		wp_kses(
			__( 'Enter SVG Icon name <a href=\'https://noor.pixeldima.com/noor-icons/\' target=\'_blank\'>(You can choose from the provided icons)</a>', 'noor' ),
			array(
				'a' => array(
					'href'   => array(),
					'target' => array(),
				),
			)
		),
	);

	$customizer_array['settings'][] = array( 'dima_portfolio_link_icon', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_portfolio_link_icon',
		'text',
		esc_html__( 'Hover SVG Icon For Portfolio', 'noor' ),
		'dima_customizer_section_layout_other',
		wp_kses(
			__( 'Enter SVG Icon name <a href=\'https://noor.pixeldima.com/noor-icons/\' target=\'_blank\'>(You can choose from the provided icons)</a>', 'noor' ),
			array(
				'a' => array(
					'href'   => array(),
					'target' => array(),
				),
			)
		),
	);

	$customizer_array['settings'][] = array( 'dima_burger_menu_icon', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_burger_menu_icon',
		'text',
		esc_html__( 'Burger Menu', 'noor' ),
		'dima_customizer_section_layout_other',
		wp_kses(
			__( 'Enter SVG Icon name <a href=\'https://noor.pixeldima.com/noor-icons/\' target=\'_blank\'>(You can choose from the provided icons)</a>', 'noor' ),
			array(
				'a' => array(
					'href'   => array(),
					'target' => array(),
				),
			)
		),
	);

	$customizer_array['settings'][] = array( 'dima_mobile_menu_icon', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_mobile_menu_icon',
		'text',
		esc_html__( 'Mobile Menu', 'noor' ),
		'dima_customizer_section_layout_other',
		wp_kses(
			__( 'Enter SVG Icon name <a href=\'https://noor.pixeldima.com/noor-icons/\' target=\'_blank\'>(You can choose from the provided icons)</a>', 'noor' ),
			array(
				'a' => array(
					'href'   => array(),
					'target' => array(),
				),
			)
		),
	);

	/* < (5) Website Backgound > */

	$customizer_array['settings'][] = array( 'dima_main_color', 'postMessage', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_main_color',
		'color-alpha',
		esc_html__( 'Primary Color', 'noor' ),
		'dima_customizer_section_layout_style',
		esc_html__( 'This color will be applied to call to action elements such as buttons and hover icons. It\'s preferable to be attractive color and define the main color of your website.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_secondary_main_color', 'postMessage', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_secondary_main_color',
		'color-alpha',
		esc_html__( 'Secondary color', 'noor' ),
		'dima_customizer_section_layout_style',
		esc_html__( 'This color will be applied to other elements and it\'s preferable to be like your headings color or a dark color.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_body_background_color', 'refresh', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_body_background_color',
		'color-alpha',
		esc_html__( 'Website Background Color', 'noor' ),
		'dima_customizer_section_layout_style',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_body_background_image', 'refresh', 'dima_validate_image' );
	$customizer_array['controls'][] = array(
		'dima_body_background_image',
		'image',
		esc_html__( 'Website Background Image', 'noor' ),
		'dima_customizer_section_layout_style',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_body_background_image_repeat', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_body_background_image_repeat',
		'select',
		esc_html__( 'Website Background Repeat', 'noor' ),
		'dima_customizer_section_layout_style',
		array(
			''          => esc_html__( 'background-repeat', 'noor' ),
			'no-repeat' => esc_html__( 'No Repeat', 'noor' ),
			'repeat'    => esc_html__( 'Repeat All', 'noor' ),
			'repeat-x'  => esc_html__( 'Repeat Horizontally', 'noor' ),
			'repeat-y'  => esc_html__( 'Repeat Vertically', 'noor' ),
			'inherit'   => esc_html__( 'Inherit', 'noor' ),
		),
		wp_kses(
			__( 'Define the background repeat. <a href=\'http://www.w3schools.com/cssref/pr_background-repeat.asp\' target=\'_blank\'>Check this for reference</a>', 'noor' ),
			array(
				'a' => array(
					'href'   => array(),
					'target' => array(),
				),
			)
		),
	);

	$customizer_array['settings'][] = array( 'dima_body_background_image_attachment', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_body_background_image_attachment',
		'select',
		esc_html__( 'Website Background Attachment', 'noor' ),
		'dima_customizer_section_layout_style',
		array(
			''        => esc_html__( 'background-attachement', 'noor' ),
			'fixed'   => esc_html__( 'Fixed', 'noor' ),
			'scroll'  => esc_html__( 'Scroll', 'noor' ),
			'inherit' => esc_html__( 'Inherit', 'noor' ),
		),
		wp_kses(
			__( "Define the background attachment. <a href='http://www.w3schools.com/cssref/pr_background-attachment.asp' target='_blank'>Check this for reference</a>", 'noor' ),
			array(
				'a' => array(
					'href'   => array(),
					'target' => array(),
				),
			)
		),
	);

	$customizer_array['settings'][] = array( 'dima_body_background_image_position', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_body_background_image_position',
		'select',
		esc_html__( 'Website Background Position', 'noor' ),
		'dima_customizer_section_layout_style',
		array(
			''              => esc_html__( 'background-position', 'noor' ),
			'left top'      => esc_html__( 'Left Top', 'noor' ),
			'left center'   => esc_html__( 'Left Center', 'noor' ),
			'left bottom'   => esc_html__( 'Left Bottom', 'noor' ),
			'center top'    => esc_html__( 'Center Top', 'noor' ),
			'center center' => esc_html__( 'Center Center', 'noor' ),
			'center bottom' => esc_html__( 'Center Bottom', 'noor' ),
			'right top'     => esc_html__( 'Right Top', 'noor' ),
			'right center'  => esc_html__( 'Right Center', 'noor' ),
			'right bottom'  => esc_html__( 'Right Bottom', 'noor' ),
		),
		wp_kses(
			__( "Define the background position. <a href='http://www.w3schools.com/cssref/pr_background-position.asp' target='_blank'>Check this for reference</a>", 'noor' ),
			array(
				'a' => array(
					'href'   => array(),
					'target' => array(),
				),
			)
		),
	);
	$customizer_array['settings'][] = array( 'dima_body_background_image_size', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_body_background_image_size',
		'text',
		esc_html__( 'Website Background Size', 'noor' ),
		'dima_customizer_section_layout_style',
		wp_kses(
			__( "Define the background size (Default value is 'cover'). <a href='http://www.w3schools.com/cssref/css3_pr_background-size.asp' target='_blank'>Check this for reference</a>", 'noor' ),
			array(
				'a' => array(
					'href'   => array(),
					'target' => array(),
				),
			)
		),
	);

	/*
	==TypoGraphy==*/
	/*--Body--*/

	$customizer_array['settings'][] = array( 'dima_custom_font', 'postMessage', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_custom_font',
		'radio_button_set',
		esc_html__( 'Custom Fonts', 'noor' ),
		'dima_customizer_section_typography_general',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_gfonts_load_method', 'postMessage', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_gfonts_load_method',
		'radio_button_set',
		esc_html__( 'Google Fonts Mode', 'noor' ),
		'dima_customizer_section_typography_general',
		array(
			'local' => esc_html__( 'Local', 'noor' ),
			'cdn'   => esc_html__( 'CDN', 'noor' ),
		),
		esc_html__( 'When set to "Local", the Google fonts set in Theme Options will be downloaded to your server. Set to "CDN" to use the Google CDN.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_body_subsets_list', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_body_subsets_list',
		'multi_check',
		esc_html__( 'Font Subsets', 'noor' ),
		'dima_customizer_section_typography_general',
		$list_font_subsets,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_custom_font_one', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_custom_font_one',
		'text',
		esc_html__( 'Custom Font #1', 'noor' ),
		'dima_customizer_section_typography_general',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_custom_font_two', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_custom_font_two',
		'text',
		esc_html__( 'Custom Font #2', 'noor' ),
		'dima_customizer_section_typography_general',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_custom_font_three', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_custom_font_three',
		'text',
		esc_html__( 'Custom Font #3', 'noor' ),
		'dima_customizer_section_typography_general',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_fontawesome_five', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_fontawesome_five',
		'radio_button_set',
		esc_html__( 'Apply to use the font-awesome v5', 'noor' ),
		'dima_customizer_section_typography_general',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_fontawesome_five_svg', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_fontawesome_five_svg',
		'radio_button_set',
		esc_html__( 'Use font-awesome v5 SVG', 'noor' ),
		'dima_customizer_section_typography_general',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_fontawesome_five_upgrading', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_fontawesome_five_upgrading',
		'radio_button_set',
		esc_html__( 'Upgrading from FontAwesome Version 4', 'noor' ),
		'dima_customizer_section_typography_general',
		$Choices_on_off,
		'',
	);

	/* ------ */
	$customizer_array['settings'][] = array( 'dima_body_font_source', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_body_font_source',
		'select',
		esc_html__( 'Source', 'noor' ),
		'dima_customizer_section_typography_body',
		array(
			''        => esc_html__( 'Theme Defaults', 'noor' ),
			'g_fonts' => esc_html__( 'Google Fonts', 'noor' ),
			's_fonts' => esc_html__( 'Standard Fonts', 'noor' ),
			'f_fonts' => esc_html__( 'FontFace.me', 'noor' ),
			'c_fonts' => esc_html__( 'Custom Fonts (e.g. Typekit)', 'noor' ),
		),
		'',
	);

	$customizer_array['settings'][] = array( 'dima_body_font_list', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_body_font_list',
		'dima_typography',
		esc_html__( 'Font Family', 'noor' ),
		'dima_customizer_section_typography_body',
		'',
		'',
	);
	/* ------ */

	$customizer_array['settings'][] = array( 'dima_body_weights_list', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_body_weights_list',
		'multi_check',
		esc_html__( 'Font Variants', 'noor' ),
		'dima_customizer_section_typography_body',
		$list_all_font_weights,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_body_weight_selected', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_body_weight_selected',
		'select',
		esc_html__( 'Font Weights', 'noor' ),
		'dima_customizer_section_typography_body',
		$list_all_font_weight_selected,
		esc_html__( 'Important: Not all fonts support every font-weight.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_body_text_size', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_body_text_size',
		'text',
		esc_html__( 'Font Size', 'noor' ),
		'dima_customizer_section_typography_body',
		esc_html__( 'You can add: px-rem-em-%, leave empty and it will apply px', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_body_line_height', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_body_line_height',
		'text',
		esc_html__( 'Line Height', 'noor' ),
		'dima_customizer_section_typography_body',
		esc_html__( 'Utilities for controlling the leading (line height)', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_body_letter_spacing', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_body_letter_spacing',
		'text',
		esc_html__( 'Letter Spacing', 'noor' ),
		'dima_customizer_section_typography_body',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_body_text_color', 'postMessage', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_body_text_color',
		'color',
		esc_html__( 'Font Color', 'noor' ),
		'dima_customizer_section_typography_body',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_body_link_color', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_body_link_color',
		'color',
		esc_html__( 'Text Link color', 'noor' ),
		'dima_customizer_section_typography_body',
		esc_html__( 'This color will be applied to the important text links in your website and it\'s preferable to be like your website main color.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_body_link_color_hover', 'postMessage', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_body_link_color_hover',
		'color',
		esc_html__( 'Text Link Hover color', 'noor' ),
		'dima_customizer_section_typography_body',
		'',
	);
	/*--!Body--*/

	/*--headings 1--*/
	$customizer_array['settings'][] = array( 'dima_heading_text_style', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_text_style',
		'font_style',
		esc_html__( 'Heading Font Style', 'noor' ),
		'dima_customizer_section_typography_heading_h1',
		$Choices_font_style,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_heading_font_source', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_font_source',
		'select',
		esc_html__( 'Source', 'noor' ),
		'dima_customizer_section_typography_heading_h1',
		array(
			''        => esc_html__( 'Theme Defaults', 'noor' ),
			'g_fonts' => esc_html__( 'Google Fonts', 'noor' ),
			's_fonts' => esc_html__( 'Standard Fonts', 'noor' ),
			'f_fonts' => esc_html__( 'FontFace.me', 'noor' ),
			'c_fonts' => esc_html__( 'Custom Fonts (e.g. Typekit)', 'noor' ),
		),
		'',
	);

	$customizer_array['settings'][] = array( 'dima_heading_font_list', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_font_list',
		'dima_typography',
		esc_html__( 'Font Family', 'noor' ),
		'dima_customizer_section_typography_heading_h1',
		'',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_heading_weights_list', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_weights_list',
		'multi_check',
		esc_html__( 'Font Variants', 'noor' ),
		'dima_customizer_section_typography_heading_h1',
		$list_all_font_weights,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_heading_weight_selected', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_weight_selected',
		'select',
		esc_html__( 'Font Weights', 'noor' ),
		'dima_customizer_section_typography_heading_h1',
		$list_all_font_weight_selected,
		esc_html__( 'Important: Not all fonts support every font-weight.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_heading_letter_spacing', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_letter_spacing',
		'text',
		esc_html__( 'Letter Spacing', 'noor' ),
		'dima_customizer_section_typography_heading_h1',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_h1_text_size', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_h1_text_size',
		'text',
		esc_html__( 'Font Size', 'noor' ),
		'dima_customizer_section_typography_heading_h1',
		esc_html__( 'You can add: px-rem-em-%, leave empty and it will apply px', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_heading_text_color', 'postMessage', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_heading_text_color',
		'color',
		esc_html__( 'Headings color', 'noor' ),
		'dima_customizer_section_typography_heading_h1',
		'',
	);
	/*--!headings 1--*/

	/*--headings 2--*/
	$customizer_array['settings'][] = array( 'dima_heading_text_style_2', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_text_style_2',
		'font_style',
		esc_html__( 'Heading Font Style', 'noor' ),
		'dima_customizer_section_typography_heading_h2',
		$Choices_font_style,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_heading_2_font_source', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_2_font_source',
		'select',
		esc_html__( 'Source', 'noor' ),
		'dima_customizer_section_typography_heading_h2',
		array(
			''        => esc_html__( 'Theme Defaults', 'noor' ),
			'g_fonts' => esc_html__( 'Google Fonts', 'noor' ),
			's_fonts' => esc_html__( 'Standard Fonts', 'noor' ),
			'f_fonts' => esc_html__( 'FontFace.me', 'noor' ),
			'c_fonts' => esc_html__( 'Custom Fonts (e.g. Typekit)', 'noor' ),
		),
		'',
	);

	$customizer_array['settings'][] = array( 'dima_heading_font_list_2', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_font_list_2',
		'dima_typography',
		esc_html__( 'Font Family', 'noor' ),
		'dima_customizer_section_typography_heading_h2',
		'',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_heading_weights_list_2', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_weights_list_2',
		'multi_check',
		esc_html__( 'Font Variants', 'noor' ),
		'dima_customizer_section_typography_heading_h2',
		$list_all_font_weights,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_heading_weight_selected_2', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_weight_selected_2',
		'select',
		esc_html__( 'Font Weights', 'noor' ),
		'dima_customizer_section_typography_heading_h2',
		$list_all_font_weight_selected,
		esc_html__( 'Important: Not all fonts support every font-weight.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_heading_letter_spacing_2', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_letter_spacing_2',
		'text',
		esc_html__( 'Letter Spacing', 'noor' ),
		'dima_customizer_section_typography_heading_h2',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_h2_text_size', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_h2_text_size',
		'text',
		esc_html__( 'Font Size', 'noor' ),
		'dima_customizer_section_typography_heading_h2',
		esc_html__( 'You can add: px-rem-em-%, leave empty and it will apply px', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_heading_text_color_2', 'postMessage', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_heading_text_color_2',
		'color',
		esc_html__( 'Headings color', 'noor' ),
		'dima_customizer_section_typography_heading_h2',
		'',
	);
	/*--!headings 2--*/

	/*--headings 3--*/
	$customizer_array['settings'][] = array( 'dima_heading_text_style_3', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_text_style_3',
		'font_style',
		esc_html__( 'Heading Font Style', 'noor' ),
		'dima_customizer_section_typography_heading_h3',
		$Choices_font_style,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_heading_3_font_source', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_3_font_source',
		'select',
		esc_html__( 'Source', 'noor' ),
		'dima_customizer_section_typography_heading_h3',
		array(
			''        => esc_html__( 'Theme Defaults', 'noor' ),
			'g_fonts' => esc_html__( 'Google Fonts', 'noor' ),
			's_fonts' => esc_html__( 'Standard Fonts', 'noor' ),
			'f_fonts' => esc_html__( 'FontFace.me', 'noor' ),
			'c_fonts' => esc_html__( 'Custom Fonts (e.g. Typekit)', 'noor' ),
		),
		'',
	);

	$customizer_array['settings'][] = array( 'dima_heading_font_list_3', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_font_list_3',
		'dima_typography',
		esc_html__( 'Font Family', 'noor' ),
		'dima_customizer_section_typography_heading_h3',
		'',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_heading_weights_list_3', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_weights_list_3',
		'multi_check',
		esc_html__( 'Font Variants', 'noor' ),
		'dima_customizer_section_typography_heading_h3',
		$list_all_font_weights,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_heading_weight_selected_3', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_weight_selected_3',
		'select',
		esc_html__( 'Font Weights', 'noor' ),
		'dima_customizer_section_typography_heading_h3',
		$list_all_font_weight_selected,
		esc_html__( 'Important: Not all fonts support every font-weight.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_heading_letter_spacing_3', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_letter_spacing_3',
		'text',
		esc_html__( 'Letter Spacing', 'noor' ),
		'dima_customizer_section_typography_heading_h3',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_h3_text_size', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_h3_text_size',
		'text',
		esc_html__( 'Font Size', 'noor' ),
		'dima_customizer_section_typography_heading_h3',
		esc_html__( 'You can add: px-rem-em-%, leave empty and it will apply px', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_heading_text_color_3', 'postMessage', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_heading_text_color_3',
		'color',
		esc_html__( 'Headings color', 'noor' ),
		'dima_customizer_section_typography_heading_h3',
		'',
	);
	/*--!headings 3--*/

	/*--headings 4--*/
	$customizer_array['settings'][] = array( 'dima_heading_text_style_4', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_text_style_4',
		'font_style',
		esc_html__( 'Heading Font Style', 'noor' ),
		'dima_customizer_section_typography_heading_h4',
		$Choices_font_style,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_heading_4_font_source', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_4_font_source',
		'select',
		esc_html__( 'Source', 'noor' ),
		'dima_customizer_section_typography_heading_h4',
		array(
			''        => esc_html__( 'Theme Defaults', 'noor' ),
			'g_fonts' => esc_html__( 'Google Fonts', 'noor' ),
			's_fonts' => esc_html__( 'Standard Fonts', 'noor' ),
			'f_fonts' => esc_html__( 'FontFace.me', 'noor' ),
			'c_fonts' => esc_html__( 'Custom Fonts (e.g. Typekit)', 'noor' ),
		),
		'',
	);

	$customizer_array['settings'][] = array( 'dima_heading_font_list_4', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_font_list_4',
		'dima_typography',
		esc_html__( 'Font Family', 'noor' ),
		'dima_customizer_section_typography_heading_h4',
		'',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_heading_weights_list_4', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_weights_list_4',
		'multi_check',
		esc_html__( 'Font Variants', 'noor' ),
		'dima_customizer_section_typography_heading_h4',
		$list_all_font_weights,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_heading_weight_selected_4', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_weight_selected_4',
		'select',
		esc_html__( 'Font Weights', 'noor' ),
		'dima_customizer_section_typography_heading_h4',
		$list_all_font_weight_selected,
		esc_html__( 'Important: Not all fonts support every font-weight.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_heading_letter_spacing_4', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_letter_spacing_4',
		'text',
		esc_html__( 'Letter Spacing', 'noor' ),
		'dima_customizer_section_typography_heading_h4',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_h4_text_size', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_h4_text_size',
		'text',
		esc_html__( 'Font Size', 'noor' ),
		'dima_customizer_section_typography_heading_h4',
		esc_html__( 'You can add: px-rem-em-%, leave empty and it will apply px', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_heading_text_color_4', 'postMessage', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_heading_text_color_4',
		'color',
		esc_html__( 'Headings color', 'noor' ),
		'dima_customizer_section_typography_heading_h4',
		'',
	);
	/*--!headings 4--*/

	/*--headings 5--*/
	$customizer_array['settings'][] = array( 'dima_heading_text_style_5', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_text_style_5',
		'font_style',
		esc_html__( 'Heading Font Style', 'noor' ),
		'dima_customizer_section_typography_heading_h5',
		$Choices_font_style,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_heading_5_font_source', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_5_font_source',
		'select',
		esc_html__( 'Source', 'noor' ),
		'dima_customizer_section_typography_heading_h5',
		array(
			''        => esc_html__( 'Theme Defaults', 'noor' ),
			'g_fonts' => esc_html__( 'Google Fonts', 'noor' ),
			's_fonts' => esc_html__( 'Standard Fonts', 'noor' ),
			'f_fonts' => esc_html__( 'FontFace.me', 'noor' ),
			'c_fonts' => esc_html__( 'Custom Fonts (e.g. Typekit)', 'noor' ),
		),
		'',
	);

	$customizer_array['settings'][] = array( 'dima_heading_font_list_5', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_font_list_5',
		'dima_typography',
		esc_html__( 'Font Family', 'noor' ),
		'dima_customizer_section_typography_heading_h5',
		'',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_heading_weights_list_5', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_weights_list_5',
		'multi_check',
		esc_html__( 'Font Variants', 'noor' ),
		'dima_customizer_section_typography_heading_h5',
		$list_all_font_weights,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_heading_weight_selected_5', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_weight_selected_5',
		'select',
		esc_html__( 'Font Weights', 'noor' ),
		'dima_customizer_section_typography_heading_h5',
		$list_all_font_weight_selected,
		esc_html__( 'Important: Not all fonts support every font-weight.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_heading_letter_spacing_5', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_letter_spacing_5',
		'text',
		esc_html__( 'Letter Spacing', 'noor' ),
		'dima_customizer_section_typography_heading_h5',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_h5_text_size', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_h5_text_size',
		'text',
		esc_html__( 'Font Size', 'noor' ),
		'dima_customizer_section_typography_heading_h5',
		esc_html__( 'You can add: px-rem-em-%, leave empty and it will apply px', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_heading_text_color_5', 'postMessage', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_heading_text_color_5',
		'color',
		esc_html__( 'Headings color', 'noor' ),
		'dima_customizer_section_typography_heading_h5',
		'',
	);
	/*--!headings 5--*/

	/*--headings 6--*/
	$customizer_array['settings'][] = array( 'dima_heading_text_style_6', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_text_style_6',
		'font_style',
		esc_html__( 'Heading Font Style', 'noor' ),
		'dima_customizer_section_typography_heading_h6',
		$Choices_font_style,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_heading_6_font_source', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_6_font_source',
		'select',
		esc_html__( 'Source', 'noor' ),
		'dima_customizer_section_typography_heading_h6',
		array(
			''        => esc_html__( 'Theme Defaults', 'noor' ),
			'g_fonts' => esc_html__( 'Google Fonts', 'noor' ),
			's_fonts' => esc_html__( 'Standard Fonts', 'noor' ),
			'f_fonts' => esc_html__( 'FontFace.me', 'noor' ),
			'c_fonts' => esc_html__( 'Custom Fonts (e.g. Typekit)', 'noor' ),
		),
		'',
	);

	$customizer_array['settings'][] = array( 'dima_heading_font_list_6', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_font_list_6',
		'dima_typography',
		esc_html__( 'Font Family', 'noor' ),
		'dima_customizer_section_typography_heading_h6',
		'',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_heading_weights_list_6', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_weights_list_6',
		'multi_check',
		esc_html__( 'Font Variants', 'noor' ),
		'dima_customizer_section_typography_heading_h6',
		$list_all_font_weights,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_heading_weight_selected_6', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_weight_selected_6',
		'select',
		esc_html__( 'Font Weights', 'noor' ),
		'dima_customizer_section_typography_heading_h6',
		$list_all_font_weight_selected,
		esc_html__( 'Important: Not all fonts support every font-weight.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_heading_letter_spacing_6', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_heading_letter_spacing_6',
		'text',
		esc_html__( 'Letter Spacing', 'noor' ),
		'dima_customizer_section_typography_heading_h6',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_h6_text_size', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_h6_text_size',
		'text',
		esc_html__( 'Font Size (px)', 'noor' ),
		'dima_customizer_section_typography_heading_h6',
		esc_html__( 'You can add: px-rem-em-%, leave empty and it will apply px', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_heading_text_color_6', 'postMessage', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_heading_text_color_6',
		'color',
		esc_html__( 'Headings color', 'noor' ),
		'dima_customizer_section_typography_heading_h6',
		'',
	);
	/*--!headings 6--*/

	/*--Menu--*/
	$customizer_array['settings'][] = array( 'dima_navbar_text_style', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_navbar_text_style',
		'font_style',
		esc_html__( 'Font Style', 'noor' ),
		'dima_customizer_section_typography_menu',
		$Choices_font_style,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_navbar_font_source', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_navbar_font_source',
		'select',
		esc_html__( 'Source', 'noor' ),
		'dima_customizer_section_typography_menu',
		array(
			''        => esc_html__( 'Theme Defaults', 'noor' ),
			'g_fonts' => esc_html__( 'Google Fonts', 'noor' ),
			's_fonts' => esc_html__( 'Standard Fonts', 'noor' ),
			'f_fonts' => esc_html__( 'FontFace.me', 'noor' ),
			'c_fonts' => esc_html__( 'Custom Fonts (e.g. Typekit)', 'noor' ),
		),
		'',
	);

	$customizer_array['settings'][] = array( 'dima_navbar_font_list', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_navbar_font_list',
		'dima_typography',
		esc_html__( 'Font Family', 'noor' ),
		'dima_customizer_section_typography_menu',
		'',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_navbar_weights_list', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_navbar_weights_list',
		'multi_check',
		esc_html__( 'Font Variants', 'noor' ),
		'dima_customizer_section_typography_menu',
		$list_all_font_weights,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_navbar_weight_selected', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_navbar_weight_selected',
		'select',
		esc_html__( 'Font Weights', 'noor' ),
		'dima_customizer_section_typography_menu',
		$list_all_font_weight_selected,
		esc_html__( 'Important: Not all fonts support every font-weight.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_navbar_text_size', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_navbar_text_size',
		'text',
		esc_html__( 'Font Size', 'noor' ),
		'dima_customizer_section_typography_menu',
		esc_html__( 'You can add: px-rem-em-%, leave empty and it will apply px', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_navbar_letter_spacing', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_navbar_letter_spacing',
		'text',
		esc_html__( 'Letter Spacing', 'noor' ),
		'dima_customizer_section_typography_menu',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_navbar_text_color', 'postMessage', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_navbar_text_color',
		'color-alpha',
		esc_html__( 'Font Color', 'noor' ),
		'dima_customizer_section_typography_menu',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_navbar_text_hover_color', 'postMessage', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_navbar_text_hover_color',
		'color-alpha',
		esc_html__( 'Font Hover Color', 'noor' ),
		'dima_customizer_section_typography_menu',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_submenu_text_color', 'postMessage', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_submenu_text_color',
		'color-alpha',
		esc_html__( 'Font Color', 'noor' ),
		'dima_customizer_section_typography_sub_menu',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_submenu_text_hover_color', 'postMessage', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_submenu_text_hover_color',
		'color-alpha',
		esc_html__( 'Font Hover Color', 'noor' ),
		'dima_customizer_section_typography_sub_menu',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_submenu_text_line_height', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_submenu_text_line_height',
		'text',
		esc_html__( 'Line Height', 'noor' ),
		'dima_customizer_section_typography_sub_menu',
		'',
	);

	/*--logo--*/

	$customizer_array['settings'][] = array( 'dima_logo_text_style', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_logo_text_style',
		'font_style',
		esc_html__( 'Font Style', 'noor' ),
		'dima_customizer_section_typography_logo',
		$Choices_font_style,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_logo_font_source', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_logo_font_source',
		'select',
		esc_html__( 'Source', 'noor' ),
		'dima_customizer_section_typography_logo',
		array(
			''        => esc_html__( 'Theme Defaults', 'noor' ),
			'g_fonts' => esc_html__( 'Google Fonts', 'noor' ),
			's_fonts' => esc_html__( 'Standard Fonts', 'noor' ),
			'f_fonts' => esc_html__( 'FontFace.me', 'noor' ),
			'c_fonts' => esc_html__( 'Custom Fonts (e.g. Typekit)', 'noor' ),
		),
		'',
	);

	$customizer_array['settings'][] = array( 'dima_logo_font_list', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_logo_font_list',
		'dima_typography',
		esc_html__( 'Font Family', 'noor' ),
		'dima_customizer_section_typography_logo',
		'',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_logo_weights_list', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_logo_weights_list',
		'multi_check',
		esc_html__( 'Font Variants', 'noor' ),
		'dima_customizer_section_typography_logo',
		$list_all_font_weights,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_logo_weight_selected', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_logo_weight_selected',
		'select',
		esc_html__( 'Font Weights', 'noor' ),
		'dima_customizer_section_typography_logo',
		$list_all_font_weight_selected,
		esc_html__( 'Important: Not all fonts support every font-weight.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_logo_text_size', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_logo_text_size',
		'text',
		esc_html__( 'Font Size', 'noor' ),
		'dima_customizer_section_typography_logo',
		esc_html__( 'You can add: px-rem-em-%, leave empty and it will apply px', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_logo_letter_spacing', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_logo_letter_spacing',
		'text',
		esc_html__( 'Letter Spacing', 'noor' ),
		'dima_customizer_section_typography_logo',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_logo_text_color', 'refresh', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_logo_text_color',
		'color',
		esc_html__( 'Logo Text Color', 'noor' ),
		'dima_customizer_section_typography_logo',
		'',
	);

	/*--!logo--*/

	/*Button typo*/

	$customizer_array['settings'][] = array( 'dima_btn_font_source', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_btn_font_source',
		'select',
		esc_html__( 'Source', 'noor' ),
		'dima_customizer_section_typography_button',
		array(
			''        => esc_html__( 'Theme Defaults', 'noor' ),
			'g_fonts' => esc_html__( 'Google Fonts', 'noor' ),
			's_fonts' => esc_html__( 'Standard Fonts', 'noor' ),
			'f_fonts' => esc_html__( 'FontFace.me', 'noor' ),
			'c_fonts' => esc_html__( 'Custom Fonts (e.g. Typekit)', 'noor' ),
		),
		'',
	);

	$customizer_array['settings'][] = array( 'dima_btn_font_list', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_btn_font_list',
		'dima_typography',
		esc_html__( 'Font Family', 'noor' ),
		'dima_customizer_section_typography_button',
		'',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_btn_weights_list', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_btn_weights_list',
		'multi_check',
		esc_html__( 'Font Variants', 'noor' ),
		'dima_customizer_section_typography_button',
		$list_all_font_weights,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_btn_weight_selected', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_btn_weight_selected',
		'select',
		esc_html__( 'Font Weights', 'noor' ),
		'dima_customizer_section_typography_button',
		$list_all_font_weight_selected,
		esc_html__( 'Important: Not all fonts support every font-weight.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_btn_text_size', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_btn_text_size',
		'text',
		esc_html__( 'Font Size', 'noor' ),
		'dima_customizer_section_typography_button',
		esc_html__( 'You can add: px-rem-em-%, leave empty and it will apply px', 'noor' ),
	);
	/*--Search Archives--*/

	$customizer_array['settings'][] = array( 'dima_search_advanced', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_search_advanced',
		'radio_button_set',
		esc_html__( 'Advanced Search', 'noor' ),
		'dima_customizer_section_search_archives',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_search_activated_on', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_search_activated_on',
		'multi_check',
		esc_html__( 'Search Tabs', 'noor' ),
		'dima_customizer_section_search_archives',
		array(
			'all'       => esc_html__( 'All', 'noor' ),
			'blog'      => esc_html__( 'blog', 'noor' ),
			'edd'       => esc_html__( 'Digital Product', 'noor' ),
			'portfolio' => esc_html__( 'Portfolio', 'noor' ),
		),
		'',
	);

	$customizer_array['settings'][] = array( 'dima_search_default_type', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_search_default_type',
		'radio',
		esc_html__( 'Default Search is:', 'noor' ),
		'dima_customizer_section_search_archives',
		array(
			'all'            => esc_html__( 'All', 'noor' ),
			'post'           => esc_html__( 'blog', 'noor' ),
			'download'       => esc_html__( 'Digital Product', 'noor' ),
			'dima-portfolio' => esc_html__( 'Portfolio', 'noor' ),
			'product'        => esc_html__( 'Woo Product', 'noor' ),
		),
		'',
	);

	/*-- !Search Archives--*/

	$customizer_array['settings'][] = array( 'dima_blog_style', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_blog_style',
		'radio-image',
		esc_html__( 'Posts Style', 'noor' ),
		'dima_customizer_section_blog',
		$Choices_of_blog_styles,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_blog_layout', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_blog_layout',
		'radio-image',
		esc_html__( 'Content Layout', 'noor' ),
		'dima_customizer_section_blog',
		$Choices_of_section_layouts,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_blog_masonry_columns', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_blog_masonry_columns',
		'radio',
		esc_html__( 'Columns', 'noor' ),
		'dima_customizer_section_blog',
		$Choices_masonry_columns,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_single_blog_layout', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_single_blog_layout',
		'radio-image',
		esc_html__( 'Content Layout', 'noor' ),
		'dima_customizer_section_single_post',
		$Choices_of_section_layouts,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_blog_comments_style', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_blog_comments_style',
		'radio_button_set',
		esc_html__( 'Comments Style', 'noor' ),
		'dima_customizer_section_single_post',
		$Choices_comments_style,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_blog_enable_full_post_index', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_blog_enable_full_post_index',
		'radio_button_set',
		esc_html__( 'Full Post Content on Index', 'noor' ),
		'dima_customizer_section_blog',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_blog_blog_excerpt', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_blog_blog_excerpt',
		'text',
		esc_html__( 'Excerpt Limit', 'noor' ),
		'dima_customizer_section_blog',
		esc_html__( 'Displayed Post Excerpt', 'noor' ),
		'',
	);

	$customizer_array['settings'][] = array( 'dima_blog_enable_post_meta', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_blog_enable_post_meta',
		'radio_button_set',
		esc_html__( 'Display Post Meta', 'noor' ),
		'dima_customizer_section_blog',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_blog_enable_post_meta_comment', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_blog_enable_post_meta_comment',
		'radio_button_set',
		esc_html__( 'Display Comment Number', 'noor' ),
		'dima_customizer_section_blog',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_blog_enable_post_meta_date', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_blog_enable_post_meta_date',
		'radio_button_set',
		esc_html__( 'Display Post Date', 'noor' ),
		'dima_customizer_section_blog',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_blog_enable_post_meta_cat', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_blog_enable_post_meta_cat',
		'radio_button_set',
		esc_html__( 'Display Categories Meta', 'noor' ),
		'dima_customizer_section_blog',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_blog_enable_post_meta_author', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_blog_enable_post_meta_author',
		'radio_button_set',
		esc_html__( 'Display Author Name', 'noor' ),
		'dima_customizer_section_blog',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_blog_enable_featured_image', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_blog_enable_featured_image',
		'radio_button_set',
		esc_html__( 'Featured Image', 'noor' ),
		'dima_customizer_section_blog',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_elm_hover', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_elm_hover',
		'radio',
		esc_html__( 'Blog Element Hover Effects ', 'noor' ),
		'dima_customizer_section_blog',
		$Choices_element_hover,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_img_hover', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_img_hover',
		'radio',
		esc_html__( 'Blog Image Hover Effects ', 'noor' ),
		'dima_customizer_section_blog',
		$Choices_image_hover,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_second_title_on_post', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_second_title_on_post',
		'radio_button_set',
		esc_html__( 'Second Title', 'noor' ),
		'dima_customizer_section_single_post',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_pagination_post', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_pagination_post',
		'radio_button_set',
		esc_html__( 'Display Previous/Next Pagination ', 'noor' ),
		'dima_customizer_section_single_post',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_shear_icons_post', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_shear_icons_post',
		'radio_button_set',
		esc_html__( 'Display Social Share Icons', 'noor' ),
		'dima_customizer_section_single_post',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_author_post', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_author_post',
		'radio_button_set',
		esc_html__( 'Display Author Box', 'noor' ),
		'dima_customizer_section_single_post',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_post_related_display', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_post_related_display',
		'radio_button_set',
		esc_html__( 'Display Related Posts', 'noor' ),
		'dima_customizer_section_related_posts',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_post_related_is_slide', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_post_related_is_slide',
		'radio_button_set',
		esc_html__( 'Related Posts Is Slide', 'noor' ),
		'dima_customizer_section_related_posts',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_post_related_columns', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_post_related_columns',
		'radio',
		esc_html__( 'Related Posts Columns', 'noor' ),
		'dima_customizer_section_related_posts',
		$Choices_masonry_columns,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_post_related_count', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_post_related_count',
		'text',
		esc_html__( 'Related Posts Count', 'noor' ),
		'dima_customizer_section_related_posts',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_pagination_bg_color', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_pagination_bg_color',
		'color',
		esc_html__( 'Pagination background color', 'noor' ),
		'dima_customizer_section_single_post',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_blog_page', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_blog_page',
		'dropdown-pages',
		esc_html__( 'Blog Page', 'noor' ),
		'dima_customizer_section_single_post',
		esc_html__( 'Select the blog page name which will be used as main blog page', 'noor' ),
		true,
	);
	/*--!BLOG--*/

	/*--Sidebar*/

	$customizer_array['settings'][] = array( 'dima_sidebar_widget_header_size', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_sidebar_widget_header_size',
		'text',
		esc_html__( 'Header text size', 'noor' ),
		'dima_customizer_section_typography_sidebar',
		esc_html__( 'You can add: px-rem-em-%, leave empty and it will apply px', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_sidebar_widget_header_uppercase', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_sidebar_widget_header_uppercase',
		'font_style',
		esc_html__( 'Header Font Style', 'noor' ),
		'dima_customizer_section_typography_sidebar',
		$Choices_font_style,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_sidebar_widget_body_size', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_sidebar_widget_body_size',
		'text',
		esc_html__( 'Widget Body/Link Text Size', 'noor' ),
		'dima_customizer_section_typography_sidebar',
		esc_html__( 'You can add: px-rem-em-%, leave empty and it will apply px', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_sidebar_widget_body_uppercase', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_sidebar_widget_body_uppercase',
		'font_style',
		esc_html__( 'Widget Body/Link Font Style', 'noor' ),
		'dima_customizer_section_typography_sidebar',
		$Choices_font_style,
		'',
	);

	/*--!Sidebar*/

	/*--!Woo*/

	$customizer_array['settings'][] = array( 'dima_shop_menu', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_shop_menu',
		'radio_button_set',
		esc_html__( 'Cart', 'noor' ),
		'dima_customizer_section_wc_menu',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_shop_sub_menu', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_shop_sub_menu',
		'radio_button_set',
		esc_html__( 'Cart Dropdown', 'noor' ),
		'dima_customizer_section_wc_menu',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_navbar_option_myaccount_display_topbar', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_navbar_option_myaccount_display_topbar',
		'radio_button_set',
		esc_html__( 'My Account', 'noor' ),
		'dima_customizer_section_wc_menu',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_navbar_option_wishlist', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_navbar_option_wishlist',
		'radio_button_set',
		esc_html__( 'Wishlist', 'noor' ),
		'dima_customizer_section_wc_menu',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_shop_layout', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_shop_layout',
		'radio-image',
		esc_html__( 'Shop Layout', 'noor' ),
		'dima_customizer_section_wc_shop',
		$Choices_of_content_shop_layouts,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_shop_columns', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_shop_columns',
		'radio_button_set',
		esc_html__( 'Shop Columns', 'noor' ),
		'dima_customizer_section_wc_shop',
		array(
			2 => esc_html__( 'Two', 'noor' ),
			3 => esc_html__( 'Three', 'noor' ),
			4 => esc_html__( 'Four', 'noor' ),
			5 => esc_html__( 'Five', 'noor' ),
			6 => esc_html__( 'Six', 'noor' ),
		),
		'',
	);

	$customizer_array['settings'][] = array( 'dima_shop_posts_per_page', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_shop_posts_per_page',
		'text',
		esc_html__( 'Product Per Page', 'noor' ),
		'dima_customizer_section_wc_shop',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_shop_elm_hover', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_shop_elm_hover',
		'radio_button_set',
		esc_html__( 'Shop Element Hover Effects', 'noor' ),
		'dima_customizer_section_wc_shop',
		$Choices_element_hover,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_shop_sort', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_shop_sort',
		'radio_button_set',
		esc_html__( 'Noor Sort', 'noor' ),
		'dima_customizer_section_wc_shop',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_shop_quick_view', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_shop_quick_view',
		'radio_button_set',
		esc_html__( 'Quick View?', 'noor' ),
		'dima_customizer_section_wc_shop',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_shop_product_layout', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_shop_product_layout',
		'radio_button_set',
		esc_html__( 'Product Layout', 'noor' ),
		'dima_customizer_section_wc_shop',
		$Choices_shop_product_layout,
		'',
	);

	// Single
	$customizer_array['settings'][] = array( 'dima_product_layout', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_product_layout',
		'radio-image',
		esc_html__( 'Shop Layout', 'noor' ),
		'dima_customizer_section_wc_sp',
		$Choices_of_content_shop_layouts,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_product_gallery_style', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_product_gallery_style',
		'radio_button_set',
		esc_html__( 'Single Product Gallery Type', 'noor' ),
		'dima_customizer_section_wc_sp',
		array(
			'classic'        => esc_html__( 'Bottom Thumbnails', 'noor' ),
			'product_sticky' => esc_html__( 'Sticky Description', 'noor' ),
		),
		'',
	);

	$customizer_array['settings'][] = array( 'dima_shop_product_nav', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_shop_product_nav',
		'radio_button_set',
		esc_html__( 'Product Nav', 'noor' ),
		'dima_customizer_section_wc_sp',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_shop_shear_icons', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_shop_shear_icons',
		'radio_button_set',
		esc_html__( 'Share Buttons', 'noor' ),
		'dima_customizer_section_wc_sp',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_shop_product_tap_display', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_shop_product_tap_display',
		'radio_button_set',
		esc_html__( 'Product Tabs', 'noor' ),
		'dima_customizer_section_wc_sp',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_shop_description_tap_display', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_shop_description_tap_display',
		'radio_button_set',
		esc_html__( 'Description Tab', 'noor' ),
		'dima_customizer_section_wc_sp',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_shop_info_tap_display', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_shop_info_tap_display',
		'radio_button_set',
		esc_html__( 'Additional Information Tab', 'noor' ),
		'dima_customizer_section_wc_sp',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_shop_reviews_tap_display', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_shop_reviews_tap_display',
		'radio_button_set',
		esc_html__( 'Reviews Tab', 'noor' ),
		'dima_customizer_section_wc_sp',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_shop_slide_animation', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_shop_slide_animation',
		'radio_button_set',
		esc_html__( 'Slide Animation Type', 'noor' ),
		'dima_customizer_section_wc_sp',
		$Choices_slide_animation,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_shop_related_products_display', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_shop_related_products_display',
		'radio_button_set',
		esc_html__( 'Related Products', 'noor' ),
		'dima_customizer_section_wc_sp',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_shop_related_product_columns', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_shop_related_product_columns',
		'radio_button_set',
		esc_html__( 'Related Product Columns', 'noor' ),
		'dima_customizer_section_wc_sp',
		$Choices_masonry_columns,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_shop_related_product_count', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_shop_related_product_count',
		'text',
		esc_html__( 'Related Product Post Count', 'noor' ),
		'dima_customizer_section_wc_sp',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_shop_upsells_display', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_shop_upsells_display',
		'radio_button_set',
		esc_html__( 'Upsells', 'noor' ),
		'dima_customizer_section_wc_sp',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_shop_upsells_columns', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_shop_upsells_columns',
		'radio_button_set',
		esc_html__( 'Upsell Columns', 'noor' ),
		'dima_customizer_section_wc_sp',
		$Choices_masonry_columns,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_shop_upsells_count', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_shop_upsells_count',
		'text',
		esc_html__( 'Upsell Post Count', 'noor' ),
		'dima_customizer_section_wc_sp',
		'',
	);
	// cart
	$customizer_array['settings'][] = array( 'dima_shop_cart_display', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_shop_cart_display',
		'radio_button_set',
		esc_html__( 'Cross Sells', 'noor' ),
		'dima_customizer_section_wc_sp',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_shop_cart_columns', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_shop_cart_columns',
		'radio_button_set',
		esc_html__( 'Cross Sells Columns', 'noor' ),
		'dima_customizer_section_wc_sp',
		$Choices_masonry_columns,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_shop_cart_count', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_shop_cart_count',
		'text',
		esc_html__( 'Cross Sells Post Count', 'noor' ),
		'dima_customizer_section_wc_sp',
		'',
	);
	/*--!Woo*/

	/*--EDD*/
	$customizer_array['settings'][] = array( 'dima_edd_menu', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_edd_menu',
		'radio_button_set',
		esc_html__( 'Cart', 'noor' ),
		'dima_customizer_section_edd',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_edd_product_layout', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_edd_product_layout',
		'radio-image',
		esc_html__( 'EDD Layout', 'noor' ),
		'dima_customizer_section_edd',
		$Choices_of_content_shop_layouts,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_edd_details_pagination', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_edd_details_pagination',
		'radio_button_set',
		esc_html__( 'Inside pagination', 'noor' ),
		'dima_customizer_section_edd',
		$Choices_on_off,
		'',
	);

	/*--!EDD*/

	/*Widgetbar*/

	/*!Widgetbar*/

	/*Footer*/

	$customizer_array['settings'][] = array( 'dima_footer_full_width', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_footer_full_width',
		'radio_button_set',
		esc_html__( 'Full Width', 'noor' ),
		'dima_customizer_section_footer',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_footer_parallax', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_footer_parallax',
		'radio_button_set',
		esc_html__( 'Footer Parallax', 'noor' ),
		'dima_customizer_section_footer',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_footer_bottom', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_footer_bottom',
		'radio_button_set',
		esc_html__( 'Small Footer', 'noor' ),
		'dima_customizer_section_copyright',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_footer_bottom_center', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_footer_bottom_center',
		'radio_button_set',
		esc_html__( 'Footer In Center', 'noor' ),
		'dima_customizer_section_copyright',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_footer_menu_display', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_footer_menu_display',
		'radio_button_set',
		esc_html__( 'Footer Menu', 'noor' ),
		'dima_customizer_section_copyright',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_footer_content_body_color', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_footer_content_body_color',
		'color',
		esc_html__( 'Font Color', 'noor' ),
		'dima_customizer_section_typography_small_footer',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_footer_content_link_color', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_footer_content_link_color',
		'color',
		esc_html__( 'Link Color', 'noor' ),
		'dima_customizer_section_typography_small_footer',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_footer_content_display', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_footer_content_display',
		'radio_button_set',
		esc_html__( 'Copyright Info on footer', 'noor' ),
		'dima_customizer_section_copyright',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_footer_content_text', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_footer_content_text',
		'textarea',
		esc_html__( 'Copyright Content', 'noor' ),
		'dima_customizer_section_copyright',
		'',
	);

	/*--featured areas--*/
	$customizer_array['settings'][] = array( 'dima_footer_featured_area', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_footer_featured_area',
		'radio_button_set',
		esc_html__( 'Featured Area', 'noor' ),
		'dima_customizer_section_featured',
		$Choices_on_off,
		'',
	);
	$customizer_array['settings'][] = array( 'dima_footer_featured_top_bg', 'refresh', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_footer_featured_top_bg',
		'color-alpha',
		esc_html__( 'Background Color', 'noor' ),
		'dima_customizer_section_featured',
		'',
	);
	$customizer_array['settings'][] = array( 'dima_footer_featured_border_color', 'refresh', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_footer_featured_border_color',
		'color-alpha',
		esc_html__( 'Border Color', 'noor' ),
		'dima_customizer_section_featured',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_footer_featured_bg_image', 'refresh', 'dima_validate_image' );
	$customizer_array['controls'][] = array(
		'dima_footer_featured_bg_image',
		'image',
		esc_html__( 'Background Image', 'noor' ),
		'dima_customizer_section_featured',
		'',
	);

	/*--featured areas--*/

	$customizer_array['settings'][] = array( 'dima_footer_is_dark', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_footer_is_dark',
		'radio_button_set',
		esc_html__( 'Footer Is dark', 'noor' ),
		'dima_customizer_section_footer',
		$Choices_on_off,
		esc_html__( 'Enabling this option will affect the color scheme of the inputs, dropdown and tags in your footer’s widgets (To change the title, text, link and border colors of your widgets you can find the settings in Footer > Widgets) .', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_footer_content_top_bg', 'refresh', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_footer_content_top_bg',
		'color-alpha',
		esc_html__( 'Footer Background Color', 'noor' ),
		'dima_customizer_section_footer',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_footer_bg_image', 'refresh', 'dima_validate_image' );
	$customizer_array['controls'][] = array(
		'dima_footer_bg_image',
		'image',
		esc_html__( 'Footer Background Image', 'noor' ),
		'dima_customizer_section_footer',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_footer_go_to_top', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_footer_go_to_top',
		'radio_button_set',
		esc_html__( 'Back To The Top Arrow', 'noor' ),
		'dima_customizer_section_footer',
		$Choices_on_off,
		'',
	);

	/*widget*/
	$customizer_array['settings'][] = array( 'dima_footer_big', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_footer_big',
		'radio_button_set',
		esc_html__( 'Footer Area ( Widgets Area )', 'noor' ),
		'dima_customizer_section_footer_widget',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_footer_widget_areas', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_footer_widget_areas',
		'radio-image',
		esc_html__( 'Footer Widget Areas', 'noor' ),
		'dima_customizer_section_footer_widget',
		array(
			'footer-1c'             => '',
			'footer-2c'             => '',
			'footer-2c-narrow-wide' => '',
			'footer-2c-wide-narrow' => '',
			'footer-3c'             => '',
			'footer-3c-wide-left'   => '',
			'footer-3c-wide-right'  => '',
			'footer-4c'             => '',
		),
		'',
	);

	$customizer_array['settings'][] = array( 'dima_second_footer_on_off', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_second_footer_on_off',
		'radio_button_set',
		esc_html__( 'Second Footer Area ( Widgets Area )', 'noor' ),
		'dima_customizer_section_footer_widget',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_second_footer_widget_areas', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_second_footer_widget_areas',
		'radio-image',
		esc_html__( 'Second Footer Widget Areas', 'noor' ),
		'dima_customizer_section_footer_widget',
		array(
			'footer-1c'             => '',
			'footer-2c'             => '',
			'footer-2c-narrow-wide' => '',
			'footer-2c-wide-narrow' => '',
			'footer-3c'             => '',
			'footer-3c-wide-left'   => '',
			'footer-3c-wide-right'  => '',
			'footer-4c'             => '',
		),
		'',
	);

	$customizer_array['settings'][] = array( 'dima_footer_widget_header_size', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_footer_widget_header_size',
		'text',
		esc_html__( 'Widget Header Font Size', 'noor' ),
		'dima_customizer_section_typography_footer',
		esc_html__( 'You can add: px-rem-em-%, leave empty and it will apply px', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_footer_widget_header_uppercase', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_footer_widget_header_uppercase',
		'font_style',
		esc_html__( 'Widget Header Font Style', 'noor' ),
		'dima_customizer_section_typography_footer',
		$Choices_font_style,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_footer_widget_body_size', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_footer_widget_body_size',
		'text',
		esc_html__( 'Widget Body/Link Font Size', 'noor' ),
		'dima_customizer_section_typography_footer',
		esc_html__( 'You can add: px-rem-em-%, leave empty and it will apply px', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_footer_widget_body_uppercase', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_footer_widget_body_uppercase',
		'font_style',
		esc_html__( 'Widget Body/Link Font Style', 'noor' ),
		'dima_customizer_section_typography_footer',
		$Choices_font_style,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_footer_widget_header_color', 'postMessage', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_footer_widget_header_color',
		'color',
		esc_html__( 'Widget Header Color', 'noor' ),
		'dima_customizer_section_typography_footer',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_footer_widget_body_color', 'postMessage', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_footer_widget_body_color',
		'color',
		esc_html__( 'Widget Text Color', 'noor' ),
		'dima_customizer_section_typography_footer',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_footer_widget_link_color', 'postMessage', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_footer_widget_link_color',
		'color',
		esc_html__( 'Widget Link Color', 'noor' ),
		'dima_customizer_section_typography_footer',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_footer_widget_link_hover_color', 'postMessage', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_footer_widget_link_hover_color',
		'color',
		esc_html__( 'Widget Hover Link Color', 'noor' ),
		'dima_customizer_section_typography_footer',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_footer_widget_border_color', 'refresh', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_footer_widget_border_color',
		'color',
		esc_html__( 'Widget Border Color', 'noor' ),
		'dima_customizer_section_footer_widget',
		'',
	);

	if ( ! dima_helper::dima_wp_version_check( '4.7' ) ) {
		$customizer_array['settings'][] = array( 'dima_custom_style', 'refresh', 'dima_return_false' );
		$customizer_array['controls'][] = array(
			'dima_custom_style',
			'textarea',
			esc_html__( 'CSS', 'noor' ),
			'dima_customizer_section_custom',
			'',
		);
	}

	if ( DIMA_AMP_IS_ACTIVE ) {

		$customizer_array['settings'][] = array( 'dima_amp_enable', 'refresh', 'dima_validate_radio' );
		$customizer_array['controls'][] = array(
			'dima_amp_enable',
			'radio_button_set',
			esc_html__( 'Enable AMP', 'noor' ),
			'dima_customizer_section_amp',
			$Choices_on_off,
			'',
		);

		$customizer_array['settings'][] = array( 'dima_amp_logo', 'refresh', 'dima_return_false' );
		$customizer_array['controls'][] = array(
			'dima_amp_logo',
			'image',
			esc_html__( 'Upload Your AMP Logo', 'noor' ),
			'dima_customizer_section_amp',
			'',
		);
		$customizer_array['settings'][] = array( 'dima_amp_logo_width', 'refresh', 'dima_return_false' );
		$customizer_array['controls'][] = array(
			'dima_amp_logo_width',
			'text',
			esc_html__( 'Logo Width (px)', 'noor' ),
			'dima_customizer_section_amp',
			'',
		);

		$customizer_array['settings'][] = array( 'dima_amp_facebook_id', 'refresh', 'dima_validate_textarea' );
		$customizer_array['controls'][] = array(
			'dima_amp_facebook_id',
			'text',
			esc_html__( 'Facebook App ID', 'noor' ),
			'dima_customizer_section_amp',
			'',
		);

		$customizer_array['settings'][] = array( 'dima_amp_leave_a_comment', 'refresh', 'dima_validate_textarea' );
		$customizer_array['controls'][] = array(
			'dima_amp_leave_a_comment',
			'text',
			esc_html__( 'Leave a Comment ( Translate )', 'noor' ),
			'dima_customizer_section_amp',
			'',
		);

		$customizer_array['settings'][] = array( 'dima_amp_check_also', 'refresh', 'dima_validate_textarea' );
		$customizer_array['controls'][] = array(
			'dima_amp_check_also',
			'text',
			esc_html__( 'Check Also ( Translate )', 'noor' ),
			'dima_customizer_section_amp',
			'',
		);

		$customizer_array['settings'][] = array( 'dima_amp_categories', 'refresh', 'dima_validate_textarea' );
		$customizer_array['controls'][] = array(
			'dima_amp_categories',
			'text',
			esc_html__( 'Categories ( Translate )', 'noor' ),
			'dima_customizer_section_amp',
			'',
		);

		$customizer_array['settings'][] = array( 'dima_amp_ago', 'refresh', 'dima_validate_textarea' );
		$customizer_array['controls'][] = array(
			'dima_amp_ago',
			'text',
			esc_html__( 'Ago ( Translate )', 'noor' ),
			'dima_customizer_section_amp',
			'',
		);

		$customizer_array['settings'][] = array( 'dima_amp_tags', 'refresh', 'dima_validate_textarea' );
		$customizer_array['controls'][] = array(
			'dima_amp_tags',
			'text',
			esc_html__( 'Tags ( Translate )', 'noor' ),
			'dima_customizer_section_amp',
			'',
		);

		$customizer_array['settings'][] = array( 'dima_amp_related_posts', 'refresh', 'dima_validate_radio' );
		$customizer_array['controls'][] = array(
			'dima_amp_related_posts',
			'radio_button_set',
			esc_html__( 'Related Posts', 'noor' ),
			'dima_customizer_section_amp',
			$Choices_on_off,
			'',
		);
		$customizer_array['settings'][] = array( 'dima_amp_share_buttons', 'refresh', 'dima_validate_radio' );
		$customizer_array['controls'][] = array(
			'dima_amp_share_buttons',
			'radio_button_set',
			esc_html__( 'Share Buttons', 'noor' ),
			'dima_customizer_section_amp',
			$Choices_on_off,
			'',
		);

		$customizer_array['settings'][] = array( 'dima_amp_back_to_top', 'refresh', 'dima_validate_radio' );
		$customizer_array['controls'][] = array(
			'dima_amp_back_to_top',
			'radio_button_set',
			esc_html__( 'Back to top button', 'noor' ),
			'dima_customizer_section_amp',
			$Choices_on_off,
			'',
		);
		$customizer_array['settings'][] = array( 'dima_amp_footer_logo', 'refresh', 'dima_return_false' );
		$customizer_array['controls'][] = array(
			'dima_amp_footer_logo',
			'image',
			esc_html__( 'Footer Logo Image', 'noor' ),
			'dima_customizer_section_amp',
			'',
		);

		$customizer_array['settings'][] = array( 'dima_amp_footer_menu', 'refresh', 'dima_return_false' );
		$customizer_array['controls'][] = array(
			'dima_amp_footer_menu',
			'select',
			esc_html__( 'Footer Menu', 'noor' ),
			'dima_customizer_section_amp',
			dima_helper::dima_get_menus_list_options(),
			'',
		);

		$customizer_array['settings'][] = array( 'dima_amp_footer_content_text', 'refresh', 'dima_return_false' );
		$customizer_array['controls'][] = array(
			'dima_amp_footer_content_text',
			'textarea',
			esc_html__( 'Copyright Text', 'noor' ),
			'dima_customizer_section_amp',
			'',
		);

		$customizer_array['settings'][] = array( 'dima_amp_ad_abover', 'refresh', 'dima_return_false' );
		$customizer_array['controls'][] = array(
			'dima_amp_ad_abover',
			'textarea',
			esc_html__( 'Advertisement Above Content', 'noor' ),
			'dima_customizer_section_amp',
			sprintf( wp_kses_post( __( 'Enter your Ad code, AMP pages support &lt;amp-ad&gt; tag only, <a href="%s" target="_blank">Click Here</a> For More info.', 'noor' ) ), 'https://www.ampproject.org/docs/reference/extended/amp-ad.html' ),
		);
		$customizer_array['settings'][] = array( 'dima_amp_ad_below', 'refresh', 'dima_return_false' );
		$customizer_array['controls'][] = array(
			'dima_amp_ad_below',
			'textarea',
			esc_html__( 'Advertisement Below Content', 'noor' ),
			'dima_customizer_section_amp',
			sprintf( wp_kses_post( __( 'Enter your Ad code, AMP pages support &lt;amp-ad&gt; tag only, <a href="%s" target="_blank">Click Here</a> For More info.', 'noor' ) ), 'https://www.ampproject.org/docs/reference/extended/amp-ad.html' ),
		);

		$customizer_array['settings'][] = array( 'dima_amp_bg_color', 'refresh', 'dima_validate_color' );
		$customizer_array['controls'][] = array(
			'dima_amp_bg_color',
			'color-alpha',
			esc_html__( 'Background Color', 'noor' ),
			'dima_customizer_section_amp',
			'',
		);

		$customizer_array['settings'][] = array( 'dima_amp_header_bg_color', 'refresh', 'dima_validate_color' );
		$customizer_array['controls'][] = array(
			'dima_amp_header_bg_color',
			'color-alpha',
			esc_html__( 'Header Background Color', 'noor' ),
			'dima_customizer_section_amp',
			'',
		);

		$customizer_array['settings'][] = array( 'dima_amp_title_color', 'refresh', 'dima_validate_color' );
		$customizer_array['controls'][] = array(
			'dima_amp_title_color',
			'color-alpha',
			esc_html__( 'Title Color', 'noor' ),
			'dima_customizer_section_amp',
			'',
		);

		$customizer_array['settings'][] = array( 'dima_amp_link_color', 'refresh', 'dima_validate_color' );
		$customizer_array['controls'][] = array(
			'dima_amp_link_color',
			'color-alpha',
			esc_html__( 'Links color', 'noor' ),
			'dima_customizer_section_amp',
			'',
		);

		$customizer_array['settings'][] = array( 'dima_amp_footer_bg_color', 'refresh', 'dima_validate_color' );
		$customizer_array['controls'][] = array(
			'dima_amp_footer_bg_color',
			'color-alpha',
			esc_html__( 'Footer color', 'noor' ),
			'dima_customizer_section_amp',
			'',
		);
		$customizer_array['settings'][] = array( 'dima_amp_footer_border_color', 'refresh', 'dima_validate_color' );
		$customizer_array['controls'][] = array(
			'dima_amp_footer_border_color',
			'color-alpha',
			esc_html__( 'Footer border color', 'noor' ),
			'dima_customizer_section_amp',
			'',
		);

	}
	/**  AMP */

	/*Ad*/

	$customizer_array['settings'][] = array( 'dima_ad_blocker_detector', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_ad_blocker_detector',
		'radio_button_set',
		esc_html__( 'Ad Blocker Detector', 'noor' ),
		'dima_customizer_section_ad',
		$Choices_on_off,
		'',
	);

	// ----------------1
	$customizer_array['settings'][] = array( 'dima_ad_above_article', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_ad_above_article',
		'radio_button_set',
		esc_html__( 'Above Article Ad', 'noor' ),
		'dima_customizer_section_ad',
		$Choices_on_off,
		'',
	);
	$customizer_array['settings'][] = array( 'dima_ad_above_article_custom_code', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_ad_above_article_custom_code',
		'textarea',
		esc_html__( 'Custom Ad Code -Above-', 'noor' ),
		'dima_customizer_section_ad',
		esc_html__( 'Supports: Text, HTML and Shortcodes', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_ad_below_article', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_ad_below_article',
		'radio_button_set',
		esc_html__( 'Below Article Ad', 'noor' ),
		'dima_customizer_section_ad',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_ad_below_article_custom_code', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_ad_below_article_custom_code',
		'textarea',
		esc_html__( 'Custom Ad Code -Below-', 'noor' ),
		'dima_customizer_section_ad',
		esc_html__( 'Supports: Text, HTML and Shortcodes', 'noor' ),
	);

	// ----------------3
	$customizer_array['settings'][] = array( 'dima_ad1_shortcode', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_ad1_shortcode',
		'textarea',
		esc_html__( '[ads1] Ad Shortcode', 'noor' ),
		'dima_customizer_section_ad',
		esc_html__( 'Supports: Text, HTML and Shortcodes', 'noor' ),
	);
	// ----------------3
	$customizer_array['settings'][] = array( 'dima_ad2_shortcode', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_ad2_shortcode',
		'textarea',
		esc_html__( '[ads2] Ad Shortcode', 'noor' ),
		'dima_customizer_section_ad',
		esc_html__( 'Supports: Text, HTML and Shortcodes', 'noor' ),
	);
	// ----------------3
	$customizer_array['settings'][] = array( 'dima_ad3_shortcode', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_ad3_shortcode',
		'textarea',
		esc_html__( '[ads3] Ad Shortcode', 'noor' ),
		'dima_customizer_section_ad',
		esc_html__( 'Supports: Text, HTML and Shortcodes', 'noor' ),
	);

	// ----------------3
	$customizer_array['settings'][] = array( 'dima_ad4_shortcode', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_ad4_shortcode',
		'textarea',
		esc_html__( '[ads4] Ad Shortcode', 'noor' ),
		'dima_customizer_section_ad',
		esc_html__( 'Supports: Text, HTML and Shortcodes', 'noor' ),
	);

	// ----------------3
	$customizer_array['settings'][] = array( 'dima_ad5_shortcode', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_ad5_shortcode',
		'textarea',
		esc_html__( '[ads5] Ad Shortcode', 'noor' ),
		'dima_customizer_section_ad',
		esc_html__( 'Supports: Text, HTML and Shortcodes', 'noor' ),
	);
	/*!Ad*/

	/*GIF*/
	$customizer_array['settings'][] = array( 'dima_disable_featured_gif', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_disable_featured_gif',
		'radio_button_set',
		esc_html__( 'Disable GIF Featured Images', 'noor' ),
		'dima_customizer_section_advanced',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_disable_lightbox', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_disable_lightbox',
		'radio_button_set',
		esc_html__( 'Lightbox', 'noor' ),
		'dima_customizer_section_advanced',
		$Choices_on_off,
		esc_html__( 'Turn on to enable the lightbox throughout the theme.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_disable_dropkick', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_disable_dropkick',
		'radio_button_set',
		esc_html__( 'Dropkick', 'noor' ),
		'dima_customizer_section_advanced',
		$Choices_on_off,
		esc_html__( 'For creating beautiful, accessible, and painless custom dropdowns.', 'noor' ),
	);

	/**
	 *  Version 2.0
	 */
	$customizer_array['settings'][] = array( 'dima_defer_async', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_defer_async',
		'radio_button_set',
		esc_html__( 'Async JavaScript Method', 'noor' ),
		'dima_customizer_section_advanced',
		array(
			'off'   => esc_html__( 'Off', 'noor' ),
			'defer' => esc_html__( 'Defer', 'noor' ),
		),
		sprintf( esc_html__( 'Please select the method (async or defer) that you wish to enable', 'noor' ), '<code>ver</code>' ),
	);

	$customizer_array['settings'][] = array( 'dima_remove_ver_params', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_remove_ver_params',
		'radio_button_set',
		esc_html__( 'Remove ver parameters', 'noor' ),
		'dima_customizer_section_advanced',
		$Choices_on_off,
		sprintf( esc_html__( 'Remove %s parameter from CSS and JS file calls. It may improve speed in some browsers which do not cache files having the parameter.', 'noor' ), '<code>ver</code>' ),
	);

	/**
	 *  Version 2.0
	 */
	$customizer_array['settings'][] = array( 'dima_optimize_wc', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_optimize_wc',
		'radio_button_set',
		esc_html__( 'Optimize WooCommerce scripts', 'noor' ),
		'dima_customizer_section_advanced',
		$Choices_on_off,
		sprintf( esc_html__( 'Load WooCommerce scripts and styles only on WooCommerce pages (WooCommerce plugin must be enabled).', 'noor' ), '<code>ver</code>' ),
	);

	/*!GIF*/

	/*GIF*/

	$customizer_array['settings'][] = array( 'dima_lazy_image', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_lazy_image',
		'radio_button_set',
		esc_html__( 'Apply Lazy Image', 'noor' ),
		'dima_customizer_section_advanced',
		$Choices_on_off,
		esc_html__( 'lazy Image mean: Images outside of viewport will not be loaded before user scrolls to them.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_lazy_plac_image', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_lazy_plac_image',
		'radio_button_set',
		esc_html__( 'Lazy Placeholder', 'noor' ),
		'dima_customizer_section_advanced',
		$Choices_on_off,
		esc_html__( 'A small image will be shown at first. For best perceived preformance , leave the option off.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_lazy_plac_ef_image', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_lazy_plac_ef_image',
		'radio_button_set',
		esc_html__( 'Lazy Placeholder Type', 'noor' ),
		'dima_customizer_section_advanced',
		array(
			'pre'   => esc_html__( 'Pre-Placeholder', 'noor' ),
			'small' => esc_html__( 'Small Images', 'noor' ),
		),
		'',
	);

	$customizer_array['settings'][] = array( 'dima_css_cache_method', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_css_cache_method',
		'radio_button_set',
		esc_html__( 'CSS Compiling method', 'noor' ),
		'dima_customizer_section_advanced',
		array(
			'file' => esc_attr__( 'File', 'noor' ),
			'db'   => esc_attr__( 'Database', 'noor' ),
			'off'  => esc_attr__( 'Disabled', 'noor' ),
		),
		esc_html__( 'Select "File" mode to compile the dynamic CSS to files (a separate file will be created for each of your pages & posts inside of the uploads/dima-styles folder), "Database" mode to cache the CSS in your database, or select "Disabled" to disable.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_cache_server_ip', 'refresh', 'dima_validate_textarea' );
	$customizer_array['controls'][] = array(
		'dima_cache_server_ip',
		'text',
		esc_html__( 'Cache Server IP', 'noor' ),
		'dima_customizer_section_advanced',
		esc_html__( 'For unique cases where you are using cloud flare and a cache server, ex: varnish cache. Enter your cache server IP to clear the theme options dynamic CSS cache. Consult with your server admin for help.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_animation_active', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_animation_active',
		'radio_button_set',
		esc_html__( 'Animation', 'noor' ),
		'dima_customizer_section_advanced',
		$Choices_on_off,
		esc_html( '“Off” means the animation effect will not be applied to the element that you have manually added an animation to it via the element settings', 'noor' ),
	);
	// Progressive Web App.
	$customizer_array['settings'][] = array( 'dima_pwa_enable', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_pwa_enable',
		'radio_button_set',
		esc_html__( 'Enable Progressive Web App', 'noor' ),
		'dima_customizer_section_advanced',
		$Choices_on_off,
		esc_html( 'Enable this option if you want to enable the Progressive Web App feature and options on your website.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_pwa_name', 'refresh', 'dima_validate_textarea' );
	$customizer_array['controls'][] = array(
		'dima_pwa_name',
		'text',
		esc_html__( 'Name', 'noor' ),
		'dima_customizer_section_advanced',
		esc_html__( 'Used in the app install prompt.', 'noor' ),
	);
	$customizer_array['settings'][] = array( 'dima_pwa_short_name', 'refresh', 'dima_validate_textarea' );
	$customizer_array['controls'][] = array(
		'dima_pwa_short_name',
		'text',
		esc_html__( 'Short name', 'noor' ),
		'dima_customizer_section_advanced',
		esc_html__( 'max 12 characters ( Used on the user\'s home screen, launcher, or other places where space may be limited. )', 'noor' ),
	);
	$customizer_array['settings'][] = array( 'dima_pwa_description', 'refresh', 'dima_validate_textarea' );
	$customizer_array['controls'][] = array(
		'dima_pwa_description',
		'text',
		esc_html__( 'Description', 'noor' ),
		'dima_customizer_section_advanced',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_pwa_filetypes_cache_first', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_pwa_filetypes_cache_first',
		'multi_check',
		esc_html__( 'Cache-First strategy file types', 'noor' ),
		'dima_customizer_section_advanced',
		array(
			'image'   => esc_html__( 'Image', 'noor' ),
			'fonts'   => esc_html__( 'Fonts', 'noor' ),
			'scripts' => esc_html__( 'Scripts', 'noor' ),
			'styles'  => esc_html__( 'Styles', 'noor' ),
		),
		esc_html( 'File types added in this list will be cached in the browser. Subsequent page requests will use the cached assets. Use this for static assets that don\'t change like images and fonts.', 'noor' ),
	);
	$customizer_array['settings'][] = array( 'dima_pwa_filetypes_network_first', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_pwa_filetypes_network_first',
		'multi_check',
		esc_html__( 'Network-First strategy file types', 'noor' ),
		'dima_customizer_section_advanced',
		array(
			'image'   => esc_html__( 'Image', 'noor' ),
			'fonts'   => esc_html__( 'Fonts', 'noor' ),
			'scripts' => esc_html__( 'Scripts', 'noor' ),
			'styles'  => esc_html__( 'Styles', 'noor' ),
		),
		esc_html( 'File types added in this list will be cached in the browser. Subsequent page requests will first try to get a more recent version of these files from the network, and fallback to the cached files in case the network is unreachable. If your site\'s content gets updated often we recommend you can use this for your content.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_pwa_filetypes_stale_while_revalidate', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_pwa_filetypes_stale_while_revalidate',
		'multi_check',
		esc_html__( 'Stale-While-Revalidating strategy file types', 'noor' ),
		'dima_customizer_section_advanced',
		array(
			'image'   => esc_html__( 'Image', 'noor' ),
			'fonts'   => esc_html__( 'Fonts', 'noor' ),
			'scripts' => esc_html__( 'Scripts', 'noor' ),
			'styles'  => esc_html__( 'Styles', 'noor' ),
		),
		esc_html( 'Any file types added here will be served with a cache-first strategy, and after the page has been loaded the caches will be updated with more recent versions of the selected file types from the network. Use this for assets that may get updated but having their latest version is not critical.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_pwa_manifest_logo', 'refresh', 'dima_validate_image' );
	$customizer_array['controls'][] = array(
		'dima_pwa_manifest_logo',
		'image',
		esc_html__( 'App Splash Screen Logo', 'noor' ),
		'dima_customizer_section_advanced',
		esc_html__( 'Logo displayed for your website at 512px x 512px when installing as an app. Logo image must be in PNG format.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_pwa_manifest_display', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_pwa_manifest_display',
		'select',
		esc_html__( 'App Display Mode', 'noor' ),
		'dima_customizer_section_advanced',
		array(
			'fullscreen' => esc_html__( 'Fullscreen', 'noor' ),
			'standalone' => esc_html__( 'Standalone', 'noor' ),
			'minimal-ui' => esc_html__( 'Minimal UI', 'noor' ),
			'browser'    => esc_html__( 'Browser', 'noor' ),
		),
		esc_html__( 'If the user installs your site as an app, select how the app will behave. For more information about these options please refer to <a href="https://developers.google.com/web/fundamentals/web-app-manifest/#display', 'noor' ),
	);
	$customizer_array['settings'][] = array( 'dima_pwa_theme_color', 'refresh', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_pwa_theme_color',
		'color-alpha',
		esc_html__( 'App Theme Color', 'noor' ),
		'dima_customizer_section_advanced',
		esc_html( 'Select a color that will be used for the header of your app, as well as the browser toolbar-color on mobile devices. The theme color should match the main theme color.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_pwa_background_color', 'refresh', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_pwa_background_color',
		'color-alpha',
		esc_html__( 'App background color', 'noor' ),
		'dima_customizer_section_advanced',
		esc_html( 'Used on the splash screen when the application is first launched.', 'noor' ),
	);

	// !PWA
	$customizer_array['settings'][] = array( 'dima_space_before_head', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_space_before_head',
		'textarea',
		esc_html__( 'Space before &lt;/head&gt;', 'noor' ),
		'dima_customizer_section_code',
		esc_html__( 'Only accepts javascript code wrapped with &lt;script&gt;  tags and HTML markup that is valid inside the &lt;head&gt;  tag.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_space_after_body', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_space_after_body',
		'textarea',
		esc_html__( 'Space After &lt;body&gt;', 'noor' ),
		'dima_customizer_section_code',
		esc_html__( 'Only accepts javascript code, wrapped with &lt;script&gt; tags and valid HTML markup inside the &lt;body&gt; tag.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_space_before_body', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_space_before_body',
		'textarea',
		esc_html__( 'Space before &lt;/body&gt;', 'noor' ),
		'dima_customizer_section_code',
		esc_html__( 'Only accepts javascript code, wrapped with &lt;script&gt; tags and valid HTML markup inside the &lt;body&gt; tag.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_google_map_api_key', 'refresh', 'dima_validate_textarea' );
	$customizer_array['controls'][] = array(
		'dima_google_map_api_key',
		'text',
		esc_html__( 'Google Map API Key', 'noor' ),
		'dima_customizer_section_code',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_custom_js', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_custom_js',
		'textarea',
		esc_html__( 'Custom JavaScript', 'noor' ),
		'dima_customizer_section_code',
		'',
	);

	/*loading*/
	$customizer_array['settings'][] = array( 'dima_loading', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_loading',
		'radio_button_set',
		esc_html__( 'Loading Screen', 'noor' ),
		'dima_customizer_section_loading',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_loading_logo', 'refresh', 'dima_validate_image' );
	$customizer_array['controls'][] = array(
		'dima_loading_logo',
		'image',
		esc_html__( 'Loading Logo', 'noor' ),
		'dima_customizer_section_loading',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_loading_bg_color', 'refresh', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_loading_bg_color',
		'color-alpha',
		esc_html__( 'Loading Background Color', 'noor' ),
		'dima_customizer_section_loading',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_loading_border_color', 'refresh', 'dima_validate_color' );
	$customizer_array['controls'][] = array(
		'dima_loading_border_color',
		'color-alpha',
		esc_html__( 'Loading Frame Color', 'noor' ),
		'dima_customizer_section_loading',
		'',
	);
	/*! loading*/

	/*social*/

	$customizer_array['settings'][] = array( 'dima_social_icons_is_colored', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_social_icons_is_colored',
		'radio_button_set',
		esc_html__( 'Use colored icons?', 'noor' ),
		'dima_customizer_section_social',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_social_facebook', 'refresh', 'dima_validate_url' );
	$customizer_array['controls'][] = array(
		'dima_social_facebook',
		'text',
		esc_html__( 'Facebook', 'noor' ),
		'dima_customizer_section_social',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_social_twitter', 'refresh', 'dima_validate_url' );
	$customizer_array['controls'][] = array(
		'dima_social_twitter',
		'text',
		esc_html__( 'Twitter', 'noor' ),
		'dima_customizer_section_social',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_social_linkedin', 'refresh', 'dima_validate_url' );
	$customizer_array['controls'][] = array(
		'dima_social_linkedin',
		'text',
		esc_html__( 'linkedin', 'noor' ),
		'dima_customizer_section_social',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_social_youtube', 'refresh', 'dima_validate_url' );
	$customizer_array['controls'][] = array(
		'dima_social_youtube',
		'text',
		esc_html__( 'Youtube', 'noor' ),
		'dima_customizer_section_social',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_social_vimeo', 'refresh', 'dima_validate_url' );
	$customizer_array['controls'][] = array(
		'dima_social_vimeo',
		'text',
		esc_html__( 'Vimeo', 'noor' ),
		'dima_customizer_section_social',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_social_foursquare', 'refresh', 'dima_validate_url' );
	$customizer_array['controls'][] = array(
		'dima_social_foursquare',
		'text',
		esc_html__( 'Foursquare', 'noor' ),
		'dima_customizer_section_social',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_social_tumblr', 'refresh', 'dima_validate_url' );
	$customizer_array['controls'][] = array(
		'dima_social_tumblr',
		'text',
		esc_html__( 'Tumblr', 'noor' ),
		'dima_customizer_section_social',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_social_instagram', 'refresh', 'dima_validate_url' );
	$customizer_array['controls'][] = array(
		'dima_social_instagram',
		'text',
		esc_html__( 'Instagram', 'noor' ),
		'dima_customizer_section_social',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_social_dribbble', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_social_dribbble',
		'text',
		esc_html__( 'Dribbble', 'noor' ),
		'dima_customizer_section_social',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_social_flickr', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_social_flickr',
		'text',
		esc_html__( 'Flickr', 'noor' ),
		'dima_customizer_section_social',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_social_behance', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_social_behance',
		'text',
		esc_html__( 'Behance', 'noor' ),
		'dima_customizer_section_social',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_social_pinterest', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_social_pinterest',
		'text',
		esc_html__( 'Pinterest', 'noor' ),
		'dima_customizer_section_social',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_social_whatsapp', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_social_whatsapp',
		'text',
		esc_html__( 'Whatsapp', 'noor' ),
		'dima_customizer_section_social',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_social_soundcloud', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_social_soundcloud',
		'text',
		esc_html__( 'Soundcloud', 'noor' ),
		'dima_customizer_section_social',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_social_rss', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_social_rss',
		'text',
		esc_html__( 'RSS', 'noor' ),
		'dima_customizer_section_social',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_social_vk', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_social_vk',
		'text',
		esc_html__( 'VK', 'noor' ),
		'dima_customizer_section_social',
		'',
	);

	/*SEO*/
	if ( ! dima_helper::dima_wp_version_check( '4.3' ) ) {

		$customizer_array['settings'][] = array( 'dima_favicon', 'refresh', 'dima_validate_image' );
		$customizer_array['controls'][] = array(
			'dima_favicon',
			'image',
			esc_html__( 'Upload Favicon', 'noor' ),
			'dima_customizer_global',
			wp_kses( __( 'There are many favicon generators available online, such as  <a href="http://www.convertico.com/" target="_blank" rel="noopener" title="Convertico">Convertico</a> and <a href="http://www.favicon.co.uk/" target="_blank" rel="noopener" title="Favicon.co.uk">Favicon.co.uk</a>.', 'noor' ), dima_helper::dima_get_allowed_html_tag() ),
		);

		$customizer_array['settings'][] = array( 'dima_iphone_icon', 'refresh', 'dima_validate_image' );
		$customizer_array['controls'][] = array(
			'dima_iphone_icon',
			'image',
			esc_html__( 'Apple iPhone Icon', 'noor' ),
			'dima_customizer_global',
			esc_html__( 'Icon for Apple iPhone (57px x 57px)', 'noor' ),
		);

		$customizer_array['settings'][] = array( 'dima_iphone_retina_icon', 'refresh', 'dima_validate_image' );
		$customizer_array['controls'][] = array(
			'dima_iphone_retina_icon',
			'image',
			esc_html__( 'Apple iPhone Retina Icon', 'noor' ),
			'dima_customizer_global',
			esc_html__( 'Icon for Apple iPhone Retina Version (120px x 120px)', 'noor' ),
		);

		$customizer_array['settings'][] = array( 'dima_ipad_icon', 'refresh', 'dima_validate_image' );
		$customizer_array['controls'][] = array(
			'dima_ipad_icon',
			'image',
			esc_html__( 'Apple iPad Icon', 'noor' ),
			'dima_customizer_global',
			esc_html__( 'Icon for Apple iPhone (72px x 72px)', 'noor' ),
		);

		$customizer_array['settings'][] = array( 'dima_ipad_retina_icon', 'refresh', 'dima_validate_image' );
		$customizer_array['controls'][] = array(
			'dima_ipad_retina_icon',
			'image',
			esc_html__( 'Apple iPad Retina Icon', 'noor' ),
			'dima_customizer_global',
			esc_html__( 'Icon for Apple iPad Retina Version (144px x 144px)', 'noor' ),
		);
	}

	$customizer_array['settings'][] = array( 'dima_seo_is_plugin', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_seo_is_plugin',
		'radio_button_set',
		esc_html__( 'I am using plugin for SEO', 'noor' ),
		'dima_customizer_global',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_open_graph_meta_tag', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_open_graph_meta_tag',
		'radio_button_set',
		esc_html__( 'Open Graph', 'noor' ),
		'dima_customizer_global',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_opengraph_image', 'refresh', 'dima_validate_image' );
	$customizer_array['controls'][] = array(
		'dima_opengraph_image',
		'image',
		esc_html__( 'Upload opengraph image', 'noor' ),
		'dima_customizer_global',
		esc_html__( 'Image URL which should represent your object within the graph.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_facebook_page_id', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_facebook_page_id',
		'text',
		esc_html__( 'Facebook Pages ID', 'noor' ),
		'dima_customizer_global',
		esc_html( 'To add by multiple IDs, enter your IDs separated by a comma.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_twitter_username', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_twitter_username',
		'text',
		esc_html__( 'Twitter Username (e.g. @pixeldima)', 'noor' ),
		'dima_customizer_global',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_twitter_account_id', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_twitter_account_id',
		'text',
		esc_html__( 'Twitter Account ID', 'noor' ),
		'dima_customizer_global',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_prefetching', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_prefetching',
		'radio_button_set',
		esc_html__( 'Prefetching', 'noor' ),
		'dima_customizer_global',
		$Choices_on_off,
		esc_html__( 'Enable or disable prefetching. If user is on homepage, then single page will load faster and if user is on single page, homepage will load faster in modern browsers.', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_structure_data', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_structure_data',
		'radio_button_set',
		esc_html__( 'Structure Data', 'noor' ),
		'dima_customizer_global',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_schema_type', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_schema_type',
		'radio',
		esc_html__( 'Default Schema type', 'noor' ),
		'dima_customizer_global',
		array(
			'NewsArticle' => esc_html__( 'NewsArticle', 'noor' ),
			'Article'     => esc_html__( 'Article', 'noor' ),
			'BlogPosting' => esc_html__( 'BlogPosting', 'noor' ),
		),
		'',
	);
	/*!SEO*/

	/* Portfolio Options */
	$customizer_array['settings'][] = array( 'dima_projects_related_display', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_projects_related_display',
		'radio_button_set',
		esc_html__( 'Display Related Projects', 'noor' ),
		'dima_customizer_related_projects',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_projects_related_style', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_projects_related_style',
		'radio_button_set',
		esc_html__( 'Related Projects Style', 'noor' ),
		'dima_customizer_related_projects',
		$Choices_related_projects_style,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_projects_related_columns', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_projects_related_columns',
		'radio',
		esc_html__( 'Related Projects Columns', 'noor' ),
		'dima_customizer_related_projects',
		$Choices_masonry_columns,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_projects_related_count', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_projects_related_count',
		'text',
		esc_html__( 'Related Projects Count', 'noor' ),
		'dima_customizer_related_projects',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_projects_related_elm_hover', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_projects_related_elm_hover',
		'radio',
		esc_html__( 'Related Projects Element Hover Effects ', 'noor' ),
		'dima_customizer_related_projects',
		$Choices_element_hover_related_projects,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_projects_related_img_hover', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_projects_related_img_hover',
		'radio',
		esc_html__( 'Related Projects Image Hover Effects ', 'noor' ),
		'dima_customizer_related_projects',
		$Choices_image_hover,
		'',
	);

	/*------------ Single portfolio ----------*/
	$customizer_array['settings'][] = array( 'dima_projects_details', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_projects_details',
		'radio_button_set',
		esc_html__( 'Portfolio Details', 'noor' ),
		'dima_customizer_single_portfolio_item',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_projects_details_style', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_projects_details_style',
		'radio_button_set',
		esc_html__( 'Portfolio Details Style', 'noor' ),
		'dima_customizer_single_portfolio_item',
		$Choices_details_style,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_projects_details_layout', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_projects_details_layout',
		'select',
		esc_html__( 'Portfolio Details Layout', 'noor' ),
		'dima_customizer_single_portfolio_item',
		$Choices_portfolio_details_layout,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_layout_projects_details_content', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_layout_projects_details_content',
		'radio-image',
		esc_html__( 'Content Layout', 'noor' ),
		'dima_customizer_single_portfolio_item',
		$Choices_of_section_layouts,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_projects_details_sidebar', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_projects_details_sidebar',
		'select',
		esc_html__( 'Portfolio Sidebar', 'noor' ),
		'dima_customizer_single_portfolio_item',
		$sidebars_name,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_projects_details_pagination', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_projects_details_pagination',
		'radio_button_set',
		esc_html__( 'Inside pagination', 'noor' ),
		'dima_customizer_single_portfolio_item',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_projects_portfolio_shear_icon_and_tag', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_projects_portfolio_shear_icon_and_tag',
		'radio_button_set',
		esc_html__( 'Share icons and Tags', 'noor' ),
		'dima_customizer_single_portfolio_item',
		$Choices_on_off,
		'',
	);

	/*------------ Portfolio page options ----------*/

	$customizer_array['settings'][] = array( 'dima_portfolio_page_columns', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_projects_related_columns',
		'radio',
		esc_html__( 'Portfolio Columns', 'noor' ),
		'dima_customizer_portfolio_page_options',
		$Choices_masonry_columns,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_portfolio_page_elm_hover', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_projects_related_elm_hover',
		'radio',
		esc_html__( 'Portfolio Element Hover Effects ', 'noor' ),
		'dima_customizer_portfolio_page_options',
		$Choices_element_hover_related_projects,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_portfolio_page_img_hover', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_projects_related_img_hover',
		'radio',
		esc_html__( 'Portfolio Image Hover Effects ', 'noor' ),
		'dima_customizer_portfolio_page_options',
		$Choices_image_hover,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_portfolio_page_filters', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_portfolio_page_filters',
		'radio_button_set',
		esc_html__( 'Filters', 'noor' ),
		'dima_customizer_portfolio_page_options',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_portfolio_page_margin', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_portfolio_page_margin',
		'radio_button_set',
		esc_html__( 'No Margin', 'noor' ),
		'dima_customizer_portfolio_page_options',
		$Choices_on_off,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_portfolio_page_count', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_portfolio_page_count',
		'text',
		esc_html__( 'Count', 'noor' ),
		'dima_customizer_portfolio_page_options',
		'',
	);

	$customizer_array['settings'][] = array( 'dima_portfolio_page_is_pagination', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_portfolio_page_is_pagination',
		'radio_button_set',
		esc_html__( 'Pagination', 'noor' ),
		'dima_customizer_portfolio_page_options',
		$Choices_on_off,
		'',
	);

	/*------------:Portfolio page options----------*/

	$customizer_array['settings'][] = array( 'dima_projects_slug_name', 'postMessage', 'dima_validate_textarea' );
	$customizer_array['controls'][] = array(
		'dima_projects_slug_name',
		'text',
		esc_html__( 'Portfolio URL Slug', 'noor' ),
		'dima_customizer_base_portfolio_options',
		esc_html__( 'This option allows you to change the portfolio slug. Set your custom slug which will be displayed instead of portfolio in portfolio URL. Please do not forget to save the permalinks in Settings -> Permalinks after changing this option', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_portfolio_page_name', 'postMessage', 'dima_validate_textarea' );
	$customizer_array['controls'][] = array(
		'dima_portfolio_page_name',
		'text',
		esc_html__( 'Portfolio page name', 'noor' ),
		'dima_customizer_base_portfolio_options',
		esc_html__( 'Set the title for your portfolio page', 'noor' ),
	);

	$customizer_array['settings'][] = array( 'dima_portfolio_top_link_source', 'refresh', 'dima_validate_radio' );
	$customizer_array['controls'][] = array(
		'dima_portfolio_top_link_source',
		'radio_button_set',
		esc_html__( 'Portfolio top link source', 'noor' ),
		'dima_customizer_base_portfolio_options',
		$Choices_link_source,
		'',
	);

	$customizer_array['settings'][] = array( 'dima_portfolio_page_url', 'refresh', 'dima_validate_textarea' );
	$customizer_array['controls'][] = array(
		'dima_portfolio_page_url',
		'text',
		esc_html__( 'Portfolio page URL', 'noor' ),
		'dima_customizer_base_portfolio_options',
		esc_html__( 'Set the portfolio page URL which will be used as main portfolio page', 'noor' ),
	);
	$customizer_array['settings'][] = array( 'dima_portfolio_page', 'refresh', 'dima_return_false' );
	$customizer_array['controls'][] = array(
		'dima_portfolio_page',
		'dropdown-pages',
		esc_html__( 'Portfolio page', 'noor' ),
		'dima_customizer_base_portfolio_options',
		'',
		true,
	);

	/* !Portfolio Options */

	if ( DIMA_BBPRESS_IS_ACTIVE ) {
		$customizer_array['settings'][] = array( 'dima_layout_bbpress_content', 'refresh', 'dima_validate_radio' );
		$customizer_array['controls'][] = array(
			'dima_layout_bbpress_content',
			'radio-image',
			esc_html__( 'Content Layout', 'noor' ),
			'dima_customizer_section_bbp',
			$Choices_of_content_layouts,
			'',
		);
	}

	if ( DIMA_BUDDYPRESS_IS_ACTIVE ) {
		$customizer_array['settings'][] = array( 'dima_layout_bp_content', 'refresh', 'dima_validate_radio' );
		$customizer_array['controls'][] = array(
			'dima_layout_bp_content',
			'radio-image',
			esc_html__( 'Content Layout', 'noor' ),
			'dima_customizer_section_bp',
			$Choices_of_content_layouts,
			'',
		);
	}
	dima_customizer_controls_list( $customizer_array, $wp_customize, $dima_customizer_data );
}

global $dima_customizer_data;


add_action( 'customize_register', 'dima_register_theme_customizer_options' );


// ----- Partials
/**
 * Undocumented function
 *
 * @param WP_Customize_Manager $wp_customize
 * @return void
 */
function dima_register_partials( WP_Customize_Manager $wp_customize ) {

	// Abort if selective refresh is not available.
	if ( ! isset( $wp_customize->selective_refresh ) ) {
		return;
	}

	/**
	 * Selective Refresh for Custom Options.
	 */
	$wp_customize->selective_refresh->add_partial(
		Dima::get_dima_option_name( 'dima_header_logo' ),
		array(
			'selector'            => '.site-title a',
			'container_inclusive' => true,
		)
	);
	// Menu.
	$wp_customize->selective_refresh->add_partial(
		Dima::get_dima_option_name( 'dima_header_search_enable' ),
		array(
			'selector' => '.dima-navbar-wrap .dima-nav',
		)
	);
	// sidebar.
	$wp_customize->selective_refresh->add_partial(
		Dima::get_dima_option_name( 'dima_pagination_bg_color' ),
		array(
			'selector' => '.dima_post_pagination',
		)
	);
	// copyright.
	$wp_customize->selective_refresh->add_partial(
		Dima::get_dima_option_name( 'dima_footer_content_text' ),
		array(
			'selector'            => '.dima-footer .copyright',
			'container_inclusive' => false,
		)
	);
	// Footer menu.
	$wp_customize->selective_refresh->add_partial(
		Dima::get_dima_option_name( 'dima_footer_menu_display' ),
		array(
			'selector' => '.dima-footer .dima-menu ',
		)
	);

}
add_action( 'customize_register', 'dima_register_partials' );
