<?php

/**
 * Custom Control .
 *
 * @package Dima Framework
 * @subpackage Admin customizer
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 */

function dima_new_custom_controls( $wp_customize ) {
	$controls_path = DIMA_TEMPLATE_PATH . '/framework/functions/admin/customizer/include/controls';

	require_once $controls_path . '/dima_custom_control_color_alpha.php';
	require_once $controls_path . '/class-control-multiple-select.php';
	require_once $controls_path . '/dima_custom_control_textarea.php';
	require_once $controls_path . '/dima_custom_control_slider.php';
	require_once $controls_path . '/dima_custom_control_radio_button_set.php';
	require_once $controls_path . '/typography/dima_custom_control_typography.php';
	require_once $controls_path . '/dima_custom_control_multi_check.php';
	require_once $controls_path . '/dima_custom_control_font_style.php';
	require_once $controls_path . '/dima_custom_control_radio-image.php';
}
add_action( 'customize_register', 'dima_new_custom_controls' );

/**
 * Using tooltips instead of option descriptions in the WordPress Theme Customizer
 */
function dima_theme_customizer_tooltips() {?>

	<script type="text/javascript">
		jQuery( document ).ready( function( $ ) {
			/**
			 * Portfolio Expend
			 */
			wp.customize.section( 'dima_customizer_base_portfolio_options', function( section ) {
				var clearPreviousUrl,previousUrl,previewUrlValue;
					previewUrlValue = wp.customize.previewer.previewUrl;
					clearPreviousUrl = function() {
						previousUrl = null;
					};
					section.expanded.bind( function( isExpanded ) {
						if ( isExpanded ) {
							url = "<?php echo esc_js( home_url( dima_helper::dima_get_option( 'dima_projects_slug_name' ) ) ); ?>";
							previousUrl = previewUrlValue.get();
							previewUrlValue.set(url);
						}else{
							previewUrlValue.unbind(clearPreviousUrl);
							if (previousUrl) {
								previewUrlValue.set(previousUrl);
							}
						}
					} );
			} );

			/**
			 * Blog Expend
			 */
			wp.customize.section("dima_customizer_section_blog", function(section) {
				var previousUrl, clearPreviousUrl, previewUrlValue;
				previewUrlValue = wp.customize.previewer.previewUrl;
				clearPreviousUrl = function() {
					previousUrl = null;
				};

				section.expanded.bind(function(isExpanded) {
					var url;
					if (isExpanded) {
						url = wp.customize.settings.url.home;
						previousUrl = previewUrlValue.get();
						previewUrlValue.set(url);
						previewUrlValue.bind(clearPreviousUrl);
					} else {
						previewUrlValue.unbind(clearPreviousUrl);
						if (previousUrl) {
							previewUrlValue.set(previousUrl);
						}
					}
				});
			});

		});

	</script>
	<?php
}
add_action( 'customize_controls_print_scripts', 'dima_theme_customizer_tooltips' );
