<?php
/**
 * Customizer Control: Dima-typography.
 *
 * @package     Noor WordPress theme
 * @subpackage  Controls
 * @since       1.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Typography control
 */
class dima_custom_control_typography extends WP_Customize_Control {


	/**
	 * The control type.
	 *
	 * @access public
	 * @var string
	 */
	public $type = 'dima_typography';

	/**
	 * Enqueue control related scripts/styles.
	 *
	 * @access public
	 */
	public function enqueue() {
		wp_enqueue_script( 'dima-select2', DIMA_TEMPLATE_URL . '/framework/asset/admin/js/chosen.jquery.min.js', array( 'jquery' ), false, true );
		wp_enqueue_style( 'select2', DIMA_TEMPLATE_URL . '/framework/asset/admin/css/chosen.min.css', null );
		wp_enqueue_script( 'dima-typography-js', DIMA_TEMPLATE_URL . '/framework/asset/admin/js/typography.min.js', array( 'jquery','dima-select2' ), false, true );
		wp_enqueue_style( 'dima_global_styles', DIMA_TEMPLATE_URL . '/framework/asset/admin/css/control_typography.min.css', array(), DIMA_VERSION, 'all' );
	}

	/**
	 * Render the control's content.
	 * Allows the content to be overriden without having to rewrite the wrapper in $this->render().
	 *
	 * @access protected
	 */
	protected function render_content() {
		$this_val = $this->value();
		?>
		<label>
			<?php if ( ! empty( $this->label ) ) : ?>
				<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
			<?php endif; ?>
			<?php if ( ! empty( $this->description ) ) : ?>
				<span class="description customize-control-description"><?php echo wp_kses_post( $this->description ); ?></span>
			<?php endif; ?>

			<select class="dima-typography-select" <?php $this->link(); ?>>
				<option value="" <?php if ( ! $this_val ) { echo 'selected="selected"'; } // phpcs:ignoreFile?>>
				- <?php esc_html_e( 'Select Font', 'noor' ); ?> -
                </option>

				<?php
				// Get custom font options.
					$font_one = dima_helper::dima_get_option('dima_custom_font_one');
					$font_two = dima_helper::dima_get_option('dima_custom_font_two');
					$font_three = dima_helper::dima_get_option('dima_custom_font_three');
					if($font_one!='' || $font_two!='' ||$font_three!=''){ ?>
						<optgroup id="c_fonts" label="<?php esc_html_e( 'Custom Fonts', 'noor' ); ?>">
							<?php if($font_one != ''){ ?>
								<option value="<?php echo esc_html( $font_one ); ?>" <?php selected( $font_one, $this_val ); ?>><?php echo esc_html( $font_one ); ?></option>
							<?php } ?>
							<?php if($font_two != ''){ ?>
								<option value="<?php echo esc_html( $font_two ); ?>" <?php selected( $font_two, $this_val ); ?>><?php echo esc_html( $font_two ); ?></option>
							<?php } ?>
							<?php if($font_three != ''){ ?>
								<option value="<?php echo esc_html( $font_three ); ?>" <?php selected( $font_three, $this_val ); ?>><?php echo esc_html( $font_three ); ?></option>
							<?php } ?>
						</optgroup>
					<?php }

				// Get Face me font options.
				if ( $f_fonts = DIMA_Webfonts::get_fontface_fonts() ) { ?>
					<optgroup id="f_fonts" label="<?php esc_html_e( 'FontFace Fonts', 'noor' ); ?>">
						<?php foreach ( $f_fonts as $font ) {?>
							<option value="<?php echo esc_html( $font['permalink'] ); ?>" <?php selected( $font['permalink'], $this_val ); ?>><?php echo esc_html( $font['name'] ); ?></option>
						<?php } ?>
					</optgroup>
                    <?php
				}

				// Get Standard font options.
				if ($std_fonts = DIMA_Webfonts::dima_standard_fonts() ) { ?>
					<optgroup id="s_fonts" label="<?php esc_html_e( 'Standard Fonts', 'noor' ); ?>">
						<?php foreach ( $std_fonts as $font ) {?>
						<option value="<?php echo esc_html( $font ); ?>" <?php selected( $font, $this_val ); ?>><?php echo esc_html( $font ); ?></option>
						<?php } ?>
					</optgroup>
                    <?php
                }

                // Google font options.
                if ($google_fonts = DIMA_Webfonts::get_google_fonts('all') ) { ?>
                    <optgroup id="g_fonts" label="<?php esc_html_e( 'Google Fonts', 'noor' ); ?>">
						<?php
						// Loop through font options and add to select
						foreach ( $google_fonts as $font ) {?>
							<option value="<?php echo esc_html( $font->family ); ?>" <?php selected( $font->family, $this_val ); ?>><?php echo esc_html( $font->family ); ?></option>
					    <?php } ?>
                    </optgroup>
                <?php } ?>
			</select>
		</label>
		<?php
	}
}
