<?php
/**
 * Custom Control .
 *
 * @package Dima Framework
 * @subpackage Admin customizer
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 */


/**
 * Color control
 */
class dima_custom_control_color_alpha extends WP_Customize_Control {

	public $type = 'color-alpha';

	/**
	 * Add support for palettes to be passed in.
	 *
	 * Supported palette values are true, false, or an array of RGBa and Hex colors.
	 */
	public $palette;

	/**
	 * Add support for showing the opacity value on the slider handle.
	 */
	public $show_opacity;

	/**
	 * Enqueue control related scripts/styles.
	 *
	 * @access public
	 */
	public function enqueue() {
		wp_enqueue_script( 'wp-color-picker' );
		wp_enqueue_script( 'dima-color', DIMA_TEMPLATE_URL . '/framework/asset/admin/js/color.min.js', array( 'jquery', 'wp-color-picker' ), false, true );
		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_style( 'dima-color', DIMA_TEMPLATE_URL . '/framework/asset/admin/css/color.min.css', array( 'wp-color-picker' ), '1.0.0' );
		wp_localize_script( 'dima-color', 'dimawpLocalize', array( 'colorPalettes' => dima_default_color_palettes() ) );
	}

	/**
	 * Refresh the parameters passed to the JavaScript via JSON.
	 *
	 * @see WP_Customize_Control::to_json()
	 */
	public function to_json() {
		parent::to_json();

		$this->json['default']      = $this->setting->default;
		$this->json['show_opacity'] = ( false === $this->show_opacity || 'false' === $this->show_opacity ) ? 'false' : 'true';
		$this->json['value']        = $this->value();
		$this->json['link']         = $this->get_link();
		$this->json['id']           = $this->id;

	}

	protected function render() {
		$id    = 'customize-control-' . str_replace( '[', '-', str_replace( ']', '', $this->id ) );
		$class = 'customize-control customize-control-' . esc_attr( $this->type );
		?>
		<li id="<?php echo esc_attr( $id ); ?>" class="<?php echo esc_attr( $class ); ?>">
			<?php $this->render_content(); ?>
		</li>
		<?php
	}

	public function render_content() {
		?>
		<label>
				<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
				<?php if ( ! empty( $this->description ) ) : ?>
				<span class="description customize-control-description"><?php echo esc_attr( $this->description ); ?></span>
				<?php endif; ?>
			<div>
			<input class="alpha-color-control" type="text"  value="<?php echo intval( $this->value() ); ?>" data-show-opacity="<?php echo esc_attr( $this->show_opacity ); ?>" data-default-color="<?php echo esc_attr( $this->setting->default ); ?>" <?php $this->link(); ?> />
			</div>
		</label>
		<?php
	}
}

/**
 * Default color picker palettes
 *
 * @since 1.0.0
 */
if ( ! function_exists( 'dima_default_color_palettes' ) ) {

	function dima_default_color_palettes() {

		$palettes = array(
			'#000000',
			'#333333',
			'#FFFFFF',
			'#757575',
			'#f44336',
			'#ffc107',
			'#4caf50',
			'#2196f3',
		);
		// Apply filters and return
		return apply_filters( 'dima_default_color_palettes', $palettes );

	}
}
