<?php
/**
 * Typography Customizer Options
 *
 * @package Dima WordPress theme
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Dima_Typography_Customizer' ) ) :

	class Dima_Typography_Customizer {

		/**
		 * Setup class.
		 *
		 * @since 1.0
		 */
		public function __construct() {
			// CSS output
			if ( is_customize_preview() ) {
				add_action( 'customize_preview_init', array( $this, 'customize_preview_init' ) );
			}
		}


		/**
		 * Loads js file for customizer preview
		 *
		 * @since 1.0.0
		 */
		public function customize_preview_init() {
			wp_enqueue_script( 'dima-typography-customize-preview', DIMA_TEMPLATE_URL . '/framework/asset/admin/js/typography-customize-preview.js', array( 'customize-preview' ), DIMA_VERSION, true );
			wp_localize_script(
				'dima-typography-customize-preview',
				'dima',
				array(
					'googleFontsUrl'    => '//fonts.googleapis.com',
					'googleFontsWeight' => '100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i',
				)
			);
		}

	}

endif;

return new Dima_Typography_Customizer();
