<?php
if ( ( ! \function_exists( 'pll_current_language' ) || ! \function_exists( 'pll_default_language' ) ) && ! \defined( 'ICL_SITEPRESS_VERSION' ) ) {
	 return;
}

// Instantiate the class.
$GLOBAL['dima_customizer_multilingual'] = Dima_Customizer_Multilingual::init();
/**
 * Class Customizer_Multilingual
 *
 * @package Dekode\DSS\Nettsteder_Mal
 */
class Dima_Customizer_Multilingual {

	/**
	 * Static factory
	 *
	 * @return void
	 */
	public static function init() {
		$self = new self();
		if ( function_exists( 'pll_default_language' ) ) {
			$options = get_option( 'polylang' );
			if ( is_customize_preview() ) {
				/**
				 * Force 'The language is set from content (in Language->Settings->URL modifications)
				 */
				$url_mod = 0;
				/**
				* Disable detect browser language, will return default language instead.
				*/
				add_filter( 'pll_preferred_language', '__return_false' );
			} else {
				/**
				 * Force 'The language is set from the directory name in pretty permalinks (in Language->Settings->URL modifications)
				 */
				$url_mod = 1;
			}

			if ( isset( $options['force_lang'] ) && $url_mod !== $options['force_lang'] ) {
				$options['force_lang'] = $url_mod;
				update_option( 'polylang', $options );
			}
		}
		if ( is_customize_preview() ) {
			\add_action( 'customize_controls_enqueue_scripts', [ $self, 'add_lang_to_customizer_previewer' ], 9 );
		}

		\add_action( 'wp_before_admin_bar_render', [ $self, 'on_wp_before_admin_bar_render' ], 100 );
		\add_action( 'admin_menu', [ $self, 'on_admin_menu' ], 100 );
		return $self;
	}

	/**
	 * Constructor.
	 */
	private function __construct() {}


	/**
	 * If Polylang activated, set the preview url and add select language control
	 *
	 * @author soderlind
	 * @version 1.0.0
	 * @link https://gist.github.com/soderlind/1908634f5eb0c1f69428666dd2a291d0
	 */
	public function add_lang_to_customizer_previewer() {

		$handle    = 'dss-add-lang-to-template';
		$src       = DIMA_TEMPLATE_URL . '/framework/asset/admin/js/customizer-multilang.js';
		$deps      = [ 'customize-controls' ];
		$version   = DIMA_VERSION;
		$in_footer = 1;
		wp_enqueue_script( $handle, $src, $deps, $version, $in_footer );
		$language = ( empty( $_REQUEST['lang'] ) ) ? Dima_Multilingual::get_active_language() : $_REQUEST['lang'];

		if ( empty( $language ) ) {
			$language = Dima_Multilingual::get_default_language_slug();
		}

		if ( ! empty( $_REQUEST['url'] ) ) {
			$current_url = add_query_arg( 'lang', $language, $_REQUEST['url'] );
		} else {
			$current_url = add_query_arg( 'lang', $language, Dima_Multilingual::get_home_url( $language ) );
		}

		wp_add_inline_script(
			$handle,
			sprintf(
				'DimaMultiLang.init( %s );',
				wp_json_encode(
					[
						'url'              => $current_url,
						'languages'        => Dima_Multilingual::get_available_data_languages( true ),
						'current_language' => $language,
						'language_label'   => '',
					]
				)
			),
			'after'
		);
	}

	/**
	 * Append lang="contrycode" to the customizer url in the adminbar
	 *
	 * @return void
	 */
	public function on_wp_before_admin_bar_render() {
		global $wp_admin_bar;
		$customize_node = $wp_admin_bar->get_node( 'customize' );
		if ( ! empty( $customize_node ) ) {
			$customize_node->href = add_query_arg( 'lang', Dima_Multilingual::get_active_language(), $customize_node->href );
			$wp_admin_bar->add_node( $customize_node );
		}
	}

	/**
	 * Append lang="contrycode" to the customizer url in the Admin->Apperance->Customize menu
	 *
	 * @return void
	 */
	public function on_admin_menu() {
		global $submenu;
		$parent = 'themes.php';
		if ( ! isset( $submenu[ $parent ] ) ) {
			return;
		}
		foreach ( $submenu[ $parent ] as $k => $d ) {
			if ( 'customize' === $d['1'] ) {
				$submenu[ $parent ][ $k ]['2'] = add_query_arg( 'lang', Dima_Multilingual::get_active_language(), $submenu[ $parent ][ $k ]['2'] );
				break;
			}
		}
	}

}
