<?php
/**
 * [List of Controls]
 *
 * @param  [array 2D] $customizer_array     [Content 4 type of variables 1: Settings 2: Sections 3: Controls  3: Panel]
 * @param  [type]     $wp_customize [WP_Customize_Manager instance]
 */
function dima_customizer_controls_list( $customizer_array, $wp_customize, $customizer_data ) {

	$add_prefix        = true;
	$dima_option_group = Dima::get_dima_theme_option_name();
	/** @var wpdb $wpdb */
	if ( isset( $customizer_array['panel'] ) ) {
		foreach ( $customizer_array['panel'] as $panel ) {
			$wp_customize->add_panel(
				$panel[0],
				array(
					'title'       => $panel[1],
					'description' => $panel[2],
					'priority'    => $panel[3],
				)
			);
		}
	}

	/**
	 * Out - Sections.
	 */
	if ( isset( $customizer_array['sections'] ) ) {
		foreach ( $customizer_array['sections'] as $section ) {
			$wp_customize->add_section(
				$section[0],
				array(
					'title'    => $section[1],
					'priority' => $section[2],
					'panel'    => $section[3],
				)
			);
		}
	}

	/**
	 * controls
	 */
	foreach ( $customizer_array['controls']  as $key => $control ) {
		$setting = $customizer_array['settings'][ $key ];

		$_opt_name       = $add_prefix ? "{$dima_option_group}[{$control[0]}]" : $control[0];
		static $priority = 1;
		/**
		 * Out - Settings.
		 */
		$__opt_name = $add_prefix ? "{$dima_option_group}[{$setting[0]}]" : $setting[0];
		$wp_customize->add_setting(
			$__opt_name,
			array(
				'type'              => 'option',
				'default'           => $customizer_data[ $setting[0] ],
				'transport'         => $setting[1],
				'sanitize_callback' => $setting[2],
			)
		);
		/**
		 * 1-radio-select
		 * 3-radio_button_set
		 * 4-multi_check
		 * 5-checkbox-text
		 * 6-textarea
		 * 7-slider
		 * 8-color
		 * 9-image
		 */
		switch ( $control[1] ) {
			case 'select':
			case 'radio':
				$wp_customize->add_control(
					$_opt_name,
					array(
						'type'        => $control[1],
						'label'       => $control[2],
						'section'     => $control[3],
						'choices'     => $control[4],
						'description' => $control[5],
						'priority'    => $priority,
					)
				);
				break;

			case 'radio_button_set':
				$wp_customize->add_control(
					new dima_custom_control_radio_button_set(
						$wp_customize,
						$_opt_name,
						array(
							'type'        => $control[1],
							'label'       => $control[2],
							'section'     => $control[3],
							'choices'     => $control[4],
							'description' => $control[5],
							'priority'    => $priority,
						)
					)
				);
				break;

			case 'radio-image':
				$wp_customize->add_control(
					new dima_custom_control_radio_image(
						$wp_customize,
						$_opt_name,
						array(
							'type'        => $control[1],
							'label'       => $control[2],
							'section'     => $control[3],
							'choices'     => $control[4],
							'description' => $control[5],
							'priority'    => $priority,
						)
					)
				);
				break;

			case 'font_style':
				$wp_customize->add_control(
					new dima_custom_control_font_style(
						$wp_customize,
						$_opt_name,
						array(
							'type'        => $control[1],
							'label'       => $control[2],
							'section'     => $control[3],
							'choices'     => $control[4],
							'description' => $control[5],
							'priority'    => $priority,
						)
					)
				);
				break;
			case 'dima_typography':
				$wp_customize->add_control(
					new dima_custom_control_typography(
						$wp_customize,
						$_opt_name,
						array(
							'type'        => $control[1],
							'label'       => $control[2],
							'section'     => $control[3],
							'choices'     => $control[4],
							'description' => $control[5],
							'priority'    => $priority,
						)
					)
				);
				break;
			case 'multi_check':
				$wp_customize->add_control(
					new dima_custom_control_multi_check(
						$wp_customize,
						$_opt_name,
						array(
							'type'        => $control[1],
							'label'       => $control[2],
							'section'     => $control[3],
							'choices'     => $control[4],
							'description' => $control[5],
							'priority'    => $priority,
						)
					)
				);
				break;
			case 'multiple-select':
				$wp_customize->add_control(
					new dima_custom_control_multiple_select(
						$wp_customize,
						$_opt_name,
						array(
							'type'        => $control[1],
							'label'       => $control[2],
							'section'     => $control[3],
							'choices'     => $control[4],
							'description' => $control[5],
							'priority'    => $priority,
						)
					)
				);
				break;
			case 'textarea':
				$wp_customize->add_control(
					new dima_custom_control_textarea(
						$wp_customize,
						$_opt_name,
						array(
							'label'       => $control[2],
							'section'     => $control[3],
							'settings'    => $_opt_name,
							'description' => $control[4],
							'priority'    => $priority,
						)
					)
				);
				break;

			case 'slider':
				$wp_customize->add_control(
					new dima_custom_control_slider(
						$wp_customize,
						$_opt_name,
						array(
							'label'       => $control[2],
							'section'     => $control[4],
							'settings'    => $_opt_name,
							'choices'     => $control[3],
							'description' => $control[5],
							'priority'    => $priority,
						)
					)
				);
				break;

			case 'color':
				$wp_customize->add_control(
					new WP_Customize_Color_Control(
						$wp_customize,
						$_opt_name,
						array(
							'label'       => $control[2],
							'settings'    => $_opt_name,
							'section'     => $control[3],
							'description' => $control[4],
							'priority'    => $priority,
						)
					)
				);
				break;

			case 'color-alpha':
				$wp_customize->add_control(
					new dima_custom_control_color_alpha(
						$wp_customize,
						$_opt_name,
						array(
							'label'       => $control[2],
							'settings'    => $_opt_name,
							'section'     => $control[3],
							'description' => $control[4],
							'priority'    => $priority,
						)
					)
				);
				break;
			case 'image':
				$wp_customize->add_control(
					new WP_Customize_Image_Control(
						$wp_customize,
						$_opt_name,
						array(
							'label'       => $control[2],
							'section'     => $control[3],
							'settings'    => $_opt_name,
							'description' => $control[4],
							'priority'    => $priority,
						)
					)
				);
				break;
			case 'dropdown-pages':
				$wp_customize->add_control(
					$_opt_name,
					array(
						'type'           => $control[1],
						'label'          => $control[2],
						'section'        => $control[3],
						'description'    => $control[4],
						'allow_addition' => $control[5],
						'priority'       => $priority,
					)
				);
				break;
			default:
				$wp_customize->add_control(
					$_opt_name,
					array(
						'type'        => $control[1],
						'label'       => $control[2],
						'section'     => $control[3],
						'description' => $control[4],
						'priority'    => $priority,
					)
				);
				break;
		}

		$priority++;
	}

}


// sanitize_callback functions.
function dima_validate_color( $value ) {

	$value = str_replace( ' ', '', $value );

	if ( empty( $value ) || is_array( $value ) ) {
		return $value;
	}
	// check hex color.
	if ( preg_match( '|^#([A-Fa-f0-9]{3}){1,2}$|', $value ) ) {
		return $value;
	} //check RGBA color.
	elseif ( false !== strpos( $value, 'rgba' ) ) {
		sscanf( $value, 'rgba(%d,%d,%d,%f)', $red, $green, $blue, $alpha );

		return 'rgba(' . esc_attr( $red ) . ',' . esc_attr( $green ) . ',' . esc_attr( $blue ) . ',' . esc_attr( $alpha ) . ')';
	} //check RGB color.
	elseif ( false !== strpos( $value, 'rgb' ) ) {
		sscanf( $value, 'rgb(%d,%d,%d)', $red, $green, $blue );

		return 'rgb(' . esc_attr( $red ) . ',' . esc_attr( $green ) . ',' . esc_attr( $blue ) . ')';
	} else {
		return false;
	}
}

function dima_validate_slider( $value ) {
	if ( is_numeric( $value ) ) {
		return $value;
	} else {
		return false;
	}
}

function dima_validate_image( $value ) {
	return esc_url_raw( $value );
}

function dima_validate_radio( $value ) {
	if ( filter_var( $value, FILTER_VALIDATE_URL ) === false ) {
		return sanitize_key( $value );
	} else {
		return $value;
	}
}

function dima_validate_attr( $value ) {
	echo $value;
	return esc_attr( $value );
}

function dima_validate_url( $value ) {
	return esc_url_raw( $value );
}

function dima_validate_textarea( $value ) {
	return esc_textarea( $value );
}

function dima_validate_html( $value ) {
	return esc_html( $value );
}

function dima_return_false( $value ) {
	return $value;
}


/**
 * When in Polylang or WPML we're using "all" languages,
 * saved options should be copied to ALL languages.
 *
 * @access public
 */
function dima_save_all_languages() {
	$is_all = Dima::get_language_is_all();

	if ( ! $is_all ) {

		$parsed_url = dima_helper::dima_get_referer();

		// Check the HTTP referrer to determine if the language is set to "all".
		if ( $parsed_url ) {

			if ( ! function_exists( 'wp_parse_url' ) ) {
				require_once wp_normalize_path( ABSPATH . '/wp-includes/http.php' );
			}

			$parsed_url = wp_parse_url( $parsed_url );
			if ( isset( $parsed_url['query'] ) ) {
				parse_str( $parsed_url['query'], $query_url );
				if ( isset( $query_url['lang'] ) && 'all' === $query_url['lang'] ) {
					$is_all = true;
				}
			}
		}
	}

	if ( ! $is_all ) {
		return;
	}

	// Get the options.
	$option_name          = Dima::get_option_name();
	$original_option_name = Dima::get_original_option_name();
	$options              = get_option( $option_name );

	// Get available languages.
	$all_languages = Dima_Multilingual::get_available_languages_slugs();

	// Get default language.
	$default_language = Dima_Multilingual::get_default_language_slug();

	if ( 'en' !== $default_language ) {
		 update_option( $original_option_name . '_' . $default_language, $options );
		 update_option( $original_option_name, $options );
	}

	foreach ( $all_languages as $language ) {

		// Skip English.
		if ( '' === $language || 'en' === $language ) {
			continue;
		}

		// Skip the main language if something other than English.
		// We've already handled that above.
		if ( 'en' !== $default_language && $default_language === $language ) {
			continue;
		}

		// Copy options to the new language.
		update_option( $original_option_name . '_' . $language, $options );
	}

}
add_action( 'customize_save_after', 'dima_save_all_languages' );
