let add_to_cart_button;

jQuery(function($) {
	/* Plus-minus buttons customization */
	const wooInitDropkick = () => {
		if ($("body").hasClass("single-product")) {
			if ($(".ul-dropdown-toggle").length > 0)
				$(".ul-dropdown-toggle").dropkick({ mobile: true });
			if ($(".variations .value select").length > 0)
				$(".variations .value select").dropkick({ mobile: true });
		}
		if ($("body.woocommerce-cart .cart-wrap .shipping select").length > 0)
			$("body.woocommerce-cart .cart-wrap .shipping select").dropkick();
	};
	/**
	 * Sticky Sidebars
	 */
	const dima_sticky_product = () => {
		let $stickySidebar = $("[data-gallery-style='product_sticky']").find(
			".entry-summary"
		);
		if ($stickySidebar.length) {
			let stickySidebarBottom = 35,
				stickySidebarTop = 120;
			stickySidebarTop =
				pxdm_js.sticky_behavior !== "default" ? 8 : stickySidebarTop;
			stickySidebarTop = $("body").hasClass("admin-bar")
				? stickySidebarTop + 32
				: stickySidebarTop;
			stickySidebarTop = $("body").hasClass("framed")
				? stickySidebarTop + 20
				: stickySidebarTop;
			$stickySidebar.theiaStickySidebar({
				additionalMarginTop: stickySidebarTop,
				additionalMarginBottom: stickySidebarBottom,
				minWidth: 990
			});
		}
	};
	const shopBtn = () => {
		const $target = $(
			"div.quantity:not(.buttons_added), td.quantity:not(.buttons_added)"
		).find("qty");
		if ($target && $target.prop("type") !== "date") {
			//buttons
			$("div.quantity:not(.buttons_added), td.quantity:not(.buttons_added)")
				.addClass("buttons_added")
				.append('<input type="button" value="+" class="plus dima-plus" />')
				.prepend('<input type="button" value="-" class="minus" />');

			$("input.qty:not(.product-quantity input.qty)").each(function() {
				const min = parseFloat($(this).attr("min"));
				if (min && min > 0 && parseFloat($(this).val()) < min) {
					$(this).val(min);
				}
			});
			$(document).on("click", ".plus, .minus", function() {
				const $qty = $(this)
					.closest(".quantity")
					.find(".qty");
				let Val = parseFloat($qty.val());
				let max = parseFloat($qty.attr("max"));
				let min = parseFloat($qty.attr("min"));
				let step = $qty.attr("step");

				if (!Val || Val === "" || Val === "NaN") Val = 0;
				if (max === "" || max === "NaN") max = "";
				if (min === "" || min === "NaN") min = 0;
				if (
					step === "any" ||
					step === "" ||
					step === undefined ||
					parseFloat(step) === "NaN"
				)
					step = 1;

				if ($(this).is(".plus")) {
					if (max && (max === Val || Val > max)) {
						$qty.val(max);
					} else {
						$qty.val(Val + parseFloat(step));
					}
				} else {
					if (min && (min === Val || Val < min)) {
						$qty.val(min);
					} else if (Val > 0) {
						$qty.val(Val - parseFloat(step));
					}
				}

				$qty.trigger("change");
			});
		}

		$(".minus").click(function() {
			const inputEl = $(this)
				.parent()
				.children()
				.next();
			let qty = inputEl.val();
			if (
				$(this)
					.parent()
					.hasClass("minus")
			)
				qty++;
			else qty--;
		});

		$(".plus").click(function() {
			const inputEl = $(this)
				.parent()
				.children()
				.next();
			let qty = inputEl.val();
			if ($(this).hasClass("plus")) qty++;
			else qty--;
		});

		$(".add_to_cart_button").click(function() {
			const $add_to_cart_button = $(this);
			$add_to_cart_button
				.find("i")
				.removeClass("fa-shopping-bag")
				.addClass("fa-check");
		});
	};

	const sliderRange = () => {
		const $slider_rang = $("#slider-range");
		$slider_rang.slider({
			range: true,
			min: 0,
			max: 40,
			values: [5, 30],
			slide(event, ui) {
				$("#amount").val(`$${ui.values[0]} - $${ui.values[1]}`);
			}
		});
		$("#amount").val(
			`$${$slider_rang.slider("values", 0)} - $${$slider_rang.slider(
				"values",
				1
			)}`
		);
	};

	$(document).ready(() => {
		shopBtn();
		sliderRange();
		dima_sticky_product();

		$(".woocommerce-page #reviews #comments ol.commentlist li").each(
			function() {
				const $self = $(this);
				const $title = $self
					.find(".comment_container .comment-text .meta strong")
					.clone();
				const $meta = $self
					.find(".comment_container .comment-text .meta time")
					.clone();

				$self
					.find(".comment_container .comment-text .meta")
					.text("")
					.append($title)
					.append($meta);
			}
		);

		var $vrf = $("form.variations_form");
		if (!$("html").hasClass("dima-ie-detected") && pxdm_js.dima_dropkick) {
			wooInitDropkick();
			$("body").on("post-load", wooInitDropkick);

			$("body").on("post-load", () => {
				if ($(".variations .value select").length > 0)
					$(".variations .value select").dropkick("refresh");
			});

			$vrf.on("click touchend", ".reset_variations", e => {
				$("table.variations select").dropkick("reset", true);
			});
			$vrf.on("show_variation", (t, e) => {
				$(".variations .value select").dropkick("refresh");
			});

			if ($(".woocommerce-ordering").find("select").length > 0) {
				$(".woocommerce-ordering")
					.find("select")
					.dropkick({ mobile: true });
			}
		} else {
			$vrf.on("show_variation", (t, e) => {
				if (e.hasOwnProperty("image") && e.image.gallery_thumbnail_src) {
					$(".product-thumbnails .first img")
						.attr("src", e.image.gallery_thumbnail_src)
						.attr("srcset", "");
					$(".product-thumbnails .first")
						.addClass("slick-current")
						.trigger("click");
				}
			});
		}
	});

	$(document.body).on("updated_wc_div cart_page_refreshed", () => {
		$(document).trigger("change input");
	});

	/**
	 * Init zoom.
	 */
	let initZoomForTarget = function(zoomTarget) {
		let zoom_enabled =
			$.isFunction($.fn.zoom) && wc_single_product_params.zoom_enabled;
		if (!zoom_enabled) {
			return false;
		}

		var galleryWidth = $(".woocommerce-product-gallery").width(),
			zoomEnabled = false;
		$(zoomTarget).each(function(index, target) {
			var image = zoomTarget.find("img");

			if (image.data("large_image_width") > galleryWidth) {
				zoomEnabled = true;
				return false;
			}
		});

		// But only zoom if the img is larger than its container.
		if (zoomEnabled) {
			var zoom_options = $.extend(
				{
					touch: false
				},
				wc_single_product_params.zoom_options
			);

			if ("ontouchstart" in document.documentElement) {
				zoom_options.on = "click";
			}

			zoomTarget.trigger("zoom.destroy");
			zoomTarget.zoom(zoom_options);

			setTimeout(function() {
				if (zoomTarget.find(":hover").length) {
					zoomTarget.trigger("mouseover");
				}
			}, 100);
		}
	};

	$(".woocommerce-product-gallery").each(function() {
		let $images = $(".woocommerce-product-gallery__image", $(this));
		initZoomForTarget($images);
	});
	$(".woocommerce-product-gallery__trigger").on("click", function(e) {
		e.preventDefault();
		e.stopPropagation();
		$(this)
			.parent()
			.find(".woocommerce-product-gallery__image.slick-current")
			.find("a")
			.click();
	});
});
