(function($) {
	$(document).ready(function() {
		$(".dima-typography-select").chosen({
			enable_split_word_search: true,
			search_contains: true
		});
	});
})(jQuery);

(function(api, $, _) {
	"use strict";
	var lang = pxdm_js.dima_lang;
	function dima_font_api(source, weights_list, fontlist) {
		source = lang + "[" + source + "]";
		weights_list = lang + "[" + weights_list + "]";
		fontlist = lang + "[" + fontlist + "]";

		api(source, function(setting) {
			var bodyFontSource,
				linkSettingValueToControlActiveState,
				linkSettingValueToControlEmpty,
				filterFontSource,
				isGoogleFontActive,
				isDefaultsFontActive;

			/**
			 * Determine whether the body font source.
			 *
			 * @returns {string} Body Font Source?
			 */
			bodyFontSource = function() {
				return setting.get();
			};

			isGoogleFontActive = function() {
				return bodyFontSource() === "g_fonts";
			};

			isDefaultsFontActive = function() {
				return bodyFontSource() !== "";
			};

			filterFontSource = function(control) {
				var setActiveState = function() {
					if (bodyFontSource() !== "") {
						var id = control.id.replace("[", "-");
						id = id.replace("]", "");

						$("#customize-control-" + id)
							.find("optgroup")
							.hideOptionGroup();
						$("#customize-control-" + id)
							.find("#" + bodyFontSource())
							.showOptionGroup();
					}
				};
				setActiveState();
				setting.bind(setActiveState);
			};

			$.fn.hideOptionGroup = function() {
				$(this).attr("disabled", "disabled");
				$(".dima-typography-select").trigger("chosen:updated");
			};

			$.fn.showOptionGroup = function() {
				$(this).removeAttr("disabled");
				$(".dima-typography-select").trigger("chosen:updated");
			};

			linkSettingValueToControlActiveState = function(control) {
				var setActiveState = function() {
					control.active.set(isGoogleFontActive());
				};
				control.active.validate = isGoogleFontActive;
				setActiveState();
				setting.bind(setActiveState);
			};

			linkSettingValueToControlEmpty = function(control) {
				var setActiveState = function() {
					control.active.set(isDefaultsFontActive());
				};
				control.active.validate = isDefaultsFontActive;
				setActiveState();
				setting.bind(setActiveState);
			};

			api.control(weights_list, linkSettingValueToControlActiveState);
			api.control(fontlist, linkSettingValueToControlEmpty);
			api.control(fontlist, filterFontSource);
		});
	}

	dima_font_api(
		"dima_body_font_source",
		"dima_body_weights_list",
		"dima_body_font_list"
	);
	dima_font_api(
		"dima_heading_font_source",
		"dima_heading_weights_list",
		"dima_heading_font_list"
	);
	dima_font_api(
		"dima_heading_2_font_source",
		"dima_heading_weights_list_2",
		"dima_heading_font_list_2"
	);
	dima_font_api(
		"dima_heading_3_font_source",
		"dima_heading_weights_list_3",
		"dima_heading_font_list_3"
	);
	dima_font_api(
		"dima_heading_4_font_source",
		"dima_heading_weights_list_4",
		"dima_heading_font_list_4"
	);
	dima_font_api(
		"dima_heading_5_font_source",
		"dima_heading_weights_list_5",
		"dima_heading_font_list_5"
	);
	dima_font_api(
		"dima_heading_6_font_source",
		"dima_heading_weights_list_6",
		"dima_heading_font_list_6"
	);
	dima_font_api(
		"dima_logo_font_source",
		"dima_logo_weights_list",
		"dima_logo_font_list"
	);
	dima_font_api(
		"dima_navbar_font_source",
		"dima_navbar_weights_list",
		"dima_navbar_font_list"
	);
	dima_font_api(
		"dima_btn_font_source",
		"dima_btn_font_list",
		"dima_btn_font_list"
	);
})(wp.customize, jQuery, _);
