/**
 * Update Typography Customizer settings live.
 *
 * @version 1.0.0
 */

(function($) {
	// Declare vars
	var api = wp.customize;
	function get_otion_name($opt) {
		var $theme_option_name = pxdm_js.dima_lang;
		if ($opt) {
			$opt = $theme_option_name + "[" + $opt + "]";
		} else {
			$opt = $theme_option_name;
		}
		return $opt;
	}
	/******** TYPOGRAPHY OPTIONS LOOP *********/
	api_font_family("dima_body_font_list", "body");
	api_font_family("dima_heading_font_list", "h1");
	api_font_family("dima_heading_font_list_2", "h2");
	api_font_family("dima_heading_font_list_3", "h3");
	api_font_family("dima_heading_font_list_4", "h4");
	api_font_family("dima_heading_font_list_5", "h5");
	api_font_family("dima_heading_font_list_6", "h6");
	api_font_family("dima_navbar_font_list", ".dima-navbar-wrap");

	api_add_one_style("dima_body_text_color", "color", "body, p");
	api_add_one_style(
		"dima_heading_text_color",
		"color",
		"h1, h1 a, a h1, h1 a:hover, a:hover h1"
	);
	api_add_one_style(
		"dima_heading_text_color_2",
		"color",
		"h2, h2 a, a h2, h2 a:hover, a:hover h2"
	);
	api_add_one_style(
		"dima_heading_text_color_3",
		"color",
		"h3, h3 a, a h3, h3 a:hover, a:hover h3"
	);
	api_add_one_style(
		"dima_heading_text_color_4",
		"color",
		"h4, h4 a, a h4, h4 a:hover, a:hover h4"
	);
	api_add_one_style(
		"dima_heading_text_color_5",
		"color",
		"h5, h5 a, a h5, h5 a:hover, a:hover h5"
	);
	api_add_one_style(
		"dima_heading_text_color_6",
		"color",
		"h6, h6 a, a h6, h6 a:hover, a:hover h6"
	);
	api_add_one_style(
		"dima_body_link_color",
		"color",
		"div.widget.twitter-widget a, div.widget.widget_display_topics a, div.widget.widget_display_replies a, div.widget.widget_recent_entries a, a"
	);
	api_add_one_style(
		"dima_body_link_color_hover",
		"color",
		"div.widget.widget_categories a:hover, div.widget.widget_meta a:hover, div.widget.widget_layered_nav a:hover, div.widget.widget_nav_menu a:hover, div.widget.widget_archive a:hover, div.widget.widget_pages a:hover, div.widget.twitter-widget a:hover, div.widget.widget_rss a:hover, div.widget.widget_product_categories a:hover, div.widget.widget_recent_comments a:hover, div.widget.bbp_widget_login a:hover, div.widget.widget_display_forums a:hover, div.widget.widget_display_topics a:hover, div.widget.widget_display_views a:hover, div.widget.widget_display_replies a:hover, .tagcloud a:hover, .tags a:hover, .dima-link p a:hover, .boxed-blog article .post-meta a:hover, .boxed-blog .post .post-meta a:hover, .isotope-item .work-item .project-info .porftfolio-cat li a:hover, .header-link-color:hover, .product-details .product-shop .posted_in a:hover, .product-details .product-shop .tagged_as a:hover, .product-details .product-shop .product_meta a:hover, a:hover"
	);
	//Main Menu
	api_add_one_style(
		"dima_navbar_text_color",
		"color",
		".navbar_is_dark .dima-navbar-wrap .dima-nav.icon-menu .badge-number,.dima-navbar-wrap .dima-nav.icon-menu .badge-number,	.dima-navbar-wrap .dima-topbar .icon_text .dima-topbar-txt,.navbar_is_dark .dima-navbar-wrap .dima-topbar .icon_text .dima-topbar-txt,.navbar_is_dark .dima-navbar-wrap .dima-nav > li > a,.navbar_is_dark .dima-navbar-wrap .dima-nav.nav-primary > li > a,.dima-nav > li > a"
	);
	api_add_one_style(
		"dima_menu_hover_text_color",
		"color",
		".navbar_is_dark .dima-navbar-wrap .dima-nav > li > a:hover ,.navbar_is_dark .dima-navbar-wrap .dima-nav.nav-primary > li > a:hover ,.dima-nav > li > a:hover"
	);
	api_add_one_style(
		"dima_submenu_text_color",
		"color",
		".sub_menu_is_dark .dima-navbar-wrap.mobile-nav .dima-navbar .dima-nav-tag .dima-nav .sub-menu li a,.sub_menu_is_dark .dima-navbar-wrap.mobile-nav .dima-navbar .dima-nav-tag .dima-nav > li > a,.sub_menu_is_dark .dima-navbar-wrap .dima-nav .sub-menu a,.dima-nav .sub-menu a"
	);
	api_add_one_style(
		"dima_submenu_text_hover_color",
		"color",
		".sub_menu_is_dark .dima-navbar-wrap.mobile-nav .dima-navbar .dima-nav-tag .dima-nav .sub-menu li a:hover,.sub_menu_is_dark .dima-navbar-wrap.mobile-nav .dima-navbar .dima-nav-tag .dima-nav > li > a:hover,.sub_menu_is_dark .dima-navbar-wrap .dima-nav .sub-menu a:hover,.dima-nav .sub-menu a:hover"
	);
	api_add_one_style(
		"dima_footer_content_body_color",
		"color",
		".dima-footer,footer.dima-footer .copyright p"
	);
	api_add_one_style(
		"dima_footer_content_link_color",
		"color",
		".dima-footer .copyright a,.dima-footer a"
	);

	api_add_one_style(
		"dima_footer_widget_header_color",
		"color",
		".footer-container .top-footer .widget .widget-title"
	);
	api_add_one_style(
		"dima_footer_widget_body_color",
		"color",
		".top-footer .widget,.top-footer .widget p"
	);
	api_add_one_style(
		"dima_footer_widget_link_color",
		"color",
		".footer-container .top-footer .widget:not(.social-icons-widget) a,.footer-container .top-footer .widget:not(.social-icons-widget) ul li a,.footer-container .top-footer .widget:not(.social-icons-widget) ol li a,.top-footer .widget_shopping_cart_content .amount,.top-footer .widget_shopping_cart_content .product-title,.top-footer .product_list_widget .amount,.top-footer .product_list_widget .product-title"
	);
	api_add_one_style(
		"dima_footer_widget_link_hover_color",
		"color",
		".footer-container .top-footer .widget:not(.social-icons-widget) a:hover,.footer-container .top-footer .widget:not(.social-icons-widget) ul li a:hover,.footer-container .top-footer .widget:not(.social-icons-widget) ol li a:hover,.top-footer .widget_shopping_cart_content .amount:hover,.top-footer .widget_shopping_cart_content .product-title:hover,.top-footer .product_list_widget .amount:hover,.top-footer .product_list_widget .product-title:hover"
	);

	/* Start Font Family */
	api_add_one_style("dima_body_text_size", "font-size", "body, p");
	api_add_one_style(
		"dima_sidebar_widget_header_size",
		"font-size",
		".dima-sidebar .widget-title"
	);
	api_add_one_style(
		"dima_sidebar_widget_body_size",
		"font-size",
		".dima-sidebar .widget a,.dima-sidebar .widget"
	);
	api_add_one_style(
		"dima_navbar_text_size",
		"font-size",
		".dima-navbar-wrap.desk-nav .dima-navbar nav .dima-nav > li > a,.dima-navbar-wrap.desk-nav .dima-navbar nav .dima-nav-end > li > a"
	);

	api_add_one_style("dima_h1_text_size", "font-size", "h1");
	api_add_one_style("dima_h2_text_size", "font-size", "h2");
	api_add_one_style("dima_h3_text_size", "font-size", "h3");
	api_add_one_style("dima_h4_text_size", "font-size", "h4");
	api_add_one_style("dima_h5_text_size", "font-size", "h5");
	api_add_one_style("dima_h6_text_size", "font-size", "h6");
	api_add_one_style(
		"dima_btn_text_size",
		"font-size",
		".widget .button, [type='submit'], .dima-button"
	);
	api_add_one_style(
		"dima_logo_text_size",
		"font-size",
		".dima-navbar-wrap.desk-nav .dima-navbar a.dima-brand,.dima-navbar-wrap.mobile-nav .dima-navbar a.dima-brand"
	);

	api_add_one_style(
		"dima_footer_widget_header_size",
		"font-size",
		".top-footer .widget .widget-title"
	);
	api_add_one_style(
		"dima_footer_widget_body_size",
		"font-size",
		".top-footer .widget,.top-footer .widget p"
	);

	/* Font Weight */
	api_add_one_style("dima_body_weight_selected", "font-weight", "p,body");
	api_add_one_style(
		"dima_heading_weight_selected",
		"font-weight",
		".title_container .header-title,h1"
	);
	api_add_one_style("dima_heading_weight_selected_2", "font-weight", "h2");
	api_add_one_style("dima_heading_weight_selected_3", "font-weight", "h3");
	api_add_one_style("dima_heading_weight_selected_4", "font-weight", "h4");
	api_add_one_style("dima_heading_weight_selected_5", "font-weight", "h5");
	api_add_one_style("dima_heading_weight_selected_6", "font-weight", "h6");
	api_add_one_style(
		"dima_navbar_weight_selected",
		"font-weight",
		".dima-navbar-wra"
	);
	api_add_one_style(
		"dima_logo_weight_selected",
		"font-weight",
		".dima-navbar-wrap.desk-nav .dima-navbar .logo"
	);
	api_add_one_style(
		"dima_btn_weight_selected",
		"font-weight",
		".widget .button, [type='submit'], .dima-button "
	);

	/* Letter Spacing */
	api_add_one_style("dima_body_letter_spacing", "letter-spacing", "body");
	api_add_one_style(
		"dima_logo_letter_spacing",
		"letter-spacing",
		".dima-navbar-wrap.desk-nav .dima-navbar a.dima-brand,.dima-navbar-wrap.mobile-nav .dima-navbar a.dima-brand"
	);
	api_add_one_style("dima_heading_letter_spacing", "letter-spacing", "h1");
	api_add_one_style("dima_heading_letter_spacing_2", "letter-spacing", "h2");
	api_add_one_style("dima_heading_letter_spacing_3", "letter-spacing", "h3");
	api_add_one_style("dima_heading_letter_spacing_4", "letter-spacing", "h4");
	api_add_one_style("dima_heading_letter_spacing_5", "letter-spacing", "h5");
	api_add_one_style("dima_heading_letter_spacing_6", "letter-spacing", "h6");
	api_add_one_style(
		"dima_navbar_letter_spacing",
		"letter-spacing",
		".dima-navbar-wrap .dima-nav.nav-primary > li > a"
	);

	/* line height */
	api_add_one_style("dima_body_line_height", "line-height", "body");
	api_add_one_style("dima_submenu_text_line_height", "line-height", ".dima-nav .sub-menu a");

	/* font-style */
	api_text_style(
		"dima_heading_text_style",
		".title_container .header-title,.boxed-blog.blog-list .post header .entry-title,.boxed-blog.blog-list article header .entry-title,h1, h2, h3, h4, h5, h6"
	);
	api_text_style("dima_heading_text_style_2", "h2");
	api_text_style("dima_heading_text_style_3", "h3");
	api_text_style("dima_heading_text_style_4", "h4");
	api_text_style("dima_heading_text_style_5", "h5");
	api_text_style("dima_heading_text_style_6", "h6");
	api_text_style(
		"dima_navbar_text_style",
		".dima-navbar-wrap.desk-nav .dima-navbar nav .dima-nav > li > a,.dima-navbar-wrap.desk-nav .dima-navbar nav .dima-nav-end > li > a"
	);
	api_text_style(
		"dima_logo_text_style",
		".dima-navbar-wrap.desk-nav .dima-navbar a.dima-brand,.dima-navbar-wrap.mobile-nav .dima-navbar a.dima-brand"
	);
	api_text_style(
		"dima_sidebar_widget_header_uppercase",
		".dima-sidebar .widget-title"
	);
	api_text_style(
		"dima_sidebar_widget_body_uppercase",
		".dima-sidebar .widget a,.dima-sidebar .widget"
	);
	api_text_style(
		"dima_footer_widget_header_uppercase",
		".top-footer .widget .widget-title"
	);
	api_text_style(
		"dima_footer_widget_body_uppercase",
		".top-footer .widget,.top-footer .widget p"
	);
	/***************************************************************************************/
	// Main Color
	/***************************************************************************************/
	api_add_one_style(
		"dima_main_color",
		"background-color",
		".dark-bg .tabs_style_1 ul.dima-tab-nav .tab.active a,.dark-bg .tabs_style_2 ul.dima-tab-nav .tab.active a,.dima-timeline-list .dima-iconbox:hover .icon-box-header .box-circle,.dima-timeline-list .dima-iconbox:hover .icon-box-header .box-square,.dropcap.dropcap-3,.entry-content .button:not(.ajax_add_to_cart),.fill,.footer-container .top-footer .dima-button,.footer-container .top-footer .widget .button,.footer-container .top-footer [type=submit],.mfp-content .mfp-close,.noor-line:before,.post-icon .icons-media li a,.stroke:hover,.tabs_style_1 ul.dima-tab-nav .tab.active a,.tabs_style_3 ul.dima-tab-nav .tab.active a,.tabs_style_5 ul.dima-tab-nav .tab.active a,.tagcloud a:hover,.widget .button,[type=submit]:not(.stroke),a .line-hr:before,form.matrial-form input[type=date]:focus~.bar::before,form.matrial-form input[type=email]:focus~.bar::before,form.matrial-form input[type=password]:focus~.bar::before,form.matrial-form input[type=search]:focus~.bar::before,form.matrial-form input[type=tel]:focus~.bar::before,form.matrial-form input[type=text]:focus~.bar::before,form.matrial-form input[type=url]:focus~.bar::before,form.matrial-form textarea:focus~.bar::before,mark.dima-mark,ul.dima-accordion .dima-accordion-group .dima-accordion-header .dima-accordion-toggle"
	);
	api_add_one_style(
		"dima_main_color",
		"color",
		".dropcap.dropcap-1,.filters-box.filters ul .current a,.filters-box.filters ul li a:hover,.filters-box.filters ul li a:hover span,.filters-box.filters ul li.current span,ul.list-style li:before"
	);
	api_add_one_style(
		"dima_main_color",
		"fill",
		".dima-blockquote>span,.read-more-icon:hover svg,blockquote>span svg"
	);
	api_add_one_style(
		"dima_main_color",
		"border-color",
		".tabs_style_5 ul.dima-tab-nav .tab.active,blockquote"
	);
	api_add_one_style(
		"dima_main_color",
		"border-top-color",
		".tabs_style_5 ul.dima-tab-nav .tab.active a::after"
	);

	api_add_one_style(
		"dima_secondary_main_color",
		"color",
		".boxed-blog .post .post-meta ul li.post-on time,.boxed-blog article .post-meta ul li.post-on time,.dark-bg .social-media.fill-icon li:hover a,.detail-label,.di_white.dima-button.fill,.di_white.dima-button.fill:hover,.dima-click-dropdown>a,.dima-pagination ul li .dima-next span,.dima-pagination ul li .next span,.field>label,.header-color,.icon-box-header span,.navbar_is_dark .dima-navbar-wrap .social-media.fill-icon li:hover a,.pagination ul li .dima-next span,.pagination ul li .next span,.price,.social-media li a,.social-media.dima-show li a,.social-media.fill-icon li a,.stroke,.tagcloud .tags-title,.tags .tags-title,.tribe-events-list-separator-month span,blockquote a,blockquote a:hover,p>label,ul.dima-accordion .dima-accordion-group .dima-accordion-header .dima-accordion-toggle.collapsed,ul.dima-accordion.dima-acc-clear .dima-accordion-group .dima-accordion-header .dima-accordion-toggle.collapsed,ul.dima-tab-nav .tab>a,.dima-data-table-wrap table tr,.product-details .product-shop .posted_in,.product-details .product-shop .product_meta,.product-details .product-shop .tagged_as,.product_list_widget .total,.product_list_widget .total a .title,.product_list_widget li,.product_list_widget li a .title,.widget_price_filter .price_slider_amount .price_label,.widget_shopping_cart_content .total,.widget_shopping_cart_content .total a .title,.widget_shopping_cart_content li,.widget_shopping_cart_content li a .title,.woocommerce .order-total td,.woocommerce .order_details .amount"
	);
	api_add_one_style(
		"dima_secondary_main_color",
		"background",
		".dima-data-table-wrap table.zibra_table thead th,.social-media.dima_add_hover li:hover a,.ui-slider .ui-slider-range,.widget_shopping_cart a.button:first-child,table.zibra_table thead th"
	);
	api_add_one_style(
		"dima_secondary_main_color",
		"fill",
		".boxed-blog .post .post-meta ul li svg,.boxed-blog article .post-meta ul li svg,.detail-container .detail-value svg,.dima-data-table-wrap table tr td svg,.dima-pagination ul li .dima-next svg,.dima-pagination ul li .dima-previous svg,.dima-pagination ul li .next svg,.dima-pagination ul li .prev svg,.pagination ul li .dima-next svg,.pagination ul li .dima-previous svg,.pagination ul li .next svg,.pagination ul li .prev svg,.tagcloud svg,.tags svg,table tr td svg"
	);
	api_add_one_style(
		"dima_secondary_main_color",
		"border-color",
		".dima-data-table-wrap table thead,.dima-pagination ul li a:not(.next):not(.dima-next):not(.dima-previous):not(.prev).current,.dima-pagination ul li a:not(.next):not(.dima-next):not(.dima-previous):not(.prev).current-page,.dima-pagination ul li a:not(.next):not(.dima-next):not(.dima-previous):not(.prev):hover,.dima-pagination ul li>span.current,.dima-pagination ul li>span.current-page,.dima-pagination ul li>span:hover,.pagination ul li a:not(.next):not(.dima-next):not(.dima-previous):not(.prev).current,.pagination ul li a:not(.next):not(.dima-next):not(.dima-previous):not(.prev).current-page,.pagination ul li a:not(.next):not(.dima-next):not(.dima-previous):not(.prev):hover,.pagination ul li>span.current,.pagination ul li>span.current-page,.pagination ul li>span:hover,.slick-dots li button:before,.wishlist-icon .wishlist-button:hover,table thead"
	),
		api_add_one_style(
			"dima_secondary_main_color",
			"border-top-color",
			".dima-click-dropdown > a:before"
		);

	/***************************************************************************************/
	// Functions
	/***************************************************************************************/
	/**
	 * Applay font family
	 * @param {*} opt_name: customzer option ID
	 * @param {*} css_classes CSS classes or IDs
	 */
	function api_font_family(opt_name, css_classes) {
		api(get_otion_name(opt_name), function($swipe) {
			$swipe.bind(function(pair) {
				if (pair) {
					/** @type {string} */
					var idfirst = (pair
						.trim()
						.toLowerCase()
						.replace(" ", "-"),
					"customize-control-" + get_otion_name() + "-" + opt_name + "");
					var fontSize = pair.replace(" ", "%20");
					fontSize = fontSize.replace(",", "%2C");
					/** @type {string} */
					fontSize =
						dima.googleFontsUrl +
						"/css?family=" +
						pair +
						":" +
						dima.googleFontsWeight;
					if ($("#" + idfirst).length) {
						$("#" + idfirst).attr("href", fontSize);
					} else {
						$("head").append(
							'<link id="' +
								idfirst +
								'" rel="stylesheet" type="text/css" href="' +
								fontSize +
								'">'
						);
					}
				}
				var $child = $(
					".customize-control-" + get_otion_name() + "-" + opt_name + ""
				);
				if (pair) {
					/** @type {string} */
					var img =
						'<style class="customize-control-' +
						get_otion_name() +
						"-" +
						opt_name +
						'">' +
						css_classes +
						"{font-family: " +
						pair +
						";}</style>";
					if ($child.length) {
						$child.replaceWith(img);
					} else {
						$("head").append(img);
					}
				} else {
					$child.remove();
				}
			});
		});
	}

	/**
	 *  Applay font weight
	 * @param {*} opt_name
	 * @param {*} css_classes
	 */
	function api_add_one_style(opt_name, pre, css_classes) {
		api(get_otion_name(opt_name), function(value) {
			value.bind(function(to) {
				var $child = $("#customizer-" + get_otion_name() + "-" + opt_name + "");
				if (to) {
					var style =
						'<style class="customizer-' +
						get_otion_name() +
						"-" +
						opt_name +
						'">' +
						css_classes +
						"{ " +
						pre +
						": " +
						to +
						"; }</style>";
					if ($child.length) {
						$child.replaceWith(style);
					} else {
						$("head").append(style);
					}
				} else {
					$child.remove();
				}
			});
		});
	}
	/**
	 *  Applay font weight
	 * @param {*} opt_name
	 * @param {*} css_classes
	 */
	function api_text_style(opt_name, css_classes) {
		api(get_otion_name(opt_name), function(value) {
			value.bind(function(to) {
				var $child = $("#customizer-" + get_otion_name() + "-" + opt_name + "");
				if (to) {
					var style =
						'<style class="customizer-' +
						get_otion_name() +
						"-" +
						opt_name +
						'">' +
						css_classes +
						"{ " +
						dima_text_style(to) +
						" }</style>";
					if ($child.length) {
						$child.replaceWith(style);
					} else {
						$("head").append(style);
					}
				} else {
					$child.remove();
				}
			});
		});
	}

	function dima_text_style($styles) {
		// Prepare variable.
		var font_styles = "";

		if ("" !== $styles && false !== $styles) {
			// Convert string into array.
			var $styles_array = $styles.split("|");

			// Use in_array to find values in strings. Otherwise, display default text.
			// Font weight.
			if ($styles_array.includes("bold")) {
				font_styles += "font-weight: bold;";
			} else {
				font_styles += "font-weight: normal; ";
			}

			// Font style.
			if ($styles_array.includes("italic")) {
				font_styles += "font-style: italic; ";
			} else {
				font_styles += "font-style: normal; ";
			}

			// Text-transform.
			if ($styles_array.includes("uppercase")) {
				font_styles += "text-transform: uppercase; ";
			} else {
				font_styles += "text-transform: inherit; ";
			}

			// Text-decoration.
			if ($styles_array.includes("underline")) {
				font_styles += "text-decoration: underline; ";
			} else {
				font_styles += "text-decoration: none; ";
			}
		} else {
			font_styles +=
				"font-weight: normal;font-style:normal;text-transform: inherit;text-decoration: none;";
		}

		return font_styles;
	}
})(jQuery);
