/**
 *
 */
/* global wp, jQuery */
var DimaMultiLang = (function( api, $ ) {
	'use strict';

	var component = {
		data: {
			url: null,
			languages: null,
			current_language: null,
			language_label: null,
		}
	};

	/**
	 * Initialize functionality.
	 *
	 * @param {object} args Args.
	 * @param {string} args.url  Preview URL.
	 * @returns {void}
	 */
	component.init = function init( pll ) {
		_.extend(component.data, pll );
		if (!pll || !pll.url || !pll.languages || !pll.current_language ) {
			throw new Error( 'Missing args' );
		}

		api.bind( 'ready', function(){
			api.previewer.previewUrl.set( pll.url );

			var languages = pll.languages;
			var current_language = pll.current_language;
			var language_label = pll.language_label;
			var keys = Object.keys(languages)

			var html = '<span class="multi-language-select"><span>'+language_label+' </span>';
			html += '<select id="multi-language-select">';

			for (var key of keys) {
				var language = languages[key];
				var selected = (language.slug === current_language) ? 'selected=""' : '';
				html += '<option ' + selected + ' value="' + language.slug + '">' + language.name + '</option>';
			}
			html += '</select></span>';
			$(html).prependTo('#customize-header-actions');


			$('body').on('change', '#multi-language-select', function () {
				var language = $(this).val();
				var old_url = window.location.href;
				window.location.href = updateQueryStringParameter(window.location.href, 'lang', language);
			});
		});

		function updateQueryStringParameter(uri, key, value) {
			var re = new RegExp("([?&])" + key + "=.*?(&|$)", "i");
			var separator = uri.indexOf('?') !== -1 ? "&" : "?";
			if (uri.match(re)) {
				return uri.replace(re, '$1' + key + "=" + value + '$2');
			} else {
				return uri + separator + key + "=" + value;
			}
		}
	};

	return component;
} ( wp.customize, jQuery ) );