<?php

/**
 * User Details
 *
 * @package bbPress
 * @subpackage Theme
 */

?>

<?php do_action( 'bbp_template_before_user_details' ); ?>

<div id="bbp-single-user-details" class="dima-single-user-details box">
    <div class="fima-bbp-user-header">
        <div id="bbp-user-avatar">

				<span class='vcard'>
					<a class="url fn n" href="<?php bbp_user_profile_url(); ?>"
                       title="<?php bbp_displayed_user_field( 'display_name' ); ?>" rel="me">
						<?php echo get_avatar( bbp_get_displayed_user_field( 'user_email', 'raw' ), apply_filters( 'bbp_single_user_details_avatar_size', 100 ) ); ?>
					</a>
				</span>

        </div>
        <div class="dima-bbp-user-content">
            <h6 class="dima-bbp-user-title"><?php echo esc_attr( bbp_get_current_user_name() ); ?></h6>
			<?php bbp_notice_edit_user_is_super_admin(); ?>
        </div>
    </div>

    <div id="bbp-user-navigation">
        <ul>
            <li class="<?php if ( bbp_is_single_user_profile() ) : ?>current<?php endif; ?>">
					<span class="vcard bbp-user-profile-link">
						<a class="url fn n" href="<?php bbp_user_profile_url(); ?>"
                           title="<?php printf( esc_attr__( "%s's Profile", 'noor' ), bbp_get_displayed_user_field( 'display_name' ) ); ?>"
                           rel="me"><?php esc_html_e( 'Profile', 'noor' ); ?></a>
					</span>
            </li>

            <li class="<?php if ( bbp_is_single_user_topics() ) : ?>current<?php endif; ?>">
					<span class='bbp-user-topics-created-link'>
						<a href="<?php bbp_user_topics_created_url(); ?>"
                           title="<?php printf( esc_attr__( "%s's Topics Started", 'noor' ), bbp_get_displayed_user_field( 'display_name' ) ); ?>"><?php esc_html_e( 'Topics Started', 'noor' ); ?></a>
					</span>
            </li>

            <li class="<?php if ( bbp_is_single_user_replies() ) : ?>current<?php endif; ?>">
					<span class='bbp-user-replies-created-link'>
						<a href="<?php bbp_user_replies_created_url(); ?>"
                           title="<?php printf( esc_attr__( "%s's Replies Created", 'noor' ), bbp_get_displayed_user_field( 'display_name' ) ); ?>"><?php esc_html_e( 'Replies Created', 'noor' ); ?></a>
					</span>
            </li>

			<?php if ( bbp_is_favorites_active() ) : ?>
                <li class="<?php if ( bbp_is_favorites() ) : ?>current<?php endif; ?>">
						<span class="bbp-user-favorites-link">
							<a href="<?php bbp_favorites_permalink(); ?>"
                               title="<?php printf( esc_attr__( "%s's Favorites", 'noor' ), bbp_get_displayed_user_field( 'display_name' ) ); ?>"><?php esc_html_e( 'Favorites', 'noor' ); ?></a>
						</span>
                </li>
			<?php endif; ?>

			<?php if ( bbp_is_user_home() || current_user_can( 'edit_users' ) ) : ?>

				<?php if ( bbp_is_subscriptions_active() ) : ?>
                    <li class="<?php if ( bbp_is_subscriptions() ) : ?>current<?php endif; ?>">
							<span class="bbp-user-subscriptions-link">
								<a href="<?php bbp_subscriptions_permalink(); ?>"
                                   title="<?php printf( esc_attr__( "%s's Subscriptions", 'noor' ), bbp_get_displayed_user_field( 'display_name' ) ); ?>"><?php esc_html_e( 'Subscriptions', 'noor' ); ?></a>
							</span>
                    </li>
				<?php endif; ?>

                <li class="<?php if ( bbp_is_single_user_edit() ) : ?>current<?php endif; ?>">
						<span class="bbp-user-edit-link">
							<a href="<?php bbp_user_profile_edit_url(); ?>"
                               title="<?php printf( esc_attr__( "Edit %s's Profile", 'noor' ), bbp_get_displayed_user_field( 'display_name' ) ); ?>"><?php esc_html_e( 'Edit', 'noor' ); ?></a>
						</span>
                </li>

			<?php endif; ?>

        </ul>
    </div><!-- #bbp-user-navigation -->
</div><!-- #bbp-single-user-details -->

<?php do_action( 'bbp_template_after_user_details' ); ?>
