<?php

/**
 * User Login Form
 *
 * @package bbPress
 * @subpackage Theme
 */
defined( 'ABSPATH' ) || exit;
?>

<div class="dima-bbp-form box">
    <form method="post" action="<?php bbp_wp_login_action( array( 'context' => 'login_post' ) ); ?>"
          class="bbp-login-form">
        <h3><?php esc_html_e( 'Login', 'noor' ); ?></h3>

        <fieldset class="bbp-form">
            <legend><?php esc_html_e( 'Log In', 'noor' ); ?></legend>

            <p class="dima-bbp-username">
                <label for="user_login"><?php esc_html_e( 'Username', 'noor' ); ?>: </label>
                <input type="text" class="input-text" name="log"
                       value="<?php bbp_sanitize_val( 'user_login', 'text' ); ?>" size="20" id="user_login"/>

            </p>

            <p class="dima-bbp-password">
                <label for="user_pass"><?php esc_html_e( 'Password', 'noor' ); ?>: </label>
                <input type="password" name="pwd" value="<?php bbp_sanitize_val( 'user_pass', 'password' ); ?>"
                       size="20" id="user_pass"/>
            </p>

            <p class="bbp-remember-me">
                <input type="checkbox" name="rememberme"
                       value="forever" <?php checked( bbp_get_sanitize_val( 'rememberme', 'checkbox' ) ); ?>
                       id="rememberme"/>
                <label for="rememberme"><?php esc_html_e( 'Keep me signed in', 'noor' ); ?></label>
            </p>

			<?php do_action( 'login_form' ); ?>

            <div class="bbp-submit-wrapper">

                <button type="submit" name="user-submit"
                        class="button submit user-submit"><?php esc_html_e( 'Log In', 'noor' ); ?></button>

				<?php bbp_user_login_fields(); ?>

            </div>
        </fieldset>
    </form>
</div>