<?php
/**
 * Plugin Name: Noor Assistant
 * Plugin URI: https://pixeldima.com
 * Description: This plugin is required to run Noor as it includes all of our shortcode functionality, which is tightly integrated into the theme
 * Author: PixelDima
 * Author URI: https://pixeldima.com
 * Tags: gutenberg, editor, block, layout, writing
 * Version: 3.0.9
 * Text Domain: noor-assistant
 * Domain Path: languages
 *
 * @author    PixelDima (https://pixeldima.com/)
 * @license   Themeforest https://themeforest.net/licenses/regular_extended
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die( 'No Naughty Business Please !' );
}

// Abort loading if WordPress is upgrading.
if ( defined( 'WP_INSTALLING' ) && WP_INSTALLING ) {
	return;
}

define( 'DIMA_NOOR_ASSISTANT', 'noor-assistant' );
define( 'DIMA_NOUR_ASSISTANT_VERSION', '3.0.9' );
define( 'DIMA_NOUR_ASSISTANT_URL', plugins_url( '', __FILE__ ) );
define( 'DIMA_NOUR_ASSISTANT_TEMPLATE_PATH', plugin_dir_path( __FILE__ ) );


/**
 * Check plugin requirements
 * ===========================================================================*/
// Don't check the requirements if it's frontend or DIMA_DUBUG set to false.
if ( is_admin() || false === get_transient( 'dima_plugin_requirements_check' ) ) {
	if ( ! class_exists( 'Dima_Plugin_Requirements' ) ) {
		require_once DIMA_NOUR_ASSISTANT_TEMPLATE_PATH . 'include/classes/class-dima-plugin-requirements.php';
	}

	$plugin_requirements               = new Dima_Plugin_Requirements();
	$plugin_requirements->requirements = array(
		'themes' => array(
			array(
				'name'                 => __( 'Noor', 'noor' ), // The theme name.
				'id'                   => 'noor', // The theme id name.
				'version'              => '3.2.0', // E.g. 1.0.0. If set, the active theme must be this version or higher.
				'is_callable'          => '', // If set, this callable will be be checked for availability to determine if a theme is active.
				'theme_requires_const' => 'DIMA_REQUIRED_VERSION',
				'file_required'        => array(
					get_template_directory() . '/framework/init/dependency.php',
					get_template_directory() . '/framework/init/constant.php',
				),
			),
		),
		'config' => array(
			'plugin_name'     => __( 'Noor Assistant', 'noor' ), // Current plugin name.
			'plugin_basename' => plugin_basename( __FILE__ ),
			'plugin_dir_path' => plugin_dir_path( __FILE__ ),
			'debug'           => false,
		),
	);
	// Check the requirements.
	$validation = $plugin_requirements->validate();


	// If the requirements were not met, dont initialize the plugin.
	if ( true !== $validation ) {
		delete_transient( 'dima_plugin_requirements_check' );
		return;
		// cache the validation result and skip the extra checks on frontend for cache period.
	} else {
		set_transient( 'dima_plugin_requirements_check', true, 15 * MINUTE_IN_SECONDS );
	}
}

/**
 * Initialize the plugin.
 */
class DIMA_NOUR_ASSISTANT_CLASS {

	/**
	 * Core singleton class
	 *
	 * @var self - pattern realization
	 */
	private static $_instance;

	/**
	 * Get the instane of dima_Theme_assistant
	 *
	 * @return self
	 */
	public static function getInstance() {
		if ( ! ( self::$_instance instanceof self ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	/**
	 * Constructor.
	 */
	public function __construct() {
		$dir = dirname( __FILE__ );
		$this->set_paths(
			array(
				'APP_DIR' => basename( $dir ),
			)
		);
		add_action( 'plugins_loaded', array( $this, 'dima_pluginsLoaded' ), 5 );
		add_action( 'init', array( $this, 'dima_noor_assistant_core_init' ), 6 );// 6
		add_action( 'init', array( $this, 'dima_add_vc_style' ) );
		add_action( 'init', array( $this, 'dima_add_vc_config' ) );
		add_action( 'init', array( $this, 'dima_add_vc' ), 12 );// after_setup_theme.
		register_activation_hook( __FILE__, array( $this, 'dima_activation_hook' ) );
		register_deactivation_hook( __FILE__, array( '$this', 'dima_deactivate_hook' ) );

		add_action( 'plugins_loaded', array( $this, 'dima_load_widgets' ), 12 );
	}

	/**
	 * Cloning disabled
	 */
	public function __clone() {
	}

	/**
	 * Serialization disabled
	 */
	public function __sleep() {
	}

	/**
	 * De-serialization disabled
	 */
	public function __wakeup() {
	}

	/**
	 * List of paths.
	 *
	 * @since 1.0.0
	 * @var array
	 */
	private $paths = array();

	/**
	 * Setter for paths
	 *
	 * @since 1.0.0
	 * @access protected
	 *
	 * @param $paths
	 */
	protected function set_paths( $paths ) {
		$this->paths = $paths;
	}

	/**
	 * Gets absolute path for file/directory in filesystem.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @param $name - name of path dir
	 * @param string                  $file - file name or directory inside path
	 *
	 * @return string
	 */
	public function path( $name, $file = '' ) {
		$path = $this->paths[ $name ] . ( strlen( $file ) > 0 ? '/' . preg_replace( '/^\//', '', $file ) : '' );

		return apply_filters( 'dima_shortcodes_path_filter', $path );
	}

	/**
	 * Undocumented function
	 *
	 * @return void
	 */
	public function dima_load_widgets() {
		/*
		 Widgets.
		*/
		require_once 'include/widgets/widget-about.php';
		require_once 'include/widgets/widget-twitter.php';
		require_once 'include/widgets/widget-facebook.php';
		if ( class_exists( 'Easy_Digital_Downloads' ) ) {
			require_once 'include/widgets/widget-edd-product-details.php';
		}
		require_once 'include/widgets/widget-instagram.php';
		require_once 'include/widgets/widget-login.php';
		require_once 'include/widgets/widget-feedburner.php';
		require_once 'include/widgets/widget-social.php';
		require_once 'include/widgets/widget-tabs.php';
		require_once 'include/widgets/widget-ads.php';
		require_once 'include/widgets/widget-adsense.php';
		require_once 'include/widgets/widget-text-html.php';
		require_once 'include/widgets/widget-slider.php';
	}

	/**
	 * Callback function WP plugin_loaded action hook. Loads locale
	 *
	 * @access public
	 */
	public function dima_pluginsLoaded() {
		do_action( 'dima_shortcodes_plugins_loaded' );
		load_plugin_textdomain( 'noor-assistant', false, $this->path( 'APP_DIR', 'languages' ) );
	}

	/**
	 * Undocumented function
	 *
	 * @return void
	 */
	public function dima_noor_assistant_core_init() {
		require_once 'include/helper.php';
		/**
		 * Custom posts type.
		 */

		require_once 'include/shortcodes.php';
		require_once 'include/scripts.php';
		require_once 'include/pixeldima-setup/setup.php';
		require_once 'include/phpquery/phpquery.php';
		require_once 'include/portfolio/dima-portfolio.php';
		require_once 'include/custom-post-type.php';
	}

	 /**
	  * add custom VC style
	  *
	  * @return void
	  */
	public function dima_add_vc_style() {
		if ( class_exists( 'Vc_Manager', false ) && class_exists( 'dima_helper' ) ) {
			require_once DIMA_NOUR_ASSISTANT_TEMPLATE_PATH . '/include/dima-extensions/vc_custom/dima-vc-style-js.php';
		}
	}

	/**
	 * add custom VC style
	 *
	 * @return void
	 */
	public function dima_add_vc_config() {
		if ( class_exists( 'Vc_Manager', false ) && class_exists( 'dima_helper' ) ) {
			require_once DIMA_NOUR_ASSISTANT_TEMPLATE_PATH . '/include/dima-extensions/vc_custom/dima-vc-config.php';
		}
	}

	 /**
	  * add custom VC elements
	  *
	  * @return void
	  */
	public function dima_add_vc() {
		if ( class_exists( 'Vc_Manager', false ) && class_exists( 'dima_helper' ) ) {
			require_once DIMA_NOUR_ASSISTANT_TEMPLATE_PATH . '/include/dima-extensions/vc_custom/dima-visual-composer.php';
		}
	}

	/**
	 * Register hooks that are fired when the plugin is activated or deactivated.
	 *
	 * @return void
	 */
	public function dima_activation_hook() {
		do_action( 'dima_activation_hook' );
	}
	/**
	 * Undocumented function
	 *
	 * @return void
	 */
	public function dima_deactivate_hook() {
		do_action( 'dima_deactivate_hook' );
	}
}
$DIMA_NOUR_ASSISTANT_CLASS = new DIMA_NOUR_ASSISTANT_CLASS();
if ( ! is_admin() && ! class_exists( 'AsyncJavaScriptFrontend' ) ) {
	require_once 'include/classes/class-dima-js-async.php';
	$dimaJsAsync = new DiamJsAsync();
}
