function dima_is_range_option(option_id) {
  const range_wrapper = jQuery(`#rangeInput-${option_id}`);
  const dima_min = parseFloat(range_wrapper.attr("data-min"));
  const dima_max = parseFloat(range_wrapper.attr("data-max"));
  const dima_step = parseFloat(range_wrapper.attr("data-step"));
  const dima_value = parseFloat(range_wrapper.attr("data-value"));
  range_wrapper.slider({
    value: dima_value,
    min: dima_min,
    max: dima_max,
    step: dima_step,
    slide(event, ui) {
      range_wrapper.siblings(".range-input-selector").val(ui.value);
    }
  });
}

function dima_visual_selector() {
  jQuery(".dima-visual-selector")
    .find("a")
    .each(function() {
      const $this = jQuery(this);
      const default_value = jQuery(this)
        .siblings("input")
        .val();
      if ($this.attr("rel") == default_value) {
        $this.addClass("current");
      }
      jQuery(this).click(function() {
        $this
          .siblings("input")
          .val(jQuery(this).attr("rel"))
          .trigger("change");
        $this
          .parent(".dima-visual-selector")
          .find(".current")
          .removeClass("current");
        $this.addClass("current");
        return false;
      });
    });
}

function dima_toggle_option(option_id) {
  const $this = jQuery(`#toggle-switch-${option_id}`);
  const $input = $this.find("input");
  //inactive
  if ($input.val() == "true") {
    $this.addClass("dima-toggle-on");
    $this.find(".button-animation").removeClass("inactive");
  } else {
    $this.addClass("dima-toggle-off");
    $this.find(".button-animation").addClass("inactive");
  }
  $this.click(() => {
    if ($this.hasClass("dima-toggle-on")) {
      $this.removeClass("dima-toggle-on").addClass("dima-toggle-off");
      $this.find(".button-animation").addClass("inactive");
      $input.val("false").trigger("change");
    } else {
      $this.removeClass("dima-toggle-off").addClass("dima-toggle-on");
      $this.find(".button-animation").removeClass("inactive");
      $input.val("true").trigger("change");
    }
  });
}
