<?php
/*
Plugin Name: DIMA-Shortcodes
Plugin URI: http://pixeldima.com/
Version: 1.0.0
Author: PixelDima
Author URI: http://pixeldima.com/
Text Domain: dima-shortcodes

*/

/**
 * Class and Function List:
 * Function list:
 * - dima_shortcode_woo()
 * Classes list:
 */

/**
 * Class DIMA_Woo_Shortcode
 */
class DIMA_Woo_Shortcode {
	private $is_paging = true;

	public function __construct() {
		add_shortcode( 'dima_woo', array( $this, 'dima_shortcode_woo' ) );
	}

	function dima_shortcode_woo( $atts ) {
		ob_start();
		extract(
			shortcode_atts(
				array(
					'post_class'       => '',
					'woo_style'        => '',
					'product_type'     => 'all',
					'count'            => 6,
					'column'           => 2,
					'category'         => '',
					'slide_pagination' => true,
					'woo_elm_hover'    => '',
					'auto_play'        => false,
					'filters'          => 'no',
					'paging'           => 'false',
					'orderby'          => 'title',
					'order'            => 'asc',
					'dark'             => '',
					'ajax'             => '',
				),
				$atts,
				'dima_woo'
			)
		);

		wp_enqueue_style( 'dima-woocommerce-style' );
		wp_enqueue_script( 'dima-js-woocommerce' );
		$classes         = array();
		$template        = dima_helper::dima_get_template();
		$classes[]       = ( $post_class != '' ) ? '' . esc_attr( $post_class ) : '';
		$category        = ( $category != '' ) ? $category : '';
		$woo_elm_hover   = ( $woo_elm_hover != '' ) ? $woo_elm_hover : '';
		$count           = ( $count != '' ) ? $count : 6;
		$dark            = ( $dark == '' ) ? 'true' : $dark;
		$paging          = ( $paging != 'true' ) ? false : true;
		$this->is_paging = $paging;

		if ( $woo_elm_hover == 'op_vc_inside' || $woo_style == 'slide' ) {
			$classes[] = 'dima_go_inside';
		}

		$is_slide   = false;
		$meta_query = WC()->query->get_meta_query();

		if ( $woo_style == 'slide' ) {
			$is_slide = true;
			wp_enqueue_script( 'slick.min' );
		}

		$filters_array = array(
			'filters'  => $filters,
			'category' => $category,
		);

		if ( ! empty( $category ) ) {
			$category = dima_helper::dima_get_slug_by_ids( $category, 'term_id', 'product_cat' );
		}

		if ( get_query_var( 'paged' ) ) {
			$paged = get_query_var( 'paged' );
		} elseif ( get_query_var( 'page' ) ) {
			$paged = get_query_var( 'page' );
		} else {
			$paged = 1;
		}
		if ( 'all' === $product_type ) {
			$array_query = array(
				'post_type'           => 'product',
				'post_status'         => 'publish',
				'ignore_sticky_posts' => 1,
				'orderby'             => $orderby,
				'order'               => $order,
				'posts_per_page'      => $count,
				'meta_query'          => $meta_query,
				'paged'               => "{$paged}",
				'product_cat'         => "{$category}",
			);
		} elseif ( 'sale' === $product_type ) {
			$array_query = array(
				'post_type'           => 'product',
				'post_status'         => 'publish',
				'ignore_sticky_posts' => 1,
				'orderby'             => $orderby,
				'order'               => $order,
				'posts_per_page'      => $count,
				'meta_query'          => $meta_query,
				'paged'               => "{$paged}",
				'product_cat'         => "{$category}",
				'post__in'            => array_merge( array( 0 ), wc_get_product_ids_on_sale() ),
			);
		} elseif ( 'featured' === $product_type ) {
			$meta_query  = WC()->query->get_meta_query();
			$tax_query   = WC()->query->get_tax_query();
			$tax_query[] = array(
				'taxonomy' => 'product_visibility',
				'field'    => 'name',
				'terms'    => 'featured',
				'operator' => 'IN',
			);
			$array_query = array(
				'post_type'           => 'product',
				'post_status'         => 'publish',
				'ignore_sticky_posts' => 1,
				'orderby'             => $orderby,
				'order'               => $order,
				'posts_per_page'      => $count,
				'paged'               => "{$paged}",
				'product_cat'         => "{$category}",
				'meta_query'          => $meta_query,
				'tax_query'           => $tax_query,
			);
		} elseif ( 'best_selling' === $product_type ) {
			$array_query = array(
				'post_type'           => 'product',
				'post_status'         => 'publish',
				'ignore_sticky_posts' => 1,
				'orderby'             => $orderby,
				'order'               => $order,
				'posts_per_page'      => $count,
				'meta_query'          => $meta_query,
				'meta_key'            => 'total_sales',
				'paged'               => "{$paged}",
				'product_cat'         => "{$category}",
				'tax_query'           => WC()->query->get_tax_query(),
			);
		}

		$WP_Query = new WP_Query( $array_query );

		$ARG_ARRAY = array(
			'blog_type'  => $woo_style,
			'post_class' => $classes,
		);

		$POST_ARRAY = array(
			'template'               => $template,
			'is_slide'               => $is_slide,
			'column'                 => $column,
			'count'                  => $count,
			'pagination'             => $slide_pagination,
			'auto_play'              => $auto_play,
			'items'                  => $column,
			'items_margin'           => '',
			'navigation'             => 'false',
			'loop'                   => 'false',
			'items_phone'            => '',
			'items_tablet'           => '',
			'dark'                   => $dark,
			'animation'              => 'transition.slideUpIn',
			'delay'                  => 30,
			'delay_offset'           => '98%',
			'delay_duration'         => 750,
			'data-dima-animate-item' => '.dima-product',
		);

		if ( $is_slide == '1' ) {
			$this->slide( $POST_ARRAY, $WP_Query, $ARG_ARRAY );
		} elseif ( $woo_style == 'grid' ) {
			$this->grid( $POST_ARRAY, $WP_Query, $ARG_ARRAY, $filters_array );
		} else {
			$this->list_style( $POST_ARRAY, $WP_Query, $ARG_ARRAY );
		}

		return ob_get_clean();
	}

	/**
	 * @param $POST_ARRAY
	 * @param $query_
	 */
	function slide( $POST_ARRAY, $query_, $ARG_ARRAY ) {

		if ( empty( $query_ ) ) {
			$query_ = new WP_Query( array( 'orderby' => 'date' ) );
		}

		$js_data = array(
			'dots'         => ( $POST_ARRAY['pagination'] == 'true' ) ? true : false,
			'autoplay'     => ( $POST_ARRAY['auto_play'] == 'true' ) ? true : false,
			'arrows'       => true,
			'infinite'     => true,
			'slidesToShow' => ( $POST_ARRAY['items'] == '' ) ? 1 : $POST_ARRAY['items'],
			'items_phone'  => ( $POST_ARRAY['items_phone'] == '' ) ? 1 : $POST_ARRAY['items_phone'],
			'items_tablet' => ( $POST_ARRAY['items_tablet'] == '' ) ? 2 : $POST_ARRAY['items_tablet'],
			'items_margin' => ( $POST_ARRAY['items_margin'] == '' ) ? 0 : $POST_ARRAY['items_margin'],
			'rtl'          => is_rtl(),
		);

		$classes   = array();
		$classes[] = join( ' ', $ARG_ARRAY['post_class'] );
		$classes[] = 'dima-slide-warp dima_slick_slider';
		$classes[] = $POST_ARRAY['dark'];
		$classes   = join( ' ', $classes );
		$data      = dima_creat_data_attributes( 'slick_slider', $js_data );

		?>
		<div class="<?php echo $POST_ARRAY['items']; ?>">
			<div class="products-grids products products-slide slick-with-margin<?php echo esc_attr( $classes ); ?>" <?php echo "$data"; ?>>
				<?php
				if ( $query_->have_posts() ) :
					while ( $query_->have_posts() ) :
						$query_->the_post();
						wc_get_template_part( 'content', 'product' );
					endwhile;
					wp_reset_postdata();
				else :
					dima_helper::dima_get_view( 'partials/contents', 'content-none' );
				endif;
				?>
			</div>
		</div>
		<?php
		wp_reset_query();
	}

	function list_style( $POST_ARRAY, $query_, $ARG_ARRAY ) {
		if ( empty( $query_ ) ) {
			$query_ = new WP_Query( array( 'orderby' => 'date' ) );
		}
		$animation_data = '';

		$animation_data .= ( $POST_ARRAY['animation'] != '' ) ? 'data-animate=' . $POST_ARRAY['animation'] . '' : '';
		$animation_data .= ( $POST_ARRAY['delay'] != '' ) ? ' data-delay=' . $POST_ARRAY['delay'] . '' : '';
		$animation_data .= ( $POST_ARRAY['delay_offset'] != '' ) ? ' data-offset=' . $POST_ARRAY['delay_offset'] . '' : '';
		$animation_data .= ( $POST_ARRAY['data-dima-animate-item'] != '' ) ? ' data-dima-animate-item=' . $POST_ARRAY['data-dima-animate-item'] . '' : '';
		$animation_data .= '';

		if ( is_archive() || is_home() || ( is_singular() && is_page() ) ) {
			$ARG_ARRAY['post_class'] = ' ok-md-12 ok-sd-6 ok-xsd-6';
		}
		$classes   = array();
		$classes[] = 'clearfix';
		$classes   = join( ' ', $classes );
		?>
		<div class="<?php echo esc_attr( $classes ); ?>" <?php echo $animation_data; ?>>
			<?php
			if ( $query_->have_posts() ) :
				?>
				<div class="products-list">
				<?php
				while ( $query_->have_posts() ) :
					$query_->the_post();
					wc_get_template_part( 'content', 'product' );
				endwhile;
				?>
				</div>
				<?php

				wp_reset_postdata();
			else :
				dima_helper::dima_get_view( 'partials/contents', 'content-none' );
			endif;
			?>
		</div>
		<?php
		if ( $this->is_paging ) {
			dima_pagination( $query_ );
		}
		?>
		<?php wp_reset_query(); ?>
		<?php
	}

	/**
	 * Grid Style
	 *
	 * @param [type] $POST_ARRAY
	 * @param [type] $query_
	 * @param [type] $ARG_ARRAY
	 * @param [type] $filters_array
	 * @return void
	 */
	function grid( $POST_ARRAY, $query_, $ARG_ARRAY, $filters_array ) {
		if ( empty( $query_ ) ) {
			$query_ = new WP_Query( array( 'orderby' => 'date' ) );
		}

		$animation_data  = '';
		$animation_data .= ( $POST_ARRAY['animation'] != '' ) ? 'data-animate=' . $POST_ARRAY['animation'] . '' : '';
		$animation_data .= ( $POST_ARRAY['delay'] != '' ) ? ' data-delay=' . $POST_ARRAY['delay'] . '' : '';
		$animation_data .= ( $POST_ARRAY['delay_offset'] != '' ) ? ' data-offset=' . $POST_ARRAY['delay_offset'] . '' : '';
		$animation_data .= ( $POST_ARRAY['data-dima-animate-item'] != '' ) ? ' data-dima-animate-item=' . $POST_ARRAY['data-dima-animate-item'] . '' : '';
		$animation_data .= ( $POST_ARRAY['delay_duration'] != '' ) ? ' data-duration=' . $POST_ARRAY['delay_duration'] . '' : '';
		$classes         = array();
		$show_filters    = $filters_array['filters'] != 'no' && $filters_array['filters'] != 'false';

		$id = '';

		if ( is_archive() || is_home() || ( is_singular() && is_page() ) ) {
			$classes[] = join( ' ', $ARG_ARRAY['post_class'] );
			$classes[] = 'products-grids products';
			if ( $show_filters ) {
				wp_enqueue_script( 'isotope.pkgd' );
				$classes[] = 'dima-isotope-container';
				$id        = 'id=dima-isotope-container';
			}
		}

		$classes[] = 'dcl-m-' . $POST_ARRAY['column'];
		$classes[] = 'clearfix';
		$classes   = join( ' ', $classes );

		?>
		<div <?php esc_attr_e( $id ); ?> class="dima-isotope-wrapper clearfix">
			<?php
			if ( $show_filters ) {
				dima_portfolio_filters( $filters_array, 'woo' );
			}
			?>
			<div class="<?php echo esc_attr( $classes ); ?>" <?php echo $animation_data; ?>>
				<div class="dima-blocks dima-justify-start flex-wrap flex">
					<?php
					if ( $query_->have_posts() ) :
						while ( $query_->have_posts() ) :
							$query_->the_post();
							wc_get_template_part( 'content', 'product' );
						endwhile;
						wp_reset_postdata();
					else :
						dima_helper::dima_get_view( 'partials/contents', 'content-none' );
					endif;
					?>
				</div>
			</div>
		</div>
		<?php
		if ( $this->is_paging ) {
			dima_pagination( $query_ );
		}
		?>
		<?php wp_reset_query(); ?>
		<?php
	}

}

if ( class_exists( 'WC_API' ) ) {
	new DIMA_Woo_Shortcode();
}
?>
