<?php

$html = '<div class="dima-shape-divider dima-shape-divider--stick">
			<div class="shape__container">
				<div class="shape">
				</div>
			</div>
		</div>';

$style       = $view_params['style'];
$size        = $view_params['size'];
$shape_color = $view_params['shape_color'];
$bg_color    = $view_params['bg_color'];
$el_class    = $view_params['el_class'];

$html = phpQuery::newDocument( $html );
$id   = uniqid();

$pattern_path    = $pattern_width = $pattern_width_viewbox = $pattern_height = '';
$shape_box       = pq( '.dima-shape-divider' );
$shape_container = $shape_box->find( '.shape__container' );

$shape_box->attr( 'id', 'dima-shape-divider-' . $id );

$shape_box->addClass( $style . '-style' );
$shape_box->addClass( $size . '-size' );
$shape_box->addClass( $el_class );
$is_top     = ( strpos( $style, '-top' ) !== false ) ? false : true;
$stickClass = ( $is_top ) ? 'dima-shape-divider--stick-bottom' : 'dima-shape-divider--stick-top';
$shape_box->filter( '.dima-shape-divider--stick' )->addClass( $stickClass );

$shape_color = $shape_color !== '' ? $shape_color : 'transparent';

// Shape Svg Settings
/*--------*/

if ( $style == 'big-wave-top' ) {
	$pattern_path          = '<path class="st0" d="M0,3.7C190,79,390.3,116.7,601,116.7c316,0,370.9-114.9,729.2-114.9c238.8,0,435.5,38.3,589.9,114.8L1920,0H0 V3.7z" fill="' . $shape_color . '"/> ';
	$pattern_width         = '100%';
	$pattern_width_viewbox = '100';
	$pattern_height        = '115';
} elseif ( $style == 'big-wave-bottom' ) {
	$pattern_path          = '<path d="M2000,113.06 C1802.08667,37.6866667 1593.42,0 1374,0 C1044.9,0 987.64,114.88 614.47,114.88 C365.703333,114.88 160.88,76.62 0,0.1 L0.09,116.73 L2000,116.73 L2000,113.06 Z" fill="' . $shape_color . '"></path>';
	$pattern_width         = '100%';
	$pattern_width_viewbox = '100';
	$pattern_height        = '115';
} elseif ( $style == 'diagonal-bottom' ) {
	if ( $size == 'small' ) {
		$pattern_path          = '<polygon fill="' . $shape_color . '" points="100,70 100,0 0,70 "/>';
		$pattern_width         = '100%';
		$pattern_width_viewbox = '100';
		$pattern_height        = '70';
	} elseif ( $size == 'big' ) {
		$pattern_path          = '<polygon fill="' . $shape_color . '" points="100,0 100,130 0,130 "/>';
		$pattern_width         = '100%';
		$pattern_width_viewbox = '100';
		$pattern_height        = '130';
	}
} elseif ( $style == 'diagonal-top' ) {
	if ( $size == 'small' ) {
		$pattern_path          = '<polygon fill="' . $shape_color . '" points="0,0 0,70 100,0 "/>';
		$pattern_width         = '100%';
		$pattern_width_viewbox = '100';
		$pattern_height        = '70';
	} elseif ( $size == 'big' ) {
		$pattern_path          = '<polygon fill="' . $shape_color . '" points="0,130 0,0 100,0 "/>';
		$pattern_width         = '100%';
		$pattern_width_viewbox = '100';
		$pattern_height        = '130';
	}
} elseif ( $style == 'peaked-top' ) {
	if ( $size == 'small' ) {
		$pattern_path          = '<polygon points="25,25,0,0,50,0" fill="' . $shape_color . '"/>';
		$pattern_width         = '50px';
		$pattern_width_viewbox = '50';
		$pattern_height        = '25';
	} elseif ( $size == 'big' ) {
		$pattern_path          = '<polygon points="50,50,0,0,100,0" fill="' . $shape_color . '"/>';
		$pattern_width         = '100px';
		$pattern_width_viewbox = '100';
		$pattern_height        = '50';
	}
} elseif ( $style == 'peaked-bottom' ) {
	if ( $size == 'small' ) {
		$pattern_path          = '<polygon points="25,0,50,25,0,25" fill="' . $shape_color . '"/>';
		$pattern_width         = '50px';
		$pattern_width_viewbox = '50';
		$pattern_height        = '25';
	} elseif ( $size == 'big' ) {
		$pattern_path          = '<polygon points="50,0,100,50,0,50" fill="' . $shape_color . '"/>';
		$pattern_width         = '100px';
		$pattern_width_viewbox = '100';
		$pattern_height        = '50';
	}
} elseif ( $style == 'small-waves-top' ) {
	if ( $size == 'small' ) {
		$pattern_path          = '<path d=" M -0.004 0.008 Q 8.25 15.021 22.494 15.021 Q 36.738 15.021 44.992 0.008 L -0.004 0.008 Z " fill="' . $shape_color . '"/>';
		$pattern_width         = '45px';
		$pattern_width_viewbox = '45';
		$pattern_height        = '15';
	} elseif ( $size == 'big' ) {
		$pattern_path          = '<path d=" M 90 0 Q 73.491 30 45 30 Q 16.509 30 0 0 L 90 0 Z " fill="' . $shape_color . '"/>';
		$pattern_width         = '90px';
		$pattern_width_viewbox = '90';
		$pattern_height        = '30';
	}
} elseif ( $style == 'small-waves-bottom' ) {
	if ( $size == 'small' ) {
		$pattern_path          = '<path d=" M 44.992 15.021 Q 36.738 0.008 22.494 0.008 Q 8.25 0.008 -0.004 15.021 L 44.992 15.021 Z " fill="' . $shape_color . '"/>';
		$pattern_width         = '45px';
		$pattern_width_viewbox = '45';
		$pattern_height        = '15';
	} elseif ( $size == 'big' ) {
		$pattern_path          = '<path d=" M 0 30 Q 16.509 0 45 0 Q 73.491 0 90 30 L 0 30 Z " fill="' . $shape_color . '"/>';
		$pattern_width         = '90px';
		$pattern_width_viewbox = '90';
		$pattern_height        = '30';
	}
} /*----------*/

if ( $style == 'drop-top' || $style == 'drop-bottom' ) {
	$shape_container->find( '.shape' )->append(
		'
		<div class="drop-left"></div>
		<div class="drop-right"></div>
		<div class="clearfix"></div>
	'
	);
} elseif ( $style != 'big-wave-top' && $style != 'big-wave-bottom' ) {
	$shape_container->find( '.shape' )->append(
		'
		<svg xmlns="http://www.w3.org/2000/svg" width="100%" height="' . $pattern_height . 'px">
			<defs>
			    <pattern id="shapeDividerPattern-' . $id . '" preserveAspectRatio="none" style="background-repeat: none;" patternUnits="userSpaceOnUse" x="0" y="0" width="' . $pattern_width . '" height="' . $pattern_height . '0px" viewBox="0 0 ' . $pattern_width_viewbox . ' ' . $pattern_height . '0" >
			        ' . $pattern_path . '
			    </pattern>
			</defs>
			<!-- Background -->
			<rect x="0" y="0" width="100%" height="' . $pattern_height . 'px" fill="url(#shapeDividerPattern-' . $id . ')" />
		</svg>
	'
	);
} else {
	$shape_container->find( '.shape' )->append(
		'
		<svg xmlns="http://www.w3.org/2000/svg" width="100%" height="' . $pattern_height . 'px">
			<g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
				<g>
				<g id="shapeDividerPattern-' . $id . '" preserveAspectRatio="none" style="background-repeat: none;" patternUnits="userSpaceOnUse" x="0" y="0" width="' . $pattern_width . '" height="' . $pattern_height . '0px" viewBox="0 0 ' . $pattern_width_viewbox . ' ' . $pattern_height . '0" >
				' . $pattern_path . '
				</g>
				<rect x="0" y="0" width="100%" height="' . $pattern_height . 'px" fill="url(#shapeDividerPattern-' . $id . ')"/>
			</g>
			</g>
		</svg>
	'
	);
}


/**
 * Custom CSS Output
 * ==================================================================================*/
DIMA_Style::dima_addCSS(
	'
	#dima-shape-divider-' . $id . ' .shape__container {
 		background-color: ' . $bg_color . ';
 	}
	/* @-moz-document url-prefix() { */
		#dima-shape-divider-' . $id . ' .shape__container .shape {
			overflow: hidden;
			height: ' . $pattern_height . 'px;
		}
	/* } */
 ',
	$id
);

if ( $is_top == true ) {
	DIMA_Style::dima_addCSS(
		'
		/* @-moz-document url-prefix() { */
			#dima-shape-divider-' . $id . ' .shape__container .shape svg {
				position: relative;
				top: 0.6px;
			}
		/* } */
	',
		$id
	);
} else {
	DIMA_Style::dima_addCSS(
		'
		/* @-moz-document url-prefix() { */
			#dima-shape-divider-' . $id . ' .shape__container .shape svg {
				position: relative;
				top: -0.6px;
			}
		/* } */
	',
		$id
	);
}

if ( 'drop-bottom' === $style || 'drop-top' === $style ) {
	DIMA_Style::dima_addCSS(
		'
		#dima-shape-divider-' . $id . ' .shape__container .shape .drop-left,
		#dima-shape-divider-' . $id . ' .shape__container .shape .drop-right {
			background-color: ' . $shape_color . ';
		}
	',
		$id
	);
}
print $html;
