<?php
/*
Plugin Name: DIMA-Shortcodes
Plugin URI: http://pixeldima.com/
Version: 1.0.0
Author: PixelDima
Author URI: http://pixeldima.com/
Text Domain: dima-shortcodes

*/

/**
 * Class and Function List:
 * Function list:
 * - dima_shortcode_portfolio()
 * Classes list:
 */

/**
 * Class DIMA_Portfolio_Shortcode
 */
class DIMA_Portfolio_Shortcode {

	private $G_pagination = true;

	public function __construct() {
		add_shortcode( 'portfolio', array( $this, 'dima_shortcode_portfolio' ) );
	}

	function dima_shortcode_portfolio( $atts ) {
		ob_start();
		extract(
			shortcode_atts(
				array(
					'id'               => '',
					'style'            => '',
					'post_class'       => '',
					'portfolio_style'  => '',
					'count'            => 6,
					'column'           => 2,
					'img_hover'        => '',
					'elm_hover'        => '',
					'no_margin'        => 'false',
					'category'         => '',
					'dark'             => '',
					'slide_pagination' => true,
					'slide_arrows'     => true,
					'auto_play'        => false,
					'loop'             => false,
					'filters'          => 'no',
					'offset'           => '',
					'ajax'             => '',
					'orderby'          => 'title',
					'order'            => 'asc',
					'paging'           => 'false',
				),
				$atts,
				'portfolio'
			)
		);

		$template        = dima_helper::dima_get_template();
		$post_class      = ( $post_class != '' ) ? ' ' . esc_attr( $post_class ) : '';
		$category        = ( $category != '' ) ? $category : '';
		$elm_hover       = ( $elm_hover != '' ) ? $elm_hover : '';
		$img_hover       = ( $img_hover != '' ) ? $img_hover : '';
		$paging          = dima_helper::dima_am_i_true( $paging );
		$dark            = ( $dark == '' ) ? 'true' : $dark;
		$is_slide        = false;
		$no_margin       = dima_helper::dima_am_i_true( $no_margin );
		$this->is_paging = $paging;
		$tag             = '';

		if ( $no_margin && $elm_hover != 'op_vc_none' ) {
			$elm_hover = 'op_vc_inside';
		}
		if ( $portfolio_style == 'slide' ) {
			$is_slide = true;
			$filters  = 'no';
			wp_enqueue_script( 'slick.min' );
		}

		if ( get_query_var( 'paged' ) ) {
			$paged = get_query_var( 'paged' );
		} elseif ( get_query_var( 'page' ) ) {
			$paged = get_query_var( 'page' );
		} else {
			$paged = 1;
		}

		if ( $offset != '' && $paging == true ) {
			$offset = ( $paged - $offset ) * $count;
		}

		$filters_array = array(
			'filters'  => $filters,
			'category' => $category,
		);
		if ( is_archive() ) {
			$page_object = get_queried_object();
			if ( ! empty( $page_object ) && isset( $page_object->taxonomy ) ) {
				if ( $page_object->taxonomy == 'portfolio-category' ) {
					$category = $page_object->slug;
				} elseif ( $page_object->taxonomy == 'portfolio-tag' ) {
					$tag = $page_object->slug;
				}
			}
		} else {
			if ( ! empty( $category ) ) {
				$category = dima_helper::dima_get_slug_by_ids( $category, 'term_id', 'portfolio-category' );
			}
		}
		// For search.
		if ( isset( $_GET['s'] ) ) {
			$array_query = array(
				'post_type'          => 'dima-portfolio',
				'posts_per_page'     => "{$count}",
				's'                  => "{$_GET['s']}",
				'paged'              => "{$paged}",
				'offset'             => "{$offset}",
				'portfolio-category' => "{$category}",
				'portfolio-tag'      => "{$tag}",
				'orderby'            => "{$orderby}",
				'order'              => "{$order}",
			);
			$WP_Query    = new WP_Query( $array_query );
			$this->query = $WP_Query;
		} else {
			if ( $paging ) {
				$array_query = array(
					'post_type'          => 'dima-portfolio',
					'posts_per_page'     => "{$count}",
					'paged'              => "{$paged}",
					'offset'             => "{$offset}",
					'portfolio-category' => "{$category}",
					'portfolio-tag'      => "{$tag}",
					'orderby'            => "{$orderby}",
					'order'              => "{$order}",
				);
				$WP_Query    = new WP_Query( $array_query );
				$this->query = $WP_Query;
			} else {
				$array_query = array(
					'post_type'          => 'dima-portfolio',
					'posts_per_page'     => "{$count}",
					'offset'             => "{$offset}",
					'portfolio-category' => "{$category}",
					'portfolio-tag'      => "{$tag}",
					'orderby'            => "{$orderby}",
					'order'              => "{$order}",
				);
				$WP_Query    = new WP_Query( $array_query );

				$this->G_pagination = false;
			}
		}

		$ARG_ARRAY = array(
			'no_margin'              => $no_margin,
			'elm_hover'              => $elm_hover,
			'img_hover'              => $img_hover,
			'blog_type'              => $portfolio_style,
			'post_class'             => $post_class,
			'animation'              => 'transition.slideUpIn',
			'delay'                  => 10,
			'delay_offset'           => '98%',
			'delay_duration'         => 300,
			'data-dima-animate-item' => '.isotope-item',
		);

		$clm = dima_helper::dima_get_clm( $column );

		$POST_ARRAY = array(
			'template'     => $template,
			'is_slide'     => $is_slide,
			'column'       => $column,
			'clm'          => $clm,
			'count'        => $count,
			'pagination'   => $slide_pagination,
			'auto_play'    => $auto_play,
			'arrows'       => $slide_arrows,
			'loop'         => $loop,
			'items'        => $column,
			'items_phone'  => '',
			'items_tablet' => '',
			'no_margin'    => $no_margin,
			'dark'         => $dark,
		);

		$this->portfolio_type( $POST_ARRAY, $WP_Query, $ARG_ARRAY, $filters_array );

		return ob_get_clean();

	}

	/**
	 * @param $POST_ARRAY
	 * @param $WP_Query
	 * @param $ARG_ARRAY
	 * @param $filters_array
	 */
	public function portfolio_type( $POST_ARRAY, $WP_Query, $ARG_ARRAY, $filters_array ) {
		$portfolio_type = $ARG_ARRAY['blog_type'];
		if ( empty( $WP_Query ) ) {
			$WP_Query = new WP_Query( array( 'orderby' => 'date' ) );
		}
		if ( $portfolio_type != '' ) {
			$this->$portfolio_type( $POST_ARRAY, $WP_Query, $ARG_ARRAY, $filters_array );
		} else {
			$this->masonry( $POST_ARRAY, $WP_Query, $ARG_ARRAY, $filters_array );
		}
	}


	/**
	 * @param $POST_ARRAY
	 * @param $portfolio
	 * @param $ARG_ARRAY
	 * @param $filters_array
	 */
	function grid( $POST_ARRAY, $portfolio, $ARG_ARRAY, $filters_array ) {

		$data    = '';
		$classes = array();
		$id      = '';

		$animation_data  = '';
		$animation_data .= ( $ARG_ARRAY['animation'] != '' ) ? 'data-animate=' . $ARG_ARRAY['animation'] . '' : '';
		$animation_data .= ( $ARG_ARRAY['delay'] != '' ) ? ' data-delay=' . $ARG_ARRAY['delay'] . '' : '';
		$animation_data .= ( $ARG_ARRAY['delay_offset'] != '' ) ? ' data-offset=' . $ARG_ARRAY['delay_offset'] . '' : '';
		$animation_data .= ( $ARG_ARRAY['data-dima-animate-item'] != '' ) ? ' data-dima-animate-item=' . $ARG_ARRAY['data-dima-animate-item'] . '' : '';
		$animation_data .= ( $ARG_ARRAY['delay_duration'] != '' ) ? ' data-duration=' . $ARG_ARRAY['delay_duration'] . '' : '';
		$show_filters    = $filters_array['filters'] != 'no' && $filters_array['filters'] != 'false';
		if ( is_archive() || is_home() || ( is_singular() && is_page() ) ) {
			if ( $show_filters ) {
				wp_enqueue_script( 'isotope.pkgd' );
				$ARG_ARRAY['post_class'] .= ' isotope-item';
				$classes[]                = 'dima-isotope-container';
			}
		}

		if ( $POST_ARRAY['no_margin'] ) {
			$classes[] = 'slick-no-margin slick-noor-margin dcl-m-' . $POST_ARRAY['column'];
		} else {
			$classes[]                = 'slick-with-margin dcl-m-' . $POST_ARRAY['column'];
			$ARG_ARRAY['post_class'] .= ' article-separation';
		}

		$classes = join( ' ', $classes );
		?>
		<div class="dima-isotope-wrapper">
			<?php
			if ( $show_filters ) {
				dima_portfolio_filters( $filters_array, 'portfolio' );
			}
			?>
			<div <?php esc_attr_e( $id ); ?> class="<?php esc_attr_e( $classes ); ?>"
								   <?php
									echo $data;
									echo $animation_data
									?>
			 >
				<div class="dima-blocks dima-justify-start flex-wrap flex">
					<?php
					if ( $portfolio->have_posts() ) :
						while ( $portfolio->have_posts() ) :
							$portfolio->the_post();
							dima_helper::dima_get_view_with_args( 'portfolio', 'content', 'portfolio', $ARG_ARRAY );
						endwhile;
						wp_reset_postdata();
					endif;
					?>
				</div>
			</div>
		</div>
		<?php
		if ( $this->G_pagination ) {
			dima_pagination( $portfolio );
		}
		?>
		<?php wp_reset_query(); ?>
		<?php
	}

	/**
	 * @param $POST_ARRAY
	 * @param $portfolio
	 * @param $ARG_ARRAY
	 * @param $filters_array
	 */
	function masonry( $POST_ARRAY, $portfolio, $ARG_ARRAY, $filters_array ) {
		wp_enqueue_script( 'isotope.pkgd' );
		$id      = '';
		$classes = array();
		if ( is_archive() || is_home() || ( is_singular() && is_page() ) ) {
			$ARG_ARRAY['post_class'] .= ' isotope-item';
			$ARG_ARRAY['post_class'] .= ' ' . $POST_ARRAY['clm'];
		}

		if ( $POST_ARRAY['no_margin'] ) {
			$classes[] = 'slick-no-margin slick-noor-margin dcl-m-' . $POST_ARRAY['column'];
		} else {
			$classes[]                = 'slick-with-margin dcl-m-' . $POST_ARRAY['column'];
			$ARG_ARRAY['post_class'] .= ' article-separation';
		}

		$show_filters    = $filters_array['filters'] != 'no' && $filters_array['filters'] != 'false';
		$animation_data  = '';
		$animation_data .= ( $ARG_ARRAY['animation'] != '' ) ? 'data-animate=' . $ARG_ARRAY['animation'] . '' : '';
		$animation_data .= ( $ARG_ARRAY['delay'] != '' ) ? ' data-delay=' . $ARG_ARRAY['delay'] . '' : '';
		$animation_data .= ( $ARG_ARRAY['delay_offset'] != '' ) ? ' data-offset=' . $ARG_ARRAY['delay_offset'] . '' : '';
		$animation_data .= ( $ARG_ARRAY['data-dima-animate-item'] != '' ) ? ' data-dima-animate-item=' . $ARG_ARRAY['data-dima-animate-item'] . '' : '';
		$animation_data .= ( $ARG_ARRAY['delay_duration'] != '' ) ? ' data-duration=' . $ARG_ARRAY['delay_duration'] . '' : '';
		$classes[]       = 'dima-isotope-container grid-masonry';
		$classes[]       = $ARG_ARRAY['no_margin'];
		$classes         = join( ' ', $classes );
		?>
		<div class="dima-isotope-wrapper">
			<?php
			if ( $show_filters ) {
				dima_portfolio_filters( $filters_array, 'portfolio' );
			}
			?>
			<div class="boxed-blog blog-list dima-layout-masonry" <?php echo $animation_data; ?>>
				<div <?php esc_attr_e( $id ); ?> class="<?php esc_attr_e( $classes ); ?>">
					<div class="dima-blocks dima-justify-start flex-wrap flex">
						<?php
						if ( $portfolio->have_posts() ) :
							while ( $portfolio->have_posts() ) :
								$portfolio->the_post();
								dima_helper::dima_get_view_with_args( 'portfolio', 'content', 'portfolio', $ARG_ARRAY );
							endwhile;
							wp_reset_postdata();
						endif;
						?>
					</div>
				</div>
			</div>
		</div>
		<?php
		if ( $this->G_pagination ) {
			dima_pagination( $portfolio );
		}
		wp_reset_query();
	}

	function slide( $POST_ARRAY, $wp_query, $ARG_ARRAY, $filters_array ) {
		$ARG_ARRAY['blog_type'] = 'grid';
		$js_data                = array(
			'dots'         => ( $POST_ARRAY['pagination'] == 'true' ) ? true : false,
			'autoplay'     => ( $POST_ARRAY['auto_play'] == 'true' ) ? true : false,
			'arrows'       => ( $POST_ARRAY['arrows'] == 'true' ) ? true : false,
			'infinite'     => ( $POST_ARRAY['loop'] == 'true' ),
			'slidesToShow' => ( $POST_ARRAY['items'] == '' ) ? 1 : $POST_ARRAY['items'],
			'items_phone'  => ( $POST_ARRAY['items_phone'] == '' ) ? 1 : $POST_ARRAY['items_phone'],
			'items_tablet' => ( $POST_ARRAY['items_tablet'] == '' ) ? 2 : $POST_ARRAY['items_tablet'],
			'draggable'    => true,
			'rtl'          => is_rtl(),
		);

		$slick_class = '' . $POST_ARRAY['dark'] . ' ';
		$data        = dima_creat_data_attributes( 'slick_slider', $js_data );

		if ( $POST_ARRAY['no_margin'] ) {
			$slick_class .= ' slick-no-margin slick-noor-margin';
		} else {
			$slick_class .= ' slick-with-margin';
		}
		?>
		<div class="<?php echo $slick_class; ?> boxed-blog blog-lis dima-layout-slide" <?php echo "$data"; ?>>
			<?php
			if ( $wp_query->have_posts() ) {
				while ( $wp_query->have_posts() ) :
					$wp_query->the_post();
					dima_helper::dima_get_view_with_args( 'portfolio', 'content', 'portfolio', $ARG_ARRAY );
				endwhile;
				wp_reset_postdata();
			}
			?>
		</div>
		<?php
		if ( $this->is_paging ) {
			ob_start();
			dima_pagination( $wp_query );
			$pagination = ob_get_contents();
			ob_get_clean();
			echo $pagination;
		}
		wp_reset_query();
	}
}

new DIMA_Portfolio_Shortcode();
