<?php
/*
Plugin Name: DIMA-Shortcodes
Plugin URI: http://pixeldima.com/
Version: 1.0.0
Author: PixelDima
Author URI: http://pixeldima.com/
Text Domain: dima-shortcodes

*/

/**
 * Class and Function List:
 * Function list:
 * - dima_shortcode_woo()
 * Classes list:
 */

/**
 * Class DIMA_Woo_Shortcode
 */
class DIMA_EDD_Shortcode {
	private $is_paging = true;

	public function __construct() {
		add_shortcode( 'dima_edd', array( $this, 'dima_shortcode_edd' ) );
	}

	function dima_shortcode_edd( $atts ) {
		ob_start();
		extract(
			shortcode_atts(
				array(
					'post_class'       => '',
					'edd_style'        => '',
					'ids'              => '',
					'count'            => get_option( 'posts_per_page' ),
					'column'           => 2,
					'category'         => '',
					'words'            => '',
					'slide_pagination' => true,
					'edd_elm_hover'    => '',
					'auto_play'        => false,
					'filters'          => 'no',
					'paging'           => 'false',
					'orderby'          => 'title',
					'order'            => 'asc',
					'author_display'   => true,
					'dark'             => '',
					'ajax'             => '',
				),
				$atts,
				'dima_edd'
			)
		);

		$template      = dima_helper::dima_get_template();
		$post_class    = ( $post_class != '' ) ? 'dima-edd ' . esc_attr( $post_class ) : 'dima-edd ';
		$category      = ( $category != '' ) ? $category : '';
		$edd_elm_hover = ( $edd_elm_hover != '' ) ? $edd_elm_hover : '';
		$count         = ( $count != '' ) ? $count : 6;
		$dark          = ( $dark == '' ) ? 'true' : $dark;
		$paging        = ( $paging != 'true' ) ? false : true;
		$words         = ( $words != '' ) ? $words : 0;

		$this->is_paging = $paging;
		if ( $edd_elm_hover == 'op_vc_inside' ) {
			$post_class .= ' dima_go_inside';
		}
		if ( dima_helper::dima_am_i_true( $author_display ) ) {
			$post_class .= ' hide_author';
		}

		$is_slide = false;

		if ( $edd_style == 'slide' ) {
			$edd_style = 'grid';
			$is_slide  = true;
			$filters   = 'no';
			wp_enqueue_script( 'slick.min' );
		}

		$filters_array = array(
			'filters'  => $filters,
			'category' => $category,
		);

		if ( get_query_var( 'paged' ) ) {
			$paged = get_query_var( 'paged' );
		} elseif ( get_query_var( 'page' ) ) {
			$paged = get_query_var( 'page' );
		} else {
			$paged = 1;
		}

		if ( ! empty( $category ) ) {
			$category                         = dima_helper::dima_get_slug_by_ids( $category, 'term_id', 'download_category' );
			$array_query['download_category'] = $category;
		}

		if ( isset( $_GET['s'] ) ) {
			$array_query = array(
				'post_type'     => 'download',
				's'             => "{$_GET['s']}",
				'paged'         => "{$paged}",
				'category_name' => "{$category}",
				'order'         => $order,
			);
		} else {
			$array_query = array(
				'post_type'         => 'download',
				'order'             => $order,
				'posts_per_page'    => $count,
				'paged'             => "{$paged}",
				'download_category' => "{$category}",
			);
		}

		switch ( $orderby ) {
			case 'price':
				$array_query['orderby']  = 'meta_value';
				$array_query['meta_key'] = 'edd_price';
				$array_query['orderby']  = 'meta_value_num';
				break;

			case 'title':
				$array_query['orderby'] = 'title';
				break;

			case 'ID':
				$array_query['orderby'] = 'ID';
				break;

			case 'rand':
				$array_query['orderby'] = 'rand';
				break;

			case 'post__in':
				$array_query['orderby'] = 'post__in';
				break;

			default:
				$array_query['orderby'] = 'post_date';
				break;
		}

		if ( ! empty( $atts['ids'] ) ) {
			$array_query['post__in'] = explode( ',', $atts['ids'] );
		}

		$array_query = apply_filters( 'edd_downloads_query', $array_query, $atts );
		$WP_Query    = new WP_Query( $array_query );
		$ARG_ARRAY   = array(
			'blog_type'  => $edd_style,
			'post_class' => $post_class,
			'words'      => $words,
		);

		$clm = dima_helper::dima_get_clm( $column );

		$POST_ARRAY = array(
			'template'               => $template,
			'is_slide'               => $is_slide,
			'column'                 => $column,
			'clm'                    => $clm,
			'count'                  => $count,
			'pagination'             => $slide_pagination,
			'auto_play'              => $auto_play,
			'items'                  => $column,
			'items_margin'           => '',
			'navigation'             => 'false',
			'loop'                   => 'false',
			'items_phone'            => '',
			'items_tablet'           => '',
			'dark'                   => $dark,
			'animation'              => 'transition.slideUpIn',
			'delay'                  => 30,
			'delay_offset'           => '98%',
			'delay_duration'         => 750,
			'data-dima-animate-item' => '.download',
		);

		if ( $is_slide == '1' ) {
			$this->slide( $POST_ARRAY, $WP_Query, $ARG_ARRAY );
		} elseif ( $edd_style == 'grid' ) {
			$this->grid( $POST_ARRAY, $WP_Query, $ARG_ARRAY, $filters_array );
		}

		return ob_get_clean();
	}

	function grid( $POST_ARRAY, $query_, $ARG_ARRAY, $filters_array ) {
		if ( empty( $query_ ) ) {
			$query_ = new WP_Query( array( 'orderby' => 'date' ) );
		}
		$show_filters    = $filters_array['filters'] != 'no' && $filters_array['filters'] != 'false';
		$animation_data  = $id = '';
		$animation_data .= ( $POST_ARRAY['animation'] != '' ) ? 'data-animate=' . $POST_ARRAY['animation'] . '' : '';
		$animation_data .= ( $POST_ARRAY['delay'] != '' ) ? ' data-delay=' . $POST_ARRAY['delay'] . '' : '';
		$animation_data .= ( $POST_ARRAY['delay_offset'] != '' ) ? ' data-offset=' . $POST_ARRAY['delay_offset'] . '' : '';
		$animation_data .= ( $POST_ARRAY['data-dima-animate-item'] != '' ) ? ' data-dima-animate-item=' . $POST_ARRAY['data-dima-animate-item'] . '' : '';
		$animation_data .= ( $POST_ARRAY['delay_duration'] != '' ) ? ' data-duration=' . $POST_ARRAY['delay_duration'] . '' : '';
		$classes         = array();

		if ( is_archive() || is_home() || ( is_singular() && is_page() ) ) {
			if ( $show_filters ) {
				wp_enqueue_script( 'isotope.pkgd' );
				$ARG_ARRAY['post_class'] .= ' isotope-item';
				$classes[]                = 'dima-isotope-container grid-masonry';
				$id                       = 'id=dima-isotope-container';
			}
		}
		$classes[]                = 'dcl-m-' . $POST_ARRAY['column'];
		$classes                  = join( ' ', $classes );
		$ARG_ARRAY['post_class'] .= ' article-separation';
		?>
		<div class="dima-isotope-wrapper clearfix">
			<div class="products-grids products">
				<?php
				if ( $show_filters ) {
					dima_portfolio_filters( $filters_array, 'edd' );
				}
				?>
				<div <?php esc_attr_e( $id ); ?>
						class="<?php echo esc_attr( $classes ); ?>" <?php echo $animation_data; ?>>
					<div class="dima-blocks dima-justify-start flex-wrap flex">
						<?php
						if ( $query_->have_posts() ) :
							while ( $query_->have_posts() ) :
								$query_->the_post();
								dima_helper::dima_get_view_with_args( 'edd', 'content', 'edd', $ARG_ARRAY );
							endwhile;
							wp_reset_postdata();
						else :
							dima_helper::dima_get_view( 'partials/contents', 'content-none' );
						endif;
						?>
					</div>
				</div>
			</div>
		</div>
		<?php
		if ( $this->is_paging ) {
			dima_pagination( $query_ );
		}
		?>
		<?php
		wp_reset_query();
	}

	/**
	 * @param $POST_ARRAY
	 * @param $query_
	 * @param $ARG_ARRAY
	 */
	function slide( $POST_ARRAY, $query_, $ARG_ARRAY ) {
		if ( empty( $query_ ) ) {
			$query_ = new WP_Query( array( 'orderby' => 'date' ) );
		}

		$js_data = array(
			'dots'         => ( $POST_ARRAY['pagination'] == 'true' ) ? true : false,
			'autoplay'     => ( $POST_ARRAY['auto_play'] == 'true' ) ? true : false,
			'arrows'       => false,
			'infinite'     => false,
			'slidesToShow' => ( $POST_ARRAY['items'] == '' ) ? 1 : $POST_ARRAY['items'],
			'items_phone'  => ( $POST_ARRAY['items_phone'] == '' ) ? 1 : $POST_ARRAY['items_phone'],
			'items_tablet' => ( $POST_ARRAY['items_tablet'] == '' ) ? 2 : $POST_ARRAY['items_tablet'],
			'items_margin' => ( $POST_ARRAY['items_margin'] == '' ) ? 0 : $POST_ARRAY['items_margin'],
			'rtl'          => is_rtl(),
		);

		$slick_class       = 'dima-slide-warp dima_slick_slider slick-with-margin ' . $POST_ARRAY['dark'] . ' ';
		$data              = dima_creat_data_attributes( 'slick_slider', $js_data );
		$POST_ARRAY['clm'] = '';

		?>
		<div class="products-grids products products-slide <?php echo $slick_class; ?>" <?php echo "$data"; ?>>
			<?php
			if ( $query_->have_posts() ) :
				while ( $query_->have_posts() ) :
					$query_->the_post();
					dima_helper::dima_get_view_with_args( 'edd', 'content', 'edd', $ARG_ARRAY );
				endwhile;
				wp_reset_postdata();
			else :
				dima_helper::dima_get_view( 'partials/contents', 'content-none' );
			endif;
			?>
		</div>
		<?php wp_reset_query(); ?>
		<?php
	}
}

if ( class_exists( 'Easy_Digital_Downloads' ) ) {
	new DIMA_EDD_Shortcode();
}
?>
