<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * Highlight
 */

function dima_shortcode_highlight( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'id'    => '',
				'class' => '',
				'style' => '',
			), $atts, 'highlight'
		)
	);

	$id    = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class = ( $class != '' ) ? 'dima-mark ' . esc_attr( $class ) : 'dima-mark';
	$style = ( $style != '' ) ? 'style="' . $style . '"' : '';

	$output = "<mark {$id} class=\"{$class}\" {$style}>{$content}</mark>";

	return $output;
}

add_shortcode( 'highlight', 'dima_shortcode_highlight' );

/**
 * Code
 *
 * @param      $atts
 * @param null $content
 *
 * @return string
 */
function dima_shortcode_code( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'id'    => '',
				'class' => '',
				'style' => '',
			), $atts, 'code'
		)
	);

	$id    = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class = ( $class != '' ) ? esc_attr( $class ) : '';
	$style = ( $style != '' ) ? 'style="' . $style . '"' : '';

	$output
		= "<pre {$id} class=\"{$class}\" {$style}><code>{$content}</code></pre>";

	return $output;
}

add_shortcode( 'code', 'dima_shortcode_code' );

/**
 * LABELS
 *
 * @param      $atts
 * @param null $content
 *
 * @return string
 */
function dima_shortcode_labels( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'id'       => '',
				'class'    => '',
				'style'    => '',
				'bg_color' => '',
				'type'     => '',//success,default,warning,info,error
				'text'     => 'Add Text Here',
			), $atts, 'product_menu'
		)
	);

	$id       = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class    = ( $class != '' ) ? 'label  ' . esc_attr( $class ) : 'label ';
	$bg_color = ( $bg_color != '' ) ? 'background-color:' . $bg_color . ';' : '';
	$style    = $style . $bg_color;
	$style    = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$text     = ( $text != '' ) ? $text : '';
	$type     = ( $type != '' ) ? $type : '';

	if ( $type != '' )
		switch ( $type ) {
			case 'success':
				$type = 'dima-alert-success';
				break;
			case 'info':
				$type = 'dima-alert-info';
				break;
			case 'warning':
				$type = 'dima-alert-warning';
				break;
			case 'dima-error':
				$type = 'dima-alert-error';
				break;
			case 'dima':
				$type = 'dima-alert-error';
				break;
			default:
				$type = '';
				break;
		}

	$class  .= $type;
	$output = "<span {$id} class=\"{$class}\" {$style}>"
	          . $text
	          . "</span>";

	return $output;
}

add_shortcode( 'labels', 'dima_shortcode_labels' );