<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * TimeLine
 *   Process
 *   Date TimeLine
 */

function dima_shortcode_process( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'id'      => '',
				'class'   => '',
				'style'   => '',
				'float'   => '',
				'vh'      => '',
				'columns' => '',
			),
			$atts,
			'process'
		)
	);

	$id       = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$_class[] = ( $class != '' ) ? 'dima-timeline-list ' . esc_attr( $class )
		: 'dima-timeline-list';
	$style    = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$float    = ( $float == 'end' ) ? ' timeline-end' : '';
	$_class[] = ( $columns != '' ) ? $columns : '';
	$_class[] = ( $vh != '' ) ? $vh : '';
	$class    = dima_helper::dima_remove_white_space( esc_attr( trim( implode( ' ', $_class ) ) ) );
	$output   = "<div {$id} class=\"{$class}{$float}\" {$style}>"
				. do_shortcode( $content )
				. '</div>';

	return $output;
}

add_shortcode( 'process', 'dima_shortcode_process' );

function dima_shortcode_date_timeline( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'id'    => '',
				'class' => '',
				'style' => '',
			),
			$atts,
			'date_timeline'
		)
	);

	$id    = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class = ( $class != '' ) ? 'dima-timeline clearfix dima-timeline-blog dima-timeline-date '
								. esc_attr( $class ) : 'dima-timeline clearfix dima-timeline-blog dima-timeline-date';
	$style = ( $style != '' ) ? 'style="' . $style . '"' : '';

	$output = "<div {$id} class=\"{$class}\" {$style}>"
			  . '<div class="h-line"></div>'
			  . dima_helper::dima_remove_wpautop( $content )
			  . '</div>';

	return $output;
}

add_shortcode( 'date_timeline', 'dima_shortcode_date_timeline' );

function dima_shortcode_date_timeline_item( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'id'    => '',
				'class' => '',
				'style' => '',
				'float' => '',
				'boxed' => '',
				'date'  => '',
			),
			$atts,
			'date_timeline_item'
		)
	);

	$id    = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class = ( $class != '' ) ? esc_attr( $class ) . ' ' : '';
	$style = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$float = ( $float != '' ) ? 'timeline_element_' . $float
		: 'timeline_element_start';
	$date  = ( $date != '' ) ? $date : '';
	$boxed = ( $boxed == 'true' ) ? ' dima-no-box ' : '';

	$output = '<div ' . $id . ' class="' . $class . '' . $float . ' "' . $style . '>'
			  . '<article class="post">'
			  . '<div class="box ' . $boxed . '">'
			  . '<p> ' . do_shortcode( $content ) . ' </p>'
			  . '</div>'
			  . '<div class="date">'
			  . '<h5>' . $date . '</h5>'
			  . '</div>'
			  . '</article>'
			  . '</div>';

	return $output;
}

add_shortcode( 'date_timeline_item', 'dima_shortcode_date_timeline_item' );
