<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Counter.
 */

function dima_shortcode_dima_text_autotype( $atts ) {
	extract(
		shortcode_atts(
			array(
				'class'                    => '',
				'id'                       => '',
				'style'                    => '',
				'css'                      => '',
				'typed_text'               => '',
				'typed_options_cursorchar' => '|',
				'typed_options_loopcount'  => '',
				'typed_options_typespeed'  => '',
				'typed_options_backspeed'  => '',
				'typed_options_startdelay' => '',
				'typed_options_backdelay'  => '',
			),
			$atts,
			'dima_text_autotype'
		)
	);
	wp_enqueue_script( 'dima-js-typed' );

	$id    = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class = ( $class != '' ) ? 'auto-type ' . esc_attr( $class ) : 'auto-type ';
	$style = ( $style != '' ) ? 'style="' . $style . '"' : '';
	// Process Text.
	$script = '';

	// Typed Text.
	$typed_text_safe = vc_value_from_safe( $typed_text );

	if ( strpos( $typed_text, '#E-' ) == 0 ) {
		$typed_text = $typed_text_safe;
	}
	if ( preg_match_all( '/(\*.*?\*)/is', $typed_text, $typed_entries ) ) {

		foreach ( $typed_entries[0] as $typed_entry ) {
			$typed_options = array(
				'cursorChar' => $typed_options_cursorchar,
				'showCursor' => $typed_options_cursorchar ? true : false,

				'loop'       => $typed_options_loopcount == -1 || $typed_options_loopcount > 0 ? true : false,
				'loopCount'  => $typed_options_loopcount > 0 ? ( $typed_options_loopcount - 1 ) : 0,

				'typeSpeed'  => absint( $typed_options_typespeed ),
				'backSpeed'  => absint( $typed_options_backspeed ),

				'startDelay' => absint( $typed_options_startdelay ),
				'backDelay'  => absint( $typed_options_backdelay ),
			);

			$typed_processed = dima_text_autotype_process_entry( $typed_entry, $typed_options );
			$typed_text      = str_replace( $typed_entry, $typed_processed['el'], $typed_text );
			$typed_text      = preg_replace( '/^\s*<br\s*(\/)?>/i', '', $typed_text );

			$script .= PHP_EOL . $typed_processed['script'];
		}
	}

	$output = '<div class="' . esc_attr( $class ) . vc_shortcode_custom_css_class( $css, ' ' ) . '">' . $typed_text . '</div>';

	if ( $script ) :
		?>
	<script type="text/javascript">
		jQuery( document ).ready( function( $ ) {
			<?php echo $script; ?>
		} );
	</script>
		<?php
	endif;
	return $output;
}

add_shortcode( 'dima_text_autotype', 'dima_shortcode_dima_text_autotype' );


/**
 * Undocumented function
 *
 * @param string $typed_syntax
 * @param array  $typed_options
 * @return void
 */
function dima_text_autotype_process_entry( $typed_syntax = '', $typed_options = array() ) {
	$typed_element = $typed_script = '';

	if ( in_array( '*', array( substr( $typed_syntax, 0, 1 ), substr( $typed_syntax, -1, 1 ) ) ) ) {
		// Typed.js Defaults.
		$defaults = array(
			'cursorChar'  => '|',
			'contentType' => 'html',

			'loop'        => false,
			'loopCount'   => false,

			'typeSpeed'   => 40,
			'backSpeed'   => 0,

			'startDelay'  => 0,
			'backDelay'   => 500,
		);

		$defaults = array_merge( $defaults, $typed_options );

		// Text Split and Map.
		$element_id = 'el_' . uniqid();

		$typed_syntax = substr( $typed_syntax, 1, -1 );

		// Escape <script inject.
		$typed_syntax = dima_esc_script( $typed_syntax );

		// Ampersand replacement.
		$ampersand_replacement = '__AMPERSAND__';
		$typed_syntax          = str_replace( array( '&amp;', '&' ), $ampersand_replacement, $typed_syntax );

		$animate_entries = explode( ';', $typed_syntax );
		$animate_entries = array_map( 'trim', $animate_entries );

		$defaults = array_merge( $defaults, array( 'strings' => $animate_entries ) );

		// Text.
		ob_start();
		?>
		<div class="inline-block lab-autotype-text-entry" id="<?php echo esc_attr( $element_id ); ?>"></div>
		<?php

		$typed_element = ob_get_clean();

		// Script.
		ob_start();
		$json_data = json_encode( $defaults, JSON_NUMERIC_CHECK );

		// Ampersand replacement.
		$json_data = str_replace( $ampersand_replacement, '&amp;', $json_data );

		?>
		new Typed("#<?php echo esc_attr( $element_id ); ?>",<?php echo $json_data; ?>);
		<?php

		$typed_script = ob_get_clean();

	}

	return array(
		'el'     => $typed_element,
		'script' => $typed_script,
	);
}

/**
 * Escape script tag
 */
function dima_esc_script( $str = '' ) {
	$str = str_ireplace( array( '<script', '</script>' ), array( '&lt;script', '&lt;/script&gt;' ), $str );

	return $str;
}
