<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Text
 *
 * @param null $content
 *
 * @return string
 */
function dima_shortcode_text( $atts, $content = null ) {

	extract(
		shortcode_atts(
			array(
				'animation'      => '',
				'delay'          => '',
				'delay_offset'   => '',
				'delay_duration' => '',
				'class'          => '',
				'css'            => '',
			), $atts, 'text'
		)
	);

	$animation_data = '';
	$animation_data .= ( $animation != '' ) ? 'data-animate=' . $animation . '' : '';
	$animation_data .= ( $delay != '' ) ? ' data-delay=' . $delay . '' : '';
	$animation_data .= ( $delay_offset != '' ) ? ' data-offset=' . $delay_offset . '' : '';
	$animation_data .= ( $delay_duration != '' ) ? ' data-duration=' . $delay_duration . '' : '';
	$output         = '';
	$css_class      = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, 'wpb_content_element ' . $class . vc_shortcode_custom_css_class( $css, ' ' ), $atts );

	//$output = do_shortcode( wpautop( $content ) );

	$output .= "\n\t" . '<div class="' . esc_attr( $css_class ) . '" ' . $animation_data . '>';
	$output .= "\n\t\t" . '<div class="wpb_wrapper">';
	$output .= "\n\t\t\t" . wpb_js_remove_wpautop( $content, true );
	$output .= "\n\t\t" . '</div> ';
	$output .= "\n\t" . '</div> ';

	return $output;

}

add_shortcode( 'text', 'dima_shortcode_text' );