<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Tab nav
 *   1 Tab nav item
 *   2 Tabs
 *   3 Tab
 */

function dima_shortcode_tab_nav( $atts, $content = null ) {
	// 1
	extract(
		shortcode_atts(
			array(
				'id'    => '',
				'class' => '',
				'style' => '',
				'clm'   => '',
				'model' => '',
				'float' => '',
			),
			$atts,
			'tab_nav'
		)
	);

	$id       = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$_class[] = ( $class != '' ) ? 'dima-tabs' . esc_attr( $class ) : 'dima-tabs ';
	$_class[] = ( $model != '' ) ? $model : 'tabs_style_1';
	$style    = ( $style != '' ) ? 'style="' . $style . '"' : '';

	$float = ( $float != '' ) ? $float : 'top';

	switch ( $float ) {
		case 'end':
			$float    = 'float-end';
			$_class[] = 'tabs_float_end';
			$clm      = '';
			break;
		case 'start':
			$float    = 'float-start';
			$_class[] = 'tabs_float_start';
			$clm      = '';
			break;

		default:
			$float    = 'top';
			$_class[] = 'tabs_on_top';
			break;
	}
	$_class[] = ( $clm != '' ) ? $clm : '';

	if ( ! empty( $_class ) ) {
		$class = join( ' ', $_class );
	}

	$output = "<div {$id} class=\"{$class}\" {$style}>"
			  . "<ul class=\"dima-tab-nav {$float}\">" . do_shortcode( $content )
			  . '</ul>'
			  . '';

	return $output;
}

add_shortcode( 'tab_nav', 'dima_shortcode_tab_nav' );


function dima_shortcode_tab_nav_item( $atts ) {
	extract(
		shortcode_atts(
			array(
				'id'               => '',
				'class'            => '',
				'style'            => '',
				'icon'             => '',
				'icon_fontawesome' => '',
				'icon_svg'         => '',
				'title'            => '',
				'active'           => '',
			),
			$atts,
			'tab_nav_item'
		)
	);

	$id               = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class            = ( $class != '' ) ? 'tab ' . esc_attr( $class ) : 'tab';
	$style            = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$title            = ( $title != '' ) ? $title : 'Title Here';
	$active           = ( $active == 'true' ) ? ' active' : '';
	$_icon            = ( $icon != '' ) ? $icon : '';
	$icon_svg         = ( $icon_svg != '' ) ? dima_get_svg_icon( $icon_svg ) : '';
	$icon_fontawesome = ( $icon_fontawesome != '' ) ? $icon_fontawesome : '';
	$_icon            = ( $_icon == '' ) ? $icon_fontawesome : $_icon;

	if ( ! empty( $icon_svg ) ) {
		$_icon = $icon_svg;
	} elseif ( ! empty( $_icon ) ) {
		$_icon = '<i class="' . $_icon . '"></i>';
	}
	static $count = 0;
	$count ++;

	$output
		= "<li {$id} class=\"{$class}{$active}\" {$style}><a href=\"#tab-{$count}\" data-toggle=\"tab\">{$_icon}{$title}</a></li>";

	return $output;
}

add_shortcode( 'tab_nav_item', 'dima_shortcode_tab_nav_item' );

function dima_shortcode_tabs( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'id'    => '',
				'class' => '',
				'style' => '',
			),
			$atts,
			'tabs'
		)
	);

	$id     = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class  = ( $class != '' ) ? 'dima-tab-content ' . esc_attr( $class )
		: 'dima-tab-content';
	$style  = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$output = "<div {$id} class=\"{$class}\" {$style}>" . do_shortcode( $content )
			  . '</div></div>';

	return $output;
}

add_shortcode( 'tabs', 'dima_shortcode_tabs' );


function dima_shortcode_tab( $atts, $content = null ) {
	// 4
	extract(
		shortcode_atts(
			array(
				'class'  => '',
				'style'  => '',
				'active' => '',
			),
			$atts,
			'tab'
		)
	);

	$class  = ( $class != '' ) ? 'tab-pane fade in clearfix dima-tab_content '
								 . esc_attr( $class ) : 'tab-pane fade clearfix dima-tab_content';
	$style  = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$active = ( $active == 'true' ) ? ' fade in active' : '';

	static $count = 0;
	$count ++;

	$output = "<div id=\"tab-{$count}\" class=\"{$class}{$active}\" {$style}>"
			  . do_shortcode( $content ) . '</div>';

	return $output;
}

add_shortcode( 'tab', 'dima_shortcode_tab' );
