<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * Search
 */
function dima_shortcode_search( $atts ) {
	extract(
		shortcode_atts(
			array(
				'id'    => '',
				'class' => '',
				'style' => ''
			), $atts, 'search'
		)
	);

	$id    = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class = ( $class != '' ) ? 'search-query ' . esc_attr( $class )
		: 'search-query';
	$style = ( $style != '' ) ? 'style="' . $style . '"' : '';

	$output = "<div {$id} class=\"{$class}\" {$style}>" . get_search_form( false )
	          . '</div>';

	return $output;
}

add_shortcode( 'search', 'dima_shortcode_search' );