<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Progress Bar
 * Progress Circle
 */

function dima_shortcode_progress_bar( $atts ) {
	extract(
		shortcode_atts(
			array(
				'id'               => '',
				'class'            => '',
				'style'            => '',
				'type'             => '',//style-1,style-2
				'heading'          => '',
				'color'            => '',
				'striped'          => '',//0,1
				'shadow'           => '',//0,1
				'dima_vc_gradient' => '',//0,1
				'percent'          => '',
				'animation'        => '',
				'delay'            => '',
				'delay_offset'     => '',
				'delay_duration'   => '',
			), $atts, 'progress_bar'
		)
	);

	$id               = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class            = ( $class != '' ) ? 'progress ' . esc_attr( $class )
		: 'progress';
	$style            = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$color            = ( $color != '' ) ? $color : '';
	$dima_vc_gradient = ( $dima_vc_gradient != '' ) ? 'gradient-vertical '
	                                                  . $dima_vc_gradient : '';

	$animation_data = '';
	$animation_data .= ( $animation != '' ) ? 'data-animate=' . $animation . '' : '';
	$animation_data .= ( $delay != '' ) ? ' data-delay=' . $delay . '' : '';
	$animation_data .= ( $delay_offset != '' ) ? ' data-offset=' . $delay_offset . '' : '';
	$animation_data .= ( $delay_duration != '' ) ? ' data-duration=' . $delay_duration . '' : '';


	$dec     = str_replace( '%', '', $percent );
	$heading = ( $heading != '' )
		? "<h6 class=\"h-skill\" {$animation_data} >{$heading}<span class=\"percent-end\">{$percent}</span></h6>"
		: '';
	$output  = $heading;
	$output  .= "<div class=\"dima-progressbar\" {$animation_data}><div {$id} class=\"{$class}\" data-color-val=\"{$color}\" {$style} >"
	            . "<div class=\"progress-bar {$dima_vc_gradient}\" role=\"progressbar\" aria-valuenow=\"{$dec}\" aria-valuemin=\"0\" aria-valuemax=\"100\">"
	            . "</div>"
	            . "</div>"
	            . "</div>";

	return $output;
}

add_shortcode( 'progress_bar', 'dima_shortcode_progress_bar' );

function dima_shortcode_progress_circle( $atts ) {
	extract(
		shortcode_atts(
			array(
				'id'               => '',
				'class'            => '',
				'style'            => '',
				'heading'          => '',
				'color'            => '',
				'color_border'     => '',
				'color_bg'         => '',
				'percent_txt'      => '',
				'color_icon'       => '',
				'bar_text'         => '',
				'icon'             => '',
				'icon_fontawesome' => '',
				'icon_svg'         => '',
				'percent'          => ''
			), $atts, 'progress_circle'
		)
	);

	$id               = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$_class[]         = ( $class != '' ) ? 'circular-bar ' . esc_attr( $class )
		: 'circular-bar';
	$style            = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$heading          = ( $heading != '' ) ? '<span class="circular-bar-heading">'
	                                         . $heading . '</span>' : '';
	$color            = ( $color != '' ) ? $color : '#333333';
	$color_bg         = ( $color_bg != '' ) ? $color_bg : '';
	$color_border     = ( $color_border != '' ) ? $color_border : '';
	$color_icon       = ( $color_icon != '' ) ? 'style="color:' . $color_icon
	                                            . '"' : '';
	$percent_txt      = ( $percent_txt != '' ) ? 'style="color:' . $percent_txt
	                                             . '"' : '';
	$size             = '150';
	$_icon            = ( $icon != '' ) ? $icon : '';
	$icon_svg         = ( $icon_svg != '' ) ? dima_get_svg_icon( $icon_svg ) : '';
	$icon_fontawesome = ( $icon_fontawesome != '' ) ? $icon_fontawesome : '';
	$_icon            = ( $_icon == '' ) ? $icon_fontawesome : $_icon;
	$Style_bg         = '';

	if ( $color_bg != '' ) {
		$Style_bg .= 'background: ' . $color_bg . ';';
	}
	if ( $color_border != '' ) {
		$Style_bg .= 'border: 1px solid ' . $color_border . ';';
	}
	if ( $Style_bg != '' ) {
		$Style_bg = 'style="' . $Style_bg . '"';
	}
	if ( ! empty( $icon_svg ) ) {
		$_icon = '<span ' . $color_icon . '>' . $icon_svg . '<span>';
	} else if ( ! empty( $_icon ) ) {
		$_icon = '<i class="' . $_icon . '" ' . $color_icon . '></i>';
	}
	$_class[] = ( $_icon != '' ) ? 'pc_icon' : 'no_pc_icon';
	$class    = dima_helper::dima_remove_white_space( esc_attr( trim( implode( ' ', $_class ) ) ) );

	$dec = str_replace( '%', '', $percent );
	if ( $_icon == '' ) {
		$output
			= "<div class=\"dima-progressbar text-center\"><div {$id} class=\"{$class}\" {$style}>"
			  . "<span class=\"pc-circle\" {$Style_bg}>"
			  . "<span class=\"circular-bar-content\">"
			  . "<label {$percent_txt}></label>"
			  . "</span>"
			  . "</span>"
			  . "<input type=\"text\" class=\"dial\" data-fgColor=\"{$color}\" data-width=\"{$size}\" data-height=\"{$size}\" value=\"{$dec}\">"
			  . $heading
			  . "</div>"
			  . "</div>";
	} else {
		$output
			= "<div class=\"dima-progressbar text-center\"><div {$id} class=\"{$class}\" {$style}>"
			  . "<span class=\"pc-circle\" {$Style_bg}>"
			  . "<span class=\"circular-bar-content\">"
			  . "<label {$percent_txt}></label>"
			  . "</span>"
			  . "</span>"
			  . "<input type=\"text\" class=\"dial\" data-fgColor=\"{$color}\" data-width=\"{$size}\" data-height=\"{$size}\" value=\"{$dec}\">"
			  . "<div class=\"circular-bar-icon\">"
			  . $_icon
			  . "</div>"
			  . $heading
			  . "</div>"
			  . "</div>";
	}

	return $output;
}

add_shortcode( 'progress_circle', 'dima_shortcode_progress_circle' );