<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Menu
 */
/**
 * @param      $atts
 * @param null $content
 *
 * @return string
 */
function dima_shortcode_product_menu( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'id'       => '',
				'class'    => '',
				'style'    => '',
				'bg_image' => '',
				'bg_color' => '',
				// 'boxed'    => 'true',
				'title'    => 'Add Title Here',
			),
			$atts,
			'product_menu'
		)
	);

	$id       = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class    = ( $class != '' ) ? 'last-menu ' . esc_attr( $class ) : 'last-menu';
	$bg_color = ( $bg_color != '' ) ? 'background-color:' . $bg_color . ';' : '';
	$style    = $style . $bg_color;
	$style    = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$title    = ( $title != '' ) ? $title : '';
	// $boxed    = ( $boxed == 'true' ) ? ' box' : ' no-box';
	$bg_image = ( $bg_image != '' ) ? $bg_image : '';

	if ( is_numeric( $bg_image ) ) {
		$bg_image_info = wp_get_attachment_image_src( $bg_image, 'full' );
		$bg_image      = "data-element-bg=\"{$bg_image_info[0]}\"";
	}

	if ( $title != '' ) {
		$title = "<h3 class=\"box-titel\">{$title}</h3>";
	}

	$output = "<div {$id} class=\"{$class}\" {$style} {$bg_image}>"
			  . $title
			  . '<ul>'
			  . do_shortcode( $content )
			  . '</ul>'
			  . '</div>';

	return $output;
}

add_shortcode( 'product_menu', 'dima_shortcode_product_menu' );

function dima_shortcode_product_menu_item( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'id'           => '',
				'class'        => '',
				'style'        => '',
				'price'        => '',
				'title'        => 'Title Here',
				'notification' => '',
				'noti_color'   => '',
				'href'         => '',
				'target'       => '',
			),
			$atts,
			'product_menu_item'
		)
	);

	$id           = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class        = ( $class != '' ) ? 'clearfix ' . esc_attr( $class )
		: 'clearfix';
	$style        = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$target       = ( $target == 'blank' ) ? 'target="_blank" rel="noopener"' : '';
	$title        = ( $title == '' ) ? '' : $title;
	$noti_color   = ( $noti_color == '' ) ? 'red_color' : $noti_color . '_color';
	$href         = ( $href == '' ) ? '#' : $href;
	$price        = ( $price == '' ) ? ''
		: '<span class="menu-price" >' . $price . '</span >';
	$notification = ( $notification == '' ) ? '' : '<span class="menu-notification ' . $noti_color . '">' . $notification
		  . '</span >';

	if ( $href != '' ) {
		$title
			= "<a class=\"menu-title\" href = \"{$href}\" {$target}>{$title}</a >";
	} else {
		$title = '<span class="menu-title" >' . $title . '</span>';
	}

	$header = '<h5>'
			  . $title
			  . $notification
			  . '<span class="menu_dots"></span>'
			  . $price
			  . '</h5>';
	$output = ' <li ' . $id . ' class="' . $class . '"  ' . $style . ' > '
			  . $header
			  . '<span class="menu-content">'
			  . do_shortcode( $content )
			  . '</span>'
			  . '</li > ';

	return $output;
}

add_shortcode( 'product_menu_item', 'dima_shortcode_product_menu_item' );
