<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @param      $atts
 * @param null $content
 *
 * @return string
 */
function dima_shortcode_pricing_table_column( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'id'                     => '',
				'class'                  => '',
				'style'                  => '',
				'featured'               => '',
				'shadow'                 => '',
				'interval'               => '',
				'title'                  => '',
				'href_callout'           => '',
				'target'                 => '',
				'currency'               => '',
				'icon'                   => '',
				'icon_svg'               => '',
				'icon_fontawesome'       => '',
				'price'                  => '',
				'dima_vc_add_shadow'     => '',
				'dima_vc_border_color'   => '',
				'dima_vc_add_border_btm' => '',
				'type'                   => '',//two,three,offers
			), $atts, 'pricing_table_column'
		)
	);

	$_class[]             = "dima-pricing-col";
	$id                   = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class                = ( $class != '' ) ? 'dima-pricing-table ' . esc_attr(
			$class
		) : 'dima-pricing-table';
	$style                = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$interval             = ( $interval != '' ) ? '' . $interval : '';
	$type                 = ( $type != '' ) ? $type : '';
	$title                = ( $title != '' ) ? $title : '';
	$currency             = ( $currency != '' ) ? $currency : '';
	$price                = ( $price != '' ) ? $price : '';
	$href_callout         = ( $href_callout == '' ) ? '' : $href_callout;
	$target               = ( $target == 'blank' ) ? 'target="_blank" rel="noopener"' : '';
	$dima_vc_add_shadow   = ( $dima_vc_add_shadow == 'true' ) ? ' box-with-shadow'
		: '';
	$dima_vc_add_shadow   .= ( $dima_vc_add_border_btm == 'true' )
		? " add_border_btm" : '';
	$dima_vc_border_color = ( $dima_vc_border_color != '' )
		? $dima_vc_border_color : '';
	$_icon                = ( $icon != '' ) ? $icon : '';
	$icon_svg             = ( $icon_svg != '' ) ? dima_get_svg_icon( $icon_svg )
		: '';
	$icon_fontawesome     = ( $icon_fontawesome != '' ) ? $icon_fontawesome : '';

	$table_class = $featured_icon = $table_style = $_price_under = "";
	if ( ! empty( $dima_vc_border_color ) ) {
		$dima_vc_border_color = "border-top-color:$dima_vc_border_color;";
		$table_style          = "style=\"$dima_vc_border_color\"";
	}

	$_icon = ( $_icon == '' ) ? $icon_fontawesome : $_icon;

	if ( ! empty( $icon_svg ) ) {
		$_icon = $icon_svg;
	} else if ( ! empty( $_icon ) ) {
		$_icon = '<i class="' . $_icon . '"></i>';
	}

	switch ( $type ) {
		case 'callout':
			$_class[] = "pricing-style-callout";
			break;
		case 'offers':
			$_class[] = "dima-offers";
			break;
		default:
			$_class[] = "";
			break;
	}
	switch ( $featured ) {
		case 'true':
			$class         .= " featured";
			$svg_icon_name = apply_filters('dima_pricing_tabel_icon','ic_favorite');
			$featuredicon = dima_get_svg_icon($svg_icon_name);
			$featured_icon = "<span class='featured_icon'>$featuredicon</span>";
			break;
		default:
			$_class[] = "";
			break;
	}
	if ( ! empty( $_class ) ) {
		$table_class = dima_short_remove_white_space( join( ' ', $_class ) );
	}
	$_price
		= '<h2 class="dima-pricing-row"><span class="pricing"><span class="currency">'
		  . $currency . '</span>' . $price . '</span><span class="interval">'
		  . $interval . '</span></h2>';

	$_price = ( $price != '' ) ? $_price : '';

	if ( $_icon != '' ) {
		$class        .= " table_icon";
		$_price_under = $_price;
		$_price       = $_icon;
	}

	if ( $type != "dima-offers" ) {
		$output = "<div {$id} class=\"{$table_class}\">"
		          . '<div class="dima-pricing-col-info' . $dima_vc_add_shadow . '" '
		          . $table_style . '>'
		          . '<div class="dima-header-col-info">'
		          . '<h6 class="dima-table-title">' . $title . '</h6>'
		          . $_price
		          . '</div>'
		          . $_price_under
		          . '<div class="dima-table-content">'
		          . do_shortcode( $content )
		          . '</div>'
		          . '</div>'
		          . '</div>';
	} else {
		$output = "<div {$id} class=\"{$table_class}\">"
		          . '<div class="dima-pricing-col-info">'
		          . do_shortcode( $content )
		          . '</div>'
		          . '</div>';
	}

	if ( ! empty( $href_callout ) && $type == ' pricing-style-callout' ) {
		$output = "<a href=\"{$href_callout}\" {$target}>" . $output . "</a>";
	}

	$output
		= "<div {$id} class=\"{$class}\" {$style}> $featured_icon$output </div>";

	return $output;
}

add_shortcode( 'pricing_table_column', 'dima_shortcode_pricing_table_column' );