<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Maps
 *   1 Embed
 *   2 Google map
 *   3 Google map marker
 */
function dima_shortcode_map( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'id'    => '',
				'class' => '',
				'style' => '',
				'boxed' => ''
			), $atts, 'map'
		)
	);

	$id    = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class = ( $class != '' ) ? 'dima-maps ' . esc_attr( $class ) : 'dima-maps';
	$style = ( $style != '' ) ? 'style="' . $style . '"' : '';

	$output
		= "<div {$id} class=\"{$class}\" {$style}><div class=\"dima-map-inner\">{$content}</div></div>";

	return $output;
}

add_shortcode( 'map', 'dima_shortcode_map' );

function dima_shortcode_google_map( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'class'        => '',
				'style'        => '',
				'lat'          => '',
				'lng'          => '',
				'drag'         => '',
				'zoom'         => '',
				'zoom_control' => '',
				'height'       => '',
				'width'        => '',
				'map_style'    => '',

				'animation'      => '',
				'delay'          => '',
				'delay_offset'   => '',
				'delay_duration' => '',
			), $atts, 'google_maptwo'
		)
	);

	$class          = ( $class != '' ) ? 'dima-maps dima-google-map ' . esc_attr( $class )
		: 'dima-maps dima-google-map';
	$style          = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$animation_data = '';
	$animation_data .= ( $animation != '' ) ? 'data-animate=' . $animation . '' : '';
	$animation_data .= ( $delay != '' ) ? ' data-delay=' . $delay . '' : '';
	$animation_data .= ( $delay_offset != '' ) ? ' data-offset=' . $delay_offset . '' : '';
	$animation_data .= ( $delay_duration != '' ) ? ' data-duration=' . $delay_duration . '' : '';

	$js_data = array(
		'lat'         => ( $lat != '' ) ? $lat : '40.7056308',
		'lng'         => ( $lng != '' ) ? $lng : '-73.9780035',
		'zoom'        => ( $zoom != '' ) ? $zoom : '7',
		'zoomControl' => ( $zoom_control == 'true' ),
		'height'      => ( $height != '' ) ? $height : '200px',
		'width'       => ( $width != '' ) ? $width : '100%',
		'map_style'   => ( $map_style != '' ) ? $map_style : '',
		'drag'        => ( $drag == 'true' )
	);

	$data = dima_creat_data_attributes( 'google_map', $js_data );

	wp_enqueue_script( 'vendor-google-maps' );

	static $count = 0;
	$count ++;

	$output
		= "<div id=\"dima-gmap-{$count}\" class=\"{$class}\" {$animation_data} {$data} {$style}>"
		  . "<div id=\"dima-gmap-in-{$count}\" class=\"dima-gmap-in\">"
		  . "</div>" . do_shortcode( $content ) . "</div>";

	return $output;
}

add_shortcode( 'google_maptwo', 'dima_shortcode_google_map' );

/**
 * @param $atts
 *
 * @return string
 */
function dima_shortcode_google_map_marker( $atts ) {
	extract(
		shortcode_atts(
			array(
				'lat'   => '',
				'lng'   => '',
				'info'  => '',
				'image' => '',

				'animation'      => '',
				'delay'          => '',
				'delay_offset'   => '',
				'delay_duration' => '',
			), $atts, 'google_map_marker'
		)
	);

	$js_data = array(
		'lat'  => ( $lat != '' ) ? $lat : '40.7056308',
		'lng'  => ( $lng != '' ) ? $lng : '-73.9780035',
		'info' => ( $info != '' ) ? $info : ''
	);

	$animation_data = '';
	$animation_data .= ( $animation != '' ) ? 'data-animate=' . $animation . '' : '';
	$animation_data .= ( $delay != '' ) ? ' data-delay=' . $delay . '' : '';
	$animation_data .= ( $delay_offset != '' ) ? ' data-offset=' . $delay_offset . '' : '';
	$animation_data .= ( $delay_duration != '' ) ? ' data-duration=' . $delay_duration . '' : '';

	if ( is_numeric( $image ) ) {
		$image_info       = wp_get_attachment_image_src( $image, 'full' );
		$js_data['image'] = $image_info[0];
	} else if ( $image != '' ) {
		$js_data['image'] = $image;
	}

	$data = dima_creat_data_attributes( 'google_map_marker', $js_data );

	$output = "<div class=\"dima-gmap-marker\" {$animation_data} {$data}></div>";

	return $output;
}

add_shortcode( 'google_map_marker', 'dima_shortcode_google_map_marker' );