<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * List
 * 1 List Item
 */
function dima_shortcode_list( $atts, $content = null ) { // 1
	extract(
		shortcode_atts(
			array(
				'id'    => '',
				'class' => '',
				'type'  => '',
				'style' => '',

				'animation'              => '',
				'delay'                  => '',
				'delay_offset'           => '',
				'delay_duration'         => '',
				'data_dima_animate_item' => '',

			), $atts, 'list'
		)
	);

	$id    = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class = ( $class != '' ) ? 'list-style ' . esc_attr( $class ) : 'list-style';
	$type  = ( $type != '' ) ? ' ' . esc_attr( $type ) : '';
	$style = ( $style != '' ) ? 'style="' . $style . '"' : '';

	$animation_data = '';
	if ( $animation != '' ) {
		$animation_data .= ( $animation != '' ) ? 'data-animate=' . $animation . '' : '';
		$animation_data .= ( $delay != '' ) ? ' data-delay=' . $delay . '' : ' data-delay="30"';
		$animation_data .= ( $delay_offset != '' ) ? ' data-offset=' . $delay_offset . '' : '';
		$animation_data .= ( $delay_duration != '' ) ? ' data-duration=' . $delay_duration . '' : '';
		$animation_data .= ( $data_dima_animate_item ) ? ' data-dima-animate-item=' . $data_dima_animate_item . '' : ' data-dima-animate-item="li"';
	}

	$output = "<ul {$id} class=\"{$class}{$type}\" {$animation_data} {$style}>" . do_shortcode(
			$content
		) . "</ul>";

	return $output;
}

add_shortcode( 'list', 'dima_shortcode_list' );

function dima_shortcode_list_item( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'id'    => '',
				'class' => '',
				'style' => '',
			), $atts, 'list_item'
		)
	);

	$id    = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class = ( $class != '' ) ? 'class="' . esc_attr( $class ) . '"' : '';
	$style = ( $style != '' ) ? 'style="' . $style . '"' : '';

	$output = "<li {$id} {$class} {$style}>" . do_shortcode( $content ) . "</li>";

	return $output;
}

add_shortcode( 'list_item', 'dima_shortcode_list_item' );

/**
 * Icon List
 *   1 Icon List Item
 */
function dima_shortcode_icon_list( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'id'    => '',
				'class' => '',
				'style' => ''
			), $atts, 'icon_list'
		)
	);

	$id    = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class = ( $class != '' ) ? 'icon-list ' . esc_attr( $class ) : 'icon-list';
	$style = ( $style != '' ) ? 'style="' . $style . '"' : '';

	$output = "<ul {$id} class=\"{$class}\" {$style}>" . do_shortcode( $content )
	          . "</ul>";

	return $output;
}

add_shortcode( 'icon_list', 'dima_shortcode_icon_list' );

function dima_shortcode_icon_list_item( $atts, $content = null ) { // 2
	extract(
		shortcode_atts(
			array(
				'id'               => '',
				'class'            => '',
				'style'            => '',
				'icon'             => '',
				'icon_fontawesome' => '',
				'icon_color'       => '',
				'icon_svg'         => ''
			), $atts, 'icon_list_item'
		)
	);

	$id               = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class            = ( $class != '' ) ? 'class="' . esc_attr( $class ) . '"'
		: '';
	$style            = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$_icon            = ( $icon != '' ) ? $icon : '';
	$icon_svg         = ( $icon_svg != '' ) ? dima_get_svg_icon( $icon_svg ) : '';
	$icon_fontawesome = ( $icon_fontawesome != '' ) ? $icon_fontawesome : '';
	$_icon            = ( $_icon == '' ) ? $icon_fontawesome : $_icon;
	$icon_color       = ( $icon_color != '' ) ? 'style="color:' . $icon_color
	                                            . ';"' : '';

	if ( ! empty( $icon_svg ) ) {
		$_icon = "<span " . $icon_color . ">" . $icon_svg . "</span>";
	} else if ( ! empty( $_icon ) ) {
		$_icon = '<i ' . $icon_color . ' class="' . $_icon . '"></i>';
	}

	$output = "<li {$id} {$class} {$style}>{$_icon}" . do_shortcode( $content )
	          . "</li>";

	return $output;
}

add_shortcode( 'icon_list_item', 'dima_shortcode_icon_list_item' );