<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Link Popovers and Tooltips
 *
 * @param      $atts
 * @param null $content
 *
 * @return string
 */
function dima_shortcode_dima_link( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'id'            => '',
				'class'         => '',
				'style'         => '',
				'href'          => '',
				'title'         => '',
				'target'        => '',
				'popup_type'    => '',
				'popup_place'   => '',
				'link_style'    => '',
				'popup_trigger' => '',
				'popup_content' => '',
				'lightbox'      => '',
			),
			$atts,
			'link'
		)
	);

	$id     = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class  = ( $class != '' ) ? ' ' . esc_attr( $class ) : '';
	$class .= ( $link_style != '' ) ? ' btm_' . esc_attr( $link_style ) : '';
	$style  = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$title  = ( $title != '' ) ? 'title="' . $title . '"' : '';
	$target = ( $target == 'blank' ) ? 'target="_blank" rel="noopener"' : '';

	$tooltip_attr = ( $popup_type != '' ) ? dima_helper::dima_tooltip_data(
		$popup_type,
		$popup_trigger,
		$popup_place,
		'',
		$popup_content
	) : '';

	if ( $lightbox != '' ) {
		wp_enqueue_style( 'fancybox-css' );
		wp_enqueue_script( 'fancybox-js' );
		switch ( $lightbox ) {
			case 'image':
				$lightbox = 'data-fancybox';
				break;
			case 'iframe_two':
				$lightbox = 'data-fancybox data-type="iframe" data-src="' . $href . '"  href="javascript:;"';
				break;
			default:
				$lightbox = 'data-fancybox';
				break;
		}
	}

	$output
		= "<a {$lightbox} {$id} class=\"{$class}\" href=\"{$href}\" {$target} {$tooltip_attr} {$title} {$style}>"
		  . do_shortcode( $content ) . '</a>';

	return $output;
}

add_shortcode( 'link', 'dima_shortcode_dima_link' );
