<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


if ( DIMA_KB_IS_ACTIVE ) {
	function dima_shortcode_kb_search( $atts ) {
		extract(
			shortcode_atts(
				array(
					'id'                    => '',
					'class'                 => '',
					'style'                 => '',
					'direction'             => '',
					'float'                 => '',
					'searchbox_width'       => '100%',
					'button'                => 'true',
					'searchbox_placeholder' => esc_html__( 'Search Knowledge Base', 'noor-assistant' ),
					'animation'             => '',
					'delay'                 => '',
					'delay_offset'          => '',
					'delay_duration'        => '',
				), $atts, 'dima_kb_search'
			)
		);
		global $pakb;
		$search_ptxt = $searchbox_placeholder;

		$id              = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
		$class           = ( $class != '' ) ? 'dima-divider ' . esc_attr( $class ) : 'dima-divider ';
		$searchbox_width = ( $searchbox_width != '' ) ? 'style="width:' . $searchbox_width . '"' : '';
		$button          = dima_helper::dima_am_i_true( $button );
		$float           = ( $float != '' ) ? ' float-' . $float : ' float-start';
		$animation_data  = '';
		$animation_data  .= ( $animation != '' ) ? 'data-animate=' . $animation . '' : '';
		$animation_data  .= ( $delay != '' ) ? ' data-delay=' . $delay . '' : '';
		$animation_data  .= ( $delay_offset != '' ) ? ' data-offset=' . $delay_offset . '' : '';
		$animation_data  .= ( $delay_duration != '' ) ? ' data-duration=' . $delay_duration . '' : '';

		$get_search_query = $autosuggest = $pakbsearchicon = '';
		$home_url         = home_url( '/' );
		$search_text      = esc_attr__( 'Search', 'noor-assistant' );
		if ( $button ) {
			$button = "<input type=\"submit\" id=\"searchsubmit\" value=\"{$search_text}\"/>";
		}
		if ( is_search() ) {
			$get_search_query = get_search_query();
		}
		if ( $pakb->get( 'live_search' ) ) {
			$autosuggest = 'autosuggest';
		}
		if ( ! $pakb->get( 'search_btn' ) ) {
			$pakbsearchicon = ' pakb-search-icon';
		}

		$output = "<div class=\"dima-kb pakb-header {$float} {$class}\"  {$id} {$searchbox_width}>"
		          . "<div role=\"search\" method=\"post\" id=\"kbsearchform\" action=\"$home_url\" {$animation_data}>"
		          . "<div class=\"pakb-search\">"
		          . wp_nonce_field( 'knowedgebase-search', 'search_nonce', false )
		          . "<input class=\"{$autosuggest}{$pakbsearchicon}\" type=\"text\" value=\"{$get_search_query}\" name=\"s\" placeholder=\"$search_ptxt\" id=\"kb-s\">"
		          . "<span>"
		          . $button
		          . "</span>"
		          . "<input type=\"hidden\" name=\"post_type\" value=\"knowledgebase\"/>"
		          . "</div>"
		          . "</div>"
		          . "</form>"
		          . "</div>";

		return $output;
	}

	add_shortcode( 'dima_kb_search', 'dima_shortcode_kb_search' );
}