<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function image_shortcode_image( $atts ) {
	extract(
		shortcode_atts(
			array(
				'id'                => '',
				'class'             => '',
				'style'             => '',
				'type'              => '',
				'width'             => '',
				'float'             => '',
				'src'               => '',
				'alt'               => '',
				'caption'           => '',
				'href'              => '',
				'shape'             => '',
				'title'             => '',
				'target'            => '',
				'popup_type'        => '',
				'popup_place'       => '',
				'popup_trigger'     => '',
				'popup_content'     => '',
				'hover'             => '',
				'lightbox'          => '',
				'is_gallert_item'   => 'false',
				'dima_lazyimage'    => 'true',
				'apply_gray'        => 'false',
				'dvc_source'        => 'media_library',
				'custom_srcs'       => '',
				'img_size'          => 'full',
				'external_img_size' => '',
				'animation'         => '',
				'delay'             => '',
				'delay_offset'      => '',
				'delay_duration'    => '',
			),
			$atts,
			'image'
		)
	);
	$classes       = array();
	$id            = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$classes[]     = ( $class != '' ) ? ' dima-img ' . esc_attr( $class )
	: 'dima-img ';
	$style         = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$classes[]     = ( $width != '' ) ? ' columns-' . esc_attr( $width ) : '';
	$classes[]     = ( $shape != '' ) ? ' ' . $shape : '';
	$classes[]     = ( $float != '' ) ? 'text-' . esc_attr( $float ) : '';
	$classes[]     = ( $apply_gray == 'true' ) ? ' apply-gray' : '';
	$src           = ( $src != '' ) ? $src : '';
	$alt           = ( $alt != '' ) ? 'alt="' . $alt . '"' : 'alt=""';
	$front_caption = ( $caption != '' ) ? $caption : '';
	$title         = ( $title != '' ) ? 'title="' . $title . '"' : '';
	$target        = ( $target == 'blank' ) ? 'target="_blank" rel="noopener"' : '';

	$animation_data  = '';
	$animation_data .= ( $animation != '' ) ? 'data-animate=' . $animation . '' : '';
	$animation_data .= ( $delay != '' ) ? ' data-delay=' . $delay . '' : '';
	$animation_data .= ( $delay_offset != '' ) ? ' data-offset=' . $delay_offset . '' : '';
	$animation_data .= ( $delay_duration != '' ) ? ' data-duration=' . $delay_duration . '' : '';

	$caption_data = get_post( $src );
	$caption      = '';
	$lazy_class   = 'dima-image';

	if ( ! dima_helper::dima_am_i_true( $dima_lazyimage ) ) {
		$lazy_class .= ' no-lazy-image';
	}

	if ( $caption_data != '' ) {
		$caption = ' data-caption = "' . $caption_data->post_excerpt . '"';
	}

	if ( $lightbox != '' ) {
		switch ( $lightbox ) {
			case 'image':
				$lightbox = 'data-fancybox ' . $caption . '';
				break;
			case 'iframe_two':
				$lightbox = 'data-fancybox data-type="iframe" data-src="' . $href . '" ' . $caption . ' href="javascript:;"';
				break;
			default:
				$lightbox = 'data-fancybox ' . $caption . '';
				break;
		}
		if ( $is_gallert_item == 'true' ) {
			$lightbox = 'data-fancybox="gallery" ' . $caption . '';
			$class   .= ' dima-gallery-item';
		}
	}

	switch ( $dvc_source ) {
		case 'media_library':
			$img_id = preg_replace( '/[^\d]/', '', $src );
			if ( preg_match( '/_circle_2$/', $style ) ) {
				$style    = preg_replace( '/_circle_2$/', '_circle', $style );
				$img_size = $this->getImageSquareSize( $img_id, $img_size );
			}
			if ( ! $img_size ) {
				$img_size = 'medium';
			}
			$img = dima_get_image_by_size(
				array(
					'attach_id'  => $img_id,
					'thumb_size' => $img_size,
					'class'      => 'dima_image-img ' . $lazy_class . '',
					'alt'        => $alt,
					'caption'    => $front_caption,
				)
			);

			$poster_info = wp_get_attachment_image_src( $img_id, 'full' );
			if ( is_array( $poster_info ) ) {
				$img['p_img_large'] = $poster_info[0];
			}

			if ( ! empty( $lightbox ) ) {
				$href = ( $href == '' ) ? $img['p_img_large'] : $href;
			}

			break;

		case 'external_link':
			$dimensions = vcExtractDimensions( $external_img_size );
			$hwstring   = $dimensions ? image_hwstring( $dimensions[0], $dimensions[1] ) : '';
			$srcs       = $custom_srcs ? $custom_srcs : $default_src;

			$img = array(
				'thumbnail' => '<img class="' . $lazy_class . '" ' . $alt . ' ' . $hwstring . ' src="' . $srcs . '" />',
			);
			if ( ! empty( $lightbox ) ) {
				$href = ( $href == '' ) ? $custom_srcs : $href;
			}

			break;

		default:
			$img = false;
	}

	if ( ! $img ) {
		$default_src      = vc_asset_url( 'vc/no_image.png' );
		$img['thumbnail'] = '<img class="' . $lazy_class . '" src="' . $default_src . '" />';
	}

	$tooltip_attr = ( $popup_type != '' ) ? dima_helper::dima_tooltip_data(
		$popup_type,
		$popup_trigger,
		$popup_place,
		'',
		$popup_content
	) : '';

	switch ( $hover ) {
		case 'zoom-out':
			$hover = 'effect-roxy';
			break;
		case 'zoom-in':
			$hover = 'effect-julia';
			break;
		case 'effect-opacity':
			$hover = 'gray-opacity';
			break;
		case 'overlay':
			$hover = 'overlay';
			break;
	}

	if ( ! empty( $href ) ) {
		if ( $hover == 'overlay' ) {
			$class .= ' overlay';
			$hover  = '';
		}
		$output = "<a {$lightbox} class=\"{$class}\" {$style} {$target} href=\"{$href}\" >{$img['thumbnail']}</a>";
	} else {
		$output = $img['thumbnail'];
	}
	$classes[] = 'column-item overflow-hidden';
	$classes   = dima_short_remove_white_space( join( ' ', $classes ) );

	if ( ! empty( $hover ) ) {
		$output = "<div class=\"{$hover}\">"
			. $output .
			'</div>';
	}

	return "<div {$id} class=\"{$classes}\" {$title}  {$tooltip_attr} {$title} {$tooltip_attr} {$animation_data} {$style}>"
		. $output .
		'</div>';
}

add_shortcode( 'image', 'image_shortcode_image' );
