<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Button
 *
 * @param $atts
 *
 * @return string
 */
function dima_shortcode_button( $atts ) {
	extract(
		shortcode_atts(
			array(
				'id'                 => '',
				'class'              => '',
				'style'              => '',
				'type'               => '',
				'color_class'        => '',
				'bg_color'       	 => '',
				'solid_text_color_override'       	 => '',
				'size'               => '',
				'float'              => '',
				'block'              => '',
				'shape'              => '',
				'icon'               => '',
				'href'               => '',
				'dima_vc_disabled'   => '',
				'title'              => '',
				'text'               => '',
				'target'             => '',
				'popup_type'         => '',
				'popup_place'        => '',
				'popup_trigger'      => '',
				'popup_content'      => '',
				'lightbox'           => '',
				'icon_fontawesome'   => '',
				'icon_svg'           => '',
				'dima_vc_add_shadow' => '',

				'margin_top'         => '',
				'margin_right'       => '',
				'margin_bottom'      => '',
				'margin_left'        => '',

				'animation'          => '',
				'delay'              => '',
				'delay_offset'       => '',
				'delay_duration'     => '',
			),
			$atts,
			'button'
		)
	);

	$id               = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$_class[]         = ( $class != '' ) ? 'dima-button dima-waves ' . esc_attr( $class ) : 'dima-button dima-waves';
	$_class[]         = ( $color_class != '' ) ? '' . esc_attr( $color_class ) . ' ' : '';
	$_class[]         = ( $type != '' ) ? $type : 'fill';
	$_class[]         = ( $size != '' ) ? 'dima-btn-' . $size : 'dima-btn-small';
	$_class[]         = ( $icon != '' ) ? ' icon' : '';
	$_class[]         = ( $dima_vc_add_shadow == 'true' ) ? 'dima-shadow' : '';
	$_icon            = ( $icon != '' ) ? $icon : '';
	$icon_svg         = ( $icon_svg != '' ) ? dima_get_svg_icon( $icon_svg ) : '';
	$icon_fontawesome = ( $icon_fontawesome != '' ) ? $icon_fontawesome : '';

	$margins = '';
	if ( ! empty( $margin_top ) ) {
		$style .= 'margin-top: ' . intval( $margin_top ) . 'px; ';
	}
	if ( ! empty( $margin_right ) ) {
		$style .= 'margin-right: ' . intval( $margin_right ) . 'px; ';
	}
	if ( ! empty( $margin_bottom ) ) {
		$style .= 'margin-bottom: ' . intval( $margin_bottom ) . 'px; ';
	}
	if ( ! empty( $margin_left ) ) {
		$style .= 'margin-left: ' . intval( $margin_left ) . 'px;';
	}
	if ( ! empty( $solid_text_color_override ) ){
		$style    .= 'color: ' .  $solid_text_color_override  . ';';
	}
	if ( ! empty( $style ) ) {
		$style = 'style="' . $style . '"';
	}

	$animation_data  = '';
	$animation_data .= ( $animation != '' ) ? 'data-animate=' . $animation . '' : '';
	$animation_data .= ( $delay != '' ) ? ' data-delay=' . $delay . '' : '';
	$animation_data .= ( $delay_offset != '' ) ? ' data-offset=' . $delay_offset . '' : '';
	$animation_data .= ( $delay_duration != '' ) ? ' data-duration=' . $delay_duration . '' : '';

	if ( $lightbox != '' ) {
		switch ( $lightbox ) {
			case 'image':
				$lightbox = 'data-fancybox';
				break;
			case 'iframe_two':
				$lightbox = 'data-fancybox data-type="iframe" data-src="' . $href . '" href="javascript:;"';
				break;
			default:
				$lightbox = 'data-fancybox';
				break;
		}
	}

	switch ( $float ) {
		case 'end':
			$_class[] = 'float-end';
			break;
		case 'start':
			$_class[] = 'float-start';
			break;
		case 'center':
			$_class[] = 'float-center';
			break;
		default:
			$_class[] = '';
	}
	$_icon = ( $_icon == '' ) ? $icon_fontawesome : $_icon;

	if ( ! empty( $icon_svg ) ) {
		$_icon = $icon_svg;
	} elseif ( ! empty( $_icon ) ) {
		$_icon = '<i class="' . $_icon . '"></i>';
	}

	$_class[]     = ( $block == 'true' ) ? 'button-block' : '';
	$_class[]     = ( $dima_vc_disabled == 'true' ) ? 'disabled' : '';
	$_class[]     = ( $shape != '' ) ? ' ' . $shape . ' ' : '';
	$href         = ( $href != '' ) ? 'href="' . esc_url( $href ) . '"' : 'href="#"';
	$title        = ( $title != '' ) ? 'title="' . $title . '"' : '';
	$target       = ( $target == 'blank' ) ? 'target="_blank" rel="noopener"' : '';
	$tooltip_attr = ( $popup_type != '' ) ? dima_helper::dima_tooltip_data(
		$popup_type,
		$popup_trigger,
		$popup_place,
		'',
		$popup_content
	) : '';

	if ( ! empty( $_class ) ) {
		$class = dima_short_remove_white_space( join( ' ', $_class ) );
	}
	if(!empty( $bg_color )){
		$bg_color =	"data-bg-color='$bg_color'";
	}

	$output = "<a {$lightbox} {$id} {$href} {$bg_color} class=\"{$class}\" {$animation_data} {$style} {$title} {$target} {$tooltip_attr} >{$_icon}{$text}</a>";

	return $output;
}

add_shortcode( 'button', 'dima_shortcode_button' );
