<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Blockquote
 */
function dima_shortcode_blockquote( $atts, $content = null ) {
	extract(
		shortcode_atts(
			array(
				'id'        => '',
				'class'     => '',
				'style'     => '',
				'cite'      => '',
				'type'      => '',
				'icon'      => '',
				'direction' => ''
			), $atts, 'blockquote'
		)
	);

	$id    = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$style = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$cite  = ( $cite != '' ) ? '<cite>' . $cite . '</cite>' : '';
	if ( $icon != 'false' ) {
		$icon = "<span>" . dima_get_svg_icon( "ic_format_quote" ) . "</span>";
	} else {
		$icon = '';
	}
	switch ( $direction ) {
		case 'end' :
			$direction = ' text-end';
			break;
		case 'start' :
			$direction = ' text-start';
			break;
		default :
			$direction = ' text-center';
	}
	if ( $type == "pull" ) {
		$class = ( $class != '' ) ? 'post-quote ' . esc_attr( $class )
			: 'post-quote';
		$output
		       = "<blockquote {$id} class=\"{$class}{$direction}\" {$style}>$icon<p>"
		         . do_shortcode( $content ) . "</p>" . $cite . ""
		         . "</blockquote>";

	} elseif ( $type == "sample" ) {
		$class = ( $class != '' ) ? 'sample-quote ' . esc_attr( $class )
			: 'sample-quote';
		$output
		       = "<blockquote {$id} class=\"{$class}{$direction}\" {$style}>$icon<p>"
		         . do_shortcode( $content ) . $cite . "</p>"
		         . "</blockquote>";

	} else {
		$class = ( $class != '' ) ? 'blog-style ' . esc_attr( $class )
			: 'blog-style ';
		$output
		       = "<div class=\"dima-blockquote single-blockquote\">$icon<blockquote {$id} class=\"{$class}{$direction}\" {$style}><p>"
		         . do_shortcode( $content ) . "</p>" . $cite . ""
		         . "</blockquote></div>";
	}

	return $output;
}

add_shortcode( 'blockquote', 'dima_shortcode_blockquote' );