<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function dima_shortcode_dima_ads( $atts ) {

	$output = $data_atts = $units = '';
	$atts   = vc_map_get_attributes( 'dima_ads', $atts );
	extract( $atts );

	$id       = ( $id != '' ) ? 'id="' . esc_attr( $id ) . '"' : '';
	$class    = ( $class != '' ) ? ' dima-img ' . esc_attr( $class )
		: 'dima-img ';
	$style    = ( $style != '' ) ? 'style="' . $style . '"' : '';
	$float    = ( $float != '' ) ? esc_attr( $float ) : '';
	$src      = ( $src != '' ) ? $src : '';
	$alt      = ( $alt != '' ) ? 'alt="' . $alt . '"' : 'alt=""';
	$target   = ( $target == 'blank' ) ? 'target="_blank" rel="noopener"' : '';
	$nofollow = ( $nofollow == 'true' ) ? 'rel="nofollow"' : '';

	$animation_data = '';
	$animation_data .= ( $animation != '' ) ? 'data-animate=' . $animation . '' : '';
	$animation_data .= ( $delay != '' ) ? ' data-delay=' . $delay . '' : '';
	$animation_data .= ( $delay_offset != '' ) ? ' data-offset=' . $delay_offset . '' : '';
	$animation_data .= ( $delay_duration != '' ) ? ' data-duration=' . $delay_duration . '' : '';


	switch ( $float ) {
		case 'end' :
			$float = ' text-end';
			break;
		case 'start' :
			$float = ' text-start float-start';
			break;
		default :
			$float = ' text-center float-end';
	}
	if ( $custom_ad != '' ) {
		$output = rawurldecode( base64_decode( strip_tags( $custom_ad ) ) );;
	} else {
		if ( $src != '' ) {
			if ( is_numeric( $src ) ) {
				$poster_info = wp_get_attachment_image_src( $src, 'full' );
				$src         = $poster_info[0];
				$img_width   = 'width="' . $poster_info[1] . '"';
				$img_height  = 'height="' . $poster_info[2] . '"';
			} else {
				$poster_info = dima_helper::dima_get_attachment_info_by_url( $src );
				$img_width   = 'width="' . $poster_info[1] . '"';
				$img_height  = 'height="' . $poster_info[2] . '"';
			}
		} else {
			return '';
		}
		if ( ! empty( $href ) ) {
			$output
				= "<a {$id} class=\"overlay {$class}\" {$style} href=\"{$href}\" {$target} {$nofollow}><img src=\"{$src}\" {$alt} $img_width $img_height></a>";
		} else {
			$output
				= "<img $img_width $img_height {$id} class=\"{$class}\" src=\"{$src}\" {$style} {$alt}>";
		}
	}

	return "<div class=\"stream-item mag-elms{$float}\" {$animation_data}>"
	       . $output . "</div>";

}

add_shortcode( 'dima_ads', 'dima_shortcode_dima_ads' );


/*-----------------------------------------------------------------------------------*/
# [ads1] Shortcode
/*-----------------------------------------------------------------------------------*/
add_shortcode( 'ads1', 'dima_extensions_sc_ads1' );
function dima_extensions_sc_ads1( $atts, $content = null ) {
	return '
		<div class="stream-item e3lan-in-post_one">
		' . dima_helper::dima_get_option( 'dima_ad1_shortcode' ) . '
		</div>
	';
}

/*-----------------------------------------------------------------------------------*/
# [ads2] Shortcode
/*-----------------------------------------------------------------------------------*/
add_shortcode( 'ads2', 'dima_extensions_sc_ads2' );
function dima_extensions_sc_ads2( $atts, $content = null ) {
	return '
		<div class="stream-item e3lan-in-post_two">' .
	       dima_helper::dima_get_option( 'dima_ad2_shortcode' ) . '
		</div>
	';
}

/*-----------------------------------------------------------------------------------*/
# [ads3] Shortcode
/*-----------------------------------------------------------------------------------*/
add_shortcode( 'ads3', 'dima_extensions_sc_ads3' );
function dima_extensions_sc_ads3( $atts, $content = null ) {
	return '
		<div class="stream-item e3lan-in-post_three">' .
	       dima_helper::dima_get_option( 'dima_ad3_shortcode' ) . '
		</div>
	';
}

/*-----------------------------------------------------------------------------------*/
# [ads4] Shortcode
/*-----------------------------------------------------------------------------------*/
add_shortcode( 'ads4', 'dima_extensions_sc_ads4' );
function dima_extensions_sc_ads4( $atts, $content = null ) {
	return '
		<div class="stream-item e3lan-in-post_four">' .
	       dima_helper::dima_get_option( 'dima_ad4_shortcode' ) . '
		</div>
	';
}

/*-----------------------------------------------------------------------------------*/
# [ads5] Shortcode
/*-----------------------------------------------------------------------------------*/
add_shortcode( 'ads5', 'dima_extensions_sc_ads5' );
function dima_extensions_sc_ads5( $atts, $content = null ) {
	return '
		<div class="stream-item e3lan-in-post_five">' .
	       dima_helper::dima_get_option( 'dima_ad5_shortcode' ) . '
		</div>
	';
}